/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.custom_views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.widget.ImageView;

public class CloseButtonImageView
extends ImageView {
    private Paint closeButtonPaint = new Paint(1);
    private int mViewWidth;
    private int mViewHeight;

    public CloseButtonImageView(Context context, int color2) {
        super(context);
        this.closeButtonPaint.setColor(color2);
        this.closeButtonPaint.setStrokeWidth((float)CloseButtonImageView.getStrokeSizeByScreenLayout(this.getContext()));
        this.closeButtonPaint.setStrokeCap(Paint.Cap.ROUND);
        this.closeButtonPaint.setDither(true);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawLine(0.0f, (float)this.mViewHeight, (float)this.mViewWidth, 0.0f, this.closeButtonPaint);
        canvas.drawLine(0.0f, 0.0f, (float)this.mViewWidth, (float)this.mViewHeight, this.closeButtonPaint);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mViewWidth = w;
        this.mViewHeight = h;
    }

    private static int getStrokeSizeByScreenLayout(Context context) {
        int size = 9;
        int screenLayout = context.getResources().getConfiguration().screenLayout;
        switch (screenLayout &= 0xF) {
            case 1: {
                size = 5;
                break;
            }
            case 2: {
                size = 8;
                break;
            }
            case 3: {
                size = 5;
                break;
            }
            case 4: {
                size = 5;
            }
        }
        return size;
    }
}

