/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.custom_views;

import android.content.Context;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.server_connect.GifDrawableCallback;
import pl.droidsonroids.gif.GifDrawable;

public class AnimatableGifImageView
extends ImageView {
    private GifDrawable mAnimatedGifDrawable = null;
    private boolean mIsPlaying = false;

    public AnimatableGifImageView(Context context) {
        super(context);
    }

    public AnimatableGifImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AnimatableGifImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setAnimatedGif(Uri uri, IOnAnimatedGifReadyListener listener) {
        if (this.getId() == -1) {
            this.setId(Utils.generateViewId());
        }
        if (this.mAnimatedGifDrawable != null) {
            KidozSDK.getApiManager(this.getContext()).cancelGifLoadingRequest(this.getId() + "");
            this.mAnimatedGifDrawable.recycle();
            this.mAnimatedGifDrawable = null;
            this.setImageDrawable(null);
        }
        this.loadGifImage(uri, listener);
    }

    private void loadGifImage(Uri uri, final IOnAnimatedGifReadyListener listener) {
        if (uri != null) {
            KidozSDK.getApiManager(this.getContext()).loadGifImage(this.getContext(), uri, this.getId() + "", new GifDrawableCallback(){

                @Override
                public void onGifDrawableLoaded(GifDrawable gifDrawable) {
                    AnimatableGifImageView.this.mAnimatedGifDrawable = gifDrawable;
                    if (gifDrawable != null && !gifDrawable.isRecycled()) {
                        AnimatableGifImageView.this.setImageDrawable(gifDrawable);
                        gifDrawable.start();
                        if (listener != null) {
                            listener.onGifReady();
                        }
                    }
                }
            });
        }
    }

    public void startGifAnimation() {
        if (this.mAnimatedGifDrawable != null) {
            this.mAnimatedGifDrawable.stop();
        }
    }

    public void stopGifAnimation() {
        if (this.mAnimatedGifDrawable != null) {
            this.mAnimatedGifDrawable.start();
        }
    }

    public void pauseGifAnimation() {
        if (this.mAnimatedGifDrawable != null && this.mAnimatedGifDrawable.canPause()) {
            this.mAnimatedGifDrawable.pause();
        }
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.mAnimatedGifDrawable != null && !this.mAnimatedGifDrawable.isRecycled() && this.mAnimatedGifDrawable.isPlaying()) {
            if (visibility == 0) {
                if (this.mIsPlaying) {
                    this.mAnimatedGifDrawable.start();
                    this.mIsPlaying = false;
                }
            } else {
                this.mIsPlaying = true;
                this.mAnimatedGifDrawable.stop();
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAnimatedGifDrawable != null && !this.mAnimatedGifDrawable.isRecycled()) {
            this.mAnimatedGifDrawable.recycle();
            this.mAnimatedGifDrawable = null;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    public static interface IOnAnimatedGifReadyListener {
        public void onGifReady();
    }
}

