/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.kidoz.sdk.api.general.utils.SDKLogger;

public class BaseDialog
extends Dialog {
    private final String TAG = BaseDialog.class.getSimpleName();
    protected Activity mCallingActivity;
    private long mDisplayDuration;

    public BaseDialog(Context context) {
        super(context);
        if (context != null) {
            this.mCallingActivity = (Activity)context;
        }
    }

    public BaseDialog(Context context, int theme) {
        super(context, theme);
        if (context != null) {
            this.mCallingActivity = (Activity)context;
        }
    }

    protected void openDialog() {
        if (this.mCallingActivity != null && !this.mCallingActivity.isFinishing()) {
            this.getWindow().setFlags(8, 8);
            this.getWindow().getDecorView().setSystemUiVisibility(this.mCallingActivity.getWindow().getDecorView().getSystemUiVisibility());
            this.mDisplayDuration = System.currentTimeMillis();
            super.show();
            this.getWindow().clearFlags(8);
            WindowManager wm = (WindowManager)this.mCallingActivity.getSystemService("window");
            wm.updateViewLayout(this.getWindow().getDecorView(), (ViewGroup.LayoutParams)this.getWindow().getAttributes());
        }
    }

    protected void closeDialog() {
        if (this.mCallingActivity != null && !this.mCallingActivity.isFinishing()) {
            this.dismiss();
        }
    }

    public void show() {
        try {
            throw new DialogException();
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to open dialog: " + ex.getMessage());
            return;
        }
    }

    public int getTotalDisplayDuration() {
        int totalTimeInSeconds = (int)((System.currentTimeMillis() - this.mDisplayDuration) / 1000L);
        return totalTimeInSeconds;
    }

    private class DialogException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private DialogException() {
        }

        @Override
        public String getMessage() {
            return "Don't use the show() method\nUse openDialog() instead!";
        }
    }
}

