/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.dialogs;

import android.animation.Animator;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import android.widget.ViewAnimator;
import com.custom_recycler_view.CustomGridLayoutManager;
import com.custom_recycler_view.CustomRecyclerView;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.dialogs.ParentalLockLayoutGenerator;
import com.kidoz.sdk.api.general.animations.AnimationFactory;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardView;
import com.kidoz.sdk.api.general.utils.AnimationsUtils;
import com.kidoz.sdk.api.general.utils.AppAssetsUtils;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.LockIconData;
import com.kidoz.sdk.api.ui_views.parental_lock.LockIconsAdapter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONObject;

public class ParentalLockDialog
extends Dialog {
    private static final int DIALOG_BACKGROUND = Color.parseColor((String)"#0fcaf7");
    private static final int DIALOG_BACKGROUND_CORRNER_RADIUS = 4;
    private final String TAG = ParentalLockDialog.class.getSimpleName();
    public static final String PARENTAL_LOCK_ACTIVE_KEY = "PARENTAL_LOCK_ACTIVE_KEY";
    public static final float PIVOT_X_FACTOR = 0.722f;
    public static final float PIVOT_Y_FACTOR = 0.04f;
    private final int NUMBER_OF_COLUMNS = 4;
    private final int NUMBER_OF_LOCK_ICONS = 8;
    private final int FLIP_ANIMATION_DURATION = 200;
    private int[] mPopLocation;
    private View mRootView;
    private CustomRecyclerView mCustomRecyclerView;
    private LockIconsAdapter mAdapter;
    private TextView mDialogMessage;
    private TextView mDialogTitleTextView;
    private ArrayList<LockIconData> mContent;
    private int[] mLockCombination;
    private boolean mIsFirstLockIconCorrect;
    private boolean mIsLockActive;
    private ParentLockDialogListener mParentLockDialogListener;
    private boolean mIsGateToGooglePlay;
    private boolean mIsLockChangeSuccessfully;
    private ViewAnimator mViewAnimator;
    private TextView mFeedbackMessage;
    private TextView mFeedbackMessageAction;
    private View mAnimatableView;
    private KidozCardView kidozCardView;
    private int mCounter;
    private Handler mHandler;

    public ParentalLockDialog(Context context, boolean isGateToGooglePlay, int[] popLocation) {
        super(context, 0x1030011);
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
        this.requestWindowFeature(1);
        this.mPopLocation = popLocation;
        this.mRootView = ParentalLockLayoutGenerator.generateParentalLockView(context);
        this.mIsGateToGooglePlay = isGateToGooglePlay;
        this.setContentView(this.mRootView);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initDialog();
    }

    private void initDialog() {
        this.mHandler = new Handler();
        this.initDialogBackgroundView();
        this.initParameters();
        this.initTitle();
        this.initDialogWidth();
        this.initExitButton();
        this.initRecyclerView();
        this.initMessageTextView();
        this.initFeedbackMessageView();
        this.prepareDialog();
        this.mCounter = 0;
    }

    private void initDialogBackgroundView() {
        this.kidozCardView = (KidozCardView)this.mRootView.findViewById(ParentalLockLayoutGenerator.PARENTAL_CARDVIEW_ID);
        this.kidozCardView.setRadius(Utils.dpTOpx(this.getContext(), 4));
        this.kidozCardView.setCardBackgroundColor(DIALOG_BACKGROUND);
    }

    private void initFeedbackMessageView() {
        View feedbackMessageContainer = this.mRootView.findViewById(ParentalLockLayoutGenerator.FEEDBACK_MESSAGE_CONTAINER_ID);
        feedbackMessageContainer.setSoundEffectsEnabled(false);
        feedbackMessageContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ParentalLockDialog.this.prepareDialog();
                if (ParentalLockDialog.this.mIsLockChangeSuccessfully) {
                    ParentalLockDialog.this.mIsLockChangeSuccessfully = false;
                }
                ParentalLockDialog.this.animateFeedBackMessageBack();
            }
        });
        this.mFeedbackMessage = (TextView)this.mRootView.findViewById(ParentalLockLayoutGenerator.FEEDBACK_MESSAGE_TEXT_VIEW_ID);
        this.mFeedbackMessageAction = (TextView)this.mRootView.findViewById(ParentalLockLayoutGenerator.FEEDBACK_ACTION_TEXT_VIEW_ID);
        int availableSpace = Math.min(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false));
        if (ScreenUtils.getIsTablet(this.getContext())) {
            availableSpace = (int)(0.8f * (float)availableSpace);
        }
        int itemSize = availableSpace / 4;
        this.mViewAnimator = (ViewAnimator)this.mRootView.findViewById(ParentalLockLayoutGenerator.VIEW_FLIPPER_ID);
        this.mViewAnimator.getLayoutParams().width = availableSpace;
        this.mViewAnimator.getLayoutParams().height = itemSize * 2;
    }

    private void initTitle() {
        this.mDialogTitleTextView = (TextView)this.mRootView.findViewById(ParentalLockLayoutGenerator.PARENTAL_DIALOG_TITLE_ID);
    }

    private void initDialogWidth() {
        this.mAnimatableView = this.mRootView.findViewById(ParentalLockLayoutGenerator.ANIMATABLE_VIEW);
        this.mAnimatableView.getLayoutParams().width = !ScreenUtils.getIsTablet(this.getContext()) ? Math.min(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false)) : (int)(0.8f * (float)Math.min(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false)));
    }

    private void initParameters() {
        this.mContent = new ArrayList();
        JSONArray jSONArray = AppAssetsUtils.loadParentalLockConfigurationFile(this.getContext());
        if (jSONArray != null && jSONArray.length() > 0) {
            for (int lockIconIndex = 0; lockIconIndex < jSONArray.length(); ++lockIconIndex) {
                try {
                    JSONObject nextJSONObject = jSONArray.getJSONObject(lockIconIndex);
                    LockIconData nextLockIconData = new LockIconData(this.getContext(), nextJSONObject);
                    this.mContent.add(nextLockIconData);
                    continue;
                }
                catch (Exception ex) {
                    SDKLogger.printErrorLog(this.TAG, "Error when trying to parse configuration JSON:" + ex.getMessage());
                }
            }
        }
    }

    private void prepareDialog() {
        this.mIsLockActive = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), PARENTAL_LOCK_ACTIVE_KEY) != null;
        this.mIsFirstLockIconCorrect = false;
        this.mLockCombination = new int[2];
        Random random = new Random();
        while (this.mLockCombination[0] == this.mLockCombination[1]) {
            this.mLockCombination[0] = random.nextInt(8);
            this.mLockCombination[1] = random.nextInt(8);
        }
        if (this.mIsGateToGooglePlay) {
            this.mDialogTitleTextView.setText((CharSequence)this.getContext().getString(R.string.ParentalLockDialogTitleForGooglePlay));
        } else if (this.mIsLockActive) {
            this.mDialogTitleTextView.setText((CharSequence)this.getContext().getString(R.string.ParentalLockDialogTitleDeActivate));
        } else {
            this.mDialogTitleTextView.setText((CharSequence)this.getContext().getString(R.string.ParentalLockDialogTitleActivate));
        }
        String name_1 = this.mContent.get(this.mLockCombination[0]).getName().toUpperCase();
        String name_2 = this.mContent.get(this.mLockCombination[1]).getName().toUpperCase();
        if (this.mIsGateToGooglePlay) {
            this.mDialogMessage.setText((CharSequence)String.format(Locale.getDefault(), this.getContext().getString(R.string.ParentalLockDialogMessageGooglePlayGate), name_1, name_2));
        } else if (this.mIsLockActive) {
            this.mDialogMessage.setText((CharSequence)String.format(Locale.getDefault(), this.getContext().getString(R.string.ParentalLockDialogMessageParentalLockDeactivation), name_1, name_2));
        } else {
            this.mDialogMessage.setText((CharSequence)String.format(Locale.getDefault(), this.getContext().getString(R.string.ParentalLockDialogMessageParentalLockActivation), name_1, name_2));
        }
    }

    private void initMessageTextView() {
        this.mDialogMessage = (TextView)this.mRootView.findViewById(ParentalLockLayoutGenerator.PARENTAL_LOCK_DIALOG_MESSAGE_TEXTVIEW_ID);
    }

    private void initExitButton() {
        this.mRootView.findViewById(ParentalLockLayoutGenerator.EXIT_BUTTON_ID).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AnimationsUtils.animateClick(view, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                    }

                    public void onAnimationEnd(Animator animation) {
                        ParentalLockDialog.this.dismiss();
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }
        });
    }

    private void initRecyclerView() {
        int availableSpace = Math.min(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false));
        if (ScreenUtils.getIsTablet(this.getContext())) {
            availableSpace = (int)(0.8f * (float)availableSpace);
        }
        int itemSize = availableSpace / 4;
        int padding = Utils.dpTOpx(this.getContext(), 30);
        ArrayList<LockIconData> content = new ArrayList<LockIconData>();
        for (int i = 0; i < 8; ++i) {
            LockIconData nextLockIconData = new LockIconData();
            content.add(nextLockIconData);
        }
        this.mAdapter = new LockIconsAdapter();
        this.mAdapter.setLockIconAdapterListener(new LockIconsAdapter.LockIconAdapterListener(){

            @Override
            public void onLockIconClick(int index) {
                if (!ParentalLockDialog.this.mIsFirstLockIconCorrect) {
                    if (index == ParentalLockDialog.this.mLockCombination[0]) {
                        ParentalLockDialog.this.mIsFirstLockIconCorrect = true;
                    } else {
                        ParentalLockDialog.this.animateFeedBackMessageError();
                    }
                } else if (index == ParentalLockDialog.this.mLockCombination[1]) {
                    ParentalLockDialog.this.mIsLockChangeSuccessfully = true;
                    if (ParentalLockDialog.this.mIsGateToGooglePlay) {
                        ParentalLockDialog.this.dismiss();
                    } else {
                        if (ParentalLockDialog.this.mIsLockActive) {
                            SharedPreferencesUtils.removeSharedPreferencesData(ParentalLockDialog.this.getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY);
                        } else {
                            SharedPreferencesUtils.saveSharedPreferencesData(ParentalLockDialog.this.getContext(), ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY, ParentalLockDialog.PARENTAL_LOCK_ACTIVE_KEY);
                        }
                        ParentalLockDialog.this.animateFeedBackMessageSuccess(ParentalLockDialog.this.mIsLockActive);
                        if (ParentalLockDialog.this.mParentLockDialogListener != null) {
                            ParentalLockDialog.this.mParentLockDialogListener.onPasswordEntered(true);
                            EventManager.getInstance().LogEventWithIntField(ParentalLockDialog.this.getContext(), EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Correct Password", null, ParentalLockDialog.this.mCounter);
                        }
                    }
                    if (ParentalLockDialog.this.mParentLockDialogListener != null) {
                        ParentalLockDialog.this.mParentLockDialogListener.onPasswordEntered(true);
                        ParentalLockDialog.this.mCounter = ParentalLockDialog.this.mCounter + 1;
                        EventManager.getInstance().LogEventWithIntField(ParentalLockDialog.this.getContext(), EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Correct Password", null, ParentalLockDialog.this.mCounter);
                    }
                } else {
                    ParentalLockDialog.this.animateFeedBackMessageError();
                }
            }
        });
        this.mCustomRecyclerView = (CustomRecyclerView)this.mRootView.findViewById(ParentalLockLayoutGenerator.RECYCLER_VIEW_ID);
        CustomGridLayoutManager layoutManager = new CustomGridLayoutManager(this.getContext(), 4);
        this.mCustomRecyclerView.setLayoutManager(layoutManager);
        this.mCustomRecyclerView.setPadding(padding, 0, padding, 0);
        this.mCustomRecyclerView.setHasFixedSize(true);
        this.mCustomRecyclerView.getLayoutParams().width = availableSpace;
        this.mCustomRecyclerView.getLayoutParams().height = itemSize * 2;
        this.mCustomRecyclerView.setAdapter(this.mAdapter);
    }

    protected void onStart() {
        super.onStart();
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                ParentalLockDialog.this.mAdapter.setContent(ParentalLockDialog.this.mContent);
            }
        }, 300L);
    }

    public void show() {
        super.show();
        EventManager.getInstance().LogEventWithIntField(this.getContext(), EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Dialog Show", null, this.mCounter);
        this.mAnimatableView.setVisibility(4);
        this.mAnimatableView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    ParentalLockDialog.this.mAnimatableView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    ParentalLockDialog.this.mAnimatableView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                if (ParentalLockDialog.this.mPopLocation != null) {
                    GenAnimator.playPopInFromRightTop(ParentalLockDialog.this.mAnimatableView, ParentalLockDialog.this.mPopLocation, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                            ParentalLockDialog.this.mAnimatableView.setVisibility(0);
                        }

                        public void onAnimationEnd(Animator animation) {
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                } else {
                    ParentalLockDialog.this.mAnimatableView.setVisibility(0);
                }
            }
        });
    }

    public void dismiss() {
        if (this.mPopLocation != null) {
            GenAnimator.playPopOutToRightTop(this.mAnimatableView, this.mPopLocation, new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    if (ParentalLockDialog.this.mParentLockDialogListener != null) {
                        ParentalLockDialog.this.mParentLockDialogListener.onPasswordEntered(false);
                    }
                    EventManager.getInstance().LogEventWithIntField(ParentalLockDialog.this.getContext(), EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Dialog Dismiss", null, ParentalLockDialog.this.mCounter);
                    ParentalLockDialog.super.dismiss();
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        } else {
            if (this.mParentLockDialogListener != null) {
                this.mParentLockDialogListener.onPasswordEntered(false);
            }
            EventManager.getInstance().LogEventWithIntField(this.getContext(), EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Dialog Dismiss", null, this.mCounter);
            ParentalLockDialog.super.dismiss();
        }
    }

    public void setParentLockDialogListener(ParentLockDialogListener parentLockDialogListener) {
        this.mParentLockDialogListener = parentLockDialogListener;
    }

    private void animateFeedBackMessageError() {
        ++this.mCounter;
        EventManager.getInstance().LogEventWithIntField(this.getContext(), EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Incorrect Password", null, this.mCounter);
        String tryAgain = this.getContext().getString(R.string.ParentalLockDialogWrongSelectionTryAgain);
        String wrongSelection = this.getContext().getString(R.string.ParentalLockDialogWrongSelection);
        SpannableString messageTextError = new SpannableString((CharSequence)wrongSelection);
        SpannableString messageActionTryAgain = new SpannableString((CharSequence)tryAgain);
        messageActionTryAgain.setSpan((Object)new StyleSpan(1), 0, messageActionTryAgain.length(), 0);
        this.mFeedbackMessage.setText((CharSequence)messageTextError);
        this.mFeedbackMessageAction.setText((CharSequence)messageActionTryAgain);
        AnimationFactory.flipTransition(this.mViewAnimator, AnimationFactory.FlipDirection.BOTTOM_TOP, 200L);
    }

    private void animateFeedBackMessageSuccess(boolean mIsLockActive) {
        if (mIsLockActive) {
            String lockStatus = this.getContext().getString(R.string.ParentalLockDialogLockStatus);
            String off = this.getContext().getString(R.string.ParentalLockDialogLockStatusOff);
            String activate = this.getContext().getString(R.string.ParentalLockDialogLockActivate);
            SpannableString message = new SpannableString((CharSequence)(lockStatus + off));
            message.setSpan((Object)new StyleSpan(1), lockStatus.length(), message.length(), 0);
            SpannableString messageAction = new SpannableString((CharSequence)activate);
            messageAction.setSpan((Object)new StyleSpan(1), 0, messageAction.length(), 0);
            this.mFeedbackMessage.setText((CharSequence)message);
            this.mFeedbackMessageAction.setText((CharSequence)messageAction);
        } else {
            String lockStatus = this.getContext().getString(R.string.ParentalLockDialogLockStatus);
            String on = this.getContext().getString(R.string.ParentalLockDialogLockStatusOn);
            String deactivate = this.getContext().getString(R.string.ParentalLockDialogLockDeactivate);
            SpannableString message = new SpannableString((CharSequence)(lockStatus + on));
            message.setSpan((Object)new StyleSpan(1), lockStatus.length(), message.length(), 0);
            SpannableString messageAction = new SpannableString((CharSequence)deactivate);
            messageAction.setSpan((Object)new StyleSpan(1), 0, messageAction.length(), 0);
            this.mFeedbackMessage.setText((CharSequence)message);
            this.mFeedbackMessageAction.setText((CharSequence)messageAction);
        }
        AnimationFactory.flipTransition(this.mViewAnimator, AnimationFactory.FlipDirection.BOTTOM_TOP, 200L);
    }

    private void animateFeedBackMessageBack() {
        AnimationFactory.flipTransition(this.mViewAnimator, AnimationFactory.FlipDirection.BOTTOM_TOP, 200L);
    }

    public static boolean getIsCanShowDialog(Context context) {
        boolean result = false;
        JSONArray jSONArray = AppAssetsUtils.loadParentalLockConfigurationFile(context);
        if (jSONArray != null && jSONArray.length() > 0) {
            result = true;
        }
        return result;
    }

    public static interface ParentLockDialogListener {
        public void onPasswordEntered(boolean var1);
    }
}

