/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.dialogs;

import android.animation.Animator;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.custom_views.CloseButtonImageView;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardView;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.web_player.KidozWebView;

public class AboutKidozDialog
extends Dialog {
    private final String TAG = AboutKidozDialog.class.getSimpleName();
    private RelativeLayout mRootView;
    private RelativeLayout mContainer;
    private KidozCardView mKidozCardView;
    private KidozWebView mKidozWebView;
    private Utils.StaticHandler mStaticHandler;
    private int[] mPopLocation;

    public AboutKidozDialog(Context context, int[] popLocation) {
        super(context, 0x1030011);
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
        this.requestWindowFeature(1);
        this.mPopLocation = popLocation;
        this.initDialog();
        this.setContentView((View)this.mRootView);
    }

    private void initDialog() {
        this.mStaticHandler = new Utils.StaticHandler();
        this.initRootView();
        this.initBackgroundkidozCardView();
        this.initWebView();
    }

    private void initRootView() {
        this.mRootView = new RelativeLayout(this.getContext());
    }

    private void initBackgroundkidozCardView() {
        this.mKidozCardView = new KidozCardView(this.getContext());
        this.mKidozCardView.setCardBackgroundColor(Color.parseColor((String)"#ffffff"));
        this.mKidozCardView.setRadius(Utils.dpTOpx(this.getContext(), 4));
        int padding = Utils.dpTOpx(this.getContext(), 10);
        this.mKidozCardView.setPadding(padding, padding, padding, padding);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        if (!ScreenUtils.getIsTablet(this.getContext())) {
            params.width = Math.min(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false));
            params.height = (int)(0.5f * (float)Math.max(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false)));
        } else {
            params.width = (int)(0.8f * (float)Math.min(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false)));
            params.height = (int)(0.5f * (float)Math.max(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false)));
        }
        params.setMargins(padding, padding, padding, padding);
        params.addRule(13);
        this.mRootView.addView((View)this.mKidozCardView, (ViewGroup.LayoutParams)params);
        this.mContainer = new RelativeLayout(this.getContext());
        this.mKidozCardView.addView((View)this.mContainer, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    private void initWebView() {
        this.mKidozWebView = new KidozWebView(this.getContext());
        this.mKidozWebView.getSettings().setUseWideViewPort(true);
        this.mKidozWebView.getSettings().setLoadWithOverviewMode(true);
        this.mKidozWebView.getSettings().setSupportZoom(false);
        this.mKidozWebView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url.startsWith("mailto:")) {
                    Intent mailIntent = new Intent("android.intent.action.SENDTO", Uri.parse((String)url));
                    AboutKidozDialog.this.getContext().startActivity(mailIntent);
                } else {
                    view.loadUrl(url);
                }
                return true;
            }
        });
        this.mKidozWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
        this.mKidozWebView.setLongClickable(true);
        this.mKidozWebView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return true;
            }
        });
        this.mKidozWebView.setVerticalScrollBarEnabled(false);
        this.mKidozWebView.setHorizontalScrollBarEnabled(false);
        this.mKidozWebView.loadUrl("http://kidoz.net/v3policy/");
        this.mContainer.addView((View)this.mKidozWebView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        CloseButtonImageView closeButtonImageView = new CloseButtonImageView(this.getContext(), Color.parseColor((String)"#04a0e1"));
        closeButtonImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GenAnimator.clickItemAnimation(v, 100, new GenAnimator.ViewAnimationListener(){

                    @Override
                    public void onAnimationEnd() {
                        AboutKidozDialog.this.dismiss();
                    }

                    @Override
                    public void onAnimationStart() {
                    }
                });
            }
        });
        int padding = Utils.dpTOpx(this.getContext(), 10);
        closeButtonImageView.setPadding(padding, padding, padding, padding);
        RelativeLayout.LayoutParams xButtonParams = new RelativeLayout.LayoutParams(-2, -2);
        xButtonParams.addRule(11);
        xButtonParams.setMargins(0, Utils.dpTOpx(this.getContext(), 5), Utils.dpTOpx(this.getContext(), 5), 0);
        this.mContainer.addView((View)closeButtonImageView, (ViewGroup.LayoutParams)xButtonParams);
    }

    public void show() {
        super.show();
        this.mKidozCardView.setVisibility(4);
        this.mKidozCardView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    AboutKidozDialog.this.mKidozCardView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    AboutKidozDialog.this.mKidozCardView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                if (AboutKidozDialog.this.mPopLocation != null) {
                    GenAnimator.playPopInFromRightTop((View)AboutKidozDialog.this.mKidozCardView, AboutKidozDialog.this.mPopLocation, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                            AboutKidozDialog.this.mKidozCardView.setVisibility(0);
                        }

                        public void onAnimationEnd(Animator animation) {
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                } else {
                    AboutKidozDialog.this.mKidozCardView.setVisibility(0);
                }
            }
        });
    }

    public void dismiss() {
        if (this.mPopLocation != null) {
            GenAnimator.playPopOutToRightTop((View)this.mKidozCardView, this.mPopLocation, new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    AboutKidozDialog.super.dismiss();
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        } else {
            AboutKidozDialog.super.dismiss();
        }
    }
}

