/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.animation.Animator;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.ContentExecutionHandler;
import com.kidoz.sdk.api.ContentLogicLoader;
import com.kidoz.sdk.api.dialogs.AboutKidozDialog;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.enums.UiStyleType;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.interfaces.IOnPanelViewEventListener;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_BUTTON_TYPE;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;
import com.kidoz.sdk.api.ui_views.panel_view.PanelButton;
import com.kidoz.sdk.api.ui_views.panel_view.PanelSliderView;
import com.kidoz.sdk.api.ui_views.panel_view.PanelViewListener;

public class PanelView
extends RelativeLayout {
    private final String TAG = PanelView.class.getSimpleName();
    private RelativeLayout mRootView;
    private RelativeLayout mContainer;
    private PANEL_TYPE mPanelType;
    private HANDLE_POSITION mHandlePosition;
    private PanelSliderView mPanelSliderView;
    private ContentLogicLoader mContentLogicLoader;
    private PanelButton mHandleButton;
    private PanelButton mParentalLockButton;
    private PanelButton mAboutKidozButton;
    private PanelViewListener mPanelViewListener;
    private IOnPanelViewEventListener mIOnPanelViewEventListener;
    private boolean mIsOpen;
    private boolean mIsAnimationRunning;
    private boolean mIsClicksBlocked;

    public PanelView(Context context) {
        super(context);
        this.initView();
    }

    public PanelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public PanelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        this.initPanelTypeAndHandlePosition();
        this.initRootView();
        this.initContainer();
        this.initHandleButton();
        this.initParentalLockButton();
        this.initAboutKidozkButton();
        this.initPanelSliderView();
        this.initPanelViewsRules();
        this.initContentLogicLoader();
        this.preparePanel();
    }

    private void initRootView() {
        this.mRootView = new RelativeLayout(this.getContext());
        this.mRootView.setBackgroundColor(0);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.addView((View)this.mRootView, (ViewGroup.LayoutParams)params);
    }

    private void initContainer() {
        this.mContainer = new RelativeLayout(this.getContext());
        this.mContainer.setBackgroundColor(0);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        this.mRootView.addView((View)this.mContainer, (ViewGroup.LayoutParams)params);
    }

    private void initHandleButton() {
        this.mHandleButton = new PanelButton(this.getContext(), PANEL_BUTTON_TYPE.HANDLE, new PanelButton.PanelButtonListener(){

            @Override
            public void onClickStarted() {
            }

            @Override
            public void onClickEnd() {
                PanelView.this.toggleAnimation();
            }
        });
        this.mHandleButton.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        this.mContainer.addView((View)this.mHandleButton, (ViewGroup.LayoutParams)params);
    }

    private void initParentalLockButton() {
        this.mParentalLockButton = new PanelButton(this.getContext(), PANEL_BUTTON_TYPE.PARENTAL_LOCK, new PanelButton.PanelButtonListener(){

            @Override
            public void onClickStarted() {
            }

            @Override
            public void onClickEnd() {
                if (!PanelView.this.mIsClicksBlocked) {
                    PanelView.this.mIsClicksBlocked = true;
                    if (ParentalLockDialog.getIsCanShowDialog(PanelView.this.getContext())) {
                        int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(PanelView.this.getContext(), true) * 0.5f), (int)((float)ScreenUtils.getScreenSize(PanelView.this.getContext(), false) * 0.5f)};
                        ParentalLockDialog parentalLockDialog = new ParentalLockDialog(PanelView.this.getContext(), false, popLocation);
                        parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                            public void onDismiss(DialogInterface dialog) {
                                boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(PanelView.this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
                                PanelView.this.mParentalLockButton.setIsLockActive(isLockActive);
                                PanelView.this.mIsClicksBlocked = false;
                            }
                        });
                        parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener(){

                            @Override
                            public void onPasswordEntered(boolean isPasswordCorrect) {
                                boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(PanelView.this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
                                PanelView.this.mParentalLockButton.setIsLockActive(isLockActive);
                            }
                        });
                        parentalLockDialog.show();
                    } else {
                        PanelView.this.mIsClicksBlocked = false;
                    }
                }
            }
        });
        this.mParentalLockButton.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        this.mContainer.addView((View)this.mParentalLockButton, (ViewGroup.LayoutParams)params);
        boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
        this.mParentalLockButton.setIsLockActive(isLockActive);
    }

    private void initAboutKidozkButton() {
        this.mAboutKidozButton = new PanelButton(this.getContext(), PANEL_BUTTON_TYPE.ABOUT_KIDOZ, new PanelButton.PanelButtonListener(){

            @Override
            public void onClickStarted() {
            }

            @Override
            public void onClickEnd() {
                int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(PanelView.this.getContext(), true) * 0.5f), (int)((float)ScreenUtils.getScreenSize(PanelView.this.getContext(), false) * 0.5f)};
                AboutKidozDialog aboutKidozDialog = new AboutKidozDialog(PanelView.this.getContext(), popLocation);
                aboutKidozDialog.show();
            }
        });
        this.mAboutKidozButton.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        this.mContainer.addView((View)this.mAboutKidozButton, (ViewGroup.LayoutParams)params);
    }

    private void initPanelSliderView() {
        this.mPanelSliderView = new PanelSliderView(this.getContext());
        this.mPanelSliderView.setId(Utils.generateViewId());
        this.mPanelSliderView.setBackgroundColor(0);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        this.mContainer.addView((View)this.mPanelSliderView, (ViewGroup.LayoutParams)params);
        this.mPanelViewListener = new PanelViewListener(){

            @Override
            public void onItemClick(ContentItem contentItem, int position) {
                ContentExecutionHandler.handleContentItemClick(PanelView.this.getContext(), contentItem, position);
            }
        };
        this.mPanelSliderView.setPanelViewListener(this.mPanelViewListener);
    }

    private void preparePanel() {
        this.mIsOpen = true;
        this.mIsAnimationRunning = true;
        Utils.setOnGlobalLayoutFinishListener((View)this.mRootView, new Utils.OnGlobalLayoutFinishedListener(){

            @Override
            public void onLayoutFinished() {
                GenAnimator.playShrinkAnimation((View)PanelView.this.mHandleButton, 0L, null);
                GenAnimator.playShrinkAnimation((View)PanelView.this.mParentalLockButton, 0L, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                    }

                    public void onAnimationEnd(Animator animation) {
                        PanelView.this.mParentalLockButton.setVisibility(4);
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
                GenAnimator.playShrinkAnimation((View)PanelView.this.mAboutKidozButton, 0L, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                    }

                    public void onAnimationEnd(Animator animation) {
                        PanelView.this.mAboutKidozButton.setVisibility(4);
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
                GenAnimator.closePanelView((View)PanelView.this.mContainer, 200L, (View)PanelView.this.mPanelSliderView, PanelView.this.mPanelType, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                        GenAnimator.animateHandleClose((View)PanelView.this.mHandleButton, null);
                    }

                    public void onAnimationEnd(Animator animation) {
                        GenAnimator.playGrowAnimation((View)PanelView.this.mHandleButton, 350L, 500L, new Animator.AnimatorListener(){

                            public void onAnimationStart(Animator animation) {
                            }

                            public void onAnimationEnd(Animator animation) {
                                PanelView.this.mIsOpen = false;
                                PanelView.this.mIsAnimationRunning = false;
                            }

                            public void onAnimationCancel(Animator animation) {
                            }

                            public void onAnimationRepeat(Animator animation) {
                            }
                        });
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }
        });
    }

    private void initPanelTypeAndHandlePosition() {
        this.mPanelType = PANEL_TYPE.BOTTOM;
        this.mHandlePosition = HANDLE_POSITION.START;
        if (Build.VERSION.SDK_INT >= 16) {
            int gravity = this.getGravity();
            switch (gravity) {
                case 3: {
                    this.mPanelType = PANEL_TYPE.LEFT;
                    break;
                }
                case 48: {
                    this.mPanelType = PANEL_TYPE.TOP;
                    break;
                }
                case 5: {
                    this.mPanelType = PANEL_TYPE.RIGHT;
                    break;
                }
                case 80: {
                    this.mPanelType = PANEL_TYPE.BOTTOM;
                }
            }
        }
    }

    private void initPanelViewsRules() {
        RelativeLayout.LayoutParams containerParams = new RelativeLayout.LayoutParams(-2, -2);
        this.mContainer.setLayoutParams((ViewGroup.LayoutParams)containerParams);
        RelativeLayout.LayoutParams sliderParams = new RelativeLayout.LayoutParams(-2, -2);
        this.mPanelSliderView.setLayoutParams((ViewGroup.LayoutParams)sliderParams);
        RelativeLayout.LayoutParams handleParams = new RelativeLayout.LayoutParams(-2, -2);
        this.mHandleButton.setLayoutParams((ViewGroup.LayoutParams)handleParams);
        RelativeLayout.LayoutParams parentalLockParams = new RelativeLayout.LayoutParams(-2, -2);
        this.mParentalLockButton.setLayoutParams((ViewGroup.LayoutParams)parentalLockParams);
        RelativeLayout.LayoutParams aboutKidozParams = new RelativeLayout.LayoutParams(-2, -2);
        this.mAboutKidozButton.setLayoutParams((ViewGroup.LayoutParams)aboutKidozParams);
        int margin = Utils.dpTOpx(this.getContext(), 6);
        switch (this.mPanelType) {
            case LEFT: {
                this.mPanelSliderView.setPanelType(PANEL_TYPE.LEFT);
                sliderParams.addRule(9);
                sliderParams.width = -2;
                sliderParams.height = -1;
                handleParams.addRule(1, this.mPanelSliderView.getId());
                aboutKidozParams.addRule(1, this.mPanelSliderView.getId());
                parentalLockParams.addRule(1, this.mPanelSliderView.getId());
                switch (this.mHandlePosition) {
                    case START: {
                        handleParams.addRule(10);
                        handleParams.topMargin = margin;
                        handleParams.leftMargin = margin;
                        aboutKidozParams.addRule(8, this.mPanelSliderView.getId());
                        aboutKidozParams.leftMargin = margin;
                        aboutKidozParams.bottomMargin = margin;
                        parentalLockParams.addRule(2, this.mAboutKidozButton.getId());
                        parentalLockParams.leftMargin = margin;
                        parentalLockParams.bottomMargin = margin;
                        break;
                    }
                    case CENTER: {
                        handleParams.addRule(15);
                        handleParams.leftMargin = margin;
                        aboutKidozParams.addRule(8, this.mPanelSliderView.getId());
                        aboutKidozParams.leftMargin = margin;
                        aboutKidozParams.bottomMargin = margin;
                        parentalLockParams.addRule(2, this.mAboutKidozButton.getId());
                        parentalLockParams.leftMargin = margin;
                        parentalLockParams.bottomMargin = margin;
                        break;
                    }
                    case END: {
                        handleParams.addRule(8, this.mPanelSliderView.getId());
                        handleParams.bottomMargin = margin;
                        handleParams.leftMargin = margin;
                        parentalLockParams.addRule(6, this.mPanelSliderView.getId());
                        parentalLockParams.leftMargin = margin;
                        parentalLockParams.topMargin = margin;
                        aboutKidozParams.addRule(3, this.mParentalLockButton.getId());
                        aboutKidozParams.leftMargin = margin;
                        aboutKidozParams.topMargin = margin;
                    }
                }
                containerParams.addRule(9);
                break;
            }
            case TOP: {
                this.mPanelSliderView.setPanelType(PANEL_TYPE.TOP);
                sliderParams.addRule(10);
                sliderParams.width = -1;
                sliderParams.height = -2;
                handleParams.addRule(3, this.mPanelSliderView.getId());
                aboutKidozParams.addRule(3, this.mPanelSliderView.getId());
                parentalLockParams.addRule(3, this.mPanelSliderView.getId());
                switch (this.mHandlePosition) {
                    case START: {
                        handleParams.addRule(9);
                        handleParams.leftMargin = margin;
                        handleParams.topMargin = margin;
                        aboutKidozParams.addRule(7, this.mPanelSliderView.getId());
                        aboutKidozParams.rightMargin = margin;
                        aboutKidozParams.topMargin = margin;
                        parentalLockParams.addRule(0, this.mAboutKidozButton.getId());
                        parentalLockParams.rightMargin = margin;
                        parentalLockParams.topMargin = margin;
                        break;
                    }
                    case CENTER: {
                        handleParams.addRule(14);
                        handleParams.topMargin = margin;
                        parentalLockParams.addRule(5, this.mPanelSliderView.getId());
                        parentalLockParams.leftMargin = margin;
                        parentalLockParams.topMargin = margin;
                        aboutKidozParams.addRule(1, this.mParentalLockButton.getId());
                        aboutKidozParams.leftMargin = margin;
                        aboutKidozParams.topMargin = margin;
                        break;
                    }
                    case END: {
                        handleParams.addRule(7, this.mPanelSliderView.getId());
                        handleParams.topMargin = margin;
                        handleParams.rightMargin = margin;
                        parentalLockParams.addRule(5, this.mPanelSliderView.getId());
                        parentalLockParams.leftMargin = margin;
                        parentalLockParams.topMargin = margin;
                        aboutKidozParams.addRule(1, this.mParentalLockButton.getId());
                        aboutKidozParams.leftMargin = margin;
                        aboutKidozParams.topMargin = margin;
                    }
                }
                containerParams.addRule(10);
                break;
            }
            case RIGHT: {
                this.mPanelSliderView.setPanelType(PANEL_TYPE.RIGHT);
                sliderParams.addRule(1, this.mHandleButton.getId());
                sliderParams.width = -2;
                sliderParams.height = -1;
                handleParams.addRule(9);
                aboutKidozParams.addRule(9);
                parentalLockParams.addRule(9);
                switch (this.mHandlePosition) {
                    case START: {
                        handleParams.addRule(10);
                        handleParams.topMargin = margin;
                        handleParams.rightMargin = margin;
                        aboutKidozParams.addRule(8, this.mPanelSliderView.getId());
                        aboutKidozParams.rightMargin = margin;
                        aboutKidozParams.bottomMargin = margin;
                        parentalLockParams.addRule(2, this.mAboutKidozButton.getId());
                        parentalLockParams.rightMargin = margin;
                        parentalLockParams.bottomMargin = margin;
                        break;
                    }
                    case CENTER: {
                        handleParams.addRule(15);
                        handleParams.rightMargin = margin;
                        aboutKidozParams.addRule(8, this.mPanelSliderView.getId());
                        aboutKidozParams.rightMargin = margin;
                        aboutKidozParams.bottomMargin = margin;
                        parentalLockParams.addRule(2, this.mAboutKidozButton.getId());
                        parentalLockParams.rightMargin = margin;
                        parentalLockParams.bottomMargin = margin;
                        break;
                    }
                    case END: {
                        handleParams.addRule(8, this.mPanelSliderView.getId());
                        handleParams.bottomMargin = margin;
                        handleParams.rightMargin = margin;
                        parentalLockParams.addRule(6, this.mPanelSliderView.getId());
                        parentalLockParams.rightMargin = margin;
                        parentalLockParams.topMargin = margin;
                        aboutKidozParams.addRule(3, this.mParentalLockButton.getId());
                        aboutKidozParams.rightMargin = margin;
                        aboutKidozParams.topMargin = margin;
                    }
                }
                containerParams.addRule(11);
                break;
            }
            case BOTTOM: {
                this.mPanelSliderView.setPanelType(PANEL_TYPE.BOTTOM);
                sliderParams.addRule(3, this.mHandleButton.getId());
                sliderParams.width = -1;
                sliderParams.height = -2;
                handleParams.addRule(10);
                aboutKidozParams.addRule(10);
                parentalLockParams.addRule(10);
                switch (this.mHandlePosition) {
                    case START: {
                        handleParams.addRule(9);
                        handleParams.leftMargin = margin;
                        handleParams.bottomMargin = margin;
                        aboutKidozParams.addRule(7, this.mPanelSliderView.getId());
                        aboutKidozParams.rightMargin = margin;
                        aboutKidozParams.bottomMargin = margin;
                        parentalLockParams.addRule(0, this.mAboutKidozButton.getId());
                        parentalLockParams.rightMargin = margin;
                        parentalLockParams.bottomMargin = margin;
                        break;
                    }
                    case CENTER: {
                        handleParams.addRule(14);
                        handleParams.bottomMargin = margin;
                        aboutKidozParams.addRule(7, this.mPanelSliderView.getId());
                        aboutKidozParams.rightMargin = margin;
                        aboutKidozParams.bottomMargin = margin;
                        parentalLockParams.addRule(0, this.mAboutKidozButton.getId());
                        parentalLockParams.rightMargin = margin;
                        parentalLockParams.bottomMargin = margin;
                        break;
                    }
                    case END: {
                        handleParams.addRule(7, this.mPanelSliderView.getId());
                        handleParams.bottomMargin = margin;
                        handleParams.rightMargin = margin;
                        parentalLockParams.addRule(5, this.mPanelSliderView.getId());
                        parentalLockParams.leftMargin = margin;
                        parentalLockParams.bottomMargin = margin;
                        aboutKidozParams.addRule(1, this.mParentalLockButton.getId());
                        aboutKidozParams.leftMargin = margin;
                        aboutKidozParams.bottomMargin = margin;
                    }
                }
                containerParams.addRule(12);
            }
        }
    }

    private void initContentLogicLoader() {
        this.mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback(){

            @Override
            public void onDataReady(ContentData contentData) {
                if (contentData != null) {
                    PanelView.this.mPanelSliderView.setContent(contentData.getContentDataItems());
                }
            }
        });
    }

    private void toggleAnimation() {
        if (this.mIsOpen) {
            this.collapsePanelView();
        } else {
            this.expandPanelView();
        }
    }

    public void collapsePanelView() {
        if (!this.mIsAnimationRunning && this.mIsOpen) {
            GenAnimator.closePanelView((View)this.mContainer, 200L, (View)this.mPanelSliderView, this.mPanelType, new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                    GenAnimator.animateHandleClose((View)PanelView.this.mHandleButton, null);
                    GenAnimator.playShrinkAnimation((View)PanelView.this.mParentalLockButton, 350L, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                        }

                        public void onAnimationEnd(Animator animation) {
                            PanelView.this.mParentalLockButton.setVisibility(4);
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                    GenAnimator.playShrinkAnimation((View)PanelView.this.mAboutKidozButton, 350L, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                        }

                        public void onAnimationEnd(Animator animation) {
                            PanelView.this.mAboutKidozButton.setVisibility(4);
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                }

                public void onAnimationEnd(Animator animation) {
                    PanelView.this.mPanelSliderView.clearContent();
                    PanelView.this.mIsOpen = false;
                    PanelView.this.mIsAnimationRunning = false;
                    if (PanelView.this.mIOnPanelViewEventListener != null) {
                        PanelView.this.mIOnPanelViewEventListener.onPanelViewCollapsed();
                    }
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
    }

    public void expandPanelView() {
        if (!this.mIsAnimationRunning && !this.mIsOpen) {
            EventManager.getInstance().logEvent(this.getContext(), EventManager.LOG_CRITICAL_LEVEL, "Sponsored Content", "Widget View", "Panel View");
            boolean isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
            this.mParentalLockButton.setIsLockActive(isLockActive);
            GenAnimator.openPanelView((View)this.mContainer, (View)this.mPanelSliderView, this.mPanelType, new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                    GenAnimator.animateHandleOpen((View)PanelView.this.mHandleButton, null);
                    PanelView.this.mContentLogicLoader.loadContent(PanelView.this.getContext(), UiStyleType.FEED_VIEW_STYLE);
                }

                public void onAnimationEnd(Animator animation) {
                    PanelView.this.mIsOpen = true;
                    PanelView.this.mIsAnimationRunning = false;
                    GenAnimator.playGrowAnimation((View)PanelView.this.mParentalLockButton, 120L, 0L, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                            PanelView.this.mParentalLockButton.setVisibility(0);
                        }

                        public void onAnimationEnd(Animator animation) {
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                    GenAnimator.playGrowAnimation((View)PanelView.this.mAboutKidozButton, 120L, 125L, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                            PanelView.this.mAboutKidozButton.setVisibility(0);
                        }

                        public void onAnimationEnd(Animator animation) {
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                    if (PanelView.this.mIOnPanelViewEventListener != null) {
                        PanelView.this.mIOnPanelViewEventListener.onPanelViewExpanded();
                    }
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
    }

    public void setPanelConfiguration(PANEL_TYPE panelType, HANDLE_POSITION handlePosition) {
        this.mPanelType = panelType;
        this.mHandlePosition = handlePosition;
        this.initPanelViewsRules();
    }

    public void setOnPanelViewEventListener(IOnPanelViewEventListener iOnPanelViewEventListener) {
        this.mIOnPanelViewEventListener = iOnPanelViewEventListener;
    }
}

