/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.kidoz.sdk.api.FeedButton;
import com.kidoz.sdk.api.FeedView;
import com.kidoz.sdk.api.PanelView;
import com.kidoz.sdk.api.interfaces.IOnFeedViewEventListener;
import com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;
import com.unity3d.player.UnityPlayer;

public final class KidozUnityBridge {
    private static KidozUnityBridge mKidozUnity;
    private Context mContext;
    private FeedView mFeedView;
    private PanelView mPanelView;
    private FeedButton mFeedButton;
    private FrameLayout mContainer;
    private boolean isContianerAdded = false;
    private String mGameObject;
    private String mShowMethodName;
    private String mDismissMethodName;

    public KidozUnityBridge(Context context) {
        this.mContext = context;
        this.mContainer = new FrameLayout(this.mContext);
    }

    public static KidozUnityBridge getInstance(Context context) {
        if (mKidozUnity == null) {
            mKidozUnity = new KidozUnityBridge(context);
        }
        return mKidozUnity;
    }

    public void addFeedButton(int x, int y) {
        this.addFeedButton(x, y, -1);
    }

    public void addFeedButton(final int x, final int y, int size) {
        this.addContainerIfNedded();
        if (this.mFeedButton == null) {
            this.mFeedButton = size == -1 ? new FeedButton(this.mContext) : new FeedButton(this.mContext, size);
            this.mFeedButton.getFeedView().setOnFeedViewEventListener(new IOnFeedViewEventListener(){

                @Override
                public void onDismissView() {
                    if (KidozUnityBridge.this.mGameObject != null && KidozUnityBridge.this.mDismissMethodName != null) {
                        UnityPlayer.UnitySendMessage((String)KidozUnityBridge.this.mGameObject, (String)KidozUnityBridge.this.mDismissMethodName, (String)"Show");
                    }
                }

                @Override
                public void onReadyToShow() {
                    if (KidozUnityBridge.this.mGameObject != null && KidozUnityBridge.this.mShowMethodName != null) {
                        UnityPlayer.UnitySendMessage((String)KidozUnityBridge.this.mGameObject, (String)KidozUnityBridge.this.mShowMethodName, (String)"Dismiss");
                    }
                }
            });
        }
        if (this.mContext instanceof Activity) {
            ((Activity)this.mContext).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (!KidozUnityBridge.this.isChildViewExistsInContainer((View)KidozUnityBridge.this.mFeedButton)) {
                        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
                        params.setMargins(x, y, 0, 0);
                        KidozUnityBridge.this.mContainer.addView((View)KidozUnityBridge.this.mFeedButton, (ViewGroup.LayoutParams)params);
                    }
                }
            });
        }
    }

    public void removeFeedButton() {
        ((Activity)this.mContext).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (KidozUnityBridge.this.mFeedButton != null) {
                    KidozUnityBridge.this.mContainer.removeView((View)KidozUnityBridge.this.mFeedButton);
                }
            }
        });
    }

    public void changeFeedButtonVisibility(final boolean visible) {
        ((Activity)this.mContext).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (KidozUnityBridge.this.mFeedButton != null) {
                    if (visible) {
                        KidozUnityBridge.this.mFeedButton.setVisibility(0);
                    } else {
                        KidozUnityBridge.this.mFeedButton.setVisibility(4);
                    }
                }
            }
        });
    }

    private boolean isChildViewExistsInContainer(View view) {
        boolean exists = false;
        if (this.mContainer != null && this.mContainer.getChildCount() > 0) {
            for (int i = 0; i < this.mContainer.getChildCount(); ++i) {
                if (this.mContainer.getChildAt(i) != view) continue;
                exists = true;
                break;
            }
        }
        return exists;
    }

    private void addContainerIfNedded() {
        ((Activity)this.mContext).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!KidozUnityBridge.this.isContianerAdded && KidozUnityBridge.this.mContext instanceof Activity) {
                    ((Activity)KidozUnityBridge.this.mContext).addContentView((View)KidozUnityBridge.this.mContainer, new ViewGroup.LayoutParams(-1, -1));
                    KidozUnityBridge.this.isContianerAdded = true;
                }
            }
        });
    }

    public void showFeedView() {
        if (this.mFeedView == null) {
            this.mFeedView = new FeedView.Builder(this.mContext).build();
            this.mFeedView.setOnFeedViewEventListener(new IOnFeedViewEventListener(){

                @Override
                public void onDismissView() {
                    if (KidozUnityBridge.this.mGameObject != null && KidozUnityBridge.this.mDismissMethodName != null) {
                        UnityPlayer.UnitySendMessage((String)KidozUnityBridge.this.mGameObject, (String)KidozUnityBridge.this.mDismissMethodName, (String)"Dismiss");
                    }
                }

                @Override
                public void onReadyToShow() {
                    if (KidozUnityBridge.this.mGameObject != null && KidozUnityBridge.this.mShowMethodName != null) {
                        UnityPlayer.UnitySendMessage((String)KidozUnityBridge.this.mGameObject, (String)KidozUnityBridge.this.mShowMethodName, (String)"Show");
                    }
                }
            });
        }
        ((Activity)this.mContext).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (KidozUnityBridge.this.mFeedView != null) {
                    KidozUnityBridge.this.mFeedView.showView();
                }
            }
        });
    }

    public void dismissFeedView() {
        ((Activity)this.mContext).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (KidozUnityBridge.this.mFeedView != null) {
                    KidozUnityBridge.this.mFeedView.dismissView();
                }
            }
        });
    }

    public void setFeedViewEventListeners(String gameObject, String showMethodName, String dismissMethodName) {
        this.mGameObject = gameObject;
        this.mShowMethodName = showMethodName;
        this.mDismissMethodName = dismissMethodName;
    }

    public void addPanelView(PANEL_TYPE panel_type, HANDLE_POSITION handle_position) {
        this.addContainerIfNedded();
        if (this.mPanelView == null) {
            this.mPanelView = new PanelView(this.mContext);
        }
        this.mPanelView.setPanelConfiguration(panel_type, handle_position);
        if (this.mContext instanceof Activity) {
            ((Activity)this.mContext).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (!KidozUnityBridge.this.isChildViewExistsInContainer((View)KidozUnityBridge.this.mPanelView)) {
                        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
                        KidozUnityBridge.this.mContainer.addView((View)KidozUnityBridge.this.mFeedButton, (ViewGroup.LayoutParams)params);
                    }
                }
            });
        }
    }

    public void changePanelVisibility(final boolean visible) {
        ((Activity)this.mContext).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (KidozUnityBridge.this.mPanelView != null) {
                    if (visible) {
                        KidozUnityBridge.this.mPanelView.setVisibility(0);
                    } else {
                        KidozUnityBridge.this.mPanelView.setVisibility(4);
                    }
                }
            }
        });
    }

    public void removePanelView() {
        ((Activity)this.mContext).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (KidozUnityBridge.this.mPanelView != null) {
                    KidozUnityBridge.this.mContainer.removeView((View)KidozUnityBridge.this.mPanelView);
                }
            }
        });
    }

    public int getFeedButtonDefaultSize(Context context) {
        return FeedButton.getDefaultButtonSize(context);
    }
}

