/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import android.view.WindowManager;
import com.kidoz.events.DeviceUtils;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;
import com.kidoz.sdk.api.structure.CreativeToolsData;
import org.json.JSONObject;

public class KidozSDK {
    private static final String TAG = KidozSDK.class.getSimpleName();
    public static final String SERVER_CONNECTION_URL = "https://kidoz.net";
    private static SdkAPIManager sdkAPIManager;
    private static CreativeToolsData sCreativeToolsData;
    private static boolean isInitialized;
    private static String mPublicherKey;
    private static String mSecurityKey;

    public static void initialize(Context context, String publicher_id, String token) {
        try {
            DeviceUtils.getGoogleAdvertisingID(context);
            SharedPreferences eventsPref = context.getSharedPreferences("events_shared_preferences", 0);
            long sessionID = eventsPref.getLong("last_session_id", 0L);
            SharedPreferences.Editor editor = eventsPref.edit();
            editor.putLong("last_session_id", ++sessionID);
            editor.commit();
            SharedPreferencesUtils.saveSharedPreferencesData(context, "PUBLISHER_ID", publicher_id);
            JSONObject eventParams = new JSONObject();
            eventParams.put("DeveloperID", (Object)publicher_id);
            eventParams.put("log_level", EventManager.LOG_NORMAL_LEVEL);
            eventParams.put("SessionID", sessionID);
            EventManager.getInstance().init(context, eventParams);
            EventManager.getInstance().setSyncAlarm(context);
            EventManager.getInstance().logEvent(context, EventManager.LOG_CRITICAL_LEVEL, "SDK", "SDK Init", publicher_id);
            EventManager.getInstance().logEvent(context, EventManager.LOG_CRITICAL_LEVEL, "Session", "Session Start", publicher_id);
            EventManager.getInstance().startSync(context);
            KidozSDK.initFrameRate(context);
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to create device params: " + ex.getMessage());
        }
        if (publicher_id == null || token == null) {
            throw new RuntimeException("Missing valid publisher id or security token!");
        }
        mPublicherKey = publicher_id;
        mSecurityKey = token;
        sdkAPIManager = new SdkAPIManager(context, publicher_id, token);
        isInitialized = true;
        KidozSDK.validateSDKConfiguration(context);
        DeviceUtils.generateGoogleAdvertisingIDInBackground(context);
    }

    public static void setCreativeToolsData(CreativeToolsData creativeToolsData) {
        sCreativeToolsData = creativeToolsData;
    }

    public static CreativeToolsData getCreativeToolsData() {
        if (sCreativeToolsData == null) {
            sCreativeToolsData = new CreativeToolsData();
        }
        return sCreativeToolsData;
    }

    public static SdkAPIManager getApiManager(Context context) {
        if (sdkAPIManager == null) {
            sdkAPIManager = new SdkAPIManager(context, mPublicherKey, mSecurityKey);
        }
        return sdkAPIManager;
    }

    static boolean isInitialised() {
        if (!isInitialized) {
            Log.e((String)"[KIDOZ SDK]", (String)"Kidoz SDK need to be initialized !");
        }
        return isInitialized;
    }

    private static void validateSDKConfiguration(final Context context) {
        SDKLogger.printDebbugLog(TAG, ">>>>validateSDKConfiguration");
        if (context != null) {
            KidozSDK.getApiManager(context).validateSDKConfiguration(context, new ApiResultCallback<PropertiesObj>(){

                @Override
                public void onServerResult(ResultData<?> result) {
                    if (result != null && result.getResponseStatus() != null && result.getResponseStatus().getIsSuccessful() && result.getData() != null && result.getData() instanceof PropertiesObj) {
                        final PropertiesObj serverConfig = (PropertiesObj)result.getData();
                        PropertiesObj appConfig = DatabaseManager.getInstance(context).getConfigTable().loadAppProperties();
                        SDKLogger.printDebbugLog(TAG, ">>>>Server config version = " + serverConfig.getConfigVersion());
                        SDKLogger.printDebbugLog(TAG, ">>>>App config version = " + (appConfig == null ? "NULL" : Integer.valueOf(appConfig.getConfigVersion())));
                        if (appConfig == null || appConfig.getConfigVersion() < serverConfig.getConfigVersion()) {
                            SDKLogger.printDebbugLog(TAG, ">>>>Going to download resources...");
                            KidozSDK.getApiManager(context).getSDKResources(context, new ApiResultCallback<Boolean>(){

                                @Override
                                public void onServerResult(ResultData<?> result) {
                                    if (result != null && result.getResponseStatus() != null && result.getResponseStatus().getIsSuccessful() && result.getData() != null && result.getData() instanceof Boolean && ((Boolean)result.getData()).booleanValue()) {
                                        SDKLogger.printDebbugLog(TAG, ">>>>All resources downloaded");
                                        DatabaseManager.getInstance(context).getConfigTable().insertAppProperties(serverConfig);
                                    }
                                }

                                @Override
                                public void onFailed() {
                                }
                            });
                        }
                    }
                }

                @Override
                public void onFailed() {
                }
            });
        }
    }

    private static void initFrameRate(Context context) {
        float frameRate = ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getRefreshRate();
        SDKLogger.printDebbugLog(TAG, ">>>>frameRate = " + String.valueOf(frameRate));
    }

    static {
        isInitialized = false;
        mPublicherKey = null;
        mSecurityKey = null;
    }
}

