/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.ContentExecutionHandler;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.BaseDialog;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.interfaces.IOnFeedViewEventListener;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.AbstractContentPanel;
import com.kidoz.sdk.api.ui_views.FeedFullVeiw;
import java.io.Serializable;

class FeedViewDialog
extends BaseDialog {
    private static final String SAVE_DATA_INSTANCE_KEY = "SAVE_DATA_INSTANCE_KEY";
    private static final String SAVE_ORIGINAL_ORIENTATION_KEY = "SAVE_ORIGINAL_ORIENTATION_KEY";
    private FeedFullVeiw mFeedFullVeiw;
    private ContentData mContentData = null;
    private View.OnClickListener mCloseBtnClickListener = null;
    private int mCurrentOrientationState;
    private long mEventID;
    private boolean mImpressionServed;
    private IOnFeedViewEventListener mOnInterstitialViewEventListener;

    public FeedViewDialog(Context context) {
        super(context, 16973834);
        this.setCancelable(false);
        this.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                boolean result = true;
                if (event.getAction() == 0 && keyCode == 4) {
                    if (FeedViewDialog.this.mFeedFullVeiw != null && FeedViewDialog.this.mFeedFullVeiw.getViewBottomBar().isAboutViewVisible()) {
                        FeedViewDialog.this.mFeedFullVeiw.getViewBottomBar().hideAboutView();
                    } else {
                        if (FeedViewDialog.this.mOnInterstitialViewEventListener != null) {
                            FeedViewDialog.this.mOnInterstitialViewEventListener.onDismissView();
                        }
                        FeedViewDialog.this.closeDialog();
                    }
                }
                return result;
            }
        });
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null && savedInstanceState.containsKey(SAVE_ORIGINAL_ORIENTATION_KEY)) {
            this.mCurrentOrientationState = savedInstanceState.getInt(SAVE_ORIGINAL_ORIENTATION_KEY);
        } else {
            this.mCurrentOrientationState = this.mCallingActivity.getResources().getConfiguration().orientation;
            this.mCallingActivity.setRequestedOrientation(4);
        }
        this.mImpressionServed = false;
        if (this.mContentData == null && savedInstanceState != null && savedInstanceState.containsKey(SAVE_DATA_INSTANCE_KEY)) {
            this.mContentData = (ContentData)savedInstanceState.get(SAVE_DATA_INSTANCE_KEY);
        }
        this.mFeedFullVeiw = new FeedFullVeiw((Context)this.mCallingActivity);
        this.mFeedFullVeiw.setOnContentItemClickListener(new AbstractContentPanel.IOnContentItemClickListener(){

            @Override
            public void onItemClick(ContentItem contentItem, int postion) {
                if (contentItem != null && contentItem.getContentType() != null && contentItem.getContentType() != ContentType.NONE) {
                    ContentExecutionHandler.handleContentItemClick((Context)FeedViewDialog.this.mCallingActivity, contentItem, postion);
                }
            }
        });
        this.mFeedFullVeiw.setOnCloseButtonClickListenr(this.mCloseBtnClickListener);
        this.mFeedFullVeiw.setContentDataAndRefresh(this.mContentData);
        this.setContentView((View)this.mFeedFullVeiw);
    }

    protected void setContentData(ContentData contentData) {
        this.mContentData = contentData;
        if (this.mFeedFullVeiw != null) {
            this.mFeedFullVeiw.setContentDataAndRefresh(this.mContentData);
        }
    }

    protected void setOnCloseButtonClickListenr(View.OnClickListener clickListenr) {
        this.mCloseBtnClickListener = clickListenr;
        if (this.mFeedFullVeiw != null) {
            this.mFeedFullVeiw.setOnCloseButtonClickListenr(this.mCloseBtnClickListener);
        }
    }

    public Bundle onSaveInstanceState() {
        Bundle bundle = super.onSaveInstanceState();
        if (this.mContentData != null) {
            bundle.putSerializable(SAVE_DATA_INSTANCE_KEY, (Serializable)this.mContentData);
            bundle.putInt(SAVE_ORIGINAL_ORIENTATION_KEY, this.mCurrentOrientationState);
        }
        return bundle;
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
    }

    @Override
    protected void closeDialog() {
        this.mContentData = null;
        super.closeDialog();
        this.restoreUserOriginalOrientation();
    }

    @Override
    protected void openDialog() {
        if (KidozSDK.isInitialised()) {
            super.openDialog();
            EventManager.getInstance().logEvent((Context)this.mCallingActivity, EventManager.LOG_CRITICAL_LEVEL, "Sponsored Content", "Widget View", "Feed View");
        }
    }

    private void restoreUserOriginalOrientation() {
        if (this.mCallingActivity != null && !this.mCallingActivity.isFinishing()) {
            switch (this.mCurrentOrientationState) {
                case 2: {
                    this.mCallingActivity.setRequestedOrientation(6);
                    break;
                }
                case 1: {
                    this.mCallingActivity.setRequestedOrientation(7);
                    break;
                }
                case 0: {
                    this.mCallingActivity.setRequestedOrientation(4);
                }
            }
        }
    }

    public void setOnInterstitialViewEventListener(IOnFeedViewEventListener onInterstitialViewEventListener) {
        this.mOnInterstitialViewEventListener = onInterstitialViewEventListener;
    }
}

