/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.app.Activity;
import android.content.Context;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.View;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.ContentLogicLoader;
import com.kidoz.sdk.api.FeedVeiwFragmentDialog;
import com.kidoz.sdk.api.FeedViewDialog;
import com.kidoz.sdk.api.general.enums.UiStyleType;
import com.kidoz.sdk.api.interfaces.IOnFeedViewEventListener;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import java.util.ArrayList;

public class FeedView {
    private static final String TAG = FeedView.class.getSimpleName();
    private Builder mBuilder;
    private FeedVeiwFragmentDialog mFeedVeiwFragmentDialog;
    private FeedViewDialog mFeedViewDialog;
    protected ContentLogicLoader mContentLogicLoader;
    private IOnFeedViewEventListener mOnInterstitialViewEventListener;
    private boolean mIsPostLoadData = false;

    private FeedView(Builder builder) {
        this.mBuilder = builder;
        if (this.mBuilder.mFragmentManager != null) {
            Fragment existingDialog = this.mBuilder.mFragmentManager.findFragmentByTag(FeedVeiwFragmentDialog.TAG);
            this.mFeedVeiwFragmentDialog = existingDialog != null && existingDialog instanceof FeedVeiwFragmentDialog ? (FeedVeiwFragmentDialog)existingDialog : FeedVeiwFragmentDialog.newInstance();
            this.mFeedVeiwFragmentDialog.setOnCloseButtonClickListenr(new View.OnClickListener(){

                public void onClick(View view) {
                    FeedView.this.dismissView();
                }
            });
        }
        this.initContentLogicLoader();
    }

    private void initContentLogicLoader() {
        this.mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback(){

            @Override
            public void onDataReady(ContentData contentData) {
                int servedCounter = 0;
                if (contentData != null) {
                    ArrayList<ContentItem> contentItems = contentData.getContentDataItems();
                    if (contentItems != null && !contentItems.isEmpty()) {
                        for (ContentItem nextContentItem : contentItems) {
                            if (!nextContentItem.isPromoted()) continue;
                            ++servedCounter;
                        }
                    }
                    EventManager.getInstance().LogEventWithIntField(FeedView.this.mBuilder.mContext, EventManager.LOG_CRITICAL_LEVEL, "Sponsored Content", "Impression Served", null, servedCounter);
                }
                if (FeedView.this.mBuilder.mFragmentManager != null && FeedView.this.mFeedVeiwFragmentDialog != null) {
                    FeedView.this.mFeedVeiwFragmentDialog.setContentData(contentData);
                } else if (FeedView.this.mFeedViewDialog != null) {
                    FeedView.this.mFeedViewDialog.setContentData(contentData);
                }
                if (!FeedView.this.mIsPostLoadData) {
                    if (FeedView.this.mOnInterstitialViewEventListener != null) {
                        FeedView.this.mOnInterstitialViewEventListener.onReadyToShow();
                    }
                    if (FeedView.this.mBuilder.mFragmentManager != null && FeedView.this.mFeedVeiwFragmentDialog != null) {
                        FeedView.this.mFeedVeiwFragmentDialog.openDialog(FeedView.this.mBuilder.mFragmentManager);
                    } else {
                        FeedView.this.openSimpleDialog();
                    }
                }
            }
        });
    }

    public void showView() {
        this.mIsPostLoadData = true;
        if (this.mOnInterstitialViewEventListener != null) {
            this.mOnInterstitialViewEventListener.onReadyToShow();
        }
        if (this.mBuilder.mFragmentManager != null && this.mFeedVeiwFragmentDialog != null) {
            this.mFeedVeiwFragmentDialog.openDialog(this.mBuilder.mFragmentManager);
        } else {
            this.openSimpleDialog();
        }
        this.mContentLogicLoader.loadContent(this.mBuilder.mContext, UiStyleType.FEED_VIEW_STYLE);
    }

    private void openSimpleDialog() {
        if (this.mBuilder.mContext != null && this.mBuilder.mContext instanceof Activity) {
            this.mFeedViewDialog = new FeedViewDialog(this.mBuilder.mContext);
            this.mFeedViewDialog.setOnCloseButtonClickListenr(new View.OnClickListener(){

                public void onClick(View view) {
                    FeedView.this.dismissView();
                }
            });
        }
        this.mFeedViewDialog.openDialog();
    }

    public void dismissView() {
        if (this.mBuilder.mFragmentManager != null && this.mFeedVeiwFragmentDialog != null) {
            this.mFeedVeiwFragmentDialog.closeDialog(this.mBuilder.mFragmentManager);
            if (this.mOnInterstitialViewEventListener != null) {
                this.mOnInterstitialViewEventListener.onDismissView();
            }
        } else {
            if (this.mFeedViewDialog != null) {
                this.mFeedViewDialog.closeDialog();
            }
            if (this.mOnInterstitialViewEventListener != null) {
                this.mOnInterstitialViewEventListener.onDismissView();
            }
        }
    }

    public void setOnFeedViewEventListener(IOnFeedViewEventListener listener) {
        this.mOnInterstitialViewEventListener = listener;
        if (this.mBuilder.mFragmentManager != null && this.mFeedVeiwFragmentDialog != null) {
            this.mFeedVeiwFragmentDialog.setOnInterstitialViewEventListener(this.mOnInterstitialViewEventListener);
        } else if (this.mFeedViewDialog != null) {
            this.mFeedViewDialog.setOnInterstitialViewEventListener(this.mOnInterstitialViewEventListener);
        }
    }

    public void onConfigurationChange() {
        if (this.mFeedViewDialog != null) {
            this.mFeedViewDialog.setOnCloseButtonClickListenr(new View.OnClickListener(){

                public void onClick(View view) {
                    FeedView.this.dismissView();
                }
            });
        }
    }

    public static class Builder {
        private FragmentManager mFragmentManager = null;
        private Context mContext;

        public Builder(Context context) {
            this.mContext = context;
            if (context instanceof FragmentActivity) {
                this.mFragmentManager = ((FragmentActivity)this.mContext).getSupportFragmentManager();
            }
        }

        public FeedView build() {
            return new FeedView(this);
        }
    }
}

