/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.FeedView;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.custom_views.AnimatableGifImageView;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.KidozLogoDrawable;

public class FeedButton
extends RelativeLayout {
    private static final String TAG = FeedButton.class.getSimpleName();
    private static final float BUTTON_SIZE_AS_SCREEN_PORTION = 0.27f;
    private AnimatableGifImageView mAnimatableGifImageView;
    private FeedView mFeedView;
    private View mRootView;

    public FeedButton(Context context) {
        super(context);
        this.intiView(-1);
    }

    public FeedButton(Context context, int size) {
        super(context);
        this.intiView(size);
    }

    public FeedButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.intiView(-1);
    }

    public FeedButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.intiView(-1);
    }

    private void intiView(int initSize) {
        this.mRootView = this;
        int size = FeedButton.getDefaultButtonSize(this.getContext());
        if (initSize != -1) {
            size = initSize;
        }
        this.mAnimatableGifImageView = new AnimatableGifImageView(this.getContext());
        RelativeLayout.LayoutParams animatableImageParams = new RelativeLayout.LayoutParams(size, size);
        this.addView((View)this.mAnimatableGifImageView, (ViewGroup.LayoutParams)animatableImageParams);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(size, size);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        KidozLogoDrawable kidozLogoDrawable = new KidozLogoDrawable();
        if (Build.VERSION.SDK_INT >= 16) {
            this.mAnimatableGifImageView.setBackground(kidozLogoDrawable);
        } else {
            this.mAnimatableGifImageView.setBackgroundDrawable(kidozLogoDrawable);
        }
        if (!this.isInEditMode()) {
            this.mAnimatableGifImageView.setAnimatedGif(Utils.prepareCorrectUri("https://kidoz-cdn.s3.amazonaws.com/sdk/btn_animation.gif"), new AnimatableGifImageView.IOnAnimatedGifReadyListener(){

                @Override
                public void onGifReady() {
                    if (Build.VERSION.SDK_INT >= 16) {
                        FeedButton.this.mAnimatableGifImageView.setBackground(null);
                    } else {
                        FeedButton.this.mAnimatableGifImageView.setBackgroundDrawable(null);
                    }
                }
            });
            this.initFeedView();
        }
    }

    private void initClickListener() {
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FeedButton.this.mFeedView != null) {
                    GenAnimator.clickItemAnimation(FeedButton.this.mRootView, 100, new GenAnimator.ViewAnimationListener(){

                        @Override
                        public void onAnimationEnd() {
                            FeedButton.this.mFeedView.showView();
                        }

                        @Override
                        public void onAnimationStart() {
                        }
                    });
                }
            }
        });
    }

    private void initFeedView() {
        this.mFeedView = new FeedView.Builder(this.getContext()).build();
        this.initClickListener();
    }

    public FeedView getFeedView() {
        if (this.mFeedView == null) {
            this.initFeedView();
        }
        return this.mFeedView;
    }

    public void setFeedButtonSize(int size) {
        this.mAnimatableGifImageView.getLayoutParams().height = size;
        this.mAnimatableGifImageView.getLayoutParams().width = size;
        this.getLayoutParams().height = size;
        this.getLayoutParams().width = size;
    }

    public static int getDefaultButtonSize(Context context) {
        Point point = Utils.getScreenSize(context);
        return (int)((float)Math.min(point.x, point.y) * 0.27f);
    }
}

