/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.content.Context;
import android.widget.Toast;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.enums.UiStyleType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.structure.ContentData;

public class ContentLogicLoader {
    IOnContentDataReadyCallback mDataReadyCallback;
    private boolean mIsLoadContentIsInProgress;

    public ContentLogicLoader(IOnContentDataReadyCallback dataReadyCallback) {
        this.mDataReadyCallback = dataReadyCallback;
    }

    public void loadContent(final Context context, UiStyleType view_style) {
        if (!this.mIsLoadContentIsInProgress) {
            this.mIsLoadContentIsInProgress = true;
            SDKLogger.printDebbugLog(">>>>loadContent");
            KidozSDK.getApiManager(context).loadContent(context, view_style, new ApiResultCallback<ContentData>(){

                @Override
                public void onServerResult(ResultData<?> result) {
                    ContentData contentData;
                    if (result != null && result.getData() != null && (contentData = (ContentData)result.getData()).isHasContentToShow() && ContentLogicLoader.this.mDataReadyCallback != null) {
                        ContentLogicLoader.this.mDataReadyCallback.onDataReady(contentData);
                    }
                    ContentLogicLoader.this.mIsLoadContentIsInProgress = false;
                }

                @Override
                public void onFailed() {
                    ContentLogicLoader.this.mIsLoadContentIsInProgress = false;
                    Toast.makeText((Context)context, (CharSequence)"No internet connection", (int)1).show();
                }
            });
        }
    }

    protected void loadRefreshebleContent(UiStyleType view_style) {
    }

    public static interface IOnContentDataReadyCallback {
        public void onDataReady(ContentData var1);
    }
}

