/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.YouTubeUtils;
import com.kidoz.sdk.api.players.video_player.YouTubePlayerActivity;
import com.kidoz.sdk.api.players.web_player.WebPlayerDialog;
import com.kidoz.sdk.api.players.web_player.WebPlayerFragmentDialog;
import com.kidoz.sdk.api.players.web_player.WebPlayerType;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.structure.IsEventRecord;
import java.util.List;

public class ContentExecutionHandler {
    public static final String TAG = ContentExecutionHandler.class.getSimpleName();

    public static void handleContentItemClick(final Context context, final ContentItem contentItem, final int position) {
        switch (contentItem.getContentType()) {
            case GOOGLE_PLAY_APPLICATION: {
                boolean isLockActive;
                boolean bl = isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(context, "PARENTAL_LOCK_ACTIVE_KEY") != null;
                if (isLockActive && ParentalLockDialog.getIsCanShowDialog(context)) {
                    int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(context, true) * 0.5f), (int)((float)ScreenUtils.getScreenSize(context, false) * 0.5f)};
                    ParentalLockDialog parentalLockDialog = new ParentalLockDialog(context, true, popLocation);
                    parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener(){

                        @Override
                        public void onPasswordEntered(boolean isPasswordCorrect) {
                            if (isPasswordCorrect) {
                                ContentExecutionHandler.onGooglePlayApp(context, contentItem, position);
                            } else {
                                EventManager.getInstance().LogEvent(context, EventManager.LOG_NORMAL_LEVEL, null, "SDK", "Incorrect Password", contentItem.getId());
                            }
                        }
                    });
                    parentalLockDialog.show();
                    break;
                }
                ContentExecutionHandler.onGooglePlayApp(context, contentItem, position);
                break;
            }
            case PROMOTED_PLAY_APPLICATION: {
                boolean isLockActive;
                if (context == null || contentItem == null) break;
                boolean bl = isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(context, "PARENTAL_LOCK_ACTIVE_KEY") != null;
                if (isLockActive && ParentalLockDialog.getIsCanShowDialog(context)) {
                    int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(context, true) * 0.5f), (int)((float)ScreenUtils.getScreenSize(context, false) * 0.5f)};
                    ParentalLockDialog parentalLockDialog = new ParentalLockDialog(context, true, popLocation);
                    parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener(){

                        @Override
                        public void onPasswordEntered(boolean isPasswordCorrect) {
                            if (isPasswordCorrect) {
                                ContentExecutionHandler.onPromotedAppItemClick(context, contentItem, position);
                                IsEventRecord isEventRecord = new IsEventRecord();
                                isEventRecord.setPackageName(contentItem.getId());
                                isEventRecord.setContentType(contentItem.getContentType().toString());
                                isEventRecord.setName(contentItem.getName());
                                isEventRecord.setPositionIndex(position);
                                isEventRecord.setAdvertiserId(contentItem.getAdvertiserID());
                                isEventRecord.setTimeStamp(System.currentTimeMillis() + "");
                                DatabaseManager.getInstance(context).getIsEventTable().insertRecord(isEventRecord);
                            } else {
                                EventManager.getInstance().LogEvent(context, EventManager.LOG_NORMAL_LEVEL, null, "Sponsored Content", "Incorrect Password", contentItem.getId());
                            }
                        }
                    });
                    parentalLockDialog.show();
                    break;
                }
                ContentExecutionHandler.onPromotedAppItemClick(context, contentItem, position);
                IsEventRecord isEventRecord = new IsEventRecord();
                isEventRecord.setPackageName(contentItem.getId());
                isEventRecord.setContentType(contentItem.getContentType().toString());
                isEventRecord.setName(contentItem.getName());
                isEventRecord.setPositionIndex(position);
                isEventRecord.setAdvertiserId(contentItem.getAdvertiserID());
                isEventRecord.setTimeStamp(System.currentTimeMillis() + "");
                DatabaseManager.getInstance(context).getIsEventTable().insertRecord(isEventRecord);
                break;
            }
            case WEB_GAME_URL: {
                ContentExecutionHandler.onlineGameItemClick(context, contentItem, position);
                break;
            }
            case WEBSITE_URL: {
                ContentExecutionHandler.onUrlItemClick(context, contentItem, position);
                break;
            }
            case YOTUBE_VIDEO: {
                ContentExecutionHandler.onYouTubeVideolItemClick(context, contentItem, position);
                break;
            }
        }
    }

    protected static void onPromotedAppItemClick(Context context, ContentItem contentItem, int position) {
        if (contentItem.getData() != null && contentItem.getData().startsWith("market://") || contentItem.getData().startsWith("https://play.google.com") || contentItem.getData().startsWith("http://play.google.com")) {
            try {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)contentItem.getData()));
                List otherApps = context.getPackageManager().queryIntentActivities(intent, 0);
                EventManager.getInstance().logSponsoredContentClickEvent(context, contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position);
                for (ResolveInfo otherApp : otherApps) {
                    if (!otherApp.activityInfo.applicationInfo.packageName.equals("com.android.vending")) continue;
                    ActivityInfo otherAppActivity = otherApp.activityInfo;
                    ComponentName componentName = new ComponentName(otherAppActivity.applicationInfo.packageName, otherAppActivity.name);
                    intent.setFlags(0x10200000);
                    intent.setComponent(componentName);
                    context.startActivity(intent);
                }
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to open google play for promoted app: \n" + ex.getMessage());
            }
        } else {
            ContentExecutionHandler.onUrlItemClick(context, contentItem, position);
        }
    }

    protected static void onGooglePlayApp(Context context, ContentItem contentItem, int position) {
        EventManager.getInstance().logClickEvent(context, "Feed Click", "Google Play App", contentItem.getId(), position);
        Intent googlePlayIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + contentItem.getId())));
        googlePlayIntent.addFlags(0x10000000);
        googlePlayIntent.addFlags(32768);
        context.startActivity(googlePlayIntent);
    }

    protected static void onlineGameItemClick(Context context, ContentItem contentItem, int position) {
        EventManager.getInstance().logClickEvent(context, "Feed Click", "Online Game", contentItem.getId(), position);
        if (context instanceof FragmentActivity) {
            FragmentManager fragmentManager = ((FragmentActivity)context).getSupportFragmentManager();
            WebPlayerFragmentDialog webPlayerFragmentDialog = WebPlayerFragmentDialog.newInstance(contentItem, WebPlayerType.ONLINE_GAME);
            webPlayerFragmentDialog.openDialog(fragmentManager);
        } else {
            WebPlayerDialog webPlayerDialog = new WebPlayerDialog(context, contentItem, WebPlayerType.ONLINE_GAME);
            webPlayerDialog.openDialog();
        }
    }

    protected static void onUrlItemClick(Context context, ContentItem contentItem, int position) {
        EventManager.getInstance().logClickEvent(context, "Feed Click", "URL", contentItem.getId(), position);
        if (context instanceof FragmentActivity) {
            FragmentManager fragmentManager = ((FragmentActivity)context).getSupportFragmentManager();
            WebPlayerType webPlayerType = WebPlayerType.WEB_BROWSER;
            if (contentItem != null && contentItem.getContentType() == ContentType.PROMOTED_PLAY_APPLICATION) {
                webPlayerType = WebPlayerType.EXTERNAL_LINK;
            }
            WebPlayerFragmentDialog webPlayerFragmentDialog = WebPlayerFragmentDialog.newInstance(contentItem, webPlayerType);
            webPlayerFragmentDialog.openDialog(fragmentManager);
        } else {
            WebPlayerDialog webPlayerDialog = new WebPlayerDialog(context, contentItem, WebPlayerType.WEB_BROWSER);
            webPlayerDialog.openDialog();
        }
    }

    protected static void onYouTubeVideolItemClick(Context context, ContentItem contentItem, int position) {
        if (context != null && contentItem != null && contentItem.getData() != null) {
            EventManager.getInstance().logClickEvent(context, "Feed Click", "Youtube", contentItem.getId(), position);
            Intent youtubeActivity = new Intent(context, YouTubePlayerActivity.class);
            youtubeActivity.putExtra("INTENT_EXTRA_VIDEO_ID", YouTubeUtils.extractYouTubeVideoIDString(contentItem.getData()));
            youtubeActivity.putExtra("INTENT_EXTRA_VIDEO_NAME", contentItem.getName());
            youtubeActivity.putExtra("INTENT_EXTRA_CONTENT_ITEM_ID", contentItem.getId());
            context.startActivity(youtubeActivity);
        }
    }
}

