/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.events;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import com.kidoz.events.EventBulk;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.structure.IsEventRecord;

public class SyncEventService
extends IntentService {
    public static final String SYNC_TYPE_KEY = "SYNC_TYPE_KEY";
    public static final int SYNC_EVENTS = 1;
    public static final int UPDATE_INSTALL_EVENT = 2;
    public static final String TAG = SyncEventService.class.getSimpleName();
    private static final int NUM_OF_RETRIES_IN_CASE_FAILED = 1;
    private static final int MAX_TIME_TO_ALLOW_SYNC_TO_RUN = 900000;
    private boolean mSyncRunning = false;
    private boolean mContinueSyncProcces;
    private int munOfRetriesInCaseFailedCount = 1;
    private long mServiceSyncStartTime;
    public static final int MAX_ACCEPTABLE_INSTALL_INTERVAL = 172800000;
    public static final String PACKAGE_NAME_KEY = "packageNameKey";

    public SyncEventService() {
        super("LogIntentService");
    }

    protected void onHandleIntent(Intent intent) {
        SDKLogger.printDebbugLog(TAG, ">>>> SyncEventService : onHandleIntent");
        if (intent != null) {
            if (intent.hasExtra(SYNC_TYPE_KEY)) {
                int type = intent.getIntExtra(SYNC_TYPE_KEY, 1);
                if (type == 2) {
                    this.updateInstallEvent(intent);
                } else {
                    this.syncEvents(intent);
                }
            } else {
                this.syncEvents(intent);
            }
        }
    }

    private void updateInstallEvent(Intent intent) {
        IsEventRecord record;
        DatabaseManager databaseManager;
        SDKLogger.printWarningLog(" ----------------------  ******************************  ----------------------");
        SDKLogger.printWarningLog(" -----------------    START UPDATE CLICK ON INSTALL EVENT ---------------------");
        SDKLogger.printWarningLog(" ----------------------  ******************************  ----------------------");
        String packageName = null;
        if (intent != null && (packageName = intent.getStringExtra(PACKAGE_NAME_KEY)) != null && (databaseManager = DatabaseManager.getInstance(this.getApplicationContext())) != null && (record = databaseManager.getIsEventTable().getRecord(packageName)) != null) {
            long setTime = -1L;
            try {
                setTime = Long.parseLong(record.getTimeStamp());
            }
            catch (NumberFormatException e) {
                setTime = -1L;
            }
            if (setTime != -1L && System.currentTimeMillis() - setTime < 172800000L) {
                EventManager.getInstance().logSponsoredContentInstallEvent(this.getApplicationContext(), record.getPackageName(), record.getAdvertiserId(), record.getPackageName(), record.getPositionIndex());
                SDKLogger.printWarningLog("!!!!!!!! SEND ANALYTICS EVENT OF APPLICATION INSTALLED !!!!!!! ");
                SDKLogger.printWarningLog("getPackageName : " + record.getPackageName());
                SDKLogger.printWarningLog("getTimeStamp : " + record.getTimeStamp());
                SDKLogger.printWarningLog("getItemType : " + record.getContentType());
                SDKLogger.printWarningLog("getLocationInFeed : " + record.getPositionIndex());
                SDKLogger.printWarningLog("getApppName : " + record.getName());
                SDKLogger.printWarningLog("getAdvertiser ID : " + record.getAdvertiserId());
            }
            databaseManager.getIsEventTable().deleteRecord(packageName);
        }
    }

    private void syncEvents(Intent intent) {
        if (intent != null && intent.hasExtra("STOP_SERVICE_EXTRA")) {
            this.mSyncRunning = false;
            this.mContinueSyncProcces = false;
        }
        if (!this.mSyncRunning) {
            SDKLogger.printWarningLog(" ----------------------  ******************************  ----------------------");
            SDKLogger.printWarningLog(" -----------------  START SYNCHRONIZATION OF LOG EVENTS DATA  V4.0 ----------------------");
            SDKLogger.printWarningLog(" ----------------------  ******************************  ----------------------");
            this.mSyncRunning = true;
            this.mContinueSyncProcces = true;
            this.mServiceSyncStartTime = System.currentTimeMillis();
            SDKLogger.printInfoLog("Log Events info:" + this.mSyncRunning + " , " + this.mContinueSyncProcces);
            while (EventManager.getInstance().getIsCanSendLog((Context)this) && this.isAllowedToRunTimeFrame() && this.mContinueSyncProcces) {
                SDKLogger.printDebbugLog(">>>> SyncEventService : sending logs");
                EventBulk bulk = EventManager.getInstance().getNextBulk((Context)this);
                SDKLogger.printInfoLog("Log Events Sync info : bulk value:" + bulk.toString());
                if (bulk != null) {
                    String json = bulk.toString();
                    if (json != null) {
                        ResultData<Boolean> resultCallback = KidozSDK.getApiManager((Context)this).sendKidozEventsToServerNotAsync(json);
                        if (resultCallback != null && resultCallback.getResponseStatus().getIsSuccessful()) {
                            EventManager.getInstance().removeBulkFromDB((Context)this, bulk);
                            this.munOfRetriesInCaseFailedCount = 1;
                            continue;
                        }
                        if (this.munOfRetriesInCaseFailedCount <= 0) break;
                        SDKLogger.printInfoLog(TAG, "Log Events Sync Info : Server response failed ! Trying again...");
                        --this.munOfRetriesInCaseFailedCount;
                        continue;
                    }
                    SDKLogger.printErrorLog(TAG, "Log Events Sync Error : Couldnt create JSON representation of an Events BULK !");
                    break;
                }
                SDKLogger.printErrorLog(TAG, "Log Events Sync Error : Events BULK object is NULL !");
                break;
            }
        }
        this.mSyncRunning = false;
    }

    public boolean isAllowedToRunTimeFrame() {
        return System.currentTimeMillis() - this.mServiceSyncStartTime < 900000L;
    }

    public void onDestroy() {
        this.mContinueSyncProcces = false;
        super.onDestroy();
    }
}

