/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.events;

import com.kidoz.events.Event;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.server_connect.ResponseStatus;
import com.kidoz.sdk.api.server_connect.ResultData;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventBulk {
    public static final int SUCCESS = 1000;
    private final String TAG = EventBulk.class.getSimpleName();
    private final String KEY_DEVICE_PARAMS = "DeviceParams";
    private final String KEY_EVENT_PARAMS = "EventParams";
    private final String KEY_ENTRIES = "Entries";
    private JSONObject mDeviceParamsJSONObject;
    private ArrayList<Event> mEventArrayList;

    public void setDeviceParamsJSONObject(JSONObject deviceParamsJSONObject) {
        this.mDeviceParamsJSONObject = deviceParamsJSONObject;
    }

    public JSONObject getDeviceParamsJSONObject() {
        return this.mDeviceParamsJSONObject;
    }

    public void setEventArrayList(ArrayList<Event> eventArrayList) {
        this.mEventArrayList = eventArrayList;
    }

    public ArrayList<Event> getEventArrayList() {
        return this.mEventArrayList;
    }

    private String convertToJson() {
        String result = null;
        if (this.mDeviceParamsJSONObject != null && this.mEventArrayList != null && this.mEventArrayList.size() > 0) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("DeviceParams", (Object)this.mDeviceParamsJSONObject);
                JSONArray jSONArray = new JSONArray();
                for (Event nextKidozEvent : this.mEventArrayList) {
                    JSONObject nextJsonObject = new JSONObject();
                    nextJsonObject.put("EventParams", (Object)nextKidozEvent.getJSONObject());
                    jSONArray.put((Object)nextJsonObject);
                }
                jSONObject.put("Entries", (Object)jSONArray);
                result = jSONObject.toString();
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(this.TAG, "Error when trying to create JSONObject from Bulk : " + ex.getMessage());
            }
        }
        return result;
    }

    public String toString() {
        return this.convertToJson();
    }

    public static ResultData<Boolean> parseResultSuccsesStatus(String data) {
        ResultData<Boolean> result = new ResultData<Boolean>();
        if (data != null) {
            ResponseStatus responseStatus = EventBulk.parseResposneStatus(data);
            result.setResponseStatus(responseStatus);
            if (result.getResponseStatus().getErrorCode() != null && result.getResponseStatus().getErrorCode().equals(String.valueOf(1000))) {
                result.setData(true);
            } else {
                result.setData(false);
            }
        }
        return result;
    }

    protected static ResponseStatus parseResposneStatus(String data) {
        ResponseStatus responseStatus = new ResponseStatus();
        if (data != null) {
            try {
                JSONObject object;
                JSONArray jsonArray = new JSONArray(data);
                if (jsonArray != null && jsonArray.length() > 0 && (object = jsonArray.getJSONObject(0)) != null) {
                    if (!object.isNull("success")) {
                        responseStatus.setIsSuccessful(object.getBoolean("success"));
                    }
                    if (object.has("messageCode") && !object.isNull("messageCode")) {
                        responseStatus.setErrorCode(object.getString("messageCode"));
                    } else if (object.has("errorMessage") && !object.isNull("errorMessage")) {
                        responseStatus.setErrorCode(object.getString("errorMessage"));
                    }
                }
            }
            catch (JSONException ex) {
                SDKLogger.printErrorLog("Error parsing response status: " + ex.getMessage());
                return new ResponseStatus();
            }
        }
        return responseStatus;
    }
}

