/*
 * Decompiled with CFR 0.152.
 */
package com.custom_recycler_view;

import android.view.View;
import com.custom_recycler_view.CustomRecyclerView;
import com.custom_recycler_view.OrientationHelper;

class ScrollbarHelper {
    ScrollbarHelper() {
    }

    static int computeScrollOffset(CustomRecyclerView.State state, OrientationHelper orientation, View startChild, View endChild, CustomRecyclerView.LayoutManager lm, boolean smoothScrollbarEnabled, boolean reverseLayout) {
        int itemsBefore;
        if (lm.getChildCount() == 0 || state.getItemCount() == 0 || startChild == null || endChild == null) {
            return 0;
        }
        int minPosition = Math.min(lm.getPosition(startChild), lm.getPosition(endChild));
        int maxPosition = Math.max(lm.getPosition(startChild), lm.getPosition(endChild));
        int n = itemsBefore = reverseLayout ? Math.max(0, state.getItemCount() - maxPosition - 1) : Math.max(0, minPosition);
        if (!smoothScrollbarEnabled) {
            return itemsBefore;
        }
        int laidOutArea = Math.abs(orientation.getDecoratedEnd(endChild) - orientation.getDecoratedStart(startChild));
        int itemRange = Math.abs(lm.getPosition(startChild) - lm.getPosition(endChild)) + 1;
        float avgSizePerRow = (float)laidOutArea / (float)itemRange;
        return Math.round((float)itemsBefore * avgSizePerRow + (float)(orientation.getStartAfterPadding() - orientation.getDecoratedStart(startChild)));
    }

    static int computeScrollExtent(CustomRecyclerView.State state, OrientationHelper orientation, View startChild, View endChild, CustomRecyclerView.LayoutManager lm, boolean smoothScrollbarEnabled) {
        if (lm.getChildCount() == 0 || state.getItemCount() == 0 || startChild == null || endChild == null) {
            return 0;
        }
        if (!smoothScrollbarEnabled) {
            return Math.abs(lm.getPosition(startChild) - lm.getPosition(endChild)) + 1;
        }
        int extend = orientation.getDecoratedEnd(endChild) - orientation.getDecoratedStart(startChild);
        return Math.min(orientation.getTotalSpace(), extend);
    }

    static int computeScrollRange(CustomRecyclerView.State state, OrientationHelper orientation, View startChild, View endChild, CustomRecyclerView.LayoutManager lm, boolean smoothScrollbarEnabled) {
        if (lm.getChildCount() == 0 || state.getItemCount() == 0 || startChild == null || endChild == null) {
            return 0;
        }
        if (!smoothScrollbarEnabled) {
            return state.getItemCount();
        }
        int laidOutArea = orientation.getDecoratedEnd(endChild) - orientation.getDecoratedStart(startChild);
        int laidOutRange = Math.abs(lm.getPosition(startChild) - lm.getPosition(endChild)) + 1;
        return (int)((float)laidOutArea / (float)laidOutRange * (float)state.getItemCount());
    }
}

