/*
 * Decompiled with CFR 0.152.
 */
package com.custom_recycler_view;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.accessibility.AccessibilityEventCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.view.accessibility.AccessibilityRecordCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import com.custom_recycler_view.CustomRecyclerView;
import com.custom_recycler_view.LayoutState;
import com.custom_recycler_view.LinearSmoothScroller;
import com.custom_recycler_view.OrientationHelper;
import com.custom_recycler_view.ScrollbarHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public class CustomStaggeredGridLayoutManager
extends CustomRecyclerView.LayoutManager {
    public static final String TAG = "CustomStaggeredGridLayoutManager";
    private static final boolean DEBUG = false;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int GAP_HANDLING_NONE = 0;
    @Deprecated
    public static final int GAP_HANDLING_LAZY = 1;
    public static final int GAP_HANDLING_MOVE_ITEMS_BETWEEN_SPANS = 2;
    private static final int INVALID_OFFSET = Integer.MIN_VALUE;
    private int mSpanCount = -1;
    private Span[] mSpans;
    OrientationHelper mPrimaryOrientation;
    OrientationHelper mSecondaryOrientation;
    private int mOrientation;
    private int mSizePerSpan;
    private LayoutState mLayoutState;
    private boolean mReverseLayout = false;
    boolean mShouldReverseLayout = false;
    private BitSet mRemainingSpans;
    int mPendingScrollPosition = -1;
    int mPendingScrollPositionOffset = Integer.MIN_VALUE;
    LazySpanLookup mLazySpanLookup = new LazySpanLookup();
    private int mGapStrategy = 2;
    private boolean mLastLayoutFromEnd;
    private boolean mLastLayoutRTL;
    private SavedState mPendingSavedState;
    private int mFullSizeSpec;
    private int mWidthSpec;
    private int mHeightSpec;
    private final AnchorInfo mAnchorInfo = new AnchorInfo();
    private boolean mLaidOutInvalidFullSpan = false;
    private boolean mSmoothScrollbarEnabled = true;
    private final Runnable checkForGapsRunnable = new Runnable(){

        @Override
        public void run() {
            CustomStaggeredGridLayoutManager.this.checkForGaps();
        }
    };

    public CustomStaggeredGridLayoutManager(int spanCount, int orientation) {
        this.mOrientation = orientation;
        this.setSpanCount(spanCount);
    }

    private void checkForGaps() {
        View gapView;
        int maxPos;
        int minPos;
        if (this.getChildCount() == 0 || this.mGapStrategy == 0) {
            return;
        }
        if (this.mShouldReverseLayout) {
            minPos = this.getLastChildPosition();
            maxPos = this.getFirstChildPosition();
        } else {
            minPos = this.getFirstChildPosition();
            maxPos = this.getLastChildPosition();
        }
        if (minPos == 0 && (gapView = this.hasGapsToFix()) != null) {
            this.mLazySpanLookup.clear();
            this.requestSimpleAnimationsInNextLayout();
            this.requestLayout();
            return;
        }
        if (!this.mLaidOutInvalidFullSpan) {
            return;
        }
        int invalidGapDir = this.mShouldReverseLayout ? -1 : 1;
        LazySpanLookup.FullSpanItem invalidFsi = this.mLazySpanLookup.getFirstFullSpanItemInRange(minPos, maxPos + 1, invalidGapDir, true);
        if (invalidFsi == null) {
            this.mLaidOutInvalidFullSpan = false;
            this.mLazySpanLookup.forceInvalidateAfter(maxPos + 1);
            return;
        }
        LazySpanLookup.FullSpanItem validFsi = this.mLazySpanLookup.getFirstFullSpanItemInRange(minPos, invalidFsi.mPosition, invalidGapDir * -1, true);
        if (validFsi == null) {
            this.mLazySpanLookup.forceInvalidateAfter(invalidFsi.mPosition);
        } else {
            this.mLazySpanLookup.forceInvalidateAfter(validFsi.mPosition + 1);
        }
        this.requestSimpleAnimationsInNextLayout();
        this.requestLayout();
    }

    @Override
    public void onScrollStateChanged(int state) {
        if (state == 0) {
            this.checkForGaps();
        }
    }

    @Override
    public void onDetachedFromWindow(CustomRecyclerView view, CustomRecyclerView.Recycler recycler) {
        for (int i = 0; i < this.mSpanCount; ++i) {
            this.mSpans[i].clear();
        }
    }

    View hasGapsToFix() {
        int childLimit;
        int firstChildIndex;
        int preferredSpanDir;
        int startChildIndex = 0;
        int endChildIndex = this.getChildCount() - 1;
        BitSet mSpansToCheck = new BitSet(this.mSpanCount);
        mSpansToCheck.set(0, this.mSpanCount, true);
        int n = preferredSpanDir = this.mOrientation == 1 && this.isLayoutRTL() ? 1 : -1;
        if (this.mShouldReverseLayout) {
            firstChildIndex = endChildIndex - 1;
            childLimit = startChildIndex - 1;
        } else {
            firstChildIndex = startChildIndex;
            childLimit = endChildIndex;
        }
        int nextChildDiff = firstChildIndex < childLimit ? 1 : -1;
        for (int i = firstChildIndex; i != childLimit; i += nextChildDiff) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (mSpansToCheck.get(lp.mSpan.mIndex)) {
                if (this.checkSpanForGap(lp.mSpan)) {
                    return child;
                }
                mSpansToCheck.clear(lp.mSpan.mIndex);
            }
            if (lp.mFullSpan || i + nextChildDiff == childLimit) continue;
            View nextChild = this.getChildAt(i + nextChildDiff);
            boolean compareSpans = false;
            if (this.mShouldReverseLayout) {
                int nextEnd;
                int myEnd = this.mPrimaryOrientation.getDecoratedEnd(child);
                if (myEnd < (nextEnd = this.mPrimaryOrientation.getDecoratedEnd(nextChild))) {
                    return child;
                }
                if (myEnd == nextEnd) {
                    compareSpans = true;
                }
            } else {
                int nextStart;
                int myStart = this.mPrimaryOrientation.getDecoratedStart(child);
                if (myStart > (nextStart = this.mPrimaryOrientation.getDecoratedStart(nextChild))) {
                    return child;
                }
                if (myStart == nextStart) {
                    compareSpans = true;
                }
            }
            if (!compareSpans) continue;
            LayoutParams nextLp = (LayoutParams)nextChild.getLayoutParams();
            if (lp.mSpan.mIndex - nextLp.mSpan.mIndex < 0 == preferredSpanDir < 0) continue;
            return child;
        }
        return null;
    }

    private boolean checkSpanForGap(Span span) {
        return this.mShouldReverseLayout ? span.getEndLine() < this.mPrimaryOrientation.getEndAfterPadding() : span.getStartLine() > this.mPrimaryOrientation.getStartAfterPadding();
    }

    public void setSpanCount(int spanCount) {
        this.assertNotInLayoutOrScroll(null);
        if (spanCount != this.mSpanCount) {
            this.invalidateSpanAssignments();
            this.mSpanCount = spanCount;
            this.mRemainingSpans = new BitSet(this.mSpanCount);
            this.mSpans = new Span[this.mSpanCount];
            for (int i = 0; i < this.mSpanCount; ++i) {
                this.mSpans[i] = new Span(i);
            }
            this.requestLayout();
        }
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("invalid orientation.");
        }
        this.assertNotInLayoutOrScroll(null);
        if (orientation == this.mOrientation) {
            return;
        }
        this.mOrientation = orientation;
        if (this.mPrimaryOrientation != null && this.mSecondaryOrientation != null) {
            OrientationHelper tmp = this.mPrimaryOrientation;
            this.mPrimaryOrientation = this.mSecondaryOrientation;
            this.mSecondaryOrientation = tmp;
        }
        this.requestLayout();
    }

    public void setReverseLayout(boolean reverseLayout) {
        this.assertNotInLayoutOrScroll(null);
        if (this.mPendingSavedState != null && this.mPendingSavedState.mReverseLayout != reverseLayout) {
            this.mPendingSavedState.mReverseLayout = reverseLayout;
        }
        this.mReverseLayout = reverseLayout;
        this.requestLayout();
    }

    public int getGapStrategy() {
        return this.mGapStrategy;
    }

    public void setGapStrategy(int gapStrategy) {
        this.assertNotInLayoutOrScroll(null);
        if (gapStrategy == this.mGapStrategy) {
            return;
        }
        if (gapStrategy != 0 && gapStrategy != 2) {
            throw new IllegalArgumentException("invalid gap strategy. Must be GAP_HANDLING_NONE or GAP_HANDLING_MOVE_ITEMS_BETWEEN_SPANS");
        }
        this.mGapStrategy = gapStrategy;
        this.requestLayout();
    }

    @Override
    public void assertNotInLayoutOrScroll(String message) {
        if (this.mPendingSavedState == null) {
            super.assertNotInLayoutOrScroll(message);
        }
    }

    public int getSpanCount() {
        return this.mSpanCount;
    }

    public void invalidateSpanAssignments() {
        this.mLazySpanLookup.clear();
        this.requestLayout();
    }

    private void ensureOrientationHelper() {
        if (this.mPrimaryOrientation == null) {
            this.mPrimaryOrientation = OrientationHelper.createOrientationHelper(this, this.mOrientation);
            this.mSecondaryOrientation = OrientationHelper.createOrientationHelper(this, 1 - this.mOrientation);
            this.mLayoutState = new LayoutState();
        }
    }

    private void resolveShouldLayoutReverse() {
        this.mShouldReverseLayout = this.mOrientation == 1 || !this.isLayoutRTL() ? this.mReverseLayout : !this.mReverseLayout;
    }

    boolean isLayoutRTL() {
        return this.getLayoutDirection() == 1;
    }

    public boolean getReverseLayout() {
        return this.mReverseLayout;
    }

    @Override
    public void onLayoutChildren(CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state) {
        this.ensureOrientationHelper();
        AnchorInfo anchorInfo = this.mAnchorInfo;
        anchorInfo.reset();
        if (this.mPendingSavedState != null) {
            this.applyPendingSavedState(anchorInfo);
        } else {
            this.resolveShouldLayoutReverse();
            anchorInfo.mLayoutFromEnd = this.mShouldReverseLayout;
        }
        this.updateAnchorInfoForLayout(state, anchorInfo);
        if (this.mPendingSavedState == null && (anchorInfo.mLayoutFromEnd != this.mLastLayoutFromEnd || this.isLayoutRTL() != this.mLastLayoutRTL)) {
            this.mLazySpanLookup.clear();
            anchorInfo.mInvalidateOffsets = true;
        }
        if (this.getChildCount() > 0 && (this.mPendingSavedState == null || this.mPendingSavedState.mSpanOffsetsSize < 1)) {
            if (anchorInfo.mInvalidateOffsets) {
                for (int i = 0; i < this.mSpanCount; ++i) {
                    this.mSpans[i].clear();
                    if (anchorInfo.mOffset == Integer.MIN_VALUE) continue;
                    this.mSpans[i].setLine(anchorInfo.mOffset);
                }
            } else {
                for (int i = 0; i < this.mSpanCount; ++i) {
                    this.mSpans[i].cacheReferenceLineAndClear(this.mShouldReverseLayout, anchorInfo.mOffset);
                }
            }
        }
        this.detachAndScrapAttachedViews(recycler);
        this.mLaidOutInvalidFullSpan = false;
        this.updateMeasureSpecs();
        if (anchorInfo.mLayoutFromEnd) {
            this.updateLayoutStateToFillStart(anchorInfo.mPosition, state);
            this.fill(recycler, this.mLayoutState, state);
            this.updateLayoutStateToFillEnd(anchorInfo.mPosition, state);
            this.mLayoutState.mCurrentPosition += this.mLayoutState.mItemDirection;
            this.fill(recycler, this.mLayoutState, state);
        } else {
            this.updateLayoutStateToFillEnd(anchorInfo.mPosition, state);
            this.fill(recycler, this.mLayoutState, state);
            this.updateLayoutStateToFillStart(anchorInfo.mPosition, state);
            this.mLayoutState.mCurrentPosition += this.mLayoutState.mItemDirection;
            this.fill(recycler, this.mLayoutState, state);
        }
        if (this.getChildCount() > 0) {
            if (this.mShouldReverseLayout) {
                this.fixEndGap(recycler, state, true);
                this.fixStartGap(recycler, state, false);
            } else {
                this.fixStartGap(recycler, state, true);
                this.fixEndGap(recycler, state, false);
            }
        }
        if (!state.isPreLayout()) {
            if (this.getChildCount() > 0 && this.mPendingScrollPosition != -1 && this.mLaidOutInvalidFullSpan) {
                ViewCompat.postOnAnimation((View)this.getChildAt(0), (Runnable)this.checkForGapsRunnable);
            }
            this.mPendingScrollPosition = -1;
            this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        }
        this.mLastLayoutFromEnd = anchorInfo.mLayoutFromEnd;
        this.mLastLayoutRTL = this.isLayoutRTL();
        this.mPendingSavedState = null;
    }

    private void applyPendingSavedState(AnchorInfo anchorInfo) {
        if (this.mPendingSavedState.mSpanOffsetsSize > 0) {
            if (this.mPendingSavedState.mSpanOffsetsSize == this.mSpanCount) {
                for (int i = 0; i < this.mSpanCount; ++i) {
                    this.mSpans[i].clear();
                    int line = this.mPendingSavedState.mSpanOffsets[i];
                    if (line != Integer.MIN_VALUE) {
                        line = this.mPendingSavedState.mAnchorLayoutFromEnd ? (line += this.mPrimaryOrientation.getEndAfterPadding()) : (line += this.mPrimaryOrientation.getStartAfterPadding());
                    }
                    this.mSpans[i].setLine(line);
                }
            } else {
                this.mPendingSavedState.invalidateSpanInfo();
                this.mPendingSavedState.mAnchorPosition = this.mPendingSavedState.mVisibleAnchorPosition;
            }
        }
        this.mLastLayoutRTL = this.mPendingSavedState.mLastLayoutRTL;
        this.setReverseLayout(this.mPendingSavedState.mReverseLayout);
        this.resolveShouldLayoutReverse();
        if (this.mPendingSavedState.mAnchorPosition != -1) {
            this.mPendingScrollPosition = this.mPendingSavedState.mAnchorPosition;
            anchorInfo.mLayoutFromEnd = this.mPendingSavedState.mAnchorLayoutFromEnd;
        } else {
            anchorInfo.mLayoutFromEnd = this.mShouldReverseLayout;
        }
        if (this.mPendingSavedState.mSpanLookupSize > 1) {
            this.mLazySpanLookup.mData = this.mPendingSavedState.mSpanLookup;
            this.mLazySpanLookup.mFullSpanItems = this.mPendingSavedState.mFullSpanItems;
        }
    }

    void updateAnchorInfoForLayout(CustomRecyclerView.State state, AnchorInfo anchorInfo) {
        if (this.updateAnchorFromPendingData(state, anchorInfo)) {
            return;
        }
        if (this.updateAnchorFromChildren(state, anchorInfo)) {
            return;
        }
        anchorInfo.assignCoordinateFromPadding();
        anchorInfo.mPosition = 0;
    }

    private boolean updateAnchorFromChildren(CustomRecyclerView.State state, AnchorInfo anchorInfo) {
        anchorInfo.mPosition = this.mLastLayoutFromEnd ? this.findLastReferenceChildPosition(state.getItemCount()) : this.findFirstReferenceChildPosition(state.getItemCount());
        anchorInfo.mOffset = Integer.MIN_VALUE;
        return true;
    }

    boolean updateAnchorFromPendingData(CustomRecyclerView.State state, AnchorInfo anchorInfo) {
        if (state.isPreLayout() || this.mPendingScrollPosition == -1) {
            return false;
        }
        if (this.mPendingScrollPosition < 0 || this.mPendingScrollPosition >= state.getItemCount()) {
            this.mPendingScrollPosition = -1;
            this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
            return false;
        }
        if (this.mPendingSavedState == null || this.mPendingSavedState.mAnchorPosition == -1 || this.mPendingSavedState.mSpanOffsetsSize < 1) {
            View child = this.findViewByPosition(this.mPendingScrollPosition);
            if (child != null) {
                int n = anchorInfo.mPosition = this.mShouldReverseLayout ? this.getLastChildPosition() : this.getFirstChildPosition();
                if (this.mPendingScrollPositionOffset != Integer.MIN_VALUE) {
                    if (anchorInfo.mLayoutFromEnd) {
                        int target = this.mPrimaryOrientation.getEndAfterPadding() - this.mPendingScrollPositionOffset;
                        anchorInfo.mOffset = target - this.mPrimaryOrientation.getDecoratedEnd(child);
                    } else {
                        int target = this.mPrimaryOrientation.getStartAfterPadding() + this.mPendingScrollPositionOffset;
                        anchorInfo.mOffset = target - this.mPrimaryOrientation.getDecoratedStart(child);
                    }
                    return true;
                }
                int childSize = this.mPrimaryOrientation.getDecoratedMeasurement(child);
                if (childSize > this.mPrimaryOrientation.getTotalSpace()) {
                    anchorInfo.mOffset = anchorInfo.mLayoutFromEnd ? this.mPrimaryOrientation.getEndAfterPadding() : this.mPrimaryOrientation.getStartAfterPadding();
                    return true;
                }
                int startGap = this.mPrimaryOrientation.getDecoratedStart(child) - this.mPrimaryOrientation.getStartAfterPadding();
                if (startGap < 0) {
                    anchorInfo.mOffset = -startGap;
                    return true;
                }
                int endGap = this.mPrimaryOrientation.getEndAfterPadding() - this.mPrimaryOrientation.getDecoratedEnd(child);
                if (endGap < 0) {
                    anchorInfo.mOffset = endGap;
                    return true;
                }
                anchorInfo.mOffset = Integer.MIN_VALUE;
            } else {
                anchorInfo.mPosition = this.mPendingScrollPosition;
                if (this.mPendingScrollPositionOffset == Integer.MIN_VALUE) {
                    int position = this.calculateScrollDirectionForPosition(anchorInfo.mPosition);
                    anchorInfo.mLayoutFromEnd = position == 1;
                    anchorInfo.assignCoordinateFromPadding();
                } else {
                    anchorInfo.assignCoordinateFromPadding(this.mPendingScrollPositionOffset);
                }
                anchorInfo.mInvalidateOffsets = true;
            }
        } else {
            anchorInfo.mOffset = Integer.MIN_VALUE;
            anchorInfo.mPosition = this.mPendingScrollPosition;
        }
        return true;
    }

    void updateMeasureSpecs() {
        this.mSizePerSpan = this.mSecondaryOrientation.getTotalSpace() / this.mSpanCount;
        this.mFullSizeSpec = View.MeasureSpec.makeMeasureSpec((int)this.mSecondaryOrientation.getTotalSpace(), (int)0x40000000);
        if (this.mOrientation == 1) {
            this.mWidthSpec = View.MeasureSpec.makeMeasureSpec((int)this.mSizePerSpan, (int)0x40000000);
            this.mHeightSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        } else {
            this.mHeightSpec = View.MeasureSpec.makeMeasureSpec((int)this.mSizePerSpan, (int)0x40000000);
            this.mWidthSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        }
    }

    @Override
    public boolean supportsPredictiveItemAnimations() {
        return this.mPendingSavedState == null;
    }

    public int[] findFirstVisibleItemPositions(int[] into) {
        if (into == null) {
            into = new int[this.mSpanCount];
        } else if (into.length < this.mSpanCount) {
            throw new IllegalArgumentException("Provided int[]'s size must be more than or equal to span count. Expected:" + this.mSpanCount + ", array size:" + into.length);
        }
        for (int i = 0; i < this.mSpanCount; ++i) {
            into[i] = this.mSpans[i].findFirstVisibleItemPosition();
        }
        return into;
    }

    public int[] findFirstCompletelyVisibleItemPositions(int[] into) {
        if (into == null) {
            into = new int[this.mSpanCount];
        } else if (into.length < this.mSpanCount) {
            throw new IllegalArgumentException("Provided int[]'s size must be more than or equal to span count. Expected:" + this.mSpanCount + ", array size:" + into.length);
        }
        for (int i = 0; i < this.mSpanCount; ++i) {
            into[i] = this.mSpans[i].findFirstCompletelyVisibleItemPosition();
        }
        return into;
    }

    public int[] findLastVisibleItemPositions(int[] into) {
        if (into == null) {
            into = new int[this.mSpanCount];
        } else if (into.length < this.mSpanCount) {
            throw new IllegalArgumentException("Provided int[]'s size must be more than or equal to span count. Expected:" + this.mSpanCount + ", array size:" + into.length);
        }
        for (int i = 0; i < this.mSpanCount; ++i) {
            into[i] = this.mSpans[i].findLastVisibleItemPosition();
        }
        return into;
    }

    public int[] findLastCompletelyVisibleItemPositions(int[] into) {
        if (into == null) {
            into = new int[this.mSpanCount];
        } else if (into.length < this.mSpanCount) {
            throw new IllegalArgumentException("Provided int[]'s size must be more than or equal to span count. Expected:" + this.mSpanCount + ", array size:" + into.length);
        }
        for (int i = 0; i < this.mSpanCount; ++i) {
            into[i] = this.mSpans[i].findLastCompletelyVisibleItemPosition();
        }
        return into;
    }

    @Override
    public int computeHorizontalScrollOffset(CustomRecyclerView.State state) {
        return this.computeScrollOffset(state);
    }

    private int computeScrollOffset(CustomRecyclerView.State state) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        this.ensureOrientationHelper();
        return ScrollbarHelper.computeScrollOffset(state, this.mPrimaryOrientation, this.findFirstVisibleItemClosestToStart(!this.mSmoothScrollbarEnabled, true), this.findFirstVisibleItemClosestToEnd(!this.mSmoothScrollbarEnabled, true), this, this.mSmoothScrollbarEnabled, this.mShouldReverseLayout);
    }

    @Override
    public int computeVerticalScrollOffset(CustomRecyclerView.State state) {
        return this.computeScrollOffset(state);
    }

    @Override
    public int computeHorizontalScrollExtent(CustomRecyclerView.State state) {
        return this.computeScrollExtent(state);
    }

    private int computeScrollExtent(CustomRecyclerView.State state) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        this.ensureOrientationHelper();
        return ScrollbarHelper.computeScrollExtent(state, this.mPrimaryOrientation, this.findFirstVisibleItemClosestToStart(!this.mSmoothScrollbarEnabled, true), this.findFirstVisibleItemClosestToEnd(!this.mSmoothScrollbarEnabled, true), this, this.mSmoothScrollbarEnabled);
    }

    @Override
    public int computeVerticalScrollExtent(CustomRecyclerView.State state) {
        return this.computeScrollExtent(state);
    }

    @Override
    public int computeHorizontalScrollRange(CustomRecyclerView.State state) {
        return this.computeScrollRange(state);
    }

    private int computeScrollRange(CustomRecyclerView.State state) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        this.ensureOrientationHelper();
        return ScrollbarHelper.computeScrollRange(state, this.mPrimaryOrientation, this.findFirstVisibleItemClosestToStart(!this.mSmoothScrollbarEnabled, true), this.findFirstVisibleItemClosestToEnd(!this.mSmoothScrollbarEnabled, true), this, this.mSmoothScrollbarEnabled);
    }

    @Override
    public int computeVerticalScrollRange(CustomRecyclerView.State state) {
        return this.computeScrollRange(state);
    }

    private void measureChildWithDecorationsAndMargin(View child, LayoutParams lp) {
        if (lp.mFullSpan) {
            if (this.mOrientation == 1) {
                this.measureChildWithDecorationsAndMargin(child, this.mFullSizeSpec, this.getSpecForDimension(lp.height, this.mHeightSpec));
            } else {
                this.measureChildWithDecorationsAndMargin(child, this.getSpecForDimension(lp.width, this.mWidthSpec), this.mFullSizeSpec);
            }
        } else if (this.mOrientation == 1) {
            this.measureChildWithDecorationsAndMargin(child, this.mWidthSpec, this.getSpecForDimension(lp.height, this.mHeightSpec));
        } else {
            this.measureChildWithDecorationsAndMargin(child, this.getSpecForDimension(lp.width, this.mWidthSpec), this.mHeightSpec);
        }
    }

    private int getSpecForDimension(int dim, int defaultSpec) {
        if (dim < 0) {
            return defaultSpec;
        }
        return View.MeasureSpec.makeMeasureSpec((int)dim, (int)0x40000000);
    }

    private void measureChildWithDecorationsAndMargin(View child, int widthSpec, int heightSpec) {
        Rect insets = this.mCustomRecyclerView.getItemDecorInsetsForChild(child);
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        widthSpec = this.updateSpecWithExtra(widthSpec, lp.leftMargin + insets.left, lp.rightMargin + insets.right);
        heightSpec = this.updateSpecWithExtra(heightSpec, lp.topMargin + insets.top, lp.bottomMargin + insets.bottom);
        child.measure(widthSpec, heightSpec);
    }

    private int updateSpecWithExtra(int spec, int startInset, int endInset) {
        if (startInset == 0 && endInset == 0) {
            return spec;
        }
        int mode = View.MeasureSpec.getMode((int)spec);
        if (mode == Integer.MIN_VALUE || mode == 0x40000000) {
            return View.MeasureSpec.makeMeasureSpec((int)(View.MeasureSpec.getSize((int)spec) - startInset - endInset), (int)mode);
        }
        return spec;
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            this.mPendingSavedState = (SavedState)state;
            this.requestLayout();
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        if (this.mPendingSavedState != null) {
            return new SavedState(this.mPendingSavedState);
        }
        SavedState state = new SavedState();
        state.mReverseLayout = this.mReverseLayout;
        state.mAnchorLayoutFromEnd = this.mLastLayoutFromEnd;
        state.mLastLayoutRTL = this.mLastLayoutRTL;
        if (this.mLazySpanLookup != null && this.mLazySpanLookup.mData != null) {
            state.mSpanLookup = this.mLazySpanLookup.mData;
            state.mSpanLookupSize = state.mSpanLookup.length;
            state.mFullSpanItems = this.mLazySpanLookup.mFullSpanItems;
        } else {
            state.mSpanLookupSize = 0;
        }
        if (this.getChildCount() > 0) {
            this.ensureOrientationHelper();
            state.mAnchorPosition = this.mLastLayoutFromEnd ? this.getLastChildPosition() : this.getFirstChildPosition();
            state.mVisibleAnchorPosition = this.findFirstVisibleItemPositionInt();
            state.mSpanOffsetsSize = this.mSpanCount;
            state.mSpanOffsets = new int[this.mSpanCount];
            for (int i = 0; i < this.mSpanCount; ++i) {
                int line;
                if (this.mLastLayoutFromEnd) {
                    line = this.mSpans[i].getEndLine(Integer.MIN_VALUE);
                    if (line != Integer.MIN_VALUE) {
                        line -= this.mPrimaryOrientation.getEndAfterPadding();
                    }
                } else {
                    line = this.mSpans[i].getStartLine(Integer.MIN_VALUE);
                    if (line != Integer.MIN_VALUE) {
                        line -= this.mPrimaryOrientation.getStartAfterPadding();
                    }
                }
                state.mSpanOffsets[i] = line;
            }
        } else {
            state.mAnchorPosition = -1;
            state.mVisibleAnchorPosition = -1;
            state.mSpanOffsetsSize = 0;
        }
        return state;
    }

    @Override
    public void onInitializeAccessibilityNodeInfoForItem(CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state, View host, AccessibilityNodeInfoCompat info) {
        ViewGroup.LayoutParams lp = host.getLayoutParams();
        if (!(lp instanceof LayoutParams)) {
            super.onInitializeAccessibilityNodeInfoForItem(host, info);
            return;
        }
        LayoutParams sglp = (LayoutParams)lp;
        if (this.mOrientation == 0) {
            info.setCollectionItemInfo((Object)AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)sglp.getSpanIndex(), (int)(sglp.mFullSpan ? this.mSpanCount : 1), (int)-1, (int)-1, (boolean)sglp.mFullSpan, (boolean)false));
        } else {
            info.setCollectionItemInfo((Object)AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)-1, (int)-1, (int)sglp.getSpanIndex(), (int)(sglp.mFullSpan ? this.mSpanCount : 1), (boolean)sglp.mFullSpan, (boolean)false));
        }
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        if (this.getChildCount() > 0) {
            int endPos;
            AccessibilityRecordCompat record = AccessibilityEventCompat.asRecord((AccessibilityEvent)event);
            View start = this.findFirstVisibleItemClosestToStart(false, true);
            View end = this.findFirstVisibleItemClosestToEnd(false, true);
            if (start == null || end == null) {
                return;
            }
            int startPos = this.getPosition(start);
            if (startPos < (endPos = this.getPosition(end))) {
                record.setFromIndex(startPos);
                record.setToIndex(endPos);
            } else {
                record.setFromIndex(endPos);
                record.setToIndex(startPos);
            }
        }
    }

    int findFirstVisibleItemPositionInt() {
        View first = this.mShouldReverseLayout ? this.findFirstVisibleItemClosestToEnd(true, true) : this.findFirstVisibleItemClosestToStart(true, true);
        return first == null ? -1 : this.getPosition(first);
    }

    @Override
    public int getRowCountForAccessibility(CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state) {
        if (this.mOrientation == 0) {
            return this.mSpanCount;
        }
        return super.getRowCountForAccessibility(recycler, state);
    }

    @Override
    public int getColumnCountForAccessibility(CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state) {
        if (this.mOrientation == 1) {
            return this.mSpanCount;
        }
        return super.getColumnCountForAccessibility(recycler, state);
    }

    View findFirstVisibleItemClosestToStart(boolean fullyVisible, boolean acceptPartiallyVisible) {
        this.ensureOrientationHelper();
        int boundsStart = this.mPrimaryOrientation.getStartAfterPadding();
        int boundsEnd = this.mPrimaryOrientation.getEndAfterPadding();
        int limit = this.getChildCount();
        View partiallyVisible = null;
        for (int i = 0; i < limit; ++i) {
            View child = this.getChildAt(i);
            if (this.mPrimaryOrientation.getDecoratedEnd(child) > boundsEnd) continue;
            if (!fullyVisible || this.mPrimaryOrientation.getDecoratedStart(child) >= boundsStart) {
                return child;
            }
            if (!acceptPartiallyVisible || partiallyVisible != null) continue;
            partiallyVisible = child;
        }
        return partiallyVisible;
    }

    View findFirstVisibleItemClosestToEnd(boolean fullyVisible, boolean acceptPartiallyVisible) {
        this.ensureOrientationHelper();
        int boundsStart = this.mPrimaryOrientation.getStartAfterPadding();
        int boundsEnd = this.mPrimaryOrientation.getEndAfterPadding();
        View partiallyVisible = null;
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (this.mPrimaryOrientation.getDecoratedStart(child) < boundsStart) continue;
            if (!fullyVisible || this.mPrimaryOrientation.getDecoratedEnd(child) <= boundsEnd) {
                return child;
            }
            if (!acceptPartiallyVisible || partiallyVisible != null) continue;
            partiallyVisible = child;
        }
        return partiallyVisible;
    }

    private void fixEndGap(CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state, boolean canOffsetChildren) {
        int maxEndLine = this.getMaxEnd(this.mPrimaryOrientation.getEndAfterPadding());
        int gap = this.mPrimaryOrientation.getEndAfterPadding() - maxEndLine;
        if (gap <= 0) {
            return;
        }
        int fixOffset = -this.scrollBy(-gap, recycler, state);
        if (canOffsetChildren && (gap -= fixOffset) > 0) {
            this.mPrimaryOrientation.offsetChildren(gap);
        }
    }

    private void fixStartGap(CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state, boolean canOffsetChildren) {
        int minStartLine = this.getMinStart(this.mPrimaryOrientation.getStartAfterPadding());
        int gap = minStartLine - this.mPrimaryOrientation.getStartAfterPadding();
        if (gap <= 0) {
            return;
        }
        int fixOffset = this.scrollBy(gap, recycler, state);
        if (canOffsetChildren && (gap -= fixOffset) > 0) {
            this.mPrimaryOrientation.offsetChildren(-gap);
        }
    }

    private void updateLayoutStateToFillStart(int anchorPosition, CustomRecyclerView.State state) {
        int targetPos;
        this.mLayoutState.mAvailable = 0;
        this.mLayoutState.mCurrentPosition = anchorPosition;
        this.mLayoutState.mExtra = this.isSmoothScrolling() ? (this.mShouldReverseLayout == (targetPos = state.getTargetScrollPosition()) < anchorPosition ? 0 : this.mPrimaryOrientation.getTotalSpace()) : 0;
        this.mLayoutState.mLayoutDirection = -1;
        this.mLayoutState.mItemDirection = this.mShouldReverseLayout ? 1 : -1;
    }

    private void updateLayoutStateToFillEnd(int anchorPosition, CustomRecyclerView.State state) {
        int targetPos;
        this.mLayoutState.mAvailable = 0;
        this.mLayoutState.mCurrentPosition = anchorPosition;
        this.mLayoutState.mExtra = this.isSmoothScrolling() ? (this.mShouldReverseLayout == (targetPos = state.getTargetScrollPosition()) > anchorPosition ? 0 : this.mPrimaryOrientation.getTotalSpace()) : 0;
        this.mLayoutState.mLayoutDirection = 1;
        this.mLayoutState.mItemDirection = this.mShouldReverseLayout ? -1 : 1;
    }

    @Override
    public void offsetChildrenHorizontal(int dx) {
        super.offsetChildrenHorizontal(dx);
        for (int i = 0; i < this.mSpanCount; ++i) {
            this.mSpans[i].onOffset(dx);
        }
    }

    @Override
    public void offsetChildrenVertical(int dy) {
        super.offsetChildrenVertical(dy);
        for (int i = 0; i < this.mSpanCount; ++i) {
            this.mSpans[i].onOffset(dy);
        }
    }

    @Override
    public void onItemsRemoved(CustomRecyclerView customRecyclerView, int positionStart, int itemCount) {
        this.handleUpdate(positionStart, itemCount, 1);
    }

    @Override
    public void onItemsAdded(CustomRecyclerView customRecyclerView, int positionStart, int itemCount) {
        this.handleUpdate(positionStart, itemCount, 0);
    }

    @Override
    public void onItemsChanged(CustomRecyclerView customRecyclerView) {
        this.mLazySpanLookup.clear();
        this.requestLayout();
    }

    @Override
    public void onItemsMoved(CustomRecyclerView customRecyclerView, int from, int to, int itemCount) {
        this.handleUpdate(from, to, 3);
    }

    @Override
    public void onItemsUpdated(CustomRecyclerView customRecyclerView, int positionStart, int itemCount) {
        this.handleUpdate(positionStart, itemCount, 2);
    }

    private void handleUpdate(int positionStart, int itemCountOrToPosition, int cmd) {
        int maxPosition;
        int affectedRangeStart;
        int affectedRangeEnd;
        int minPosition;
        int n = minPosition = this.mShouldReverseLayout ? this.getLastChildPosition() : this.getFirstChildPosition();
        if (cmd == 3) {
            if (positionStart < itemCountOrToPosition) {
                affectedRangeEnd = itemCountOrToPosition + 1;
                affectedRangeStart = positionStart;
            } else {
                affectedRangeEnd = positionStart + 1;
                affectedRangeStart = itemCountOrToPosition;
            }
        } else {
            affectedRangeStart = positionStart;
            affectedRangeEnd = positionStart + itemCountOrToPosition;
        }
        this.mLazySpanLookup.invalidateAfter(affectedRangeStart);
        switch (cmd) {
            case 0: {
                this.mLazySpanLookup.offsetForAddition(positionStart, itemCountOrToPosition);
                break;
            }
            case 1: {
                this.mLazySpanLookup.offsetForRemoval(positionStart, itemCountOrToPosition);
                break;
            }
            case 3: {
                this.mLazySpanLookup.offsetForRemoval(positionStart, 1);
                this.mLazySpanLookup.offsetForAddition(itemCountOrToPosition, 1);
            }
        }
        if (affectedRangeEnd <= minPosition) {
            return;
        }
        int n2 = maxPosition = this.mShouldReverseLayout ? this.getFirstChildPosition() : this.getLastChildPosition();
        if (affectedRangeStart <= maxPosition) {
            this.requestLayout();
        }
    }

    private int fill(CustomRecyclerView.Recycler recycler, LayoutState layoutState, CustomRecyclerView.State state) {
        int defaultNewViewLine;
        int targetLine;
        int recycleLine;
        this.mRemainingSpans.set(0, this.mSpanCount, true);
        if (layoutState.mLayoutDirection == 1) {
            recycleLine = this.mPrimaryOrientation.getEndAfterPadding() + this.mLayoutState.mAvailable;
            targetLine = recycleLine + this.mLayoutState.mExtra + this.mPrimaryOrientation.getEndPadding();
        } else {
            recycleLine = this.mPrimaryOrientation.getStartAfterPadding() - this.mLayoutState.mAvailable;
            targetLine = recycleLine - this.mLayoutState.mExtra - this.mPrimaryOrientation.getStartAfterPadding();
        }
        this.updateAllRemainingSpans(layoutState.mLayoutDirection, targetLine);
        int n = defaultNewViewLine = this.mShouldReverseLayout ? this.mPrimaryOrientation.getEndAfterPadding() : this.mPrimaryOrientation.getStartAfterPadding();
        while (layoutState.hasMore(state) && !this.mRemainingSpans.isEmpty()) {
            int end;
            int start;
            Span currentSpan;
            boolean assignSpan;
            View view = layoutState.next(recycler);
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            int position = lp.getViewLayoutPosition();
            int spanIndex = this.mLazySpanLookup.getSpan(position);
            boolean bl = assignSpan = spanIndex == -1;
            if (assignSpan) {
                currentSpan = lp.mFullSpan ? this.mSpans[0] : this.getNextSpan(layoutState);
                this.mLazySpanLookup.setSpan(position, currentSpan);
            } else {
                currentSpan = this.mSpans[spanIndex];
            }
            lp.mSpan = currentSpan;
            if (layoutState.mLayoutDirection == 1) {
                this.addView(view);
            } else {
                this.addView(view, 0);
            }
            this.measureChildWithDecorationsAndMargin(view, lp);
            if (layoutState.mLayoutDirection == 1) {
                start = lp.mFullSpan ? this.getMaxEnd(defaultNewViewLine) : currentSpan.getEndLine(defaultNewViewLine);
                end = start + this.mPrimaryOrientation.getDecoratedMeasurement(view);
                if (assignSpan && lp.mFullSpan) {
                    LazySpanLookup.FullSpanItem fullSpanItem = this.createFullSpanItemFromEnd(start);
                    fullSpanItem.mGapDir = -1;
                    fullSpanItem.mPosition = position;
                    this.mLazySpanLookup.addFullSpanItem(fullSpanItem);
                }
            } else {
                end = lp.mFullSpan ? this.getMinStart(defaultNewViewLine) : currentSpan.getStartLine(defaultNewViewLine);
                start = end - this.mPrimaryOrientation.getDecoratedMeasurement(view);
                if (assignSpan && lp.mFullSpan) {
                    LazySpanLookup.FullSpanItem fullSpanItem = this.createFullSpanItemFromStart(end);
                    fullSpanItem.mGapDir = 1;
                    fullSpanItem.mPosition = position;
                    this.mLazySpanLookup.addFullSpanItem(fullSpanItem);
                }
            }
            if (lp.mFullSpan && layoutState.mItemDirection == -1) {
                if (assignSpan) {
                    this.mLaidOutInvalidFullSpan = true;
                } else {
                    boolean hasInvalidGap;
                    if (layoutState.mLayoutDirection == 1) {
                        hasInvalidGap = !this.areAllEndsEqual();
                    } else {
                        boolean bl2 = hasInvalidGap = !this.areAllStartsEqual();
                    }
                    if (hasInvalidGap) {
                        LazySpanLookup.FullSpanItem fullSpanItem = this.mLazySpanLookup.getFullSpanItem(position);
                        if (fullSpanItem != null) {
                            fullSpanItem.mHasUnwantedGapAfter = true;
                        }
                        this.mLaidOutInvalidFullSpan = true;
                    }
                }
            }
            this.attachViewToSpans(view, lp, layoutState);
            int otherStart = lp.mFullSpan ? this.mSecondaryOrientation.getStartAfterPadding() : currentSpan.mIndex * this.mSizePerSpan + this.mSecondaryOrientation.getStartAfterPadding();
            int otherEnd = otherStart + this.mSecondaryOrientation.getDecoratedMeasurement(view);
            if (this.mOrientation == 1) {
                this.layoutDecoratedWithMargins(view, otherStart, start, otherEnd, end);
            } else {
                this.layoutDecoratedWithMargins(view, start, otherStart, end, otherEnd);
            }
            if (lp.mFullSpan) {
                this.updateAllRemainingSpans(this.mLayoutState.mLayoutDirection, targetLine);
            } else {
                this.updateRemainingSpans(currentSpan, this.mLayoutState.mLayoutDirection, targetLine);
            }
            this.recycle(recycler, this.mLayoutState, currentSpan, recycleLine);
        }
        if (this.mLayoutState.mLayoutDirection == -1) {
            int minStart = this.getMinStart(this.mPrimaryOrientation.getStartAfterPadding());
            return Math.max(0, this.mLayoutState.mAvailable + (recycleLine - minStart));
        }
        int max = this.getMaxEnd(this.mPrimaryOrientation.getEndAfterPadding());
        return Math.max(0, this.mLayoutState.mAvailable + (max - recycleLine));
    }

    private LazySpanLookup.FullSpanItem createFullSpanItemFromEnd(int newItemTop) {
        LazySpanLookup.FullSpanItem fsi = new LazySpanLookup.FullSpanItem();
        fsi.mGapPerSpan = new int[this.mSpanCount];
        for (int i = 0; i < this.mSpanCount; ++i) {
            fsi.mGapPerSpan[i] = newItemTop - this.mSpans[i].getEndLine(newItemTop);
        }
        return fsi;
    }

    private LazySpanLookup.FullSpanItem createFullSpanItemFromStart(int newItemBottom) {
        LazySpanLookup.FullSpanItem fsi = new LazySpanLookup.FullSpanItem();
        fsi.mGapPerSpan = new int[this.mSpanCount];
        for (int i = 0; i < this.mSpanCount; ++i) {
            fsi.mGapPerSpan[i] = this.mSpans[i].getStartLine(newItemBottom) - newItemBottom;
        }
        return fsi;
    }

    private void attachViewToSpans(View view, LayoutParams lp, LayoutState layoutState) {
        if (layoutState.mLayoutDirection == 1) {
            if (lp.mFullSpan) {
                this.appendViewToAllSpans(view);
            } else {
                lp.mSpan.appendToSpan(view);
            }
        } else if (lp.mFullSpan) {
            this.prependViewToAllSpans(view);
        } else {
            lp.mSpan.prependToSpan(view);
        }
    }

    private void recycle(CustomRecyclerView.Recycler recycler, LayoutState layoutState, Span updatedSpan, int recycleLine) {
        if (layoutState.mLayoutDirection == -1) {
            int maxStart = this.getMaxStart(updatedSpan.getStartLine());
            this.recycleFromEnd(recycler, Math.max(recycleLine, maxStart) + (this.mPrimaryOrientation.getEnd() - this.mPrimaryOrientation.getStartAfterPadding()));
        } else {
            int minEnd = this.getMinEnd(updatedSpan.getEndLine());
            this.recycleFromStart(recycler, Math.min(recycleLine, minEnd) - (this.mPrimaryOrientation.getEnd() - this.mPrimaryOrientation.getStartAfterPadding()));
        }
    }

    private void appendViewToAllSpans(View view) {
        for (int i = this.mSpanCount - 1; i >= 0; --i) {
            this.mSpans[i].appendToSpan(view);
        }
    }

    private void prependViewToAllSpans(View view) {
        for (int i = this.mSpanCount - 1; i >= 0; --i) {
            this.mSpans[i].prependToSpan(view);
        }
    }

    private void layoutDecoratedWithMargins(View child, int left, int top, int right, int bottom) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        this.layoutDecorated(child, left + lp.leftMargin, top + lp.topMargin, right - lp.rightMargin, bottom - lp.bottomMargin);
    }

    private void updateAllRemainingSpans(int layoutDir, int targetLine) {
        for (int i = 0; i < this.mSpanCount; ++i) {
            if (this.mSpans[i].mViews.isEmpty()) continue;
            this.updateRemainingSpans(this.mSpans[i], layoutDir, targetLine);
        }
    }

    private void updateRemainingSpans(Span span, int layoutDir, int targetLine) {
        int deletedSize = span.getDeletedSize();
        if (layoutDir == -1) {
            int line = span.getStartLine();
            if (line + deletedSize < targetLine) {
                this.mRemainingSpans.set(span.mIndex, false);
            }
        } else {
            int line = span.getEndLine();
            if (line - deletedSize > targetLine) {
                this.mRemainingSpans.set(span.mIndex, false);
            }
        }
    }

    private int getMaxStart(int def) {
        int maxStart = this.mSpans[0].getStartLine(def);
        for (int i = 1; i < this.mSpanCount; ++i) {
            int spanStart = this.mSpans[i].getStartLine(def);
            if (spanStart <= maxStart) continue;
            maxStart = spanStart;
        }
        return maxStart;
    }

    private int getMinStart(int def) {
        int minStart = this.mSpans[0].getStartLine(def);
        for (int i = 1; i < this.mSpanCount; ++i) {
            int spanStart = this.mSpans[i].getStartLine(def);
            if (spanStart >= minStart) continue;
            minStart = spanStart;
        }
        return minStart;
    }

    boolean areAllEndsEqual() {
        int end = this.mSpans[0].getEndLine(Integer.MIN_VALUE);
        for (int i = 1; i < this.mSpanCount; ++i) {
            if (this.mSpans[i].getEndLine(Integer.MIN_VALUE) == end) continue;
            return false;
        }
        return true;
    }

    boolean areAllStartsEqual() {
        int start = this.mSpans[0].getStartLine(Integer.MIN_VALUE);
        for (int i = 1; i < this.mSpanCount; ++i) {
            if (this.mSpans[i].getStartLine(Integer.MIN_VALUE) == start) continue;
            return false;
        }
        return true;
    }

    private int getMaxEnd(int def) {
        int maxEnd = this.mSpans[0].getEndLine(def);
        for (int i = 1; i < this.mSpanCount; ++i) {
            int spanEnd = this.mSpans[i].getEndLine(def);
            if (spanEnd <= maxEnd) continue;
            maxEnd = spanEnd;
        }
        return maxEnd;
    }

    private int getMinEnd(int def) {
        int minEnd = this.mSpans[0].getEndLine(def);
        for (int i = 1; i < this.mSpanCount; ++i) {
            int spanEnd = this.mSpans[i].getEndLine(def);
            if (spanEnd >= minEnd) continue;
            minEnd = spanEnd;
        }
        return minEnd;
    }

    private void recycleFromStart(CustomRecyclerView.Recycler recycler, int line) {
        while (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            if (this.mPrimaryOrientation.getDecoratedEnd(child) < line) {
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp.mFullSpan) {
                    for (int j = 0; j < this.mSpanCount; ++j) {
                        this.mSpans[j].popStart();
                    }
                } else {
                    lp.mSpan.popStart();
                }
                this.removeAndRecycleView(child, recycler);
                continue;
            }
            return;
        }
    }

    private void recycleFromEnd(CustomRecyclerView.Recycler recycler, int line) {
        int childCount = this.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (this.mPrimaryOrientation.getDecoratedStart(child) > line) {
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp.mFullSpan) {
                    for (int j = 0; j < this.mSpanCount; ++j) {
                        this.mSpans[j].popEnd();
                    }
                } else {
                    lp.mSpan.popEnd();
                }
            } else {
                return;
            }
            this.removeAndRecycleView(child, recycler);
        }
    }

    private boolean preferLastSpan(int layoutDir) {
        if (this.mOrientation == 0) {
            return layoutDir == -1 != this.mShouldReverseLayout;
        }
        return layoutDir == -1 == this.mShouldReverseLayout == this.isLayoutRTL();
    }

    private Span getNextSpan(LayoutState layoutState) {
        int diff;
        int endIndex;
        int startIndex;
        boolean preferLastSpan = this.preferLastSpan(layoutState.mLayoutDirection);
        if (preferLastSpan) {
            startIndex = this.mSpanCount - 1;
            endIndex = -1;
            diff = -1;
        } else {
            startIndex = 0;
            endIndex = this.mSpanCount;
            diff = 1;
        }
        if (layoutState.mLayoutDirection == 1) {
            Span min = null;
            int minLine = Integer.MAX_VALUE;
            int defaultLine = this.mPrimaryOrientation.getStartAfterPadding();
            for (int i = startIndex; i != endIndex; i += diff) {
                Span other = this.mSpans[i];
                int otherLine = other.getEndLine(defaultLine);
                if (otherLine >= minLine) continue;
                min = other;
                minLine = otherLine;
            }
            return min;
        }
        Span max = null;
        int maxLine = Integer.MIN_VALUE;
        int defaultLine = this.mPrimaryOrientation.getEndAfterPadding();
        for (int i = startIndex; i != endIndex; i += diff) {
            Span other = this.mSpans[i];
            int otherLine = other.getStartLine(defaultLine);
            if (otherLine <= maxLine) continue;
            max = other;
            maxLine = otherLine;
        }
        return max;
    }

    @Override
    public boolean canScrollVertically() {
        return this.mOrientation == 1;
    }

    @Override
    public boolean canScrollHorizontally() {
        return this.mOrientation == 0;
    }

    @Override
    public int scrollHorizontallyBy(int dx, CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state) {
        return this.scrollBy(dx, recycler, state);
    }

    @Override
    public int scrollVerticallyBy(int dy, CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state) {
        return this.scrollBy(dy, recycler, state);
    }

    private int calculateScrollDirectionForPosition(int position) {
        if (this.getChildCount() == 0) {
            return this.mShouldReverseLayout ? 1 : -1;
        }
        int firstChildPos = this.getFirstChildPosition();
        return position < firstChildPos != this.mShouldReverseLayout ? -1 : 1;
    }

    @Override
    public void smoothScrollToPosition(CustomRecyclerView customRecyclerView, CustomRecyclerView.State state, int position) {
        LinearSmoothScroller scroller = new LinearSmoothScroller(customRecyclerView.getContext()){

            @Override
            public PointF computeScrollVectorForPosition(int targetPosition) {
                int direction = CustomStaggeredGridLayoutManager.this.calculateScrollDirectionForPosition(targetPosition);
                if (direction == 0) {
                    return null;
                }
                if (CustomStaggeredGridLayoutManager.this.mOrientation == 0) {
                    return new PointF((float)direction, 0.0f);
                }
                return new PointF(0.0f, (float)direction);
            }
        };
        scroller.setTargetPosition(position);
        this.startSmoothScroll(scroller);
    }

    @Override
    public void scrollToPosition(int position) {
        if (this.mPendingSavedState != null && this.mPendingSavedState.mAnchorPosition != position) {
            this.mPendingSavedState.invalidateAnchorPositionInfo();
        }
        this.mPendingScrollPosition = position;
        this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        this.requestLayout();
    }

    public void scrollToPositionWithOffset(int position, int offset) {
        if (this.mPendingSavedState != null) {
            this.mPendingSavedState.invalidateAnchorPositionInfo();
        }
        this.mPendingScrollPosition = position;
        this.mPendingScrollPositionOffset = offset;
        this.requestLayout();
    }

    int scrollBy(int dt, CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state) {
        int absDt;
        int referenceChildPosition;
        this.ensureOrientationHelper();
        if (dt > 0) {
            this.mLayoutState.mLayoutDirection = 1;
            this.mLayoutState.mItemDirection = this.mShouldReverseLayout ? -1 : 1;
            referenceChildPosition = this.getLastChildPosition();
        } else {
            this.mLayoutState.mLayoutDirection = -1;
            this.mLayoutState.mItemDirection = this.mShouldReverseLayout ? 1 : -1;
            referenceChildPosition = this.getFirstChildPosition();
        }
        this.mLayoutState.mCurrentPosition = referenceChildPosition + this.mLayoutState.mItemDirection;
        this.mLayoutState.mAvailable = absDt = Math.abs(dt);
        this.mLayoutState.mExtra = this.isSmoothScrolling() ? this.mPrimaryOrientation.getTotalSpace() : 0;
        int consumed = this.fill(recycler, this.mLayoutState, state);
        int totalScroll = absDt < consumed ? dt : (dt < 0 ? -consumed : consumed);
        this.mPrimaryOrientation.offsetChildren(-totalScroll);
        this.mLastLayoutFromEnd = this.mShouldReverseLayout;
        return totalScroll;
    }

    private int getLastChildPosition() {
        int childCount = this.getChildCount();
        return childCount == 0 ? 0 : this.getPosition(this.getChildAt(childCount - 1));
    }

    private int getFirstChildPosition() {
        int childCount = this.getChildCount();
        return childCount == 0 ? 0 : this.getPosition(this.getChildAt(0));
    }

    private int findFirstReferenceChildPosition(int itemCount) {
        int limit = this.getChildCount();
        for (int i = 0; i < limit; ++i) {
            View view = this.getChildAt(i);
            int position = this.getPosition(view);
            if (position < 0 || position >= itemCount) continue;
            return position;
        }
        return 0;
    }

    private int findLastReferenceChildPosition(int itemCount) {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View view = this.getChildAt(i);
            int position = this.getPosition(view);
            if (position < 0 || position >= itemCount) continue;
            return position;
        }
        return 0;
    }

    @Override
    public CustomRecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    @Override
    public CustomRecyclerView.LayoutParams generateLayoutParams(Context c, AttributeSet attrs) {
        return new LayoutParams(c, attrs);
    }

    @Override
    public CustomRecyclerView.LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)lp);
        }
        return new LayoutParams(lp);
    }

    @Override
    public boolean checkLayoutParams(CustomRecyclerView.LayoutParams lp) {
        return lp instanceof LayoutParams;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    private class AnchorInfo {
        int mPosition;
        int mOffset;
        boolean mLayoutFromEnd;
        boolean mInvalidateOffsets;

        private AnchorInfo() {
        }

        void reset() {
            this.mPosition = -1;
            this.mOffset = Integer.MIN_VALUE;
            this.mLayoutFromEnd = false;
            this.mInvalidateOffsets = false;
        }

        void assignCoordinateFromPadding() {
            this.mOffset = this.mLayoutFromEnd ? CustomStaggeredGridLayoutManager.this.mPrimaryOrientation.getEndAfterPadding() : CustomStaggeredGridLayoutManager.this.mPrimaryOrientation.getStartAfterPadding();
        }

        void assignCoordinateFromPadding(int addedDistance) {
            this.mOffset = this.mLayoutFromEnd ? CustomStaggeredGridLayoutManager.this.mPrimaryOrientation.getEndAfterPadding() - addedDistance : CustomStaggeredGridLayoutManager.this.mPrimaryOrientation.getStartAfterPadding() + addedDistance;
        }
    }

    static class SavedState
    implements Parcelable {
        int mAnchorPosition;
        int mVisibleAnchorPosition;
        int mSpanOffsetsSize;
        int[] mSpanOffsets;
        int mSpanLookupSize;
        int[] mSpanLookup;
        List<LazySpanLookup.FullSpanItem> mFullSpanItems;
        boolean mReverseLayout;
        boolean mAnchorLayoutFromEnd;
        boolean mLastLayoutRTL;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState() {
        }

        SavedState(Parcel in) {
            this.mAnchorPosition = in.readInt();
            this.mVisibleAnchorPosition = in.readInt();
            this.mSpanOffsetsSize = in.readInt();
            if (this.mSpanOffsetsSize > 0) {
                this.mSpanOffsets = new int[this.mSpanOffsetsSize];
                in.readIntArray(this.mSpanOffsets);
            }
            this.mSpanLookupSize = in.readInt();
            if (this.mSpanLookupSize > 0) {
                this.mSpanLookup = new int[this.mSpanLookupSize];
                in.readIntArray(this.mSpanLookup);
            }
            this.mReverseLayout = in.readInt() == 1;
            this.mAnchorLayoutFromEnd = in.readInt() == 1;
            this.mLastLayoutRTL = in.readInt() == 1;
            this.mFullSpanItems = in.readArrayList(LazySpanLookup.FullSpanItem.class.getClassLoader());
        }

        public SavedState(SavedState other) {
            this.mSpanOffsetsSize = other.mSpanOffsetsSize;
            this.mAnchorPosition = other.mAnchorPosition;
            this.mVisibleAnchorPosition = other.mVisibleAnchorPosition;
            this.mSpanOffsets = other.mSpanOffsets;
            this.mSpanLookupSize = other.mSpanLookupSize;
            this.mSpanLookup = other.mSpanLookup;
            this.mReverseLayout = other.mReverseLayout;
            this.mAnchorLayoutFromEnd = other.mAnchorLayoutFromEnd;
            this.mLastLayoutRTL = other.mLastLayoutRTL;
            this.mFullSpanItems = other.mFullSpanItems;
        }

        void invalidateSpanInfo() {
            this.mSpanOffsets = null;
            this.mSpanOffsetsSize = 0;
            this.mSpanLookupSize = 0;
            this.mSpanLookup = null;
            this.mFullSpanItems = null;
        }

        void invalidateAnchorPositionInfo() {
            this.mSpanOffsets = null;
            this.mSpanOffsetsSize = 0;
            this.mAnchorPosition = -1;
            this.mVisibleAnchorPosition = -1;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mAnchorPosition);
            dest.writeInt(this.mVisibleAnchorPosition);
            dest.writeInt(this.mSpanOffsetsSize);
            if (this.mSpanOffsetsSize > 0) {
                dest.writeIntArray(this.mSpanOffsets);
            }
            dest.writeInt(this.mSpanLookupSize);
            if (this.mSpanLookupSize > 0) {
                dest.writeIntArray(this.mSpanLookup);
            }
            dest.writeInt(this.mReverseLayout ? 1 : 0);
            dest.writeInt(this.mAnchorLayoutFromEnd ? 1 : 0);
            dest.writeInt(this.mLastLayoutRTL ? 1 : 0);
            dest.writeList(this.mFullSpanItems);
        }
    }

    static class LazySpanLookup {
        private static final int MIN_SIZE = 10;
        int[] mData;
        List<FullSpanItem> mFullSpanItems;

        LazySpanLookup() {
        }

        int forceInvalidateAfter(int position) {
            if (this.mFullSpanItems != null) {
                for (int i = this.mFullSpanItems.size() - 1; i >= 0; --i) {
                    FullSpanItem fsi = this.mFullSpanItems.get(i);
                    if (fsi.mPosition < position) continue;
                    this.mFullSpanItems.remove(i);
                }
            }
            return this.invalidateAfter(position);
        }

        int invalidateAfter(int position) {
            if (this.mData == null) {
                return -1;
            }
            if (position >= this.mData.length) {
                return -1;
            }
            int endPosition = this.invalidateFullSpansAfter(position);
            if (endPosition == -1) {
                Arrays.fill(this.mData, position, this.mData.length, -1);
                return this.mData.length;
            }
            Arrays.fill(this.mData, position, endPosition + 1, -1);
            return endPosition + 1;
        }

        int getSpan(int position) {
            if (this.mData == null || position >= this.mData.length) {
                return -1;
            }
            return this.mData[position];
        }

        void setSpan(int position, Span span) {
            this.ensureSize(position);
            this.mData[position] = span.mIndex;
        }

        int sizeForPosition(int position) {
            int len;
            for (len = this.mData.length; len <= position; len *= 2) {
            }
            return len;
        }

        void ensureSize(int position) {
            if (this.mData == null) {
                this.mData = new int[Math.max(position, 10) + 1];
                Arrays.fill(this.mData, -1);
            } else if (position >= this.mData.length) {
                int[] old = this.mData;
                this.mData = new int[this.sizeForPosition(position)];
                System.arraycopy(old, 0, this.mData, 0, old.length);
                Arrays.fill(this.mData, old.length, this.mData.length, -1);
            }
        }

        void clear() {
            if (this.mData != null) {
                Arrays.fill(this.mData, -1);
            }
            this.mFullSpanItems = null;
        }

        void offsetForRemoval(int positionStart, int itemCount) {
            if (this.mData == null || positionStart >= this.mData.length) {
                return;
            }
            this.ensureSize(positionStart + itemCount);
            System.arraycopy(this.mData, positionStart + itemCount, this.mData, positionStart, this.mData.length - positionStart - itemCount);
            Arrays.fill(this.mData, this.mData.length - itemCount, this.mData.length, -1);
            this.offsetFullSpansForRemoval(positionStart, itemCount);
        }

        private void offsetFullSpansForRemoval(int positionStart, int itemCount) {
            if (this.mFullSpanItems == null) {
                return;
            }
            int end = positionStart + itemCount;
            for (int i = this.mFullSpanItems.size() - 1; i >= 0; --i) {
                FullSpanItem fsi = this.mFullSpanItems.get(i);
                if (fsi.mPosition < positionStart) continue;
                if (fsi.mPosition < end) {
                    this.mFullSpanItems.remove(i);
                    continue;
                }
                fsi.mPosition -= itemCount;
            }
        }

        void offsetForAddition(int positionStart, int itemCount) {
            if (this.mData == null || positionStart >= this.mData.length) {
                return;
            }
            this.ensureSize(positionStart + itemCount);
            System.arraycopy(this.mData, positionStart, this.mData, positionStart + itemCount, this.mData.length - positionStart - itemCount);
            Arrays.fill(this.mData, positionStart, positionStart + itemCount, -1);
            this.offsetFullSpansForAddition(positionStart, itemCount);
        }

        private void offsetFullSpansForAddition(int positionStart, int itemCount) {
            if (this.mFullSpanItems == null) {
                return;
            }
            for (int i = this.mFullSpanItems.size() - 1; i >= 0; --i) {
                FullSpanItem fsi = this.mFullSpanItems.get(i);
                if (fsi.mPosition < positionStart) continue;
                fsi.mPosition += itemCount;
            }
        }

        private int invalidateFullSpansAfter(int position) {
            if (this.mFullSpanItems == null) {
                return -1;
            }
            FullSpanItem item = this.getFullSpanItem(position);
            if (item != null) {
                this.mFullSpanItems.remove(item);
            }
            int nextFsiIndex = -1;
            int count = this.mFullSpanItems.size();
            for (int i = 0; i < count; ++i) {
                FullSpanItem fsi = this.mFullSpanItems.get(i);
                if (fsi.mPosition < position) continue;
                nextFsiIndex = i;
                break;
            }
            if (nextFsiIndex != -1) {
                FullSpanItem fsi = this.mFullSpanItems.get(nextFsiIndex);
                this.mFullSpanItems.remove(nextFsiIndex);
                return fsi.mPosition;
            }
            return -1;
        }

        public void addFullSpanItem(FullSpanItem fullSpanItem) {
            if (this.mFullSpanItems == null) {
                this.mFullSpanItems = new ArrayList<FullSpanItem>();
            }
            int size = this.mFullSpanItems.size();
            for (int i = 0; i < size; ++i) {
                FullSpanItem other = this.mFullSpanItems.get(i);
                if (other.mPosition == fullSpanItem.mPosition) {
                    this.mFullSpanItems.remove(i);
                }
                if (other.mPosition < fullSpanItem.mPosition) continue;
                this.mFullSpanItems.add(i, fullSpanItem);
                return;
            }
            this.mFullSpanItems.add(fullSpanItem);
        }

        public FullSpanItem getFullSpanItem(int position) {
            if (this.mFullSpanItems == null) {
                return null;
            }
            for (int i = this.mFullSpanItems.size() - 1; i >= 0; --i) {
                FullSpanItem fsi = this.mFullSpanItems.get(i);
                if (fsi.mPosition != position) continue;
                return fsi;
            }
            return null;
        }

        public FullSpanItem getFirstFullSpanItemInRange(int minPos, int maxPos, int gapDir, boolean hasUnwantedGapAfter) {
            if (this.mFullSpanItems == null) {
                return null;
            }
            int limit = this.mFullSpanItems.size();
            for (int i = 0; i < limit; ++i) {
                FullSpanItem fsi = this.mFullSpanItems.get(i);
                if (fsi.mPosition >= maxPos) {
                    return null;
                }
                if (fsi.mPosition < minPos || gapDir != 0 && fsi.mGapDir != gapDir && (!hasUnwantedGapAfter || !fsi.mHasUnwantedGapAfter)) continue;
                return fsi;
            }
            return null;
        }

        static class FullSpanItem
        implements Parcelable {
            int mPosition;
            int mGapDir;
            int[] mGapPerSpan;
            boolean mHasUnwantedGapAfter;
            public static final Parcelable.Creator<FullSpanItem> CREATOR = new Parcelable.Creator<FullSpanItem>(){

                public FullSpanItem createFromParcel(Parcel in) {
                    return new FullSpanItem(in);
                }

                public FullSpanItem[] newArray(int size) {
                    return new FullSpanItem[size];
                }
            };

            public FullSpanItem(Parcel in) {
                this.mPosition = in.readInt();
                this.mGapDir = in.readInt();
                this.mHasUnwantedGapAfter = in.readInt() == 1;
                int spanCount = in.readInt();
                if (spanCount > 0) {
                    this.mGapPerSpan = new int[spanCount];
                    in.readIntArray(this.mGapPerSpan);
                }
            }

            public FullSpanItem() {
            }

            int getGapForSpan(int spanIndex) {
                return this.mGapPerSpan == null ? 0 : this.mGapPerSpan[spanIndex];
            }

            public void invalidateSpanGaps() {
                this.mGapPerSpan = null;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.mPosition);
                dest.writeInt(this.mGapDir);
                dest.writeInt(this.mHasUnwantedGapAfter ? 1 : 0);
                if (this.mGapPerSpan != null && this.mGapPerSpan.length > 0) {
                    dest.writeInt(this.mGapPerSpan.length);
                    dest.writeIntArray(this.mGapPerSpan);
                } else {
                    dest.writeInt(0);
                }
            }

            public String toString() {
                return "FullSpanItem{mPosition=" + this.mPosition + ", mGapDir=" + this.mGapDir + ", mHasUnwantedGapAfter=" + this.mHasUnwantedGapAfter + ", mGapPerSpan=" + Arrays.toString(this.mGapPerSpan) + '}';
            }
        }
    }

    class Span {
        static final int INVALID_LINE = Integer.MIN_VALUE;
        private ArrayList<View> mViews = new ArrayList();
        int mCachedStart = Integer.MIN_VALUE;
        int mCachedEnd = Integer.MIN_VALUE;
        int mDeletedSize = 0;
        final int mIndex;

        private Span(int index) {
            this.mIndex = index;
        }

        int getStartLine(int def) {
            if (this.mCachedStart != Integer.MIN_VALUE) {
                return this.mCachedStart;
            }
            if (this.mViews.size() == 0) {
                return def;
            }
            this.calculateCachedStart();
            return this.mCachedStart;
        }

        void calculateCachedStart() {
            LazySpanLookup.FullSpanItem fsi;
            View startView = this.mViews.get(0);
            LayoutParams lp = this.getLayoutParams(startView);
            this.mCachedStart = CustomStaggeredGridLayoutManager.this.mPrimaryOrientation.getDecoratedStart(startView);
            if (lp.mFullSpan && (fsi = CustomStaggeredGridLayoutManager.this.mLazySpanLookup.getFullSpanItem(lp.getViewLayoutPosition())) != null && fsi.mGapDir == -1) {
                this.mCachedStart -= fsi.getGapForSpan(this.mIndex);
            }
        }

        int getStartLine() {
            if (this.mCachedStart != Integer.MIN_VALUE) {
                return this.mCachedStart;
            }
            this.calculateCachedStart();
            return this.mCachedStart;
        }

        int getEndLine(int def) {
            if (this.mCachedEnd != Integer.MIN_VALUE) {
                return this.mCachedEnd;
            }
            int size = this.mViews.size();
            if (size == 0) {
                return def;
            }
            this.calculateCachedEnd();
            return this.mCachedEnd;
        }

        void calculateCachedEnd() {
            LazySpanLookup.FullSpanItem fsi;
            View endView = this.mViews.get(this.mViews.size() - 1);
            LayoutParams lp = this.getLayoutParams(endView);
            this.mCachedEnd = CustomStaggeredGridLayoutManager.this.mPrimaryOrientation.getDecoratedEnd(endView);
            if (lp.mFullSpan && (fsi = CustomStaggeredGridLayoutManager.this.mLazySpanLookup.getFullSpanItem(lp.getViewLayoutPosition())) != null && fsi.mGapDir == 1) {
                this.mCachedEnd += fsi.getGapForSpan(this.mIndex);
            }
        }

        int getEndLine() {
            if (this.mCachedEnd != Integer.MIN_VALUE) {
                return this.mCachedEnd;
            }
            this.calculateCachedEnd();
            return this.mCachedEnd;
        }

        void prependToSpan(View view) {
            LayoutParams lp = this.getLayoutParams(view);
            lp.mSpan = this;
            this.mViews.add(0, view);
            this.mCachedStart = Integer.MIN_VALUE;
            if (this.mViews.size() == 1) {
                this.mCachedEnd = Integer.MIN_VALUE;
            }
            if (lp.isItemRemoved() || lp.isItemChanged()) {
                this.mDeletedSize += CustomStaggeredGridLayoutManager.this.mPrimaryOrientation.getDecoratedMeasurement(view);
            }
        }

        void appendToSpan(View view) {
            LayoutParams lp = this.getLayoutParams(view);
            lp.mSpan = this;
            this.mViews.add(view);
            this.mCachedEnd = Integer.MIN_VALUE;
            if (this.mViews.size() == 1) {
                this.mCachedStart = Integer.MIN_VALUE;
            }
            if (lp.isItemRemoved() || lp.isItemChanged()) {
                this.mDeletedSize += CustomStaggeredGridLayoutManager.this.mPrimaryOrientation.getDecoratedMeasurement(view);
            }
        }

        void cacheReferenceLineAndClear(boolean reverseLayout, int offset) {
            int reference = reverseLayout ? this.getEndLine(Integer.MIN_VALUE) : this.getStartLine(Integer.MIN_VALUE);
            this.clear();
            if (reference == Integer.MIN_VALUE) {
                return;
            }
            if (reverseLayout && reference < CustomStaggeredGridLayoutManager.this.mPrimaryOrientation.getEndAfterPadding() || !reverseLayout && reference > CustomStaggeredGridLayoutManager.this.mPrimaryOrientation.getStartAfterPadding()) {
                return;
            }
            if (offset != Integer.MIN_VALUE) {
                reference += offset;
            }
            this.mCachedStart = this.mCachedEnd = reference;
        }

        void clear() {
            this.mViews.clear();
            this.invalidateCache();
            this.mDeletedSize = 0;
        }

        void invalidateCache() {
            this.mCachedStart = Integer.MIN_VALUE;
            this.mCachedEnd = Integer.MIN_VALUE;
        }

        void setLine(int line) {
            this.mCachedEnd = this.mCachedStart = line;
        }

        void popEnd() {
            int size = this.mViews.size();
            View end = this.mViews.remove(size - 1);
            LayoutParams lp = this.getLayoutParams(end);
            lp.mSpan = null;
            if (lp.isItemRemoved() || lp.isItemChanged()) {
                this.mDeletedSize -= CustomStaggeredGridLayoutManager.this.mPrimaryOrientation.getDecoratedMeasurement(end);
            }
            if (size == 1) {
                this.mCachedStart = Integer.MIN_VALUE;
            }
            this.mCachedEnd = Integer.MIN_VALUE;
        }

        void popStart() {
            View start = this.mViews.remove(0);
            LayoutParams lp = this.getLayoutParams(start);
            lp.mSpan = null;
            if (this.mViews.size() == 0) {
                this.mCachedEnd = Integer.MIN_VALUE;
            }
            if (lp.isItemRemoved() || lp.isItemChanged()) {
                this.mDeletedSize -= CustomStaggeredGridLayoutManager.this.mPrimaryOrientation.getDecoratedMeasurement(start);
            }
            this.mCachedStart = Integer.MIN_VALUE;
        }

        public int getDeletedSize() {
            return this.mDeletedSize;
        }

        LayoutParams getLayoutParams(View view) {
            return (LayoutParams)view.getLayoutParams();
        }

        void onOffset(int dt) {
            if (this.mCachedStart != Integer.MIN_VALUE) {
                this.mCachedStart += dt;
            }
            if (this.mCachedEnd != Integer.MIN_VALUE) {
                this.mCachedEnd += dt;
            }
        }

        int getNormalizedOffset(int dt, int targetStart, int targetEnd) {
            if (this.mViews.size() == 0) {
                return 0;
            }
            if (dt < 0) {
                int endSpace = this.getEndLine() - targetEnd;
                if (endSpace <= 0) {
                    return 0;
                }
                return -dt > endSpace ? -endSpace : dt;
            }
            int startSpace = targetStart - this.getStartLine();
            if (startSpace <= 0) {
                return 0;
            }
            return startSpace < dt ? startSpace : dt;
        }

        boolean isEmpty(int start, int end) {
            int count = this.mViews.size();
            for (int i = 0; i < count; ++i) {
                View view = this.mViews.get(i);
                if (CustomStaggeredGridLayoutManager.this.mPrimaryOrientation.getDecoratedStart(view) >= end || CustomStaggeredGridLayoutManager.this.mPrimaryOrientation.getDecoratedEnd(view) <= start) continue;
                return false;
            }
            return true;
        }

        public int findFirstVisibleItemPosition() {
            return CustomStaggeredGridLayoutManager.this.mReverseLayout ? this.findOneVisibleChild(this.mViews.size() - 1, -1, false) : this.findOneVisibleChild(0, this.mViews.size(), false);
        }

        public int findFirstCompletelyVisibleItemPosition() {
            return CustomStaggeredGridLayoutManager.this.mReverseLayout ? this.findOneVisibleChild(this.mViews.size() - 1, -1, true) : this.findOneVisibleChild(0, this.mViews.size(), true);
        }

        public int findLastVisibleItemPosition() {
            return CustomStaggeredGridLayoutManager.this.mReverseLayout ? this.findOneVisibleChild(0, this.mViews.size(), false) : this.findOneVisibleChild(this.mViews.size() - 1, -1, false);
        }

        public int findLastCompletelyVisibleItemPosition() {
            return CustomStaggeredGridLayoutManager.this.mReverseLayout ? this.findOneVisibleChild(0, this.mViews.size(), true) : this.findOneVisibleChild(this.mViews.size() - 1, -1, true);
        }

        int findOneVisibleChild(int fromIndex, int toIndex, boolean completelyVisible) {
            int start = CustomStaggeredGridLayoutManager.this.mPrimaryOrientation.getStartAfterPadding();
            int end = CustomStaggeredGridLayoutManager.this.mPrimaryOrientation.getEndAfterPadding();
            int next = toIndex > fromIndex ? 1 : -1;
            for (int i = fromIndex; i != toIndex; i += next) {
                View child = this.mViews.get(i);
                int childStart = CustomStaggeredGridLayoutManager.this.mPrimaryOrientation.getDecoratedStart(child);
                int childEnd = CustomStaggeredGridLayoutManager.this.mPrimaryOrientation.getDecoratedEnd(child);
                if (childStart >= end || childEnd <= start) continue;
                if (completelyVisible) {
                    if (childStart < start || childEnd > end) continue;
                    return CustomStaggeredGridLayoutManager.this.getPosition(child);
                }
                return CustomStaggeredGridLayoutManager.this.getPosition(child);
            }
            return -1;
        }
    }

    public static class LayoutParams
    extends CustomRecyclerView.LayoutParams {
        public static final int INVALID_SPAN_ID = -1;
        Span mSpan;
        boolean mFullSpan;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(CustomRecyclerView.LayoutParams source) {
            super(source);
        }

        public void setFullSpan(boolean fullSpan) {
            this.mFullSpan = fullSpan;
        }

        public boolean isFullSpan() {
            return this.mFullSpan;
        }

        public final int getSpanIndex() {
            if (this.mSpan == null) {
                return -1;
            }
            return this.mSpan.mIndex;
        }
    }
}

