/*
 * Decompiled with CFR 0.152.
 */
package com.custom_recycler_view;

import android.content.Context;
import android.database.Observable;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v4.view.accessibility.AccessibilityEventCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.view.accessibility.AccessibilityRecordCompat;
import android.support.v4.widget.EdgeEffectCompat;
import android.support.v4.widget.ScrollerCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.FocusFinder;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.Interpolator;
import com.custom_recycler_view.AdapterHelper;
import com.custom_recycler_view.ChildHelper;
import com.custom_recycler_view.DefaultItemAnimator;
import com.custom_recycler_view.RecyclerViewAccessibilityDelegate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CustomRecyclerView
extends ViewGroup {
    private static final String TAG = "RecyclerView";
    private static final boolean DEBUG = false;
    private static final boolean FORCE_INVALIDATE_DISPLAY_LIST = Build.VERSION.SDK_INT == 19 || Build.VERSION.SDK_INT == 20;
    private static final boolean DISPATCH_TEMP_DETACH = false;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int NO_POSITION = -1;
    public static final long NO_ID = -1L;
    public static final int INVALID_TYPE = -1;
    public static final int TOUCH_SLOP_DEFAULT = 0;
    public static final int TOUCH_SLOP_PAGING = 1;
    private static final int MAX_SCROLL_DURATION = 2000;
    private final RecyclerViewDataObserver mObserver = new RecyclerViewDataObserver();
    final Recycler mRecycler = new Recycler();
    private SavedState mPendingSavedState;
    AdapterHelper mAdapterHelper;
    ChildHelper mChildHelper;
    final List<View> mDisappearingViewsInLayoutPass = new ArrayList<View>();
    private boolean mClipToPadding;
    private final Runnable mUpdateChildViewsRunnable = new Runnable(){

        @Override
        public void run() {
            if (!CustomRecyclerView.this.mFirstLayoutComplete) {
                return;
            }
            if (CustomRecyclerView.this.mDataSetHasChangedAfterLayout) {
                CustomRecyclerView.this.dispatchLayout();
            } else if (CustomRecyclerView.this.mAdapterHelper.hasPendingUpdates()) {
                CustomRecyclerView.this.eatRequestLayout();
                CustomRecyclerView.this.mAdapterHelper.preProcess();
                if (!CustomRecyclerView.this.mLayoutRequestEaten) {
                    CustomRecyclerView.this.rebindUpdatedViewHolders();
                }
                CustomRecyclerView.this.resumeRequestLayout(true);
            }
        }
    };
    private final Rect mTempRect = new Rect();
    private Adapter mAdapter;
    private LayoutManager mLayout;
    private RecyclerListener mRecyclerListener;
    private final ArrayList<ItemDecoration> mItemDecorations = new ArrayList();
    private final ArrayList<OnItemTouchListener> mOnItemTouchListeners = new ArrayList();
    private OnItemTouchListener mActiveOnItemTouchListener;
    private boolean mIsAttached;
    private boolean mHasFixedSize;
    private boolean mFirstLayoutComplete;
    private boolean mEatRequestLayout;
    private boolean mLayoutRequestEaten;
    private boolean mAdapterUpdateDuringMeasure;
    private final boolean mPostUpdatesOnAnimation;
    private final AccessibilityManager mAccessibilityManager;
    private boolean mDataSetHasChangedAfterLayout = false;
    private boolean mRunningLayoutOrScroll = false;
    private EdgeEffectCompat mLeftGlow;
    private EdgeEffectCompat mTopGlow;
    private EdgeEffectCompat mRightGlow;
    private EdgeEffectCompat mBottomGlow;
    ItemAnimator mItemAnimator = new DefaultItemAnimator();
    private static final int INVALID_POINTER = -1;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SETTLING = 2;
    private int mScrollState = 0;
    private int mScrollPointerId = -1;
    private VelocityTracker mVelocityTracker;
    private int mInitialTouchX;
    private int mInitialTouchY;
    private int mLastTouchX;
    private int mLastTouchY;
    private int mTouchSlop;
    private final int mMinFlingVelocity;
    private final int mMaxFlingVelocity;
    private final ViewFlinger mViewFlinger = new ViewFlinger();
    final State mState = new State();
    private OnScrollListener mScrollListener;
    boolean mItemsAddedOrRemoved = false;
    boolean mItemsChanged = false;
    private ItemAnimator.ItemAnimatorListener mItemAnimatorListener = new ItemAnimatorRestoreListener();
    private boolean mPostedAnimatorRunner = false;
    private RecyclerViewAccessibilityDelegate mAccessibilityDelegate;
    private final int[] mMinMaxLayoutPositions = new int[2];
    private Runnable mItemAnimatorRunner = new Runnable(){

        @Override
        public void run() {
            if (CustomRecyclerView.this.mItemAnimator != null) {
                CustomRecyclerView.this.mItemAnimator.runPendingAnimations();
            }
            CustomRecyclerView.this.mPostedAnimatorRunner = false;
        }
    };
    private static final Interpolator sQuinticInterpolator = new Interpolator(){

        public float getInterpolation(float t) {
            return (t -= 1.0f) * t * t * t * t + 1.0f;
        }
    };

    public CustomRecyclerView(Context context) {
        this(context, null);
    }

    public CustomRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CustomRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int version = Build.VERSION.SDK_INT;
        this.mPostUpdatesOnAnimation = version >= 16;
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        this.mTouchSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity();
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        this.setWillNotDraw(ViewCompat.getOverScrollMode((View)this) == 2);
        this.mItemAnimator.setListener(this.mItemAnimatorListener);
        this.initAdapterManager();
        this.initChildrenHelper();
        if (ViewCompat.getImportantForAccessibility((View)this) == 0) {
            ViewCompat.setImportantForAccessibility((View)this, (int)1);
        }
        this.mAccessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
        this.setAccessibilityDelegateCompat(new RecyclerViewAccessibilityDelegate(this));
    }

    public RecyclerViewAccessibilityDelegate getCompatAccessibilityDelegate() {
        return this.mAccessibilityDelegate;
    }

    public void setAccessibilityDelegateCompat(RecyclerViewAccessibilityDelegate accessibilityDelegate) {
        this.mAccessibilityDelegate = accessibilityDelegate;
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)this.mAccessibilityDelegate);
    }

    private void initChildrenHelper() {
        this.mChildHelper = new ChildHelper(new ChildHelper.Callback(){

            @Override
            public int getChildCount() {
                return CustomRecyclerView.this.getChildCount();
            }

            @Override
            public void addView(View child, int index) {
                CustomRecyclerView.this.addView(child, index);
                CustomRecyclerView.this.dispatchChildAttached(child);
            }

            @Override
            public int indexOfChild(View view) {
                return CustomRecyclerView.this.indexOfChild(view);
            }

            @Override
            public void removeViewAt(int index) {
                View child = CustomRecyclerView.this.getChildAt(index);
                if (child != null) {
                    CustomRecyclerView.this.dispatchChildDetached(child);
                }
                CustomRecyclerView.this.removeViewAt(index);
            }

            @Override
            public View getChildAt(int offset) {
                return CustomRecyclerView.this.getChildAt(offset);
            }

            @Override
            public void removeAllViews() {
                int count = this.getChildCount();
                for (int i = 0; i < count; ++i) {
                    CustomRecyclerView.this.dispatchChildDetached(this.getChildAt(i));
                }
                CustomRecyclerView.this.removeAllViews();
            }

            @Override
            public ViewHolder getChildViewHolder(View view) {
                return CustomRecyclerView.getChildViewHolderInt(view);
            }

            @Override
            public void attachViewToParent(View child, int index, ViewGroup.LayoutParams layoutParams) {
                ViewHolder vh = CustomRecyclerView.getChildViewHolderInt(child);
                if (vh != null) {
                    if (!vh.isTmpDetached() && !vh.shouldIgnore()) {
                        throw new IllegalArgumentException("Called attach on a child which is not detached: " + vh);
                    }
                    vh.clearTmpDetachFlag();
                }
                CustomRecyclerView.this.attachViewToParent(child, index, layoutParams);
            }

            @Override
            public void detachViewFromParent(int offset) {
                ViewHolder vh;
                View view = this.getChildAt(offset);
                if (view != null && (vh = CustomRecyclerView.getChildViewHolderInt(view)) != null) {
                    if (vh.isTmpDetached() && !vh.shouldIgnore()) {
                        throw new IllegalArgumentException("called detach on an already detached child " + vh);
                    }
                    vh.addFlags(256);
                }
                CustomRecyclerView.this.detachViewFromParent(offset);
            }
        });
    }

    void initAdapterManager() {
        this.mAdapterHelper = new AdapterHelper(new AdapterHelper.Callback(){

            @Override
            public ViewHolder findViewHolder(int position) {
                return CustomRecyclerView.this.findViewHolderForPosition(position, true);
            }

            @Override
            public void offsetPositionsForRemovingInvisible(int start, int count) {
                CustomRecyclerView.this.offsetPositionRecordsForRemove(start, count, true);
                CustomRecyclerView.this.mItemsAddedOrRemoved = true;
                State state = CustomRecyclerView.this.mState;
                state.mDeletedInvisibleItemCountSincePreviousLayout = state.mDeletedInvisibleItemCountSincePreviousLayout + count;
            }

            @Override
            public void offsetPositionsForRemovingLaidOutOrNewView(int positionStart, int itemCount) {
                CustomRecyclerView.this.offsetPositionRecordsForRemove(positionStart, itemCount, false);
                CustomRecyclerView.this.mItemsAddedOrRemoved = true;
            }

            @Override
            public void markViewHoldersUpdated(int positionStart, int itemCount) {
                CustomRecyclerView.this.viewRangeUpdate(positionStart, itemCount);
                CustomRecyclerView.this.mItemsChanged = true;
            }

            @Override
            public void onDispatchFirstPass(AdapterHelper.UpdateOp op) {
                this.dispatchUpdate(op);
            }

            void dispatchUpdate(AdapterHelper.UpdateOp op) {
                switch (op.cmd) {
                    case 0: {
                        CustomRecyclerView.this.mLayout.onItemsAdded(CustomRecyclerView.this, op.positionStart, op.itemCount);
                        break;
                    }
                    case 1: {
                        CustomRecyclerView.this.mLayout.onItemsRemoved(CustomRecyclerView.this, op.positionStart, op.itemCount);
                        break;
                    }
                    case 2: {
                        CustomRecyclerView.this.mLayout.onItemsUpdated(CustomRecyclerView.this, op.positionStart, op.itemCount);
                        break;
                    }
                    case 3: {
                        CustomRecyclerView.this.mLayout.onItemsMoved(CustomRecyclerView.this, op.positionStart, op.itemCount, 1);
                    }
                }
            }

            @Override
            public void onDispatchSecondPass(AdapterHelper.UpdateOp op) {
                this.dispatchUpdate(op);
            }

            @Override
            public void offsetPositionsForAdd(int positionStart, int itemCount) {
                CustomRecyclerView.this.offsetPositionRecordsForInsert(positionStart, itemCount);
                CustomRecyclerView.this.mItemsAddedOrRemoved = true;
            }

            @Override
            public void offsetPositionsForMove(int from, int to) {
                CustomRecyclerView.this.offsetPositionRecordsForMove(from, to);
                CustomRecyclerView.this.mItemsAddedOrRemoved = true;
            }
        });
    }

    public void setHasFixedSize(boolean hasFixedSize) {
        this.mHasFixedSize = hasFixedSize;
    }

    public boolean hasFixedSize() {
        return this.mHasFixedSize;
    }

    public void setClipToPadding(boolean clipToPadding) {
        if (clipToPadding != this.mClipToPadding) {
            this.invalidateGlows();
        }
        this.mClipToPadding = clipToPadding;
        super.setClipToPadding(clipToPadding);
        if (this.mFirstLayoutComplete) {
            this.requestLayout();
        }
    }

    public void setScrollingTouchSlop(int slopConstant) {
        ViewConfiguration vc = ViewConfiguration.get((Context)this.getContext());
        switch (slopConstant) {
            default: {
                Log.w((String)TAG, (String)("setScrollingTouchSlop(): bad argument constant " + slopConstant + "; using default value"));
            }
            case 0: {
                this.mTouchSlop = vc.getScaledTouchSlop();
                break;
            }
            case 1: {
                this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop((ViewConfiguration)vc);
            }
        }
    }

    public void swapAdapter(Adapter adapter, boolean removeAndRecycleExistingViews) {
        this.setAdapterInternal(adapter, true, removeAndRecycleExistingViews);
        this.setDataSetChangedAfterLayout();
        this.requestLayout();
    }

    public void setAdapter(Adapter adapter) {
        this.setAdapterInternal(adapter, false, true);
        this.requestLayout();
    }

    private void setAdapterInternal(Adapter adapter, boolean compatibleWithPrevious, boolean removeAndRecycleViews) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterAdapterDataObserver(this.mObserver);
            this.mAdapter.onDetachedFromRecyclerView(this);
        }
        if (!compatibleWithPrevious || removeAndRecycleViews) {
            if (this.mItemAnimator != null) {
                this.mItemAnimator.endAnimations();
            }
            if (this.mLayout != null) {
                this.mLayout.removeAndRecycleAllViews(this.mRecycler);
                this.mLayout.removeAndRecycleScrapInt(this.mRecycler);
            }
            this.mRecycler.clear();
        }
        this.mAdapterHelper.reset();
        Adapter oldAdapter = this.mAdapter;
        this.mAdapter = adapter;
        if (adapter != null) {
            adapter.registerAdapterDataObserver(this.mObserver);
            adapter.onAttachedToRecyclerView(this);
        }
        if (this.mLayout != null) {
            this.mLayout.onAdapterChanged(oldAdapter, this.mAdapter);
        }
        this.mRecycler.onAdapterChanged(oldAdapter, this.mAdapter, compatibleWithPrevious);
        this.mState.mStructureChanged = true;
        this.markKnownViewsInvalid();
    }

    public Adapter getAdapter() {
        return this.mAdapter;
    }

    public void setRecyclerListener(RecyclerListener listener) {
        this.mRecyclerListener = listener;
    }

    public void setLayoutManager(LayoutManager layout) {
        if (layout == this.mLayout) {
            return;
        }
        if (this.mLayout != null) {
            if (this.mIsAttached) {
                this.mLayout.onDetachedFromWindow(this, this.mRecycler);
            }
            this.mLayout.setRecyclerView(null);
        }
        this.mRecycler.clear();
        this.mChildHelper.removeAllViewsUnfiltered();
        this.mLayout = layout;
        if (layout != null) {
            if (layout.mCustomRecyclerView != null) {
                throw new IllegalArgumentException("LayoutManager " + layout + " is already attached to a RecyclerView: " + (Object)((Object)layout.mCustomRecyclerView));
            }
            this.mLayout.setRecyclerView(this);
            if (this.mIsAttached) {
                this.mLayout.onAttachedToWindow(this);
            }
        }
        this.requestLayout();
    }

    protected Parcelable onSaveInstanceState() {
        SavedState state = new SavedState(super.onSaveInstanceState());
        if (this.mPendingSavedState != null) {
            state.copyFrom(this.mPendingSavedState);
        } else {
            state.mLayoutState = this.mLayout != null ? this.mLayout.onSaveInstanceState() : null;
        }
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        this.mPendingSavedState = (SavedState)state;
        super.onRestoreInstanceState(this.mPendingSavedState.getSuperState());
        if (this.mLayout != null && this.mPendingSavedState.mLayoutState != null) {
            this.mLayout.onRestoreInstanceState(this.mPendingSavedState.mLayoutState);
        }
    }

    private void addAnimatingView(ViewHolder viewHolder) {
        View view = viewHolder.itemView;
        boolean alreadyParented = view.getParent() == this;
        this.mRecycler.unscrapView(this.getChildViewHolder(view));
        if (viewHolder.isTmpDetached()) {
            this.mChildHelper.attachViewToParent(view, -1, view.getLayoutParams(), true);
        } else if (!alreadyParented) {
            this.mChildHelper.addView(view, true);
        } else {
            this.mChildHelper.hide(view);
        }
    }

    private boolean removeAnimatingView(View view) {
        this.eatRequestLayout();
        boolean removed = this.mChildHelper.removeViewIfHidden(view);
        if (removed) {
            ViewHolder viewHolder = CustomRecyclerView.getChildViewHolderInt(view);
            this.mRecycler.unscrapView(viewHolder);
            this.mRecycler.recycleViewHolderInternal(viewHolder);
        }
        this.resumeRequestLayout(false);
        return removed;
    }

    public LayoutManager getLayoutManager() {
        return this.mLayout;
    }

    public RecycledViewPool getRecycledViewPool() {
        return this.mRecycler.getRecycledViewPool();
    }

    public void setRecycledViewPool(RecycledViewPool pool) {
        this.mRecycler.setRecycledViewPool(pool);
    }

    public void setViewCacheExtension(ViewCacheExtension extension) {
        this.mRecycler.setViewCacheExtension(extension);
    }

    public void setItemViewCacheSize(int size) {
        this.mRecycler.setViewCacheSize(size);
    }

    public int getScrollState() {
        return this.mScrollState;
    }

    private void setScrollState(int state) {
        if (state == this.mScrollState) {
            return;
        }
        this.mScrollState = state;
        if (state != 2) {
            this.stopScrollersInternal();
        }
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrollStateChanged(this, state);
        }
        if (this.mLayout != null) {
            this.mLayout.onScrollStateChanged(state);
        }
    }

    public void addItemDecoration(ItemDecoration decor, int index) {
        if (this.mLayout != null) {
            this.mLayout.assertNotInLayoutOrScroll("Cannot add item decoration during a scroll  or layout");
        }
        if (this.mItemDecorations.isEmpty()) {
            this.setWillNotDraw(false);
        }
        if (index < 0) {
            this.mItemDecorations.add(decor);
        } else {
            this.mItemDecorations.add(index, decor);
        }
        this.markItemDecorInsetsDirty();
        this.requestLayout();
    }

    public void addItemDecoration(ItemDecoration decor) {
        this.addItemDecoration(decor, -1);
    }

    public void removeItemDecoration(ItemDecoration decor) {
        if (this.mLayout != null) {
            this.mLayout.assertNotInLayoutOrScroll("Cannot remove item decoration during a scroll  or layout");
        }
        this.mItemDecorations.remove(decor);
        if (this.mItemDecorations.isEmpty()) {
            this.setWillNotDraw(ViewCompat.getOverScrollMode((View)this) == 2);
        }
        this.markItemDecorInsetsDirty();
        this.requestLayout();
    }

    public void setOnScrollListener(OnScrollListener listener) {
        this.mScrollListener = listener;
    }

    public void scrollToPosition(int position) {
        this.stopScroll();
        if (this.mLayout == null) {
            Log.e((String)TAG, (String)"Cannot scroll to position a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        this.mLayout.scrollToPosition(position);
        this.awakenScrollBars();
    }

    public void smoothScrollToPosition(int position) {
        if (this.mLayout == null) {
            Log.e((String)TAG, (String)"Cannot smooth scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        this.mLayout.smoothScrollToPosition(this, this.mState, position);
    }

    public void scrollTo(int x, int y) {
        throw new UnsupportedOperationException("RecyclerView does not support scrolling to an absolute position.");
    }

    public void scrollBy(int x, int y) {
        if (this.mLayout == null) {
            Log.e((String)TAG, (String)"Cannot scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        boolean canScrollHorizontal = this.mLayout.canScrollHorizontally();
        boolean canScrollVertical = this.mLayout.canScrollVertically();
        if (canScrollHorizontal || canScrollVertical) {
            this.scrollByInternal(canScrollHorizontal ? x : 0, canScrollVertical ? y : 0);
        }
    }

    private void consumePendingUpdateOperations() {
        this.mUpdateChildViewsRunnable.run();
    }

    boolean scrollByInternal(int x, int y) {
        int overscrollX = 0;
        int overscrollY = 0;
        int hresult = 0;
        int vresult = 0;
        this.consumePendingUpdateOperations();
        if (this.mAdapter != null) {
            this.eatRequestLayout();
            this.mRunningLayoutOrScroll = true;
            if (x != 0) {
                hresult = this.mLayout.scrollHorizontallyBy(x, this.mRecycler, this.mState);
                overscrollX = x - hresult;
            }
            if (y != 0) {
                vresult = this.mLayout.scrollVerticallyBy(y, this.mRecycler, this.mState);
                overscrollY = y - vresult;
            }
            if (this.supportsChangeAnimations()) {
                int count = this.mChildHelper.getChildCount();
                for (int i = 0; i < count; ++i) {
                    View shadowingView;
                    View view = this.mChildHelper.getChildAt(i);
                    ViewHolder holder = this.getChildViewHolder(view);
                    if (holder == null || holder.mShadowingHolder == null) continue;
                    ViewHolder shadowingHolder = holder.mShadowingHolder;
                    View view2 = shadowingView = shadowingHolder != null ? shadowingHolder.itemView : null;
                    if (shadowingView == null) continue;
                    int left = view.getLeft();
                    int top = view.getTop();
                    if (left == shadowingView.getLeft() && top == shadowingView.getTop()) continue;
                    shadowingView.layout(left, top, left + shadowingView.getWidth(), top + shadowingView.getHeight());
                }
            }
            this.mRunningLayoutOrScroll = false;
            this.resumeRequestLayout(false);
        }
        if (!this.mItemDecorations.isEmpty()) {
            this.invalidate();
        }
        if (ViewCompat.getOverScrollMode((View)this) != 2) {
            this.considerReleasingGlowsOnScroll(x, y);
            this.pullGlows(overscrollX, overscrollY);
        }
        if (hresult != 0 || vresult != 0) {
            this.notifyOnScrolled(hresult, vresult);
        }
        if (!this.awakenScrollBars()) {
            this.invalidate();
        }
        return hresult != 0 || vresult != 0;
    }

    protected int computeHorizontalScrollOffset() {
        return this.mLayout.canScrollHorizontally() ? this.mLayout.computeHorizontalScrollOffset(this.mState) : 0;
    }

    protected int computeHorizontalScrollExtent() {
        return this.mLayout.canScrollHorizontally() ? this.mLayout.computeHorizontalScrollExtent(this.mState) : 0;
    }

    protected int computeHorizontalScrollRange() {
        return this.mLayout.canScrollHorizontally() ? this.mLayout.computeHorizontalScrollRange(this.mState) : 0;
    }

    protected int computeVerticalScrollOffset() {
        return this.mLayout.canScrollVertically() ? this.mLayout.computeVerticalScrollOffset(this.mState) : 0;
    }

    protected int computeVerticalScrollExtent() {
        return this.mLayout.canScrollVertically() ? this.mLayout.computeVerticalScrollExtent(this.mState) : 0;
    }

    protected int computeVerticalScrollRange() {
        return this.mLayout.canScrollVertically() ? this.mLayout.computeVerticalScrollRange(this.mState) : 0;
    }

    void eatRequestLayout() {
        if (!this.mEatRequestLayout) {
            this.mEatRequestLayout = true;
            this.mLayoutRequestEaten = false;
        }
    }

    void resumeRequestLayout(boolean performLayoutChildren) {
        if (this.mEatRequestLayout) {
            if (performLayoutChildren && this.mLayoutRequestEaten && this.mLayout != null && this.mAdapter != null) {
                this.dispatchLayout();
            }
            this.mEatRequestLayout = false;
            this.mLayoutRequestEaten = false;
        }
    }

    public void smoothScrollBy(int dx, int dy) {
        if (this.mLayout == null) {
            Log.e((String)TAG, (String)"Cannot smooth scroll without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return;
        }
        if (!this.mLayout.canScrollHorizontally()) {
            dx = 0;
        }
        if (!this.mLayout.canScrollVertically()) {
            dy = 0;
        }
        if (dx != 0 || dy != 0) {
            this.mViewFlinger.smoothScrollBy(dx, dy);
        }
    }

    public boolean fling(int velocityX, int velocityY) {
        if (this.mLayout == null) {
            Log.e((String)TAG, (String)"Cannot fling without a LayoutManager set. Call setLayoutManager with a non-null argument.");
            return false;
        }
        boolean canScrollHorizontal = this.mLayout.canScrollHorizontally();
        boolean canScrollVertical = this.mLayout.canScrollVertically();
        if (!canScrollHorizontal || Math.abs(velocityX) < this.mMinFlingVelocity) {
            velocityX = 0;
        }
        if (!canScrollVertical || Math.abs(velocityY) < this.mMinFlingVelocity) {
            velocityY = 0;
        }
        velocityX = Math.max(-this.mMaxFlingVelocity, Math.min(velocityX, this.mMaxFlingVelocity));
        velocityY = Math.max(-this.mMaxFlingVelocity, Math.min(velocityY, this.mMaxFlingVelocity));
        if (velocityX != 0 || velocityY != 0) {
            this.mViewFlinger.fling(velocityX, velocityY);
            return true;
        }
        return false;
    }

    public void stopScroll() {
        this.setScrollState(0);
        this.stopScrollersInternal();
    }

    private void stopScrollersInternal() {
        this.mViewFlinger.stop();
        if (this.mLayout != null) {
            this.mLayout.stopSmoothScroller();
        }
    }

    private void pullGlows(int overscrollX, int overscrollY) {
        if (overscrollX < 0) {
            this.ensureLeftGlow();
            this.mLeftGlow.onPull((float)(-overscrollX) / (float)this.getWidth());
        } else if (overscrollX > 0) {
            this.ensureRightGlow();
            this.mRightGlow.onPull((float)overscrollX / (float)this.getWidth());
        }
        if (overscrollY < 0) {
            this.ensureTopGlow();
            this.mTopGlow.onPull((float)(-overscrollY) / (float)this.getHeight());
        } else if (overscrollY > 0) {
            this.ensureBottomGlow();
            this.mBottomGlow.onPull((float)overscrollY / (float)this.getHeight());
        }
        if (overscrollX != 0 || overscrollY != 0) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    private void releaseGlows() {
        boolean needsInvalidate = false;
        if (this.mLeftGlow != null) {
            needsInvalidate = this.mLeftGlow.onRelease();
        }
        if (this.mTopGlow != null) {
            needsInvalidate |= this.mTopGlow.onRelease();
        }
        if (this.mRightGlow != null) {
            needsInvalidate |= this.mRightGlow.onRelease();
        }
        if (this.mBottomGlow != null) {
            needsInvalidate |= this.mBottomGlow.onRelease();
        }
        if (needsInvalidate) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    private void considerReleasingGlowsOnScroll(int dx, int dy) {
        boolean needsInvalidate = false;
        if (this.mLeftGlow != null && !this.mLeftGlow.isFinished() && dx > 0) {
            needsInvalidate = this.mLeftGlow.onRelease();
        }
        if (this.mRightGlow != null && !this.mRightGlow.isFinished() && dx < 0) {
            needsInvalidate |= this.mRightGlow.onRelease();
        }
        if (this.mTopGlow != null && !this.mTopGlow.isFinished() && dy > 0) {
            needsInvalidate |= this.mTopGlow.onRelease();
        }
        if (this.mBottomGlow != null && !this.mBottomGlow.isFinished() && dy < 0) {
            needsInvalidate |= this.mBottomGlow.onRelease();
        }
        if (needsInvalidate) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    void absorbGlows(int velocityX, int velocityY) {
        if (velocityX < 0) {
            this.ensureLeftGlow();
            this.mLeftGlow.onAbsorb(-velocityX);
        } else if (velocityX > 0) {
            this.ensureRightGlow();
            this.mRightGlow.onAbsorb(velocityX);
        }
        if (velocityY < 0) {
            this.ensureTopGlow();
            this.mTopGlow.onAbsorb(-velocityY);
        } else if (velocityY > 0) {
            this.ensureBottomGlow();
            this.mBottomGlow.onAbsorb(velocityY);
        }
        if (velocityX != 0 || velocityY != 0) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    void ensureLeftGlow() {
        if (this.mLeftGlow != null) {
            return;
        }
        this.mLeftGlow = new EdgeEffectCompat(this.getContext());
        if (this.mClipToPadding) {
            this.mLeftGlow.setSize(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom(), this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight());
        } else {
            this.mLeftGlow.setSize(this.getMeasuredHeight(), this.getMeasuredWidth());
        }
    }

    void ensureRightGlow() {
        if (this.mRightGlow != null) {
            return;
        }
        this.mRightGlow = new EdgeEffectCompat(this.getContext());
        if (this.mClipToPadding) {
            this.mRightGlow.setSize(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom(), this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight());
        } else {
            this.mRightGlow.setSize(this.getMeasuredHeight(), this.getMeasuredWidth());
        }
    }

    void ensureTopGlow() {
        if (this.mTopGlow != null) {
            return;
        }
        this.mTopGlow = new EdgeEffectCompat(this.getContext());
        if (this.mClipToPadding) {
            this.mTopGlow.setSize(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom());
        } else {
            this.mTopGlow.setSize(this.getMeasuredWidth(), this.getMeasuredHeight());
        }
    }

    void ensureBottomGlow() {
        if (this.mBottomGlow != null) {
            return;
        }
        this.mBottomGlow = new EdgeEffectCompat(this.getContext());
        if (this.mClipToPadding) {
            this.mBottomGlow.setSize(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom());
        } else {
            this.mBottomGlow.setSize(this.getMeasuredWidth(), this.getMeasuredHeight());
        }
    }

    void invalidateGlows() {
        this.mBottomGlow = null;
        this.mTopGlow = null;
        this.mRightGlow = null;
        this.mLeftGlow = null;
    }

    public View focusSearch(View focused, int direction) {
        View result = this.mLayout.onInterceptFocusSearch(focused, direction);
        if (result != null) {
            return result;
        }
        FocusFinder ff = FocusFinder.getInstance();
        result = ff.findNextFocus((ViewGroup)this, focused, direction);
        if (result == null && this.mAdapter != null && this.mLayout != null) {
            this.eatRequestLayout();
            result = this.mLayout.onFocusSearchFailed(focused, direction, this.mRecycler, this.mState);
            this.resumeRequestLayout(false);
        }
        return result != null ? result : super.focusSearch(focused, direction);
    }

    public void requestChildFocus(View child, View focused) {
        if (!this.mLayout.onRequestChildFocus(this, this.mState, child, focused) && focused != null) {
            this.mTempRect.set(0, 0, focused.getWidth(), focused.getHeight());
            this.offsetDescendantRectToMyCoords(focused, this.mTempRect);
            this.offsetRectIntoDescendantCoords(child, this.mTempRect);
            this.requestChildRectangleOnScreen(child, this.mTempRect, !this.mFirstLayoutComplete);
        }
        super.requestChildFocus(child, focused);
    }

    public boolean requestChildRectangleOnScreen(View child, Rect rect, boolean immediate) {
        return this.mLayout.requestChildRectangleOnScreen(this, child, rect, immediate);
    }

    public void addFocusables(ArrayList<View> views, int direction, int focusableMode) {
        if (!this.mLayout.onAddFocusables(this, views, direction, focusableMode)) {
            super.addFocusables(views, direction, focusableMode);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mIsAttached = true;
        this.mFirstLayoutComplete = false;
        if (this.mLayout != null) {
            this.mLayout.onAttachedToWindow(this);
        }
        this.mPostedAnimatorRunner = false;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mItemAnimator != null) {
            this.mItemAnimator.endAnimations();
        }
        this.mFirstLayoutComplete = false;
        this.stopScroll();
        this.mIsAttached = false;
        if (this.mLayout != null) {
            this.mLayout.onDetachedFromWindow(this, this.mRecycler);
        }
        this.removeCallbacks(this.mItemAnimatorRunner);
    }

    void assertInLayoutOrScroll(String message) {
        if (!this.mRunningLayoutOrScroll) {
            if (message == null) {
                throw new IllegalStateException("Cannot call this method unless RecyclerView is computing a layout or scrolling");
            }
            throw new IllegalStateException(message);
        }
    }

    void assertNotInLayoutOrScroll(String message) {
        if (this.mRunningLayoutOrScroll) {
            if (message == null) {
                throw new IllegalStateException("Cannot call this method while RecyclerView is computing a layout or scrolling");
            }
            throw new IllegalStateException(message);
        }
    }

    public void addOnItemTouchListener(OnItemTouchListener listener) {
        this.mOnItemTouchListeners.add(listener);
    }

    public void removeOnItemTouchListener(OnItemTouchListener listener) {
        this.mOnItemTouchListeners.remove(listener);
        if (this.mActiveOnItemTouchListener == listener) {
            this.mActiveOnItemTouchListener = null;
        }
    }

    private boolean dispatchOnItemTouchIntercept(MotionEvent e) {
        int action = e.getAction();
        if (action == 3 || action == 0) {
            this.mActiveOnItemTouchListener = null;
        }
        int listenerCount = this.mOnItemTouchListeners.size();
        for (int i = 0; i < listenerCount; ++i) {
            OnItemTouchListener listener = this.mOnItemTouchListeners.get(i);
            if (!listener.onInterceptTouchEvent(this, e) || action == 3) continue;
            this.mActiveOnItemTouchListener = listener;
            return true;
        }
        return false;
    }

    private boolean dispatchOnItemTouch(MotionEvent e) {
        int action = e.getAction();
        if (this.mActiveOnItemTouchListener != null) {
            if (action == 0) {
                this.mActiveOnItemTouchListener = null;
            } else {
                this.mActiveOnItemTouchListener.onTouchEvent(this, e);
                if (action == 3 || action == 1) {
                    this.mActiveOnItemTouchListener = null;
                }
                return true;
            }
        }
        if (action != 0) {
            int listenerCount = this.mOnItemTouchListeners.size();
            for (int i = 0; i < listenerCount; ++i) {
                OnItemTouchListener listener = this.mOnItemTouchListeners.get(i);
                if (!listener.onInterceptTouchEvent(this, e)) continue;
                this.mActiveOnItemTouchListener = listener;
                return true;
            }
        }
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        if (this.dispatchOnItemTouchIntercept(e)) {
            this.cancelTouch();
            return true;
        }
        boolean canScrollHorizontally = this.mLayout.canScrollHorizontally();
        boolean canScrollVertically = this.mLayout.canScrollVertically();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(e);
        int action = MotionEventCompat.getActionMasked((MotionEvent)e);
        int actionIndex = MotionEventCompat.getActionIndex((MotionEvent)e);
        switch (action) {
            case 0: {
                this.mScrollPointerId = MotionEventCompat.getPointerId((MotionEvent)e, (int)0);
                this.mInitialTouchX = this.mLastTouchX = (int)(e.getX() + 0.5f);
                this.mInitialTouchY = this.mLastTouchY = (int)(e.getY() + 0.5f);
                if (this.mScrollState != 2) break;
                this.getParent().requestDisallowInterceptTouchEvent(true);
                this.setScrollState(1);
                break;
            }
            case 5: {
                this.mScrollPointerId = MotionEventCompat.getPointerId((MotionEvent)e, (int)actionIndex);
                this.mInitialTouchX = this.mLastTouchX = (int)(MotionEventCompat.getX((MotionEvent)e, (int)actionIndex) + 0.5f);
                this.mInitialTouchY = this.mLastTouchY = (int)(MotionEventCompat.getY((MotionEvent)e, (int)actionIndex) + 0.5f);
                break;
            }
            case 2: {
                int index = MotionEventCompat.findPointerIndex((MotionEvent)e, (int)this.mScrollPointerId);
                if (index < 0) {
                    Log.e((String)TAG, (String)("Error processing scroll; pointer index for id " + this.mScrollPointerId + " not found. Did any MotionEvents get skipped?"));
                    return false;
                }
                int x = (int)(MotionEventCompat.getX((MotionEvent)e, (int)index) + 0.5f);
                int y = (int)(MotionEventCompat.getY((MotionEvent)e, (int)index) + 0.5f);
                if (this.mScrollState == 1) break;
                int dx = x - this.mInitialTouchX;
                int dy = y - this.mInitialTouchY;
                boolean startScroll = false;
                if (canScrollHorizontally && Math.abs(dx) > this.mTouchSlop) {
                    this.mLastTouchX = this.mInitialTouchX + this.mTouchSlop * (dx < 0 ? -1 : 1);
                    startScroll = true;
                }
                if (canScrollVertically && Math.abs(dy) > this.mTouchSlop) {
                    this.mLastTouchY = this.mInitialTouchY + this.mTouchSlop * (dy < 0 ? -1 : 1);
                    startScroll = true;
                }
                if (!startScroll) break;
                this.setScrollState(1);
                break;
            }
            case 6: {
                this.onPointerUp(e);
                break;
            }
            case 1: {
                this.mVelocityTracker.clear();
                break;
            }
            case 3: {
                this.cancelTouch();
            }
        }
        return this.mScrollState == 1;
    }

    public boolean onTouchEvent(MotionEvent e) {
        if (this.dispatchOnItemTouch(e)) {
            this.cancelTouch();
            return true;
        }
        boolean canScrollHorizontally = this.mLayout.canScrollHorizontally();
        boolean canScrollVertically = this.mLayout.canScrollVertically();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(e);
        int action = MotionEventCompat.getActionMasked((MotionEvent)e);
        int actionIndex = MotionEventCompat.getActionIndex((MotionEvent)e);
        switch (action) {
            case 0: {
                this.mScrollPointerId = MotionEventCompat.getPointerId((MotionEvent)e, (int)0);
                this.mInitialTouchX = this.mLastTouchX = (int)(e.getX() + 0.5f);
                this.mInitialTouchY = this.mLastTouchY = (int)(e.getY() + 0.5f);
                break;
            }
            case 5: {
                this.mScrollPointerId = MotionEventCompat.getPointerId((MotionEvent)e, (int)actionIndex);
                this.mInitialTouchX = this.mLastTouchX = (int)(MotionEventCompat.getX((MotionEvent)e, (int)actionIndex) + 0.5f);
                this.mInitialTouchY = this.mLastTouchY = (int)(MotionEventCompat.getY((MotionEvent)e, (int)actionIndex) + 0.5f);
                break;
            }
            case 2: {
                int dy;
                int dx;
                int index = MotionEventCompat.findPointerIndex((MotionEvent)e, (int)this.mScrollPointerId);
                if (index < 0) {
                    Log.e((String)TAG, (String)("Error processing scroll; pointer index for id " + this.mScrollPointerId + " not found. Did any MotionEvents get skipped?"));
                    return false;
                }
                int x = (int)(MotionEventCompat.getX((MotionEvent)e, (int)index) + 0.5f);
                int y = (int)(MotionEventCompat.getY((MotionEvent)e, (int)index) + 0.5f);
                if (this.mScrollState != 1) {
                    dx = x - this.mInitialTouchX;
                    dy = y - this.mInitialTouchY;
                    boolean startScroll = false;
                    if (canScrollHorizontally && Math.abs(dx) > this.mTouchSlop) {
                        this.mLastTouchX = this.mInitialTouchX + this.mTouchSlop * (dx < 0 ? -1 : 1);
                        startScroll = true;
                    }
                    if (canScrollVertically && Math.abs(dy) > this.mTouchSlop) {
                        this.mLastTouchY = this.mInitialTouchY + this.mTouchSlop * (dy < 0 ? -1 : 1);
                        startScroll = true;
                    }
                    if (startScroll) {
                        this.setScrollState(1);
                    }
                }
                if (this.mScrollState == 1) {
                    dx = x - this.mLastTouchX;
                    dy = y - this.mLastTouchY;
                    if (this.scrollByInternal(canScrollHorizontally ? -dx : 0, canScrollVertically ? -dy : 0)) {
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                    }
                }
                this.mLastTouchX = x;
                this.mLastTouchY = y;
                break;
            }
            case 6: {
                this.onPointerUp(e);
                break;
            }
            case 1: {
                float yvel;
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxFlingVelocity);
                float xvel = canScrollHorizontally ? -VelocityTrackerCompat.getXVelocity((VelocityTracker)this.mVelocityTracker, (int)this.mScrollPointerId) : 0.0f;
                float f = yvel = canScrollVertically ? -VelocityTrackerCompat.getYVelocity((VelocityTracker)this.mVelocityTracker, (int)this.mScrollPointerId) : 0.0f;
                if (xvel == 0.0f && yvel == 0.0f || !this.fling((int)xvel, (int)yvel)) {
                    this.setScrollState(0);
                }
                this.mVelocityTracker.clear();
                this.releaseGlows();
                break;
            }
            case 3: {
                this.cancelTouch();
            }
        }
        return true;
    }

    private void cancelTouch() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.clear();
        }
        this.releaseGlows();
        this.setScrollState(0);
    }

    private void onPointerUp(MotionEvent e) {
        int actionIndex = MotionEventCompat.getActionIndex((MotionEvent)e);
        if (MotionEventCompat.getPointerId((MotionEvent)e, (int)actionIndex) == this.mScrollPointerId) {
            int newIndex = actionIndex == 0 ? 1 : 0;
            this.mScrollPointerId = MotionEventCompat.getPointerId((MotionEvent)e, (int)newIndex);
            this.mInitialTouchX = this.mLastTouchX = (int)(MotionEventCompat.getX((MotionEvent)e, (int)newIndex) + 0.5f);
            this.mInitialTouchY = this.mLastTouchY = (int)(MotionEventCompat.getY((MotionEvent)e, (int)newIndex) + 0.5f);
        }
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        if (this.mAdapterUpdateDuringMeasure) {
            this.eatRequestLayout();
            this.processAdapterUpdatesAndSetAnimationFlags();
            if (this.mState.mRunPredictiveAnimations) {
                this.mState.mInPreLayout = true;
            } else {
                this.mAdapterHelper.consumeUpdatesInOnePass();
                this.mState.mInPreLayout = false;
            }
            this.mAdapterUpdateDuringMeasure = false;
            this.resumeRequestLayout(false);
        }
        this.mState.mItemCount = this.mAdapter != null ? this.mAdapter.getItemCount() : 0;
        if (this.mLayout == null) {
            this.defaultOnMeasure(widthSpec, heightSpec);
        } else {
            this.mLayout.onMeasure(this.mRecycler, this.mState, widthSpec, heightSpec);
        }
        this.mState.mInPreLayout = false;
    }

    private void defaultOnMeasure(int widthSpec, int heightSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightSpec);
        int width = 0;
        int height = 0;
        switch (widthMode) {
            case -2147483648: 
            case 0x40000000: {
                width = widthSize;
                break;
            }
            default: {
                width = ViewCompat.getMinimumWidth((View)this);
            }
        }
        switch (heightMode) {
            case -2147483648: 
            case 0x40000000: {
                height = heightSize;
                break;
            }
            default: {
                height = ViewCompat.getMinimumHeight((View)this);
            }
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw || h != oldh) {
            this.invalidateGlows();
        }
    }

    public void setItemAnimator(ItemAnimator animator) {
        if (this.mItemAnimator != null) {
            this.mItemAnimator.endAnimations();
            this.mItemAnimator.setListener(null);
        }
        this.mItemAnimator = animator;
        if (this.mItemAnimator != null) {
            this.mItemAnimator.setListener(this.mItemAnimatorListener);
        }
    }

    public ItemAnimator getItemAnimator() {
        return this.mItemAnimator;
    }

    private boolean supportsChangeAnimations() {
        return this.mItemAnimator != null && this.mItemAnimator.getSupportsChangeAnimations();
    }

    private void postAnimationRunner() {
        if (!this.mPostedAnimatorRunner && this.mIsAttached) {
            ViewCompat.postOnAnimation((View)this, (Runnable)this.mItemAnimatorRunner);
            this.mPostedAnimatorRunner = true;
        }
    }

    private boolean predictiveItemAnimationsEnabled() {
        return this.mItemAnimator != null && this.mLayout.supportsPredictiveItemAnimations();
    }

    private void processAdapterUpdatesAndSetAnimationFlags() {
        if (this.mDataSetHasChangedAfterLayout) {
            this.mAdapterHelper.reset();
            this.markKnownViewsInvalid();
            this.mLayout.onItemsChanged(this);
        }
        if (this.mItemAnimator != null && this.mLayout.supportsPredictiveItemAnimations()) {
            this.mAdapterHelper.preProcess();
        } else {
            this.mAdapterHelper.consumeUpdatesInOnePass();
        }
        boolean animationTypeSupported = this.mItemsAddedOrRemoved && !this.mItemsChanged || this.mItemsAddedOrRemoved || this.mItemsChanged && this.supportsChangeAnimations();
        this.mState.mRunSimpleAnimations = !(!this.mFirstLayoutComplete || this.mItemAnimator == null || !this.mDataSetHasChangedAfterLayout && !animationTypeSupported && !this.mLayout.mRequestedSimpleAnimations || this.mDataSetHasChangedAfterLayout && !this.mAdapter.hasStableIds());
        this.mState.mRunPredictiveAnimations = this.mState.mRunSimpleAnimations && animationTypeSupported && !this.mDataSetHasChangedAfterLayout && this.predictiveItemAnimationsEnabled();
    }

    void dispatchLayout() {
        ViewHolder holder;
        int i;
        int count;
        if (this.mAdapter == null) {
            Log.e((String)TAG, (String)"No adapter attached; skipping layout");
            return;
        }
        if (this.mLayout == null) {
            Log.e((String)TAG, (String)"No layout manager attached; skipping layout");
            return;
        }
        this.mDisappearingViewsInLayoutPass.clear();
        this.eatRequestLayout();
        this.mRunningLayoutOrScroll = true;
        this.processAdapterUpdatesAndSetAnimationFlags();
        this.mState.mOldChangedHolders = this.mState.mRunSimpleAnimations && this.mItemsChanged && this.supportsChangeAnimations() ? new ArrayMap() : null;
        this.mItemsChanged = false;
        this.mItemsAddedOrRemoved = false;
        ArrayMap appearingViewInitialBounds = null;
        this.mState.mInPreLayout = this.mState.mRunPredictiveAnimations;
        this.mState.mItemCount = this.mAdapter.getItemCount();
        this.findMinMaxChildLayoutPositions(this.mMinMaxLayoutPositions);
        if (this.mState.mRunSimpleAnimations) {
            this.mState.mPreLayoutHolderMap.clear();
            this.mState.mPostLayoutHolderMap.clear();
            count = this.mChildHelper.getChildCount();
            for (i = 0; i < count; ++i) {
                holder = CustomRecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(i));
                if (holder.shouldIgnore() || holder.isInvalid() && !this.mAdapter.hasStableIds()) continue;
                View view = holder.itemView;
                this.mState.mPreLayoutHolderMap.put((Object)holder, (Object)new ItemHolderInfo(holder, view.getLeft(), view.getTop(), view.getRight(), view.getBottom()));
            }
        }
        if (this.mState.mRunPredictiveAnimations) {
            this.saveOldPositions();
            if (this.mState.mOldChangedHolders != null) {
                count = this.mChildHelper.getChildCount();
                for (i = 0; i < count; ++i) {
                    holder = CustomRecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(i));
                    if (!holder.isChanged() || holder.isRemoved() || holder.shouldIgnore()) continue;
                    long key = this.getChangedHolderKey(holder);
                    this.mState.mOldChangedHolders.put((Object)key, (Object)holder);
                    this.mState.mPreLayoutHolderMap.remove((Object)holder);
                }
            }
            boolean didStructureChange = this.mState.mStructureChanged;
            this.mState.mStructureChanged = false;
            this.mLayout.onLayoutChildren(this.mRecycler, this.mState);
            this.mState.mStructureChanged = didStructureChange;
            appearingViewInitialBounds = new ArrayMap();
            for (i = 0; i < this.mChildHelper.getChildCount(); ++i) {
                boolean found = false;
                View child = this.mChildHelper.getChildAt(i);
                if (CustomRecyclerView.getChildViewHolderInt(child).shouldIgnore()) continue;
                for (int j = 0; j < this.mState.mPreLayoutHolderMap.size(); ++j) {
                    ViewHolder holder2 = (ViewHolder)this.mState.mPreLayoutHolderMap.keyAt(j);
                    if (holder2.itemView != child) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                appearingViewInitialBounds.put((Object)child, (Object)new Rect(child.getLeft(), child.getTop(), child.getRight(), child.getBottom()));
            }
            this.clearOldPositions();
            this.mAdapterHelper.consumePostponedUpdates();
        } else {
            this.clearOldPositions();
            this.mAdapterHelper.consumeUpdatesInOnePass();
            if (this.mState.mOldChangedHolders != null) {
                count = this.mChildHelper.getChildCount();
                for (i = 0; i < count; ++i) {
                    holder = CustomRecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(i));
                    if (!holder.isChanged() || holder.isRemoved() || holder.shouldIgnore()) continue;
                    long key = this.getChangedHolderKey(holder);
                    this.mState.mOldChangedHolders.put((Object)key, (Object)holder);
                    this.mState.mPreLayoutHolderMap.remove((Object)holder);
                }
            }
        }
        this.mState.mItemCount = this.mAdapter.getItemCount();
        this.mState.mDeletedInvisibleItemCountSincePreviousLayout = 0;
        this.mState.mInPreLayout = false;
        this.mLayout.onLayoutChildren(this.mRecycler, this.mState);
        this.mState.mStructureChanged = false;
        this.mPendingSavedState = null;
        this.mState.mRunSimpleAnimations = this.mState.mRunSimpleAnimations && this.mItemAnimator != null;
        if (this.mState.mRunSimpleAnimations) {
            int i2;
            ArrayMap newChangedHolders = this.mState.mOldChangedHolders != null ? new ArrayMap() : null;
            int count2 = this.mChildHelper.getChildCount();
            for (int i3 = 0; i3 < count2; ++i3) {
                ViewHolder holder3 = CustomRecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(i3));
                if (holder3.shouldIgnore()) continue;
                View view = holder3.itemView;
                long key = this.getChangedHolderKey(holder3);
                if (newChangedHolders != null && this.mState.mOldChangedHolders.get((Object)key) != null) {
                    newChangedHolders.put((Object)key, (Object)holder3);
                    continue;
                }
                this.mState.mPostLayoutHolderMap.put((Object)holder3, (Object)new ItemHolderInfo(holder3, view.getLeft(), view.getTop(), view.getRight(), view.getBottom()));
            }
            this.processDisappearingList((ArrayMap<View, Rect>)appearingViewInitialBounds);
            int preLayoutCount = this.mState.mPreLayoutHolderMap.size();
            for (int i4 = preLayoutCount - 1; i4 >= 0; --i4) {
                ViewHolder itemHolder = (ViewHolder)this.mState.mPreLayoutHolderMap.keyAt(i4);
                if (this.mState.mPostLayoutHolderMap.containsKey((Object)itemHolder)) continue;
                ItemHolderInfo disappearingItem = (ItemHolderInfo)this.mState.mPreLayoutHolderMap.valueAt(i4);
                this.mState.mPreLayoutHolderMap.removeAt(i4);
                View disappearingItemView = disappearingItem.holder.itemView;
                this.mRecycler.unscrapView(disappearingItem.holder);
                this.animateDisappearance(disappearingItem);
            }
            int postLayoutCount = this.mState.mPostLayoutHolderMap.size();
            if (postLayoutCount > 0) {
                for (int i5 = postLayoutCount - 1; i5 >= 0; --i5) {
                    ViewHolder itemHolder = (ViewHolder)this.mState.mPostLayoutHolderMap.keyAt(i5);
                    ItemHolderInfo info = (ItemHolderInfo)this.mState.mPostLayoutHolderMap.valueAt(i5);
                    if (!this.mState.mPreLayoutHolderMap.isEmpty() && this.mState.mPreLayoutHolderMap.containsKey((Object)itemHolder)) continue;
                    this.mState.mPostLayoutHolderMap.removeAt(i5);
                    Rect initialBounds = appearingViewInitialBounds != null ? (Rect)appearingViewInitialBounds.get((Object)itemHolder.itemView) : null;
                    this.animateAppearance(itemHolder, initialBounds, info.left, info.top);
                }
            }
            count2 = this.mState.mPostLayoutHolderMap.size();
            for (i2 = 0; i2 < count2; ++i2) {
                ViewHolder postHolder = (ViewHolder)this.mState.mPostLayoutHolderMap.keyAt(i2);
                ItemHolderInfo postInfo = (ItemHolderInfo)this.mState.mPostLayoutHolderMap.valueAt(i2);
                ItemHolderInfo preInfo = (ItemHolderInfo)this.mState.mPreLayoutHolderMap.get((Object)postHolder);
                if (preInfo == null || postInfo == null || preInfo.left == postInfo.left && preInfo.top == postInfo.top) continue;
                postHolder.setIsRecyclable(false);
                if (!this.mItemAnimator.animateMove(postHolder, preInfo.left, preInfo.top, postInfo.left, postInfo.top)) continue;
                this.postAnimationRunner();
            }
            count2 = this.mState.mOldChangedHolders != null ? this.mState.mOldChangedHolders.size() : 0;
            for (i2 = count2 - 1; i2 >= 0; --i2) {
                long key = (Long)this.mState.mOldChangedHolders.keyAt(i2);
                ViewHolder oldHolder = (ViewHolder)this.mState.mOldChangedHolders.get((Object)key);
                View oldView = oldHolder.itemView;
                if (oldHolder.shouldIgnore() || this.mRecycler.mChangedScrap == null || !this.mRecycler.mChangedScrap.contains(oldHolder)) continue;
                this.animateChange(oldHolder, (ViewHolder)newChangedHolders.get((Object)key));
            }
        }
        this.resumeRequestLayout(false);
        this.mLayout.removeAndRecycleScrapInt(this.mRecycler);
        this.mState.mPreviousLayoutItemCount = this.mState.mItemCount;
        this.mDataSetHasChangedAfterLayout = false;
        this.mState.mRunSimpleAnimations = false;
        this.mState.mRunPredictiveAnimations = false;
        this.mRunningLayoutOrScroll = false;
        this.mLayout.mRequestedSimpleAnimations = false;
        if (this.mRecycler.mChangedScrap != null) {
            this.mRecycler.mChangedScrap.clear();
        }
        this.mState.mOldChangedHolders = null;
        if (this.didChildRangeChange(this.mMinMaxLayoutPositions[0], this.mMinMaxLayoutPositions[1])) {
            this.notifyOnScrolled(0, 0);
        }
    }

    private void findMinMaxChildLayoutPositions(int[] into) {
        int count = this.mChildHelper.getChildCount();
        if (count == 0) {
            into[0] = 0;
            into[1] = 0;
            return;
        }
        int minPositionPreLayout = Integer.MAX_VALUE;
        int maxPositionPreLayout = Integer.MIN_VALUE;
        for (int i = 0; i < count; ++i) {
            ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(i));
            if (holder.shouldIgnore()) continue;
            int pos = holder.getLayoutPosition();
            if (pos < minPositionPreLayout) {
                minPositionPreLayout = pos;
            }
            if (pos <= maxPositionPreLayout) continue;
            maxPositionPreLayout = pos;
        }
        into[0] = minPositionPreLayout;
        into[1] = maxPositionPreLayout;
    }

    private boolean didChildRangeChange(int minPositionPreLayout, int maxPositionPreLayout) {
        int count = this.mChildHelper.getChildCount();
        if (count == 0) {
            return minPositionPreLayout != 0 || maxPositionPreLayout != 0;
        }
        for (int i = 0; i < count; ++i) {
            int pos;
            ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(i));
            if (holder.shouldIgnore() || (pos = holder.getLayoutPosition()) >= minPositionPreLayout && pos <= maxPositionPreLayout) continue;
            return true;
        }
        return false;
    }

    protected void removeDetachedView(View child, boolean animate) {
        ViewHolder vh = CustomRecyclerView.getChildViewHolderInt(child);
        if (vh != null) {
            if (vh.isTmpDetached()) {
                vh.clearTmpDetachFlag();
            } else if (!vh.shouldIgnore()) {
                throw new IllegalArgumentException("Called removeDetachedView with a view which is not flagged as tmp detached." + vh);
            }
        }
        this.dispatchChildDetached(child);
        super.removeDetachedView(child, animate);
    }

    long getChangedHolderKey(ViewHolder holder) {
        return this.mAdapter.hasStableIds() ? holder.getItemId() : (long)holder.mPosition;
    }

    private void processDisappearingList(ArrayMap<View, Rect> appearingViews) {
        int count = this.mDisappearingViewsInLayoutPass.size();
        for (int i = 0; i < count; ++i) {
            View view = this.mDisappearingViewsInLayoutPass.get(i);
            ViewHolder vh = CustomRecyclerView.getChildViewHolderInt(view);
            ItemHolderInfo info = (ItemHolderInfo)this.mState.mPreLayoutHolderMap.remove((Object)vh);
            if (!this.mState.isPreLayout()) {
                this.mState.mPostLayoutHolderMap.remove((Object)vh);
            }
            if (appearingViews.remove((Object)view) != null) {
                this.mLayout.removeAndRecycleView(view, this.mRecycler);
                continue;
            }
            if (info != null) {
                this.animateDisappearance(info);
                continue;
            }
            this.animateDisappearance(new ItemHolderInfo(vh, view.getLeft(), view.getTop(), view.getRight(), view.getBottom()));
        }
        this.mDisappearingViewsInLayoutPass.clear();
    }

    private void animateAppearance(ViewHolder itemHolder, Rect beforeBounds, int afterLeft, int afterTop) {
        View newItemView = itemHolder.itemView;
        if (beforeBounds != null && (beforeBounds.left != afterLeft || beforeBounds.top != afterTop)) {
            itemHolder.setIsRecyclable(false);
            if (this.mItemAnimator.animateMove(itemHolder, beforeBounds.left, beforeBounds.top, afterLeft, afterTop)) {
                this.postAnimationRunner();
            }
        } else {
            itemHolder.setIsRecyclable(false);
            if (this.mItemAnimator.animateAdd(itemHolder)) {
                this.postAnimationRunner();
            }
        }
    }

    private void animateDisappearance(ItemHolderInfo disappearingItem) {
        View disappearingItemView = disappearingItem.holder.itemView;
        this.addAnimatingView(disappearingItem.holder);
        int oldLeft = disappearingItem.left;
        int oldTop = disappearingItem.top;
        int newLeft = disappearingItemView.getLeft();
        int newTop = disappearingItemView.getTop();
        if (oldLeft != newLeft || oldTop != newTop) {
            disappearingItem.holder.setIsRecyclable(false);
            disappearingItemView.layout(newLeft, newTop, newLeft + disappearingItemView.getWidth(), newTop + disappearingItemView.getHeight());
            if (this.mItemAnimator.animateMove(disappearingItem.holder, oldLeft, oldTop, newLeft, newTop)) {
                this.postAnimationRunner();
            }
        } else {
            disappearingItem.holder.setIsRecyclable(false);
            if (this.mItemAnimator.animateRemove(disappearingItem.holder)) {
                this.postAnimationRunner();
            }
        }
    }

    private void animateChange(ViewHolder oldHolder, ViewHolder newHolder) {
        int toTop;
        int toLeft;
        oldHolder.setIsRecyclable(false);
        this.addAnimatingView(oldHolder);
        oldHolder.mShadowedHolder = newHolder;
        this.mRecycler.unscrapView(oldHolder);
        int fromLeft = oldHolder.itemView.getLeft();
        int fromTop = oldHolder.itemView.getTop();
        if (newHolder == null || newHolder.shouldIgnore()) {
            toLeft = fromLeft;
            toTop = fromTop;
        } else {
            toLeft = newHolder.itemView.getLeft();
            toTop = newHolder.itemView.getTop();
            newHolder.setIsRecyclable(false);
            newHolder.mShadowingHolder = oldHolder;
        }
        if (this.mItemAnimator.animateChange(oldHolder, newHolder, fromLeft, fromTop, toLeft, toTop)) {
            this.postAnimationRunner();
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.eatRequestLayout();
        this.dispatchLayout();
        this.resumeRequestLayout(false);
        this.mFirstLayoutComplete = true;
    }

    public void requestLayout() {
        if (!this.mEatRequestLayout) {
            super.requestLayout();
        } else {
            this.mLayoutRequestEaten = true;
        }
    }

    void markItemDecorInsetsDirty() {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.mChildHelper.getUnfilteredChildAt(i);
            ((LayoutParams)child.getLayoutParams()).mInsetsDirty = true;
        }
        this.mRecycler.markItemDecorInsetsDirty();
    }

    public void draw(Canvas c) {
        int restore;
        super.draw(c);
        int count = this.mItemDecorations.size();
        for (int i = 0; i < count; ++i) {
            this.mItemDecorations.get(i).onDrawOver(c, this, this.mState);
        }
        boolean needsInvalidate = false;
        if (this.mLeftGlow != null && !this.mLeftGlow.isFinished()) {
            restore = c.save();
            int padding = this.mClipToPadding ? this.getPaddingBottom() : 0;
            c.rotate(270.0f);
            c.translate((float)(-this.getHeight() + padding), 0.0f);
            needsInvalidate = this.mLeftGlow != null && this.mLeftGlow.draw(c);
            c.restoreToCount(restore);
        }
        if (this.mTopGlow != null && !this.mTopGlow.isFinished()) {
            restore = c.save();
            if (this.mClipToPadding) {
                c.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            }
            needsInvalidate |= this.mTopGlow != null && this.mTopGlow.draw(c);
            c.restoreToCount(restore);
        }
        if (this.mRightGlow != null && !this.mRightGlow.isFinished()) {
            restore = c.save();
            int width = this.getWidth();
            int padding = this.mClipToPadding ? this.getPaddingTop() : 0;
            c.rotate(90.0f);
            c.translate((float)(-padding), (float)(-width));
            needsInvalidate |= this.mRightGlow != null && this.mRightGlow.draw(c);
            c.restoreToCount(restore);
        }
        if (this.mBottomGlow != null && !this.mBottomGlow.isFinished()) {
            restore = c.save();
            c.rotate(180.0f);
            if (this.mClipToPadding) {
                c.translate((float)(-this.getWidth() + this.getPaddingRight()), (float)(-this.getHeight() + this.getPaddingBottom()));
            } else {
                c.translate((float)(-this.getWidth()), (float)(-this.getHeight()));
            }
            needsInvalidate |= this.mBottomGlow != null && this.mBottomGlow.draw(c);
            c.restoreToCount(restore);
        }
        if (!needsInvalidate && this.mItemAnimator != null && this.mItemDecorations.size() > 0 && this.mItemAnimator.isRunning()) {
            needsInvalidate = true;
        }
        if (needsInvalidate) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void onDraw(Canvas c) {
        super.onDraw(c);
        int count = this.mItemDecorations.size();
        for (int i = 0; i < count; ++i) {
            this.mItemDecorations.get(i).onDraw(c, this, this.mState);
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams && this.mLayout.checkLayoutParams((LayoutParams)p);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        if (this.mLayout == null) {
            throw new IllegalStateException("RecyclerView has no LayoutManager");
        }
        return this.mLayout.generateDefaultLayoutParams();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        if (this.mLayout == null) {
            throw new IllegalStateException("RecyclerView has no LayoutManager");
        }
        return this.mLayout.generateLayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        if (this.mLayout == null) {
            throw new IllegalStateException("RecyclerView has no LayoutManager");
        }
        return this.mLayout.generateLayoutParams(p);
    }

    void saveOldPositions() {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder.shouldIgnore()) continue;
            holder.saveOldPosition();
        }
    }

    void clearOldPositions() {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder.shouldIgnore()) continue;
            holder.clearOldPosition();
        }
        this.mRecycler.clearOldPositions();
    }

    void offsetPositionRecordsForMove(int from, int to) {
        int inBetweenOffset;
        int end;
        int start;
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        if (from < to) {
            start = from;
            end = to;
            inBetweenOffset = -1;
        } else {
            start = to;
            end = from;
            inBetweenOffset = 1;
        }
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.mPosition < start || holder.mPosition > end) continue;
            if (holder.mPosition == from) {
                holder.offsetPosition(to - from, false);
            } else {
                holder.offsetPosition(inBetweenOffset, false);
            }
            this.mState.mStructureChanged = true;
        }
        this.mRecycler.offsetPositionRecordsForMove(from, to);
        this.requestLayout();
    }

    void offsetPositionRecordsForInsert(int positionStart, int itemCount) {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.shouldIgnore() || holder.mPosition < positionStart) continue;
            holder.offsetPosition(itemCount, false);
            this.mState.mStructureChanged = true;
        }
        this.mRecycler.offsetPositionRecordsForInsert(positionStart, itemCount);
        this.requestLayout();
    }

    void offsetPositionRecordsForRemove(int positionStart, int itemCount, boolean applyToPreLayout) {
        int positionEnd = positionStart + itemCount;
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.shouldIgnore()) continue;
            if (holder.mPosition >= positionEnd) {
                holder.offsetPosition(-itemCount, applyToPreLayout);
                this.mState.mStructureChanged = true;
                continue;
            }
            if (holder.mPosition < positionStart) continue;
            holder.flagRemovedAndOffsetPosition(positionStart - 1, -itemCount, applyToPreLayout);
            this.mState.mStructureChanged = true;
        }
        this.mRecycler.offsetPositionRecordsForRemove(positionStart, itemCount, applyToPreLayout);
        this.requestLayout();
    }

    void viewRangeUpdate(int positionStart, int itemCount) {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        int positionEnd = positionStart + itemCount;
        for (int i = 0; i < childCount; ++i) {
            View child = this.mChildHelper.getUnfilteredChildAt(i);
            ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(child);
            if (holder == null || holder.shouldIgnore() || holder.mPosition < positionStart || holder.mPosition >= positionEnd) continue;
            holder.addFlags(2);
            if (this.supportsChangeAnimations()) {
                holder.addFlags(64);
            }
            ((LayoutParams)child.getLayoutParams()).mInsetsDirty = true;
        }
        this.mRecycler.viewRangeUpdate(positionStart, itemCount);
    }

    void rebindUpdatedViewHolders() {
        int childCount = this.mChildHelper.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(this.mChildHelper.getChildAt(i));
            if (holder == null || holder.shouldIgnore()) continue;
            if (holder.isRemoved() || holder.isInvalid()) {
                this.requestLayout();
                continue;
            }
            if (!holder.needsUpdate()) continue;
            int type = this.mAdapter.getItemViewType(holder.mPosition);
            if (holder.getItemViewType() == type) {
                if (!holder.isChanged() || !this.supportsChangeAnimations()) {
                    this.mAdapter.bindViewHolder(holder, holder.mPosition);
                    continue;
                }
                this.requestLayout();
                continue;
            }
            holder.addFlags(4);
            this.requestLayout();
        }
    }

    private void setDataSetChangedAfterLayout() {
        if (this.mDataSetHasChangedAfterLayout) {
            return;
        }
        this.mDataSetHasChangedAfterLayout = true;
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.shouldIgnore()) continue;
            holder.addFlags(512);
        }
        this.mRecycler.setAdapterPositionsAsUnknown();
    }

    void markKnownViewsInvalid() {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.shouldIgnore()) continue;
            holder.addFlags(6);
        }
        this.markItemDecorInsetsDirty();
        this.mRecycler.markKnownViewsInvalid();
    }

    public void invalidateItemDecorations() {
        if (this.mItemDecorations.size() == 0) {
            return;
        }
        if (this.mLayout != null) {
            this.mLayout.assertNotInLayoutOrScroll("Cannot invalidate item decorations during a scroll or layout");
        }
        this.markItemDecorInsetsDirty();
        this.requestLayout();
    }

    public ViewHolder getChildViewHolder(View child) {
        ViewParent parent = child.getParent();
        if (parent != null && parent != this) {
            throw new IllegalArgumentException("View " + child + " is not a direct child of " + (Object)((Object)this));
        }
        return CustomRecyclerView.getChildViewHolderInt(child);
    }

    static ViewHolder getChildViewHolderInt(View child) {
        if (child == null) {
            return null;
        }
        return ((LayoutParams)child.getLayoutParams()).mViewHolder;
    }

    @Deprecated
    public int getChildPosition(View child) {
        return this.getChildAdapterPosition(child);
    }

    public int getChildAdapterPosition(View child) {
        ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(child);
        return holder != null ? holder.getAdapterPosition() : -1;
    }

    public int getChildLayoutPosition(View child) {
        ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(child);
        return holder != null ? holder.getLayoutPosition() : -1;
    }

    public long getChildItemId(View child) {
        if (this.mAdapter == null || !this.mAdapter.hasStableIds()) {
            return -1L;
        }
        ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(child);
        return holder != null ? holder.getItemId() : -1L;
    }

    @Deprecated
    public ViewHolder findViewHolderForPosition(int position) {
        return this.findViewHolderForPosition(position, false);
    }

    public ViewHolder findViewHolderForLayoutPosition(int position) {
        return this.findViewHolderForPosition(position, false);
    }

    public ViewHolder findViewHolderForAdapterPosition(int position) {
        if (this.mDataSetHasChangedAfterLayout) {
            return null;
        }
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.isRemoved() || this.getAdapterPositionFor(holder) != position) continue;
            return holder;
        }
        return null;
    }

    ViewHolder findViewHolderForPosition(int position, boolean checkNewPosition) {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.isRemoved() || !(checkNewPosition ? holder.mPosition == position : holder.getLayoutPosition() == position)) continue;
            return holder;
        }
        return null;
    }

    public ViewHolder findViewHolderForItemId(long id) {
        int childCount = this.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(this.mChildHelper.getUnfilteredChildAt(i));
            if (holder == null || holder.getItemId() != id) continue;
            return holder;
        }
        return null;
    }

    public View findChildViewUnder(float x, float y) {
        int count = this.mChildHelper.getChildCount();
        for (int i = count - 1; i >= 0; --i) {
            View child = this.mChildHelper.getChildAt(i);
            float translationX = ViewCompat.getTranslationX((View)child);
            float translationY = ViewCompat.getTranslationY((View)child);
            if (!(x >= (float)child.getLeft() + translationX) || !(x <= (float)child.getRight() + translationX) || !(y >= (float)child.getTop() + translationY) || !(y <= (float)child.getBottom() + translationY)) continue;
            return child;
        }
        return null;
    }

    public void offsetChildrenVertical(int dy) {
        int childCount = this.mChildHelper.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.mChildHelper.getChildAt(i).offsetTopAndBottom(dy);
        }
    }

    public void onChildAttachedToWindow(View child) {
    }

    public void onChildDetachedFromWindow(View child) {
    }

    public void offsetChildrenHorizontal(int dx) {
        int childCount = this.mChildHelper.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.mChildHelper.getChildAt(i).offsetLeftAndRight(dx);
        }
    }

    Rect getItemDecorInsetsForChild(View child) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (!lp.mInsetsDirty) {
            return lp.mDecorInsets;
        }
        Rect insets = lp.mDecorInsets;
        insets.set(0, 0, 0, 0);
        int decorCount = this.mItemDecorations.size();
        for (int i = 0; i < decorCount; ++i) {
            this.mTempRect.set(0, 0, 0, 0);
            this.mItemDecorations.get(i).getItemOffsets(this.mTempRect, child, this, this.mState);
            insets.left += this.mTempRect.left;
            insets.top += this.mTempRect.top;
            insets.right += this.mTempRect.right;
            insets.bottom += this.mTempRect.bottom;
        }
        lp.mInsetsDirty = false;
        return insets;
    }

    private void notifyOnScrolled(int hresult, int vresult) {
        this.onScrollChanged(0, 0, 0, 0);
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrolled(this, hresult, vresult);
        }
    }

    private void dispatchChildDetached(View child) {
        if (this.mAdapter != null) {
            this.mAdapter.onViewDetachedFromWindow(CustomRecyclerView.getChildViewHolderInt(child));
        }
        this.onChildDetachedFromWindow(child);
    }

    private void dispatchChildAttached(View child) {
        if (this.mAdapter != null) {
            this.mAdapter.onViewAttachedToWindow(CustomRecyclerView.getChildViewHolderInt(child));
        }
        this.onChildAttachedToWindow(child);
    }

    private void removeFromDisappearingList(View child) {
        this.mDisappearingViewsInLayoutPass.remove(child);
    }

    private void addToDisappearingList(View child) {
        if (!this.mDisappearingViewsInLayoutPass.contains(child)) {
            this.mDisappearingViewsInLayoutPass.add(child);
        }
    }

    private int getAdapterPositionFor(ViewHolder viewHolder) {
        if (viewHolder.hasAnyOfTheFlags(520)) {
            return -1;
        }
        return this.mAdapterHelper.applyPendingUpdatesToPosition(viewHolder.mPosition);
    }

    private static class ItemHolderInfo {
        ViewHolder holder;
        int left;
        int top;
        int right;
        int bottom;

        ItemHolderInfo(ViewHolder holder, int left, int top, int right, int bottom) {
            this.holder = holder;
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }
    }

    public static abstract class ItemAnimator {
        private ItemAnimatorListener mListener = null;
        private ArrayList<ItemAnimatorFinishedListener> mFinishedListeners = new ArrayList();
        private long mAddDuration = 120L;
        private long mRemoveDuration = 120L;
        private long mMoveDuration = 250L;
        private long mChangeDuration = 250L;
        private boolean mSupportsChangeAnimations = true;

        public long getMoveDuration() {
            return this.mMoveDuration;
        }

        public void setMoveDuration(long moveDuration) {
            this.mMoveDuration = moveDuration;
        }

        public long getAddDuration() {
            return this.mAddDuration;
        }

        public void setAddDuration(long addDuration) {
            this.mAddDuration = addDuration;
        }

        public long getRemoveDuration() {
            return this.mRemoveDuration;
        }

        public void setRemoveDuration(long removeDuration) {
            this.mRemoveDuration = removeDuration;
        }

        public long getChangeDuration() {
            return this.mChangeDuration;
        }

        public void setChangeDuration(long changeDuration) {
            this.mChangeDuration = changeDuration;
        }

        public boolean getSupportsChangeAnimations() {
            return this.mSupportsChangeAnimations;
        }

        public void setSupportsChangeAnimations(boolean supportsChangeAnimations) {
            this.mSupportsChangeAnimations = supportsChangeAnimations;
        }

        void setListener(ItemAnimatorListener listener) {
            this.mListener = listener;
        }

        public abstract void runPendingAnimations();

        public abstract boolean animateRemove(ViewHolder var1);

        public abstract boolean animateAdd(ViewHolder var1);

        public abstract boolean animateMove(ViewHolder var1, int var2, int var3, int var4, int var5);

        public abstract boolean animateChange(ViewHolder var1, ViewHolder var2, int var3, int var4, int var5, int var6);

        public final void dispatchRemoveFinished(ViewHolder item) {
            this.onRemoveFinished(item);
            if (this.mListener != null) {
                this.mListener.onRemoveFinished(item);
            }
        }

        public final void dispatchMoveFinished(ViewHolder item) {
            this.onMoveFinished(item);
            if (this.mListener != null) {
                this.mListener.onMoveFinished(item);
            }
        }

        public final void dispatchAddFinished(ViewHolder item) {
            this.onAddFinished(item);
            if (this.mListener != null) {
                this.mListener.onAddFinished(item);
            }
        }

        public final void dispatchChangeFinished(ViewHolder item, boolean oldItem) {
            this.onChangeFinished(item, oldItem);
            if (this.mListener != null) {
                this.mListener.onChangeFinished(item);
            }
        }

        public final void dispatchRemoveStarting(ViewHolder item) {
            this.onRemoveStarting(item);
        }

        public final void dispatchMoveStarting(ViewHolder item) {
            this.onMoveStarting(item);
        }

        public final void dispatchAddStarting(ViewHolder item) {
            this.onAddStarting(item);
        }

        public final void dispatchChangeStarting(ViewHolder item, boolean oldItem) {
            this.onChangeStarting(item, oldItem);
        }

        public abstract void endAnimation(ViewHolder var1);

        public abstract void endAnimations();

        public abstract boolean isRunning();

        public final boolean isRunning(ItemAnimatorFinishedListener listener) {
            boolean running = this.isRunning();
            if (listener != null) {
                if (!running) {
                    listener.onAnimationsFinished();
                } else {
                    this.mFinishedListeners.add(listener);
                }
            }
            return running;
        }

        public final void dispatchAnimationsFinished() {
            int count = this.mFinishedListeners.size();
            for (int i = 0; i < count; ++i) {
                this.mFinishedListeners.get(i).onAnimationsFinished();
            }
            this.mFinishedListeners.clear();
        }

        public void onRemoveStarting(ViewHolder item) {
        }

        public void onRemoveFinished(ViewHolder item) {
        }

        public void onAddStarting(ViewHolder item) {
        }

        public void onAddFinished(ViewHolder item) {
        }

        public void onMoveStarting(ViewHolder item) {
        }

        public void onMoveFinished(ViewHolder item) {
        }

        public void onChangeStarting(ViewHolder item, boolean oldItem) {
        }

        public void onChangeFinished(ViewHolder item, boolean oldItem) {
        }

        public static interface ItemAnimatorFinishedListener {
            public void onAnimationsFinished();
        }

        static interface ItemAnimatorListener {
            public void onRemoveFinished(ViewHolder var1);

            public void onAddFinished(ViewHolder var1);

            public void onMoveFinished(ViewHolder var1);

            public void onChangeFinished(ViewHolder var1);
        }
    }

    private class ItemAnimatorRestoreListener
    implements ItemAnimator.ItemAnimatorListener {
        private ItemAnimatorRestoreListener() {
        }

        @Override
        public void onRemoveFinished(ViewHolder item) {
            item.setIsRecyclable(true);
            if (!CustomRecyclerView.this.removeAnimatingView(item.itemView) && item.isTmpDetached()) {
                CustomRecyclerView.this.removeDetachedView(item.itemView, false);
            }
        }

        @Override
        public void onAddFinished(ViewHolder item) {
            item.setIsRecyclable(true);
            if (!item.shouldBeKeptAsChild()) {
                CustomRecyclerView.this.removeAnimatingView(item.itemView);
            }
        }

        @Override
        public void onMoveFinished(ViewHolder item) {
            item.setIsRecyclable(true);
            if (!item.shouldBeKeptAsChild()) {
                CustomRecyclerView.this.removeAnimatingView(item.itemView);
            }
        }

        @Override
        public void onChangeFinished(ViewHolder item) {
            item.setIsRecyclable(true);
            if (item.mShadowedHolder != null && item.mShadowingHolder == null) {
                item.mShadowedHolder = null;
                item.setFlags(-65, item.mFlags);
            }
            item.mShadowingHolder = null;
            if (!item.shouldBeKeptAsChild()) {
                CustomRecyclerView.this.removeAnimatingView(item.itemView);
            }
        }
    }

    public static class State {
        private int mTargetPosition = -1;
        ArrayMap<ViewHolder, ItemHolderInfo> mPreLayoutHolderMap = new ArrayMap();
        ArrayMap<ViewHolder, ItemHolderInfo> mPostLayoutHolderMap = new ArrayMap();
        ArrayMap<Long, ViewHolder> mOldChangedHolders = new ArrayMap();
        private SparseArray<Object> mData;
        int mItemCount = 0;
        private int mPreviousLayoutItemCount = 0;
        private int mDeletedInvisibleItemCountSincePreviousLayout = 0;
        private boolean mStructureChanged = false;
        private boolean mInPreLayout = false;
        private boolean mRunSimpleAnimations = false;
        private boolean mRunPredictiveAnimations = false;

        State reset() {
            this.mTargetPosition = -1;
            if (this.mData != null) {
                this.mData.clear();
            }
            this.mItemCount = 0;
            this.mStructureChanged = false;
            return this;
        }

        public boolean isPreLayout() {
            return this.mInPreLayout;
        }

        public boolean willRunPredictiveAnimations() {
            return this.mRunPredictiveAnimations;
        }

        public boolean willRunSimpleAnimations() {
            return this.mRunSimpleAnimations;
        }

        public void remove(int resourceId) {
            if (this.mData == null) {
                return;
            }
            this.mData.remove(resourceId);
        }

        public <T> T get(int resourceId) {
            if (this.mData == null) {
                return null;
            }
            return (T)this.mData.get(resourceId);
        }

        public void put(int resourceId, Object data) {
            if (this.mData == null) {
                this.mData = new SparseArray();
            }
            this.mData.put(resourceId, data);
        }

        public int getTargetScrollPosition() {
            return this.mTargetPosition;
        }

        public boolean hasTargetScrollPosition() {
            return this.mTargetPosition != -1;
        }

        public boolean didStructureChange() {
            return this.mStructureChanged;
        }

        public int getItemCount() {
            return this.mInPreLayout ? this.mPreviousLayoutItemCount - this.mDeletedInvisibleItemCountSincePreviousLayout : this.mItemCount;
        }

        public void onViewRecycled(ViewHolder holder) {
            this.mPreLayoutHolderMap.remove((Object)holder);
            this.mPostLayoutHolderMap.remove((Object)holder);
            if (this.mOldChangedHolders != null) {
                this.removeFrom(this.mOldChangedHolders, holder);
            }
        }

        public void onViewIgnored(ViewHolder holder) {
            this.onViewRecycled(holder);
        }

        private void removeFrom(ArrayMap<Long, ViewHolder> holderMap, ViewHolder holder) {
            for (int i = holderMap.size() - 1; i >= 0; --i) {
                if (holder != holderMap.valueAt(i)) continue;
                holderMap.removeAt(i);
                return;
            }
        }

        public String toString() {
            return "State{mTargetPosition=" + this.mTargetPosition + ", mPreLayoutHolderMap=" + this.mPreLayoutHolderMap + ", mPostLayoutHolderMap=" + this.mPostLayoutHolderMap + ", mData=" + this.mData + ", mItemCount=" + this.mItemCount + ", mPreviousLayoutItemCount=" + this.mPreviousLayoutItemCount + ", mDeletedInvisibleItemCountSincePreviousLayout=" + this.mDeletedInvisibleItemCountSincePreviousLayout + ", mStructureChanged=" + this.mStructureChanged + ", mInPreLayout=" + this.mInPreLayout + ", mRunSimpleAnimations=" + this.mRunSimpleAnimations + ", mRunPredictiveAnimations=" + this.mRunPredictiveAnimations + '}';
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        Parcelable mLayoutState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcel in) {
            super(in);
            this.mLayoutState = in.readParcelable(LayoutManager.class.getClassLoader());
        }

        SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeParcelable(this.mLayoutState, 0);
        }

        private void copyFrom(SavedState other) {
            this.mLayoutState = other.mLayoutState;
        }
    }

    static class AdapterDataObservable
    extends Observable<AdapterDataObserver> {
        AdapterDataObservable() {
        }

        public boolean hasObservers() {
            return !this.mObservers.isEmpty();
        }

        public void notifyChanged() {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onChanged();
            }
        }

        public void notifyItemRangeChanged(int positionStart, int itemCount) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onItemRangeChanged(positionStart, itemCount);
            }
        }

        public void notifyItemRangeInserted(int positionStart, int itemCount) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onItemRangeInserted(positionStart, itemCount);
            }
        }

        public void notifyItemRangeRemoved(int positionStart, int itemCount) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onItemRangeRemoved(positionStart, itemCount);
            }
        }

        public void notifyItemMoved(int fromPosition, int toPosition) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onItemRangeMoved(fromPosition, toPosition, 1);
            }
        }
    }

    public static abstract class SmoothScroller {
        private int mTargetPosition = -1;
        private CustomRecyclerView mCustomRecyclerView;
        private LayoutManager mLayoutManager;
        private boolean mPendingInitialRun;
        private boolean mRunning;
        private View mTargetView;
        private final Action mRecyclingAction = new Action(0, 0);

        void start(CustomRecyclerView customRecyclerView, LayoutManager layoutManager) {
            this.mCustomRecyclerView = customRecyclerView;
            this.mLayoutManager = layoutManager;
            if (this.mTargetPosition == -1) {
                throw new IllegalArgumentException("Invalid target position");
            }
            this.mCustomRecyclerView.mState.mTargetPosition = this.mTargetPosition;
            this.mRunning = true;
            this.mPendingInitialRun = true;
            this.mTargetView = this.findViewByPosition(this.getTargetPosition());
            this.onStart();
            this.mCustomRecyclerView.mViewFlinger.postOnAnimation();
        }

        public void setTargetPosition(int targetPosition) {
            this.mTargetPosition = targetPosition;
        }

        public LayoutManager getLayoutManager() {
            return this.mLayoutManager;
        }

        protected final void stop() {
            if (!this.mRunning) {
                return;
            }
            this.onStop();
            this.mCustomRecyclerView.mState.mTargetPosition = -1;
            this.mTargetView = null;
            this.mTargetPosition = -1;
            this.mPendingInitialRun = false;
            this.mRunning = false;
            this.mLayoutManager.onSmoothScrollerStopped(this);
            this.mLayoutManager = null;
            this.mCustomRecyclerView = null;
        }

        public boolean isPendingInitialRun() {
            return this.mPendingInitialRun;
        }

        public boolean isRunning() {
            return this.mRunning;
        }

        public int getTargetPosition() {
            return this.mTargetPosition;
        }

        private void onAnimation(int dx, int dy) {
            if (!this.mRunning || this.mTargetPosition == -1) {
                this.stop();
            }
            this.mPendingInitialRun = false;
            if (this.mTargetView != null) {
                if (this.getChildPosition(this.mTargetView) == this.mTargetPosition) {
                    this.onTargetFound(this.mTargetView, this.mCustomRecyclerView.mState, this.mRecyclingAction);
                    this.mRecyclingAction.runIfNecessary(this.mCustomRecyclerView);
                    this.stop();
                } else {
                    Log.e((String)CustomRecyclerView.TAG, (String)"Passed over target position while smooth scrolling.");
                    this.mTargetView = null;
                }
            }
            if (this.mRunning) {
                this.onSeekTargetStep(dx, dy, this.mCustomRecyclerView.mState, this.mRecyclingAction);
                this.mRecyclingAction.runIfNecessary(this.mCustomRecyclerView);
            }
        }

        public int getChildPosition(View view) {
            return this.mCustomRecyclerView.getChildLayoutPosition(view);
        }

        public int getChildCount() {
            return this.mCustomRecyclerView.mLayout.getChildCount();
        }

        public View findViewByPosition(int position) {
            return this.mCustomRecyclerView.mLayout.findViewByPosition(position);
        }

        public void instantScrollToPosition(int position) {
            this.mCustomRecyclerView.scrollToPosition(position);
        }

        protected void onChildAttachedToWindow(View child) {
            if (this.getChildPosition(child) == this.getTargetPosition()) {
                this.mTargetView = child;
            }
        }

        protected void normalize(PointF scrollVector) {
            double magnitute = Math.sqrt(scrollVector.x * scrollVector.x + scrollVector.y * scrollVector.y);
            scrollVector.x = (float)((double)scrollVector.x / magnitute);
            scrollVector.y = (float)((double)scrollVector.y / magnitute);
        }

        protected abstract void onStart();

        protected abstract void onStop();

        protected abstract void onSeekTargetStep(int var1, int var2, State var3, Action var4);

        protected abstract void onTargetFound(View var1, State var2, Action var3);

        public static class Action {
            public static final int UNDEFINED_DURATION = Integer.MIN_VALUE;
            private int mDx;
            private int mDy;
            private int mDuration;
            private Interpolator mInterpolator;
            private boolean changed = false;
            private int consecutiveUpdates = 0;

            public Action(int dx, int dy) {
                this(dx, dy, Integer.MIN_VALUE, null);
            }

            public Action(int dx, int dy, int duration) {
                this(dx, dy, duration, null);
            }

            public Action(int dx, int dy, int duration, Interpolator interpolator) {
                this.mDx = dx;
                this.mDy = dy;
                this.mDuration = duration;
                this.mInterpolator = interpolator;
            }

            private void runIfNecessary(CustomRecyclerView customRecyclerView) {
                if (this.changed) {
                    this.validate();
                    if (this.mInterpolator == null) {
                        if (this.mDuration == Integer.MIN_VALUE) {
                            customRecyclerView.mViewFlinger.smoothScrollBy(this.mDx, this.mDy);
                        } else {
                            customRecyclerView.mViewFlinger.smoothScrollBy(this.mDx, this.mDy, this.mDuration);
                        }
                    } else {
                        customRecyclerView.mViewFlinger.smoothScrollBy(this.mDx, this.mDy, this.mDuration, this.mInterpolator);
                    }
                    ++this.consecutiveUpdates;
                    if (this.consecutiveUpdates > 10) {
                        Log.e((String)CustomRecyclerView.TAG, (String)"Smooth Scroll action is being updated too frequently. Make sure you are not changing it unless necessary");
                    }
                    this.changed = false;
                } else {
                    this.consecutiveUpdates = 0;
                }
            }

            private void validate() {
                if (this.mInterpolator != null && this.mDuration < 1) {
                    throw new IllegalStateException("If you provide an interpolator, you must set a positive duration");
                }
                if (this.mDuration < 1) {
                    throw new IllegalStateException("Scroll duration must be a positive number");
                }
            }

            public int getDx() {
                return this.mDx;
            }

            public void setDx(int dx) {
                this.changed = true;
                this.mDx = dx;
            }

            public int getDy() {
                return this.mDy;
            }

            public void setDy(int dy) {
                this.changed = true;
                this.mDy = dy;
            }

            public int getDuration() {
                return this.mDuration;
            }

            public void setDuration(int duration) {
                this.changed = true;
                this.mDuration = duration;
            }

            public Interpolator getInterpolator() {
                return this.mInterpolator;
            }

            public void setInterpolator(Interpolator interpolator) {
                this.changed = true;
                this.mInterpolator = interpolator;
            }

            public void update(int dx, int dy, int duration, Interpolator interpolator) {
                this.mDx = dx;
                this.mDy = dy;
                this.mDuration = duration;
                this.mInterpolator = interpolator;
                this.changed = true;
            }
        }
    }

    public static abstract class AdapterDataObserver {
        public void onChanged() {
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        ViewHolder mViewHolder;
        final Rect mDecorInsets = new Rect();
        boolean mInsetsDirty = true;
        boolean mPendingInvalidate = false;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(LayoutParams source) {
            super((ViewGroup.LayoutParams)source);
        }

        public boolean viewNeedsUpdate() {
            return this.mViewHolder.needsUpdate();
        }

        public boolean isViewInvalid() {
            return this.mViewHolder.isInvalid();
        }

        public boolean isItemRemoved() {
            return this.mViewHolder.isRemoved();
        }

        public boolean isItemChanged() {
            return this.mViewHolder.isChanged();
        }

        public int getViewPosition() {
            return this.mViewHolder.getPosition();
        }

        public int getViewLayoutPosition() {
            return this.mViewHolder.getLayoutPosition();
        }

        public int getViewAdapterPosition() {
            return this.mViewHolder.getAdapterPosition();
        }
    }

    public static abstract class ViewHolder {
        public final View itemView;
        int mPosition = -1;
        int mOldPosition = -1;
        long mItemId = -1L;
        int mItemViewType = -1;
        int mPreLayoutPosition = -1;
        ViewHolder mShadowedHolder = null;
        ViewHolder mShadowingHolder = null;
        static final int FLAG_BOUND = 1;
        static final int FLAG_UPDATE = 2;
        static final int FLAG_INVALID = 4;
        static final int FLAG_REMOVED = 8;
        static final int FLAG_NOT_RECYCLABLE = 16;
        static final int FLAG_RETURNED_FROM_SCRAP = 32;
        static final int FLAG_CHANGED = 64;
        static final int FLAG_IGNORE = 128;
        static final int FLAG_TMP_DETACHED = 256;
        static final int FLAG_ADAPTER_POSITION_UNKNOWN = 512;
        private int mFlags;
        private int mIsRecyclableCount = 0;
        private Recycler mScrapContainer = null;

        public ViewHolder(View itemView) {
            if (itemView == null) {
                throw new IllegalArgumentException("itemView may not be null");
            }
            this.itemView = itemView;
        }

        void flagRemovedAndOffsetPosition(int mNewPosition, int offset, boolean applyToPreLayout) {
            this.addFlags(8);
            this.offsetPosition(offset, applyToPreLayout);
            this.mPosition = mNewPosition;
        }

        void offsetPosition(int offset, boolean applyToPreLayout) {
            if (this.mOldPosition == -1) {
                this.mOldPosition = this.mPosition;
            }
            if (this.mPreLayoutPosition == -1) {
                this.mPreLayoutPosition = this.mPosition;
            }
            if (applyToPreLayout) {
                this.mPreLayoutPosition += offset;
            }
            this.mPosition += offset;
            if (this.itemView.getLayoutParams() != null) {
                ((LayoutParams)this.itemView.getLayoutParams()).mInsetsDirty = true;
            }
        }

        void clearOldPosition() {
            this.mOldPosition = -1;
            this.mPreLayoutPosition = -1;
        }

        void saveOldPosition() {
            if (this.mOldPosition == -1) {
                this.mOldPosition = this.mPosition;
            }
        }

        boolean shouldIgnore() {
            return (this.mFlags & 0x80) != 0;
        }

        @Deprecated
        public final int getPosition() {
            return this.mPreLayoutPosition == -1 ? this.mPosition : this.mPreLayoutPosition;
        }

        public final int getLayoutPosition() {
            return this.mPreLayoutPosition == -1 ? this.mPosition : this.mPreLayoutPosition;
        }

        public final int getAdapterPosition() {
            ViewParent parent = this.itemView.getParent();
            if (!(parent instanceof CustomRecyclerView)) {
                return -1;
            }
            CustomRecyclerView rv = (CustomRecyclerView)parent;
            return rv.getAdapterPositionFor(this);
        }

        public final int getOldPosition() {
            return this.mOldPosition;
        }

        public final long getItemId() {
            return this.mItemId;
        }

        public final int getItemViewType() {
            return this.mItemViewType;
        }

        boolean isScrap() {
            return this.mScrapContainer != null;
        }

        void unScrap() {
            this.mScrapContainer.unscrapView(this);
        }

        boolean wasReturnedFromScrap() {
            return (this.mFlags & 0x20) != 0;
        }

        void clearReturnedFromScrapFlag() {
            this.mFlags &= 0xFFFFFFDF;
        }

        void clearTmpDetachFlag() {
            this.mFlags &= 0xFFFFFEFF;
        }

        void stopIgnoring() {
            this.mFlags &= 0xFFFFFF7F;
        }

        void setScrapContainer(Recycler recycler) {
            this.mScrapContainer = recycler;
        }

        boolean isInvalid() {
            return (this.mFlags & 4) != 0;
        }

        boolean needsUpdate() {
            return (this.mFlags & 2) != 0;
        }

        boolean isChanged() {
            return (this.mFlags & 0x40) != 0;
        }

        boolean isBound() {
            return (this.mFlags & 1) != 0;
        }

        boolean isRemoved() {
            return (this.mFlags & 8) != 0;
        }

        boolean hasAnyOfTheFlags(int flags) {
            return (this.mFlags & flags) != 0;
        }

        boolean isTmpDetached() {
            return (this.mFlags & 0x100) != 0;
        }

        boolean isAdapterPositionUnknown() {
            return (this.mFlags & 0x200) != 0;
        }

        void setFlags(int flags, int mask) {
            this.mFlags = this.mFlags & ~mask | flags & mask;
        }

        void addFlags(int flags) {
            this.mFlags |= flags;
        }

        void resetInternal() {
            this.mFlags = 0;
            this.mPosition = -1;
            this.mOldPosition = -1;
            this.mItemId = -1L;
            this.mPreLayoutPosition = -1;
            this.mIsRecyclableCount = 0;
            this.mShadowedHolder = null;
            this.mShadowingHolder = null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ViewHolder{" + Integer.toHexString(this.hashCode()) + " position=" + this.mPosition + " id=" + this.mItemId + ", oldPos=" + this.mOldPosition + ", pLpos:" + this.mPreLayoutPosition);
            if (this.isScrap()) {
                sb.append(" scrap");
            }
            if (this.isInvalid()) {
                sb.append(" invalid");
            }
            if (!this.isBound()) {
                sb.append(" unbound");
            }
            if (this.needsUpdate()) {
                sb.append(" update");
            }
            if (this.isRemoved()) {
                sb.append(" removed");
            }
            if (this.shouldIgnore()) {
                sb.append(" ignored");
            }
            if (this.isChanged()) {
                sb.append(" changed");
            }
            if (this.isTmpDetached()) {
                sb.append(" tmpDetached");
            }
            if (!this.isRecyclable()) {
                sb.append(" not recyclable(" + this.mIsRecyclableCount + ")");
            }
            if (!this.isAdapterPositionUnknown()) {
                sb.append("undefined adapter position");
            }
            if (this.itemView.getParent() == null) {
                sb.append(" no parent");
            }
            sb.append("}");
            return sb.toString();
        }

        public final void setIsRecyclable(boolean recyclable) {
            int n = this.mIsRecyclableCount = recyclable ? this.mIsRecyclableCount - 1 : this.mIsRecyclableCount + 1;
            if (this.mIsRecyclableCount < 0) {
                this.mIsRecyclableCount = 0;
                Log.e((String)"View", (String)("isRecyclable decremented below 0: unmatched pair of setIsRecyable() calls for " + this));
            } else if (!recyclable && this.mIsRecyclableCount == 1) {
                this.mFlags |= 0x10;
            } else if (recyclable && this.mIsRecyclableCount == 0) {
                this.mFlags &= 0xFFFFFFEF;
            }
        }

        public final boolean isRecyclable() {
            return (this.mFlags & 0x10) == 0 && !ViewCompat.hasTransientState((View)this.itemView);
        }

        private boolean shouldBeKeptAsChild() {
            return (this.mFlags & 0x10) != 0;
        }

        private boolean doesTransientStatePreventRecycling() {
            return (this.mFlags & 0x10) == 0 && ViewCompat.hasTransientState((View)this.itemView);
        }
    }

    public static interface RecyclerListener {
        public void onViewRecycled(ViewHolder var1);
    }

    public static abstract class OnScrollListener {
        public void onScrollStateChanged(CustomRecyclerView customRecyclerView, int newState) {
        }

        public void onScrolled(CustomRecyclerView customRecyclerView, int dx, int dy) {
        }
    }

    public static interface OnItemTouchListener {
        public boolean onInterceptTouchEvent(CustomRecyclerView var1, MotionEvent var2);

        public void onTouchEvent(CustomRecyclerView var1, MotionEvent var2);
    }

    public static abstract class ItemDecoration {
        public void onDraw(Canvas c, CustomRecyclerView parent, State state) {
            this.onDraw(c, parent);
        }

        @Deprecated
        public void onDraw(Canvas c, CustomRecyclerView parent) {
        }

        public void onDrawOver(Canvas c, CustomRecyclerView parent, State state) {
            this.onDrawOver(c, parent);
        }

        @Deprecated
        public void onDrawOver(Canvas c, CustomRecyclerView parent) {
        }

        @Deprecated
        public void getItemOffsets(Rect outRect, int itemPosition, CustomRecyclerView parent) {
            outRect.set(0, 0, 0, 0);
        }

        public void getItemOffsets(Rect outRect, View view, CustomRecyclerView parent, State state) {
            this.getItemOffsets(outRect, ((LayoutParams)view.getLayoutParams()).getViewLayoutPosition(), parent);
        }
    }

    public static abstract class LayoutManager {
        ChildHelper mChildHelper;
        CustomRecyclerView mCustomRecyclerView;
        @Nullable
        SmoothScroller mSmoothScroller;
        private boolean mRequestedSimpleAnimations = false;

        void setRecyclerView(CustomRecyclerView customRecyclerView) {
            if (customRecyclerView == null) {
                this.mCustomRecyclerView = null;
                this.mChildHelper = null;
            } else {
                this.mCustomRecyclerView = customRecyclerView;
                this.mChildHelper = customRecyclerView.mChildHelper;
            }
        }

        public void requestLayout() {
            if (this.mCustomRecyclerView != null) {
                this.mCustomRecyclerView.requestLayout();
            }
        }

        public void assertInLayoutOrScroll(String message) {
            if (this.mCustomRecyclerView != null) {
                this.mCustomRecyclerView.assertInLayoutOrScroll(message);
            }
        }

        public void assertNotInLayoutOrScroll(String message) {
            if (this.mCustomRecyclerView != null) {
                this.mCustomRecyclerView.assertNotInLayoutOrScroll(message);
            }
        }

        public boolean supportsPredictiveItemAnimations() {
            return false;
        }

        public void onAttachedToWindow(CustomRecyclerView view) {
        }

        @Deprecated
        public void onDetachedFromWindow(CustomRecyclerView view) {
        }

        public void onDetachedFromWindow(CustomRecyclerView view, Recycler recycler) {
            this.onDetachedFromWindow(view);
        }

        public boolean getClipToPadding() {
            return this.mCustomRecyclerView != null && this.mCustomRecyclerView.mClipToPadding;
        }

        public void onLayoutChildren(Recycler recycler, State state) {
            Log.e((String)CustomRecyclerView.TAG, (String)"You must override onLayoutChildren(Recycler recycler, State state) ");
        }

        public abstract LayoutParams generateDefaultLayoutParams();

        public boolean checkLayoutParams(LayoutParams lp) {
            return lp != null;
        }

        public LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
            if (lp instanceof LayoutParams) {
                return new LayoutParams((LayoutParams)lp);
            }
            if (lp instanceof ViewGroup.MarginLayoutParams) {
                return new LayoutParams((ViewGroup.MarginLayoutParams)lp);
            }
            return new LayoutParams(lp);
        }

        public LayoutParams generateLayoutParams(Context c, AttributeSet attrs) {
            return new LayoutParams(c, attrs);
        }

        public int scrollHorizontallyBy(int dx, Recycler recycler, State state) {
            return 0;
        }

        public int scrollVerticallyBy(int dy, Recycler recycler, State state) {
            return 0;
        }

        public boolean canScrollHorizontally() {
            return false;
        }

        public boolean canScrollVertically() {
            return false;
        }

        public void scrollToPosition(int position) {
        }

        public void smoothScrollToPosition(CustomRecyclerView customRecyclerView, State state, int position) {
            Log.e((String)CustomRecyclerView.TAG, (String)"You must override smoothScrollToPosition to support smooth scrolling");
        }

        public void startSmoothScroll(SmoothScroller smoothScroller) {
            if (this.mSmoothScroller != null && smoothScroller != this.mSmoothScroller && this.mSmoothScroller.isRunning()) {
                this.mSmoothScroller.stop();
            }
            this.mSmoothScroller = smoothScroller;
            this.mSmoothScroller.start(this.mCustomRecyclerView, this);
        }

        public boolean isSmoothScrolling() {
            return this.mSmoothScroller != null && this.mSmoothScroller.isRunning();
        }

        public int getLayoutDirection() {
            return ViewCompat.getLayoutDirection((View)this.mCustomRecyclerView);
        }

        public void endAnimation(View view) {
            if (this.mCustomRecyclerView.mItemAnimator != null) {
                this.mCustomRecyclerView.mItemAnimator.endAnimation(CustomRecyclerView.getChildViewHolderInt(view));
            }
        }

        public void addDisappearingView(View child) {
            this.addDisappearingView(child, -1);
        }

        public void addDisappearingView(View child, int index) {
            this.addViewInt(child, index, true);
        }

        public void addView(View child) {
            this.addView(child, -1);
        }

        public void addView(View child, int index) {
            this.addViewInt(child, index, false);
        }

        private void addViewInt(View child, int index, boolean disappearing) {
            ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(child);
            if (disappearing || holder.isRemoved()) {
                this.mCustomRecyclerView.addToDisappearingList(child);
            } else {
                this.mCustomRecyclerView.removeFromDisappearingList(child);
            }
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (holder.wasReturnedFromScrap() || holder.isScrap()) {
                if (holder.isScrap()) {
                    holder.unScrap();
                } else {
                    holder.clearReturnedFromScrapFlag();
                }
                this.mChildHelper.attachViewToParent(child, index, child.getLayoutParams(), false);
            } else if (child.getParent() == this.mCustomRecyclerView) {
                int currentIndex = this.mChildHelper.indexOfChild(child);
                if (index == -1) {
                    index = this.mChildHelper.getChildCount();
                }
                if (currentIndex == -1) {
                    throw new IllegalStateException("Added View has RecyclerView as parent but view is not a real child. Unfiltered index:" + this.mCustomRecyclerView.indexOfChild(child));
                }
                if (currentIndex != index) {
                    this.mCustomRecyclerView.mLayout.moveView(currentIndex, index);
                }
            } else {
                this.mChildHelper.addView(child, index, false);
                lp.mInsetsDirty = true;
                if (this.mSmoothScroller != null && this.mSmoothScroller.isRunning()) {
                    this.mSmoothScroller.onChildAttachedToWindow(child);
                }
            }
            if (lp.mPendingInvalidate) {
                holder.itemView.invalidate();
                lp.mPendingInvalidate = false;
            }
        }

        public void removeView(View child) {
            this.mChildHelper.removeView(child);
        }

        public void removeViewAt(int index) {
            View child = this.getChildAt(index);
            if (child != null) {
                this.mChildHelper.removeViewAt(index);
            }
        }

        public void removeAllViews() {
            int childCount = this.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                this.mChildHelper.removeViewAt(i);
            }
        }

        public int getPosition(View view) {
            return ((LayoutParams)view.getLayoutParams()).getViewLayoutPosition();
        }

        public int getItemViewType(View view) {
            return CustomRecyclerView.getChildViewHolderInt(view).getItemViewType();
        }

        public View findViewByPosition(int position) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                ViewHolder vh = CustomRecyclerView.getChildViewHolderInt(child);
                if (vh == null || vh.getLayoutPosition() != position || vh.shouldIgnore() || !this.mCustomRecyclerView.mState.isPreLayout() && vh.isRemoved()) continue;
                return child;
            }
            return null;
        }

        public void detachView(View child) {
            int ind = this.mChildHelper.indexOfChild(child);
            if (ind >= 0) {
                this.detachViewInternal(ind, child);
            }
        }

        public void detachViewAt(int index) {
            this.detachViewInternal(index, this.getChildAt(index));
        }

        private void detachViewInternal(int index, View view) {
            this.mChildHelper.detachViewFromParent(index);
        }

        public void attachView(View child, int index, LayoutParams lp) {
            ViewHolder vh = CustomRecyclerView.getChildViewHolderInt(child);
            if (vh.isRemoved()) {
                this.mCustomRecyclerView.addToDisappearingList(child);
            } else {
                this.mCustomRecyclerView.removeFromDisappearingList(child);
            }
            this.mChildHelper.attachViewToParent(child, index, (ViewGroup.LayoutParams)lp, vh.isRemoved());
        }

        public void attachView(View child, int index) {
            this.attachView(child, index, (LayoutParams)child.getLayoutParams());
        }

        public void attachView(View child) {
            this.attachView(child, -1);
        }

        public void removeDetachedView(View child) {
            this.mCustomRecyclerView.removeDetachedView(child, false);
        }

        public void moveView(int fromIndex, int toIndex) {
            View view = this.getChildAt(fromIndex);
            if (view == null) {
                throw new IllegalArgumentException("Cannot move a child from non-existing index:" + fromIndex);
            }
            this.detachViewAt(fromIndex);
            this.attachView(view, toIndex);
        }

        public void detachAndScrapView(View child, Recycler recycler) {
            int index = this.mChildHelper.indexOfChild(child);
            this.scrapOrRecycleView(recycler, index, child);
        }

        public void detachAndScrapViewAt(int index, Recycler recycler) {
            View child = this.getChildAt(index);
            this.scrapOrRecycleView(recycler, index, child);
        }

        public void removeAndRecycleView(View child, Recycler recycler) {
            this.removeView(child);
            recycler.recycleView(child);
        }

        public void removeAndRecycleViewAt(int index, Recycler recycler) {
            View view = this.getChildAt(index);
            this.removeViewAt(index);
            recycler.recycleView(view);
        }

        public int getChildCount() {
            return this.mChildHelper != null ? this.mChildHelper.getChildCount() : 0;
        }

        public View getChildAt(int index) {
            return this.mChildHelper != null ? this.mChildHelper.getChildAt(index) : null;
        }

        public int getWidth() {
            return this.mCustomRecyclerView != null ? this.mCustomRecyclerView.getWidth() : 0;
        }

        public int getHeight() {
            return this.mCustomRecyclerView != null ? this.mCustomRecyclerView.getHeight() : 0;
        }

        public int getPaddingLeft() {
            return this.mCustomRecyclerView != null ? this.mCustomRecyclerView.getPaddingLeft() : 0;
        }

        public int getPaddingTop() {
            return this.mCustomRecyclerView != null ? this.mCustomRecyclerView.getPaddingTop() : 0;
        }

        public int getPaddingRight() {
            return this.mCustomRecyclerView != null ? this.mCustomRecyclerView.getPaddingRight() : 0;
        }

        public int getPaddingBottom() {
            return this.mCustomRecyclerView != null ? this.mCustomRecyclerView.getPaddingBottom() : 0;
        }

        public int getPaddingStart() {
            return this.mCustomRecyclerView != null ? ViewCompat.getPaddingStart((View)this.mCustomRecyclerView) : 0;
        }

        public int getPaddingEnd() {
            return this.mCustomRecyclerView != null ? ViewCompat.getPaddingEnd((View)this.mCustomRecyclerView) : 0;
        }

        public boolean isFocused() {
            return this.mCustomRecyclerView != null && this.mCustomRecyclerView.isFocused();
        }

        public boolean hasFocus() {
            return this.mCustomRecyclerView != null && this.mCustomRecyclerView.hasFocus();
        }

        public View getFocusedChild() {
            if (this.mCustomRecyclerView == null) {
                return null;
            }
            View focused = this.mCustomRecyclerView.getFocusedChild();
            if (focused == null || this.mChildHelper.isHidden(focused)) {
                return null;
            }
            return focused;
        }

        public int getItemCount() {
            Adapter a = this.mCustomRecyclerView != null ? this.mCustomRecyclerView.getAdapter() : null;
            return a != null ? a.getItemCount() : 0;
        }

        public void offsetChildrenHorizontal(int dx) {
            if (this.mCustomRecyclerView != null) {
                this.mCustomRecyclerView.offsetChildrenHorizontal(dx);
            }
        }

        public void offsetChildrenVertical(int dy) {
            if (this.mCustomRecyclerView != null) {
                this.mCustomRecyclerView.offsetChildrenVertical(dy);
            }
        }

        public void ignoreView(View view) {
            if (view.getParent() != this.mCustomRecyclerView || this.mCustomRecyclerView.indexOfChild(view) == -1) {
                throw new IllegalArgumentException("View should be fully attached to be ignored");
            }
            ViewHolder vh = CustomRecyclerView.getChildViewHolderInt(view);
            vh.addFlags(128);
            this.mCustomRecyclerView.mState.onViewIgnored(vh);
        }

        public void stopIgnoringView(View view) {
            ViewHolder vh = CustomRecyclerView.getChildViewHolderInt(view);
            vh.stopIgnoring();
            vh.resetInternal();
            vh.addFlags(4);
        }

        public void detachAndScrapAttachedViews(Recycler recycler) {
            int childCount = this.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                View v = this.getChildAt(i);
                this.scrapOrRecycleView(recycler, i, v);
            }
        }

        private void scrapOrRecycleView(Recycler recycler, int index, View view) {
            ViewHolder viewHolder = CustomRecyclerView.getChildViewHolderInt(view);
            if (viewHolder.shouldIgnore()) {
                return;
            }
            if (viewHolder.isInvalid() && !viewHolder.isRemoved() && !viewHolder.isChanged() && !this.mCustomRecyclerView.mAdapter.hasStableIds()) {
                this.removeViewAt(index);
                recycler.recycleViewHolderInternal(viewHolder);
            } else {
                this.detachViewAt(index);
                recycler.scrapView(view);
            }
        }

        void removeAndRecycleScrapInt(Recycler recycler) {
            int scrapCount = recycler.getScrapCount();
            for (int i = 0; i < scrapCount; ++i) {
                View scrap = recycler.getScrapViewAt(i);
                ViewHolder vh = CustomRecyclerView.getChildViewHolderInt(scrap);
                if (vh.shouldIgnore()) continue;
                if (vh.isTmpDetached()) {
                    this.mCustomRecyclerView.removeDetachedView(scrap, false);
                }
                recycler.quickRecycleScrapView(scrap);
            }
            recycler.clearScrap();
            if (scrapCount > 0) {
                this.mCustomRecyclerView.invalidate();
            }
        }

        public void measureChild(View child, int widthUsed, int heightUsed) {
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            Rect insets = this.mCustomRecyclerView.getItemDecorInsetsForChild(child);
            int widthSpec = LayoutManager.getChildMeasureSpec(this.getWidth(), this.getPaddingLeft() + this.getPaddingRight() + (widthUsed += insets.left + insets.right), lp.width, this.canScrollHorizontally());
            int heightSpec = LayoutManager.getChildMeasureSpec(this.getHeight(), this.getPaddingTop() + this.getPaddingBottom() + (heightUsed += insets.top + insets.bottom), lp.height, this.canScrollVertically());
            child.measure(widthSpec, heightSpec);
        }

        public void measureChildWithMargins(View child, int widthUsed, int heightUsed) {
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            Rect insets = this.mCustomRecyclerView.getItemDecorInsetsForChild(child);
            int widthSpec = LayoutManager.getChildMeasureSpec(this.getWidth(), this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin + (widthUsed += insets.left + insets.right), lp.width, this.canScrollHorizontally());
            int heightSpec = LayoutManager.getChildMeasureSpec(this.getHeight(), this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin + (heightUsed += insets.top + insets.bottom), lp.height, this.canScrollVertically());
            child.measure(widthSpec, heightSpec);
        }

        public static int getChildMeasureSpec(int parentSize, int padding, int childDimension, boolean canScroll) {
            int size = Math.max(0, parentSize - padding);
            int resultSize = 0;
            int resultMode = 0;
            if (canScroll) {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                } else {
                    resultSize = 0;
                    resultMode = 0;
                }
            } else if (childDimension >= 0) {
                resultSize = childDimension;
                resultMode = 0x40000000;
            } else if (childDimension == -1) {
                resultSize = size;
                resultMode = 0x40000000;
            } else if (childDimension == -2) {
                resultSize = size;
                resultMode = Integer.MIN_VALUE;
            }
            return View.MeasureSpec.makeMeasureSpec((int)resultSize, (int)resultMode);
        }

        public int getDecoratedMeasuredWidth(View child) {
            Rect insets = ((LayoutParams)child.getLayoutParams()).mDecorInsets;
            return child.getMeasuredWidth() + insets.left + insets.right;
        }

        public int getDecoratedMeasuredHeight(View child) {
            Rect insets = ((LayoutParams)child.getLayoutParams()).mDecorInsets;
            return child.getMeasuredHeight() + insets.top + insets.bottom;
        }

        public void layoutDecorated(View child, int left, int top, int right, int bottom) {
            Rect insets = ((LayoutParams)child.getLayoutParams()).mDecorInsets;
            child.layout(left + insets.left, top + insets.top, right - insets.right, bottom - insets.bottom);
        }

        public int getDecoratedLeft(View child) {
            return child.getLeft() - this.getLeftDecorationWidth(child);
        }

        public int getDecoratedTop(View child) {
            return child.getTop() - this.getTopDecorationHeight(child);
        }

        public int getDecoratedRight(View child) {
            return child.getRight() + this.getRightDecorationWidth(child);
        }

        public int getDecoratedBottom(View child) {
            return child.getBottom() + this.getBottomDecorationHeight(child);
        }

        public void calculateItemDecorationsForChild(View child, Rect outRect) {
            if (this.mCustomRecyclerView == null) {
                outRect.set(0, 0, 0, 0);
                return;
            }
            Rect insets = this.mCustomRecyclerView.getItemDecorInsetsForChild(child);
            outRect.set(insets);
        }

        public int getTopDecorationHeight(View child) {
            return ((LayoutParams)child.getLayoutParams()).mDecorInsets.top;
        }

        public int getBottomDecorationHeight(View child) {
            return ((LayoutParams)child.getLayoutParams()).mDecorInsets.bottom;
        }

        public int getLeftDecorationWidth(View child) {
            return ((LayoutParams)child.getLayoutParams()).mDecorInsets.left;
        }

        public int getRightDecorationWidth(View child) {
            return ((LayoutParams)child.getLayoutParams()).mDecorInsets.right;
        }

        public View onFocusSearchFailed(View focused, int direction, Recycler recycler, State state) {
            return null;
        }

        public View onInterceptFocusSearch(View focused, int direction) {
            return null;
        }

        public boolean requestChildRectangleOnScreen(CustomRecyclerView parent, View child, Rect rect, boolean immediate) {
            int dy;
            int parentLeft = this.getPaddingLeft();
            int parentTop = this.getPaddingTop();
            int parentRight = this.getWidth() - this.getPaddingRight();
            int parentBottom = this.getHeight() - this.getPaddingBottom();
            int childLeft = child.getLeft() + rect.left;
            int childTop = child.getTop() + rect.top;
            int childRight = childLeft + rect.width();
            int childBottom = childTop + rect.height();
            int offScreenLeft = Math.min(0, childLeft - parentLeft);
            int offScreenTop = Math.min(0, childTop - parentTop);
            int offScreenRight = Math.max(0, childRight - parentRight);
            int offScreenBottom = Math.max(0, childBottom - parentBottom);
            int dx = ViewCompat.getLayoutDirection((View)parent) == 1 ? (offScreenRight != 0 ? offScreenRight : offScreenLeft) : (offScreenLeft != 0 ? offScreenLeft : offScreenRight);
            int n = dy = offScreenTop != 0 ? offScreenTop : offScreenBottom;
            if (dx != 0 || dy != 0) {
                if (immediate) {
                    parent.scrollBy(dx, dy);
                } else {
                    parent.smoothScrollBy(dx, dy);
                }
                return true;
            }
            return false;
        }

        @Deprecated
        public boolean onRequestChildFocus(CustomRecyclerView parent, View child, View focused) {
            return this.isSmoothScrolling() || parent.mRunningLayoutOrScroll;
        }

        public boolean onRequestChildFocus(CustomRecyclerView parent, State state, View child, View focused) {
            return this.onRequestChildFocus(parent, child, focused);
        }

        public void onAdapterChanged(Adapter oldAdapter, Adapter newAdapter) {
        }

        public boolean onAddFocusables(CustomRecyclerView customRecyclerView, ArrayList<View> views, int direction, int focusableMode) {
            return false;
        }

        public void onItemsChanged(CustomRecyclerView customRecyclerView) {
        }

        public void onItemsAdded(CustomRecyclerView customRecyclerView, int positionStart, int itemCount) {
        }

        public void onItemsRemoved(CustomRecyclerView customRecyclerView, int positionStart, int itemCount) {
        }

        public void onItemsUpdated(CustomRecyclerView customRecyclerView, int positionStart, int itemCount) {
        }

        public void onItemsMoved(CustomRecyclerView customRecyclerView, int from, int to, int itemCount) {
        }

        public int computeHorizontalScrollExtent(State state) {
            return 0;
        }

        public int computeHorizontalScrollOffset(State state) {
            return 0;
        }

        public int computeHorizontalScrollRange(State state) {
            return 0;
        }

        public int computeVerticalScrollExtent(State state) {
            return 0;
        }

        public int computeVerticalScrollOffset(State state) {
            return 0;
        }

        public int computeVerticalScrollRange(State state) {
            return 0;
        }

        public void onMeasure(Recycler recycler, State state, int widthSpec, int heightSpec) {
            this.mCustomRecyclerView.defaultOnMeasure(widthSpec, heightSpec);
        }

        public void setMeasuredDimension(int widthSize, int heightSize) {
            this.mCustomRecyclerView.setMeasuredDimension(widthSize, heightSize);
        }

        public int getMinimumWidth() {
            return ViewCompat.getMinimumWidth((View)this.mCustomRecyclerView);
        }

        public int getMinimumHeight() {
            return ViewCompat.getMinimumHeight((View)this.mCustomRecyclerView);
        }

        public Parcelable onSaveInstanceState() {
            return null;
        }

        public void onRestoreInstanceState(Parcelable state) {
        }

        void stopSmoothScroller() {
            if (this.mSmoothScroller != null) {
                this.mSmoothScroller.stop();
            }
        }

        private void onSmoothScrollerStopped(SmoothScroller smoothScroller) {
            if (this.mSmoothScroller == smoothScroller) {
                this.mSmoothScroller = null;
            }
        }

        public void onScrollStateChanged(int state) {
        }

        public void removeAndRecycleAllViews(Recycler recycler) {
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                View view = this.getChildAt(i);
                if (CustomRecyclerView.getChildViewHolderInt(view).shouldIgnore()) continue;
                this.removeAndRecycleViewAt(i, recycler);
            }
        }

        void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfoCompat info) {
            this.onInitializeAccessibilityNodeInfo(this.mCustomRecyclerView.mRecycler, this.mCustomRecyclerView.mState, info);
        }

        public void onInitializeAccessibilityNodeInfo(Recycler recycler, State state, AccessibilityNodeInfoCompat info) {
            info.setClassName((CharSequence)CustomRecyclerView.class.getName());
            if (ViewCompat.canScrollVertically((View)this.mCustomRecyclerView, (int)-1) || ViewCompat.canScrollHorizontally((View)this.mCustomRecyclerView, (int)-1)) {
                info.addAction(8192);
                info.setScrollable(true);
            }
            if (ViewCompat.canScrollVertically((View)this.mCustomRecyclerView, (int)1) || ViewCompat.canScrollHorizontally((View)this.mCustomRecyclerView, (int)1)) {
                info.addAction(4096);
                info.setScrollable(true);
            }
            AccessibilityNodeInfoCompat.CollectionInfoCompat collectionInfo = AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain((int)this.getRowCountForAccessibility(recycler, state), (int)this.getColumnCountForAccessibility(recycler, state), (boolean)this.isLayoutHierarchical(recycler, state), (int)this.getSelectionModeForAccessibility(recycler, state));
            info.setCollectionInfo((Object)collectionInfo);
        }

        public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
            this.onInitializeAccessibilityEvent(this.mCustomRecyclerView.mRecycler, this.mCustomRecyclerView.mState, event);
        }

        public void onInitializeAccessibilityEvent(Recycler recycler, State state, AccessibilityEvent event) {
            AccessibilityRecordCompat record = AccessibilityEventCompat.asRecord((AccessibilityEvent)event);
            if (this.mCustomRecyclerView == null || record == null) {
                return;
            }
            record.setScrollable(ViewCompat.canScrollVertically((View)this.mCustomRecyclerView, (int)1) || ViewCompat.canScrollVertically((View)this.mCustomRecyclerView, (int)-1) || ViewCompat.canScrollHorizontally((View)this.mCustomRecyclerView, (int)-1) || ViewCompat.canScrollHorizontally((View)this.mCustomRecyclerView, (int)1));
            if (this.mCustomRecyclerView.mAdapter != null) {
                record.setItemCount(this.mCustomRecyclerView.mAdapter.getItemCount());
            }
        }

        void onInitializeAccessibilityNodeInfoForItem(View host, AccessibilityNodeInfoCompat info) {
            ViewHolder vh = CustomRecyclerView.getChildViewHolderInt(host);
            if (vh != null && !vh.isRemoved()) {
                this.onInitializeAccessibilityNodeInfoForItem(this.mCustomRecyclerView.mRecycler, this.mCustomRecyclerView.mState, host, info);
            }
        }

        public void onInitializeAccessibilityNodeInfoForItem(Recycler recycler, State state, View host, AccessibilityNodeInfoCompat info) {
            int rowIndexGuess = this.canScrollVertically() ? this.getPosition(host) : 0;
            int columnIndexGuess = this.canScrollHorizontally() ? this.getPosition(host) : 0;
            AccessibilityNodeInfoCompat.CollectionItemInfoCompat itemInfo = AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)rowIndexGuess, (int)1, (int)columnIndexGuess, (int)1, (boolean)false, (boolean)false);
            info.setCollectionItemInfo((Object)itemInfo);
        }

        public void requestSimpleAnimationsInNextLayout() {
            this.mRequestedSimpleAnimations = true;
        }

        public int getSelectionModeForAccessibility(Recycler recycler, State state) {
            return 0;
        }

        public int getRowCountForAccessibility(Recycler recycler, State state) {
            if (this.mCustomRecyclerView == null || this.mCustomRecyclerView.mAdapter == null) {
                return 1;
            }
            return this.canScrollVertically() ? this.mCustomRecyclerView.mAdapter.getItemCount() : 1;
        }

        public int getColumnCountForAccessibility(Recycler recycler, State state) {
            if (this.mCustomRecyclerView == null || this.mCustomRecyclerView.mAdapter == null) {
                return 1;
            }
            return this.canScrollHorizontally() ? this.mCustomRecyclerView.mAdapter.getItemCount() : 1;
        }

        public boolean isLayoutHierarchical(Recycler recycler, State state) {
            return false;
        }

        boolean performAccessibilityAction(int action, Bundle args) {
            return this.performAccessibilityAction(this.mCustomRecyclerView.mRecycler, this.mCustomRecyclerView.mState, action, args);
        }

        public boolean performAccessibilityAction(Recycler recycler, State state, int action, Bundle args) {
            if (this.mCustomRecyclerView == null) {
                return false;
            }
            int vScroll = 0;
            int hScroll = 0;
            switch (action) {
                case 8192: {
                    if (ViewCompat.canScrollVertically((View)this.mCustomRecyclerView, (int)-1)) {
                        vScroll = -(this.getHeight() - this.getPaddingTop() - this.getPaddingBottom());
                    }
                    if (!ViewCompat.canScrollHorizontally((View)this.mCustomRecyclerView, (int)-1)) break;
                    hScroll = -(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight());
                    break;
                }
                case 4096: {
                    if (ViewCompat.canScrollVertically((View)this.mCustomRecyclerView, (int)1)) {
                        vScroll = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                    }
                    if (!ViewCompat.canScrollHorizontally((View)this.mCustomRecyclerView, (int)1)) break;
                    hScroll = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
                }
            }
            if (vScroll == 0 && hScroll == 0) {
                return false;
            }
            this.mCustomRecyclerView.scrollBy(hScroll, vScroll);
            return true;
        }

        boolean performAccessibilityActionForItem(View view, int action, Bundle args) {
            return this.performAccessibilityActionForItem(this.mCustomRecyclerView.mRecycler, this.mCustomRecyclerView.mState, view, action, args);
        }

        public boolean performAccessibilityActionForItem(Recycler recycler, State state, View view, int action, Bundle args) {
            return false;
        }
    }

    public static abstract class Adapter<VH extends ViewHolder> {
        private final AdapterDataObservable mObservable = new AdapterDataObservable();
        private boolean mHasStableIds = false;

        public abstract VH onCreateViewHolder(ViewGroup var1, int var2);

        public abstract void onBindViewHolder(VH var1, int var2);

        public final VH createViewHolder(ViewGroup parent, int viewType) {
            VH holder = this.onCreateViewHolder(parent, viewType);
            ((ViewHolder)holder).mItemViewType = viewType;
            return holder;
        }

        public final void bindViewHolder(VH holder, int position) {
            ((ViewHolder)holder).mPosition = position;
            if (this.hasStableIds()) {
                ((ViewHolder)holder).mItemId = this.getItemId(position);
            }
            this.onBindViewHolder(holder, position);
            ((ViewHolder)holder).setFlags(1, 519);
        }

        public int getItemViewType(int position) {
            return 0;
        }

        public void setHasStableIds(boolean hasStableIds) {
            if (this.hasObservers()) {
                throw new IllegalStateException("Cannot change whether this adapter has stable IDs while the adapter has registered observers.");
            }
            this.mHasStableIds = hasStableIds;
        }

        public long getItemId(int position) {
            return -1L;
        }

        public abstract int getItemCount();

        public final boolean hasStableIds() {
            return this.mHasStableIds;
        }

        public void onViewRecycled(VH holder) {
        }

        public boolean onFailedToRecycleView(VH holder) {
            return false;
        }

        public void onViewAttachedToWindow(VH holder) {
        }

        public void onViewDetachedFromWindow(VH holder) {
        }

        public final boolean hasObservers() {
            return this.mObservable.hasObservers();
        }

        public void registerAdapterDataObserver(AdapterDataObserver observer) {
            this.mObservable.registerObserver(observer);
        }

        public void unregisterAdapterDataObserver(AdapterDataObserver observer) {
            this.mObservable.unregisterObserver(observer);
        }

        public void onAttachedToRecyclerView(CustomRecyclerView customRecyclerView) {
        }

        public void onDetachedFromRecyclerView(CustomRecyclerView customRecyclerView) {
        }

        public final void notifyDataSetChanged() {
            this.mObservable.notifyChanged();
        }

        public final void notifyItemChanged(int position) {
            this.mObservable.notifyItemRangeChanged(position, 1);
        }

        public final void notifyItemRangeChanged(int positionStart, int itemCount) {
            this.mObservable.notifyItemRangeChanged(positionStart, itemCount);
        }

        public final void notifyItemInserted(int position) {
            this.mObservable.notifyItemRangeInserted(position, 1);
        }

        public final void notifyItemMoved(int fromPosition, int toPosition) {
            this.mObservable.notifyItemMoved(fromPosition, toPosition);
        }

        public final void notifyItemRangeInserted(int positionStart, int itemCount) {
            this.mObservable.notifyItemRangeInserted(positionStart, itemCount);
        }

        public final void notifyItemRemoved(int position) {
            this.mObservable.notifyItemRangeRemoved(position, 1);
        }

        public final void notifyItemRangeRemoved(int positionStart, int itemCount) {
            this.mObservable.notifyItemRangeRemoved(positionStart, itemCount);
        }
    }

    public static abstract class ViewCacheExtension {
        public abstract View getViewForPositionAndType(Recycler var1, int var2, int var3);
    }

    public final class Recycler {
        final ArrayList<ViewHolder> mAttachedScrap = new ArrayList();
        private ArrayList<ViewHolder> mChangedScrap = null;
        final ArrayList<ViewHolder> mCachedViews = new ArrayList();
        private final List<ViewHolder> mUnmodifiableAttachedScrap = Collections.unmodifiableList(this.mAttachedScrap);
        private int mViewCacheMax = 2;
        private RecycledViewPool mRecyclerPool;
        private ViewCacheExtension mViewCacheExtension;
        private static final int DEFAULT_CACHE_SIZE = 2;

        public void clear() {
            this.mAttachedScrap.clear();
            this.recycleAndClearCachedViews();
        }

        public void setViewCacheSize(int viewCount) {
            this.mViewCacheMax = viewCount;
            for (int i = this.mCachedViews.size() - 1; i >= 0 && this.mCachedViews.size() > viewCount; --i) {
                this.recycleCachedViewAt(i);
            }
        }

        public List<ViewHolder> getScrapList() {
            return this.mUnmodifiableAttachedScrap;
        }

        boolean validateViewHolderForOffsetPosition(ViewHolder holder) {
            int type;
            if (holder.isRemoved()) {
                return true;
            }
            if (holder.mPosition < 0 || holder.mPosition >= CustomRecyclerView.this.mAdapter.getItemCount()) {
                throw new IndexOutOfBoundsException("Inconsistency detected. Invalid view holder adapter position" + holder);
            }
            if (!CustomRecyclerView.this.mState.isPreLayout() && (type = CustomRecyclerView.this.mAdapter.getItemViewType(holder.mPosition)) != holder.getItemViewType()) {
                return false;
            }
            if (CustomRecyclerView.this.mAdapter.hasStableIds()) {
                return holder.getItemId() == CustomRecyclerView.this.mAdapter.getItemId(holder.mPosition);
            }
            return true;
        }

        public void bindViewToPosition(View view, int position) {
            LayoutParams rvLayoutParams;
            ViewGroup.LayoutParams lp;
            ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(view);
            if (holder == null) {
                throw new IllegalArgumentException("The view does not have a ViewHolder. You cannot pass arbitrary views to this method, they should be created by the Adapter");
            }
            int offsetPosition = CustomRecyclerView.this.mAdapterHelper.findPositionOffset(position);
            if (offsetPosition < 0 || offsetPosition >= CustomRecyclerView.this.mAdapter.getItemCount()) {
                throw new IndexOutOfBoundsException("Inconsistency detected. Invalid item position " + position + "(offset:" + offsetPosition + ")." + "state:" + CustomRecyclerView.this.mState.getItemCount());
            }
            CustomRecyclerView.this.mAdapter.bindViewHolder(holder, offsetPosition);
            this.attachAccessibilityDelegate(view);
            if (CustomRecyclerView.this.mState.isPreLayout()) {
                holder.mPreLayoutPosition = position;
            }
            if ((lp = holder.itemView.getLayoutParams()) == null) {
                rvLayoutParams = (LayoutParams)CustomRecyclerView.this.generateDefaultLayoutParams();
                holder.itemView.setLayoutParams((ViewGroup.LayoutParams)rvLayoutParams);
            } else if (!CustomRecyclerView.this.checkLayoutParams(lp)) {
                rvLayoutParams = (LayoutParams)CustomRecyclerView.this.generateLayoutParams(lp);
                holder.itemView.setLayoutParams((ViewGroup.LayoutParams)rvLayoutParams);
            } else {
                rvLayoutParams = (LayoutParams)lp;
            }
            rvLayoutParams.mInsetsDirty = true;
            rvLayoutParams.mViewHolder = holder;
            rvLayoutParams.mPendingInvalidate = holder.itemView.getParent() == null;
        }

        public int convertPreLayoutPositionToPostLayout(int position) {
            if (position < 0 || position >= CustomRecyclerView.this.mState.getItemCount()) {
                throw new IndexOutOfBoundsException("invalid position " + position + ". State " + "item count is " + CustomRecyclerView.this.mState.getItemCount());
            }
            if (!CustomRecyclerView.this.mState.isPreLayout()) {
                return position;
            }
            return CustomRecyclerView.this.mAdapterHelper.findPositionOffset(position);
        }

        public View getViewForPosition(int position) {
            return this.getViewForPosition(position, false);
        }

        View getViewForPosition(int position, boolean dryRun) {
            LayoutParams rvLayoutParams;
            if (position < 0 || position >= CustomRecyclerView.this.mState.getItemCount()) {
                throw new IndexOutOfBoundsException("Invalid item position " + position + "(" + position + "). Item count:" + CustomRecyclerView.this.mState.getItemCount());
            }
            boolean fromScrap = false;
            ViewHolder holder = null;
            if (CustomRecyclerView.this.mState.isPreLayout()) {
                holder = this.getChangedScrapViewForPosition(position);
                boolean bl = fromScrap = holder != null;
            }
            if (holder == null && (holder = this.getScrapViewForPosition(position, -1, dryRun)) != null) {
                if (!this.validateViewHolderForOffsetPosition(holder)) {
                    if (!dryRun) {
                        holder.addFlags(4);
                        if (holder.isScrap()) {
                            CustomRecyclerView.this.removeDetachedView(holder.itemView, false);
                            holder.unScrap();
                        } else if (holder.wasReturnedFromScrap()) {
                            holder.clearReturnedFromScrapFlag();
                        }
                        this.recycleViewHolderInternal(holder);
                    }
                    holder = null;
                } else {
                    fromScrap = true;
                }
            }
            if (holder == null) {
                View view;
                int offsetPosition = CustomRecyclerView.this.mAdapterHelper.findPositionOffset(position);
                if (offsetPosition < 0 || offsetPosition >= CustomRecyclerView.this.mAdapter.getItemCount()) {
                    throw new IndexOutOfBoundsException("Inconsistency detected. Invalid item position " + position + "(offset:" + offsetPosition + ")." + "state:" + CustomRecyclerView.this.mState.getItemCount());
                }
                int type = CustomRecyclerView.this.mAdapter.getItemViewType(offsetPosition);
                if (CustomRecyclerView.this.mAdapter.hasStableIds() && (holder = this.getScrapViewForId(CustomRecyclerView.this.mAdapter.getItemId(offsetPosition), type, dryRun)) != null) {
                    holder.mPosition = offsetPosition;
                    fromScrap = true;
                }
                if (holder == null && this.mViewCacheExtension != null && (view = this.mViewCacheExtension.getViewForPositionAndType(this, position, type)) != null) {
                    holder = CustomRecyclerView.this.getChildViewHolder(view);
                    if (holder == null) {
                        throw new IllegalArgumentException("getViewForPositionAndType returned a view which does not have a ViewHolder");
                    }
                    if (holder.shouldIgnore()) {
                        throw new IllegalArgumentException("getViewForPositionAndType returned a view that is ignored. You must call stopIgnoring before returning this view.");
                    }
                }
                if (holder == null && (holder = this.getRecycledViewPool().getRecycledView(CustomRecyclerView.this.mAdapter.getItemViewType(offsetPosition))) != null) {
                    holder.resetInternal();
                    if (FORCE_INVALIDATE_DISPLAY_LIST) {
                        this.invalidateDisplayListInt(holder);
                    }
                }
                if (holder == null) {
                    holder = CustomRecyclerView.this.mAdapter.createViewHolder(CustomRecyclerView.this, CustomRecyclerView.this.mAdapter.getItemViewType(offsetPosition));
                }
            }
            boolean bound = false;
            if (CustomRecyclerView.this.mState.isPreLayout() && holder.isBound()) {
                holder.mPreLayoutPosition = position;
            } else if (!holder.isBound() || holder.needsUpdate() || holder.isInvalid()) {
                int offsetPosition = CustomRecyclerView.this.mAdapterHelper.findPositionOffset(position);
                CustomRecyclerView.this.mAdapter.bindViewHolder(holder, offsetPosition);
                this.attachAccessibilityDelegate(holder.itemView);
                bound = true;
                if (CustomRecyclerView.this.mState.isPreLayout()) {
                    holder.mPreLayoutPosition = position;
                }
            }
            ViewGroup.LayoutParams lp = holder.itemView.getLayoutParams();
            if (lp == null) {
                rvLayoutParams = (LayoutParams)CustomRecyclerView.this.generateDefaultLayoutParams();
                holder.itemView.setLayoutParams((ViewGroup.LayoutParams)rvLayoutParams);
            } else if (!CustomRecyclerView.this.checkLayoutParams(lp)) {
                rvLayoutParams = (LayoutParams)CustomRecyclerView.this.generateLayoutParams(lp);
                holder.itemView.setLayoutParams((ViewGroup.LayoutParams)rvLayoutParams);
            } else {
                rvLayoutParams = (LayoutParams)lp;
            }
            rvLayoutParams.mViewHolder = holder;
            rvLayoutParams.mPendingInvalidate = fromScrap && bound;
            return holder.itemView;
        }

        private void attachAccessibilityDelegate(View itemView) {
            if (CustomRecyclerView.this.mAccessibilityManager != null && CustomRecyclerView.this.mAccessibilityManager.isEnabled()) {
                if (ViewCompat.getImportantForAccessibility((View)itemView) == 0) {
                    ViewCompat.setImportantForAccessibility((View)itemView, (int)1);
                }
                if (!ViewCompat.hasAccessibilityDelegate((View)itemView)) {
                    ViewCompat.setAccessibilityDelegate((View)itemView, (AccessibilityDelegateCompat)CustomRecyclerView.this.mAccessibilityDelegate.getItemDelegate());
                }
            }
        }

        private void invalidateDisplayListInt(ViewHolder holder) {
            if (holder.itemView instanceof ViewGroup) {
                this.invalidateDisplayListInt((ViewGroup)holder.itemView, false);
            }
        }

        private void invalidateDisplayListInt(ViewGroup viewGroup, boolean invalidateThis) {
            for (int i = viewGroup.getChildCount() - 1; i >= 0; --i) {
                View view = viewGroup.getChildAt(i);
                if (!(view instanceof ViewGroup)) continue;
                this.invalidateDisplayListInt((ViewGroup)view, true);
            }
            if (!invalidateThis) {
                return;
            }
            if (viewGroup.getVisibility() == 4) {
                viewGroup.setVisibility(0);
                viewGroup.setVisibility(4);
            } else {
                int visibility = viewGroup.getVisibility();
                viewGroup.setVisibility(4);
                viewGroup.setVisibility(visibility);
            }
        }

        public void recycleView(View view) {
            ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(view);
            if (holder.isTmpDetached()) {
                CustomRecyclerView.this.removeDetachedView(view, false);
            }
            if (holder.isScrap()) {
                holder.unScrap();
            } else if (holder.wasReturnedFromScrap()) {
                holder.clearReturnedFromScrapFlag();
            }
            this.recycleViewHolderInternal(holder);
        }

        void recycleViewInternal(View view) {
            this.recycleViewHolderInternal(CustomRecyclerView.getChildViewHolderInt(view));
        }

        void recycleAndClearCachedViews() {
            int count = this.mCachedViews.size();
            for (int i = count - 1; i >= 0; --i) {
                this.recycleCachedViewAt(i);
            }
            this.mCachedViews.clear();
        }

        void recycleCachedViewAt(int cachedViewIndex) {
            ViewHolder viewHolder = this.mCachedViews.get(cachedViewIndex);
            this.addViewHolderToRecycledViewPool(viewHolder);
            this.mCachedViews.remove(cachedViewIndex);
        }

        void recycleViewHolderInternal(ViewHolder holder) {
            boolean forceRecycle;
            if (holder.isScrap() || holder.itemView.getParent() != null) {
                throw new IllegalArgumentException("Scrapped or attached views may not be recycled. isScrap:" + holder.isScrap() + " isAttached:" + (holder.itemView.getParent() != null));
            }
            if (holder.isTmpDetached()) {
                throw new IllegalArgumentException("Tmp detached view should be removed from RecyclerView before it can be recycled: " + holder);
            }
            if (holder.shouldIgnore()) {
                throw new IllegalArgumentException("Trying to recycle an ignored view holder. You should first call stopIgnoringView(view) before calling recycle.");
            }
            boolean bl = forceRecycle = CustomRecyclerView.this.mAdapter != null && holder.doesTransientStatePreventRecycling() && CustomRecyclerView.this.mAdapter.onFailedToRecycleView(holder);
            if (forceRecycle || holder.isRecyclable()) {
                boolean cached = false;
                if (!(holder.isInvalid() || !CustomRecyclerView.this.mState.mInPreLayout && holder.isRemoved() || holder.isChanged())) {
                    int cachedViewSize = this.mCachedViews.size();
                    if (cachedViewSize == this.mViewCacheMax && cachedViewSize > 0) {
                        this.recycleCachedViewAt(0);
                    }
                    if (cachedViewSize < this.mViewCacheMax) {
                        this.mCachedViews.add(holder);
                        cached = true;
                    }
                }
                if (!cached) {
                    this.addViewHolderToRecycledViewPool(holder);
                }
            }
            CustomRecyclerView.this.mState.onViewRecycled(holder);
        }

        void addViewHolderToRecycledViewPool(ViewHolder holder) {
            ViewCompat.setAccessibilityDelegate((View)holder.itemView, null);
            this.getRecycledViewPool().putRecycledView(holder);
            this.dispatchViewRecycled(holder);
        }

        void quickRecycleScrapView(View view) {
            ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(view);
            holder.mScrapContainer = null;
            holder.clearReturnedFromScrapFlag();
            this.recycleViewHolderInternal(holder);
        }

        void scrapView(View view) {
            ViewHolder holder = CustomRecyclerView.getChildViewHolderInt(view);
            holder.setScrapContainer(this);
            if (!holder.isChanged() || !CustomRecyclerView.this.supportsChangeAnimations()) {
                if (holder.isInvalid() && !holder.isRemoved() && !CustomRecyclerView.this.mAdapter.hasStableIds()) {
                    throw new IllegalArgumentException("Called scrap view with an invalid view. Invalid views cannot be reused from scrap, they should rebound from recycler pool.");
                }
                this.mAttachedScrap.add(holder);
            } else {
                if (this.mChangedScrap == null) {
                    this.mChangedScrap = new ArrayList();
                }
                this.mChangedScrap.add(holder);
            }
        }

        void unscrapView(ViewHolder holder) {
            if (!holder.isChanged() || !CustomRecyclerView.this.supportsChangeAnimations() || this.mChangedScrap == null) {
                this.mAttachedScrap.remove(holder);
            } else {
                this.mChangedScrap.remove(holder);
            }
            holder.mScrapContainer = null;
            holder.clearReturnedFromScrapFlag();
        }

        int getScrapCount() {
            return this.mAttachedScrap.size();
        }

        View getScrapViewAt(int index) {
            return this.mAttachedScrap.get((int)index).itemView;
        }

        void clearScrap() {
            this.mAttachedScrap.clear();
        }

        ViewHolder getChangedScrapViewForPosition(int position) {
            int offsetPosition;
            int changedScrapSize;
            if (this.mChangedScrap == null || (changedScrapSize = this.mChangedScrap.size()) == 0) {
                return null;
            }
            for (int i = 0; i < changedScrapSize; ++i) {
                ViewHolder holder = this.mChangedScrap.get(i);
                if (holder.wasReturnedFromScrap() || holder.getLayoutPosition() != position) continue;
                holder.addFlags(32);
                return holder;
            }
            if (CustomRecyclerView.this.mAdapter.hasStableIds() && (offsetPosition = CustomRecyclerView.this.mAdapterHelper.findPositionOffset(position)) > 0 && offsetPosition < CustomRecyclerView.this.mAdapter.getItemCount()) {
                long id = CustomRecyclerView.this.mAdapter.getItemId(offsetPosition);
                for (int i = 0; i < changedScrapSize; ++i) {
                    ViewHolder holder = this.mChangedScrap.get(i);
                    if (holder.wasReturnedFromScrap() || holder.getItemId() != id) continue;
                    holder.addFlags(32);
                    return holder;
                }
            }
            return null;
        }

        ViewHolder getScrapViewForPosition(int position, int type, boolean dryRun) {
            View view;
            int scrapCount = this.mAttachedScrap.size();
            for (int i = 0; i < scrapCount; ++i) {
                ViewHolder holder = this.mAttachedScrap.get(i);
                if (holder.wasReturnedFromScrap() || holder.getLayoutPosition() != position || holder.isInvalid() || !CustomRecyclerView.this.mState.mInPreLayout && holder.isRemoved()) continue;
                if (type != -1 && holder.getItemViewType() != type) {
                    Log.e((String)CustomRecyclerView.TAG, (String)("Scrap view for position " + position + " isn't dirty but has" + " wrong view type! (found " + holder.getItemViewType() + " but expected " + type + ")"));
                    break;
                }
                holder.addFlags(32);
                return holder;
            }
            if (!dryRun && (view = CustomRecyclerView.this.mChildHelper.findHiddenNonRemovedView(position, type)) != null) {
                CustomRecyclerView.this.mItemAnimator.endAnimation(CustomRecyclerView.this.getChildViewHolder(view));
            }
            int cacheSize = this.mCachedViews.size();
            for (int i = 0; i < cacheSize; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder.isInvalid() || holder.getLayoutPosition() != position) continue;
                if (!dryRun) {
                    this.mCachedViews.remove(i);
                }
                return holder;
            }
            return null;
        }

        ViewHolder getScrapViewForId(long id, int type, boolean dryRun) {
            int count = this.mAttachedScrap.size();
            for (int i = count - 1; i >= 0; --i) {
                ViewHolder holder = this.mAttachedScrap.get(i);
                if (holder.getItemId() != id || holder.wasReturnedFromScrap()) continue;
                if (type == holder.getItemViewType()) {
                    holder.addFlags(32);
                    if (holder.isRemoved() && !CustomRecyclerView.this.mState.isPreLayout()) {
                        holder.setFlags(2, 14);
                    }
                    return holder;
                }
                if (dryRun) continue;
                this.mAttachedScrap.remove(i);
                CustomRecyclerView.this.removeDetachedView(holder.itemView, false);
                this.quickRecycleScrapView(holder.itemView);
            }
            int cacheSize = this.mCachedViews.size();
            for (int i = cacheSize - 1; i >= 0; --i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder.getItemId() != id) continue;
                if (type == holder.getItemViewType()) {
                    if (!dryRun) {
                        this.mCachedViews.remove(i);
                    }
                    return holder;
                }
                if (dryRun) continue;
                this.recycleCachedViewAt(i);
            }
            return null;
        }

        void dispatchViewRecycled(ViewHolder holder) {
            if (CustomRecyclerView.this.mRecyclerListener != null) {
                CustomRecyclerView.this.mRecyclerListener.onViewRecycled(holder);
            }
            if (CustomRecyclerView.this.mAdapter != null) {
                CustomRecyclerView.this.mAdapter.onViewRecycled(holder);
            }
            if (CustomRecyclerView.this.mState != null) {
                CustomRecyclerView.this.mState.onViewRecycled(holder);
            }
        }

        void onAdapterChanged(Adapter oldAdapter, Adapter newAdapter, boolean compatibleWithPrevious) {
            this.clear();
            this.getRecycledViewPool().onAdapterChanged(oldAdapter, newAdapter, compatibleWithPrevious);
        }

        void offsetPositionRecordsForMove(int from, int to) {
            int inBetweenOffset;
            int end;
            int start;
            if (from < to) {
                start = from;
                end = to;
                inBetweenOffset = -1;
            } else {
                start = to;
                end = from;
                inBetweenOffset = 1;
            }
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null || holder.mPosition < start || holder.mPosition > end) continue;
                if (holder.mPosition == from) {
                    holder.offsetPosition(to - from, false);
                    continue;
                }
                holder.offsetPosition(inBetweenOffset, false);
            }
        }

        void offsetPositionRecordsForInsert(int insertedAt, int count) {
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null || holder.getLayoutPosition() < insertedAt) continue;
                holder.offsetPosition(count, true);
            }
        }

        void offsetPositionRecordsForRemove(int removedFrom, int count, boolean applyToPreLayout) {
            int removedEnd = removedFrom + count;
            int cachedCount = this.mCachedViews.size();
            for (int i = cachedCount - 1; i >= 0; --i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null) continue;
                if (holder.getLayoutPosition() >= removedEnd) {
                    holder.offsetPosition(-count, applyToPreLayout);
                    continue;
                }
                if (holder.getLayoutPosition() < removedFrom) continue;
                this.recycleCachedViewAt(i);
            }
        }

        void setViewCacheExtension(ViewCacheExtension extension) {
            this.mViewCacheExtension = extension;
        }

        void setRecycledViewPool(RecycledViewPool pool) {
            if (this.mRecyclerPool != null) {
                this.mRecyclerPool.detach();
            }
            this.mRecyclerPool = pool;
            if (pool != null) {
                this.mRecyclerPool.attach(CustomRecyclerView.this.getAdapter());
            }
        }

        RecycledViewPool getRecycledViewPool() {
            if (this.mRecyclerPool == null) {
                this.mRecyclerPool = new RecycledViewPool();
            }
            return this.mRecyclerPool;
        }

        void viewRangeUpdate(int positionStart, int itemCount) {
            int positionEnd = positionStart + itemCount;
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                int pos;
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null || (pos = holder.getLayoutPosition()) < positionStart || pos >= positionEnd) continue;
                holder.addFlags(2);
            }
        }

        void setAdapterPositionsAsUnknown() {
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                if (holder == null) continue;
                holder.addFlags(512);
            }
        }

        void markKnownViewsInvalid() {
            if (CustomRecyclerView.this.mAdapter != null && CustomRecyclerView.this.mAdapter.hasStableIds()) {
                int cachedCount = this.mCachedViews.size();
                for (int i = 0; i < cachedCount; ++i) {
                    ViewHolder holder = this.mCachedViews.get(i);
                    if (holder == null) continue;
                    holder.addFlags(6);
                }
            } else {
                this.recycleAndClearCachedViews();
            }
        }

        void clearOldPositions() {
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                holder.clearOldPosition();
            }
            int scrapCount = this.mAttachedScrap.size();
            for (int i = 0; i < scrapCount; ++i) {
                this.mAttachedScrap.get(i).clearOldPosition();
            }
            if (this.mChangedScrap != null) {
                int changedScrapCount = this.mChangedScrap.size();
                for (int i = 0; i < changedScrapCount; ++i) {
                    this.mChangedScrap.get(i).clearOldPosition();
                }
            }
        }

        void markItemDecorInsetsDirty() {
            int cachedCount = this.mCachedViews.size();
            for (int i = 0; i < cachedCount; ++i) {
                ViewHolder holder = this.mCachedViews.get(i);
                LayoutParams layoutParams = (LayoutParams)holder.itemView.getLayoutParams();
                if (layoutParams == null) continue;
                layoutParams.mInsetsDirty = true;
            }
        }
    }

    public static class RecycledViewPool {
        private SparseArray<ArrayList<ViewHolder>> mScrap = new SparseArray();
        private SparseIntArray mMaxScrap = new SparseIntArray();
        private int mAttachCount = 0;
        private static final int DEFAULT_MAX_SCRAP = 5;

        public void clear() {
            this.mScrap.clear();
        }

        public void setMaxRecycledViews(int viewType, int max) {
            this.mMaxScrap.put(viewType, max);
            ArrayList scrapHeap = (ArrayList)this.mScrap.get(viewType);
            if (scrapHeap != null) {
                while (scrapHeap.size() > max) {
                    scrapHeap.remove(scrapHeap.size() - 1);
                }
            }
        }

        public ViewHolder getRecycledView(int viewType) {
            ArrayList scrapHeap = (ArrayList)this.mScrap.get(viewType);
            if (scrapHeap != null && !scrapHeap.isEmpty()) {
                int index = scrapHeap.size() - 1;
                ViewHolder scrap = (ViewHolder)scrapHeap.get(index);
                scrapHeap.remove(index);
                return scrap;
            }
            return null;
        }

        int size() {
            int count = 0;
            for (int i = 0; i < this.mScrap.size(); ++i) {
                ArrayList viewHolders = (ArrayList)this.mScrap.valueAt(i);
                if (viewHolders == null) continue;
                count += viewHolders.size();
            }
            return count;
        }

        public void putRecycledView(ViewHolder scrap) {
            int viewType = scrap.getItemViewType();
            ArrayList<ViewHolder> scrapHeap = this.getScrapHeapForType(viewType);
            if (this.mMaxScrap.get(viewType) <= scrapHeap.size()) {
                return;
            }
            scrap.resetInternal();
            scrapHeap.add(scrap);
        }

        void attach(Adapter adapter) {
            ++this.mAttachCount;
        }

        void detach() {
            --this.mAttachCount;
        }

        void onAdapterChanged(Adapter oldAdapter, Adapter newAdapter, boolean compatibleWithPrevious) {
            if (oldAdapter != null) {
                this.detach();
            }
            if (!compatibleWithPrevious && this.mAttachCount == 0) {
                this.clear();
            }
            if (newAdapter != null) {
                this.attach(newAdapter);
            }
        }

        private ArrayList<ViewHolder> getScrapHeapForType(int viewType) {
            ArrayList scrap = (ArrayList)this.mScrap.get(viewType);
            if (scrap == null) {
                scrap = new ArrayList();
                this.mScrap.put(viewType, scrap);
                if (this.mMaxScrap.indexOfKey(viewType) < 0) {
                    this.mMaxScrap.put(viewType, 5);
                }
            }
            return scrap;
        }
    }

    private class RecyclerViewDataObserver
    extends AdapterDataObserver {
        private RecyclerViewDataObserver() {
        }

        @Override
        public void onChanged() {
            CustomRecyclerView.this.assertNotInLayoutOrScroll(null);
            if (CustomRecyclerView.this.mAdapter.hasStableIds()) {
                CustomRecyclerView.this.mState.mStructureChanged = true;
                CustomRecyclerView.this.setDataSetChangedAfterLayout();
            } else {
                CustomRecyclerView.this.mState.mStructureChanged = true;
                CustomRecyclerView.this.setDataSetChangedAfterLayout();
            }
            if (!CustomRecyclerView.this.mAdapterHelper.hasPendingUpdates()) {
                CustomRecyclerView.this.requestLayout();
            }
        }

        @Override
        public void onItemRangeChanged(int positionStart, int itemCount) {
            CustomRecyclerView.this.assertNotInLayoutOrScroll(null);
            if (CustomRecyclerView.this.mAdapterHelper.onItemRangeChanged(positionStart, itemCount)) {
                this.triggerUpdateProcessor();
            }
        }

        @Override
        public void onItemRangeInserted(int positionStart, int itemCount) {
            CustomRecyclerView.this.assertNotInLayoutOrScroll(null);
            if (CustomRecyclerView.this.mAdapterHelper.onItemRangeInserted(positionStart, itemCount)) {
                this.triggerUpdateProcessor();
            }
        }

        @Override
        public void onItemRangeRemoved(int positionStart, int itemCount) {
            CustomRecyclerView.this.assertNotInLayoutOrScroll(null);
            if (CustomRecyclerView.this.mAdapterHelper.onItemRangeRemoved(positionStart, itemCount)) {
                this.triggerUpdateProcessor();
            }
        }

        @Override
        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            CustomRecyclerView.this.assertNotInLayoutOrScroll(null);
            if (CustomRecyclerView.this.mAdapterHelper.onItemRangeMoved(fromPosition, toPosition, itemCount)) {
                this.triggerUpdateProcessor();
            }
        }

        void triggerUpdateProcessor() {
            if (CustomRecyclerView.this.mPostUpdatesOnAnimation && CustomRecyclerView.this.mHasFixedSize && CustomRecyclerView.this.mIsAttached) {
                ViewCompat.postOnAnimation((View)CustomRecyclerView.this, (Runnable)CustomRecyclerView.this.mUpdateChildViewsRunnable);
            } else {
                CustomRecyclerView.this.mAdapterUpdateDuringMeasure = true;
                CustomRecyclerView.this.requestLayout();
            }
        }
    }

    private class ViewFlinger
    implements Runnable {
        private int mLastFlingX;
        private int mLastFlingY;
        private ScrollerCompat mScroller;
        private Interpolator mInterpolator = CustomRecyclerView.access$2000();
        private boolean mEatRunOnAnimationRequest = false;
        private boolean mReSchedulePostAnimationCallback = false;

        public ViewFlinger() {
            this.mScroller = ScrollerCompat.create((Context)CustomRecyclerView.this.getContext(), (Interpolator)sQuinticInterpolator);
        }

        @Override
        public void run() {
            this.disableRunOnAnimationRequests();
            CustomRecyclerView.this.consumePendingUpdateOperations();
            ScrollerCompat scroller = this.mScroller;
            SmoothScroller smoothScroller = ((CustomRecyclerView)CustomRecyclerView.this).mLayout.mSmoothScroller;
            if (scroller.computeScrollOffset()) {
                boolean fullyConsumedAny;
                int x = scroller.getCurrX();
                int y = scroller.getCurrY();
                int dx = x - this.mLastFlingX;
                int dy = y - this.mLastFlingY;
                int hresult = 0;
                int vresult = 0;
                this.mLastFlingX = x;
                this.mLastFlingY = y;
                int overscrollX = 0;
                int overscrollY = 0;
                if (CustomRecyclerView.this.mAdapter != null) {
                    CustomRecyclerView.this.eatRequestLayout();
                    CustomRecyclerView.this.mRunningLayoutOrScroll = true;
                    if (dx != 0) {
                        hresult = CustomRecyclerView.this.mLayout.scrollHorizontallyBy(dx, CustomRecyclerView.this.mRecycler, CustomRecyclerView.this.mState);
                        overscrollX = dx - hresult;
                    }
                    if (dy != 0) {
                        vresult = CustomRecyclerView.this.mLayout.scrollVerticallyBy(dy, CustomRecyclerView.this.mRecycler, CustomRecyclerView.this.mState);
                        overscrollY = dy - vresult;
                    }
                    if (CustomRecyclerView.this.supportsChangeAnimations()) {
                        int count = CustomRecyclerView.this.mChildHelper.getChildCount();
                        for (int i = 0; i < count; ++i) {
                            View view = CustomRecyclerView.this.mChildHelper.getChildAt(i);
                            ViewHolder holder = CustomRecyclerView.this.getChildViewHolder(view);
                            if (holder == null || holder.mShadowingHolder == null) continue;
                            View shadowingView = holder.mShadowingHolder.itemView;
                            int left = view.getLeft();
                            int top = view.getTop();
                            if (left == shadowingView.getLeft() && top == shadowingView.getTop()) continue;
                            shadowingView.layout(left, top, left + shadowingView.getWidth(), top + shadowingView.getHeight());
                        }
                    }
                    if (smoothScroller != null && !smoothScroller.isPendingInitialRun() && smoothScroller.isRunning()) {
                        int adapterSize = CustomRecyclerView.this.mState.getItemCount();
                        if (adapterSize == 0) {
                            smoothScroller.stop();
                        } else if (smoothScroller.getTargetPosition() >= adapterSize) {
                            smoothScroller.setTargetPosition(adapterSize - 1);
                            smoothScroller.onAnimation(dx - overscrollX, dy - overscrollY);
                        } else {
                            smoothScroller.onAnimation(dx - overscrollX, dy - overscrollY);
                        }
                    }
                    CustomRecyclerView.this.mRunningLayoutOrScroll = false;
                    CustomRecyclerView.this.resumeRequestLayout(false);
                }
                if (!CustomRecyclerView.this.mItemDecorations.isEmpty()) {
                    CustomRecyclerView.this.invalidate();
                }
                if (ViewCompat.getOverScrollMode((View)CustomRecyclerView.this) != 2) {
                    CustomRecyclerView.this.considerReleasingGlowsOnScroll(dx, dy);
                }
                if (overscrollX != 0 || overscrollY != 0) {
                    int vel = (int)scroller.getCurrVelocity();
                    int velX = 0;
                    if (overscrollX != x) {
                        velX = overscrollX < 0 ? -vel : (overscrollX > 0 ? vel : 0);
                    }
                    int velY = 0;
                    if (overscrollY != y) {
                        int n = overscrollY < 0 ? -vel : (velY = overscrollY > 0 ? vel : 0);
                    }
                    if (ViewCompat.getOverScrollMode((View)CustomRecyclerView.this) != 2) {
                        CustomRecyclerView.this.absorbGlows(velX, velY);
                    }
                    if (!(velX == 0 && overscrollX != x && scroller.getFinalX() != 0 || velY == 0 && overscrollY != y && scroller.getFinalY() != 0)) {
                        scroller.abortAnimation();
                    }
                }
                if (hresult != 0 || vresult != 0) {
                    CustomRecyclerView.this.notifyOnScrolled(hresult, vresult);
                }
                if (!CustomRecyclerView.this.awakenScrollBars()) {
                    CustomRecyclerView.this.invalidate();
                }
                boolean fullyConsumedVertical = dy != 0 && CustomRecyclerView.this.mLayout.canScrollVertically() && vresult == dy;
                boolean fullyConsumedHorizontal = dx != 0 && CustomRecyclerView.this.mLayout.canScrollHorizontally() && hresult == dx;
                boolean bl = fullyConsumedAny = dx == 0 && dy == 0 || fullyConsumedHorizontal || fullyConsumedVertical;
                if (scroller.isFinished() || !fullyConsumedAny) {
                    CustomRecyclerView.this.setScrollState(0);
                } else {
                    this.postOnAnimation();
                }
            }
            if (smoothScroller != null && smoothScroller.isPendingInitialRun()) {
                smoothScroller.onAnimation(0, 0);
            }
            this.enableRunOnAnimationRequests();
        }

        private void disableRunOnAnimationRequests() {
            this.mReSchedulePostAnimationCallback = false;
            this.mEatRunOnAnimationRequest = true;
        }

        private void enableRunOnAnimationRequests() {
            this.mEatRunOnAnimationRequest = false;
            if (this.mReSchedulePostAnimationCallback) {
                this.postOnAnimation();
            }
        }

        void postOnAnimation() {
            if (this.mEatRunOnAnimationRequest) {
                this.mReSchedulePostAnimationCallback = true;
            } else {
                CustomRecyclerView.this.removeCallbacks(this);
                ViewCompat.postOnAnimation((View)CustomRecyclerView.this, (Runnable)this);
            }
        }

        public void fling(int velocityX, int velocityY) {
            CustomRecyclerView.this.setScrollState(2);
            this.mLastFlingY = 0;
            this.mLastFlingX = 0;
            this.mScroller.fling(0, 0, velocityX, velocityY, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.postOnAnimation();
        }

        public void smoothScrollBy(int dx, int dy) {
            this.smoothScrollBy(dx, dy, 0, 0);
        }

        public void smoothScrollBy(int dx, int dy, int vx, int vy) {
            this.smoothScrollBy(dx, dy, this.computeScrollDuration(dx, dy, vx, vy));
        }

        private float distanceInfluenceForSnapDuration(float f) {
            f -= 0.5f;
            f = (float)((double)f * 0.4712389167638204);
            return (float)Math.sin(f);
        }

        private int computeScrollDuration(int dx, int dy, int vx, int vy) {
            int duration;
            int absDy;
            int absDx = Math.abs(dx);
            boolean horizontal = absDx > (absDy = Math.abs(dy));
            int velocity = (int)Math.sqrt(vx * vx + vy * vy);
            int delta = (int)Math.sqrt(dx * dx + dy * dy);
            int containerSize = horizontal ? CustomRecyclerView.this.getWidth() : CustomRecyclerView.this.getHeight();
            int halfContainerSize = containerSize / 2;
            float distanceRatio = Math.min(1.0f, 1.0f * (float)delta / (float)containerSize);
            float distance = (float)halfContainerSize + (float)halfContainerSize * this.distanceInfluenceForSnapDuration(distanceRatio);
            if (velocity > 0) {
                duration = 4 * Math.round(1000.0f * Math.abs(distance / (float)velocity));
            } else {
                float absDelta = horizontal ? absDx : absDy;
                duration = (int)((absDelta / (float)containerSize + 1.0f) * 300.0f);
            }
            return Math.min(duration, 2000);
        }

        public void smoothScrollBy(int dx, int dy, int duration) {
            this.smoothScrollBy(dx, dy, duration, sQuinticInterpolator);
        }

        public void smoothScrollBy(int dx, int dy, int duration, Interpolator interpolator) {
            if (this.mInterpolator != interpolator) {
                this.mInterpolator = interpolator;
                this.mScroller = ScrollerCompat.create((Context)CustomRecyclerView.this.getContext(), (Interpolator)interpolator);
            }
            CustomRecyclerView.this.setScrollState(2);
            this.mLastFlingY = 0;
            this.mLastFlingX = 0;
            this.mScroller.startScroll(0, 0, dx, dy, duration);
            this.postOnAnimation();
        }

        public void stop() {
            CustomRecyclerView.this.removeCallbacks(this);
            this.mScroller.abortAnimation();
        }
    }
}

