/*
 * Decompiled with CFR 0.152.
 */
package com.custom_recycler_view;

import android.content.Context;
import android.graphics.PointF;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.accessibility.AccessibilityEventCompat;
import android.support.v4.view.accessibility.AccessibilityRecordCompat;
import android.util.Log;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import com.custom_recycler_view.CustomRecyclerView;
import com.custom_recycler_view.LinearSmoothScroller;
import com.custom_recycler_view.OrientationHelper;
import com.custom_recycler_view.ScrollbarHelper;
import java.util.List;

public class CustomLinearLayoutManager
extends CustomRecyclerView.LayoutManager {
    private static final String TAG = "CustomLinearLayoutManager";
    private static final boolean DEBUG = false;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int INVALID_OFFSET = Integer.MIN_VALUE;
    private static final float MAX_SCROLL_FACTOR = 0.33f;
    int mOrientation;
    private LayoutState mLayoutState;
    OrientationHelper mOrientationHelper;
    private boolean mLastStackFromEnd;
    private boolean mReverseLayout = false;
    boolean mShouldReverseLayout = false;
    private boolean mStackFromEnd = false;
    private boolean mSmoothScrollbarEnabled = true;
    int mPendingScrollPosition = -1;
    int mPendingScrollPositionOffset = Integer.MIN_VALUE;
    private boolean mRecycleChildrenOnDetach;
    SavedState mPendingSavedState = null;
    final AnchorInfo mAnchorInfo = new AnchorInfo();

    public CustomLinearLayoutManager(Context context) {
        this(context, 1, false);
    }

    public CustomLinearLayoutManager(Context context, int orientation, boolean reverseLayout) {
        this.setOrientation(orientation);
        this.setReverseLayout(reverseLayout);
    }

    @Override
    public CustomRecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new CustomRecyclerView.LayoutParams(-2, -2);
    }

    public boolean getRecycleChildrenOnDetach() {
        return this.mRecycleChildrenOnDetach;
    }

    public void setRecycleChildrenOnDetach(boolean recycleChildrenOnDetach) {
        this.mRecycleChildrenOnDetach = recycleChildrenOnDetach;
    }

    @Override
    public void onDetachedFromWindow(CustomRecyclerView view, CustomRecyclerView.Recycler recycler) {
        super.onDetachedFromWindow(view, recycler);
        if (this.mRecycleChildrenOnDetach) {
            this.removeAndRecycleAllViews(recycler);
            recycler.clear();
        }
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        if (this.getChildCount() > 0) {
            AccessibilityRecordCompat record = AccessibilityEventCompat.asRecord((AccessibilityEvent)event);
            record.setFromIndex(this.findFirstVisibleItemPosition());
            record.setToIndex(this.findLastVisibleItemPosition());
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        if (this.mPendingSavedState != null) {
            return new SavedState(this.mPendingSavedState);
        }
        SavedState state = new SavedState();
        if (this.getChildCount() > 0) {
            boolean didLayoutFromEnd;
            this.ensureLayoutState();
            state.mAnchorLayoutFromEnd = didLayoutFromEnd = this.mLastStackFromEnd ^ this.mShouldReverseLayout;
            if (didLayoutFromEnd) {
                View refChild = this.getChildClosestToEnd();
                state.mAnchorOffset = this.mOrientationHelper.getEndAfterPadding() - this.mOrientationHelper.getDecoratedEnd(refChild);
                state.mAnchorPosition = this.getPosition(refChild);
            } else {
                View refChild = this.getChildClosestToStart();
                state.mAnchorPosition = this.getPosition(refChild);
                state.mAnchorOffset = this.mOrientationHelper.getDecoratedStart(refChild) - this.mOrientationHelper.getStartAfterPadding();
            }
        } else {
            state.invalidateAnchor();
        }
        return state;
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            this.mPendingSavedState = (SavedState)state;
            this.requestLayout();
        }
    }

    @Override
    public boolean canScrollHorizontally() {
        return this.mOrientation == 0;
    }

    @Override
    public boolean canScrollVertically() {
        return this.mOrientation == 1;
    }

    public void setStackFromEnd(boolean stackFromEnd) {
        this.assertNotInLayoutOrScroll(null);
        if (this.mStackFromEnd == stackFromEnd) {
            return;
        }
        this.mStackFromEnd = stackFromEnd;
        this.requestLayout();
    }

    public boolean getStackFromEnd() {
        return this.mStackFromEnd;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("invalid orientation:" + orientation);
        }
        this.assertNotInLayoutOrScroll(null);
        if (orientation == this.mOrientation) {
            return;
        }
        this.mOrientation = orientation;
        this.mOrientationHelper = null;
        this.requestLayout();
    }

    private void resolveShouldLayoutReverse() {
        this.mShouldReverseLayout = this.mOrientation == 1 || !this.isLayoutRTL() ? this.mReverseLayout : !this.mReverseLayout;
    }

    public boolean getReverseLayout() {
        return this.mReverseLayout;
    }

    public void setReverseLayout(boolean reverseLayout) {
        this.assertNotInLayoutOrScroll(null);
        if (reverseLayout == this.mReverseLayout) {
            return;
        }
        this.mReverseLayout = reverseLayout;
        this.requestLayout();
    }

    @Override
    public View findViewByPosition(int position) {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return null;
        }
        int firstChild = this.getPosition(this.getChildAt(0));
        int viewPosition = position - firstChild;
        if (viewPosition >= 0 && viewPosition < childCount) {
            return this.getChildAt(viewPosition);
        }
        return null;
    }

    protected int getExtraLayoutSpace(CustomRecyclerView.State state) {
        if (state.hasTargetScrollPosition()) {
            return this.mOrientationHelper.getTotalSpace();
        }
        return 0;
    }

    @Override
    public void smoothScrollToPosition(CustomRecyclerView customRecyclerView, CustomRecyclerView.State state, int position) {
        LinearSmoothScroller linearSmoothScroller = new LinearSmoothScroller(customRecyclerView.getContext()){

            @Override
            public PointF computeScrollVectorForPosition(int targetPosition) {
                return CustomLinearLayoutManager.this.computeScrollVectorForPosition(targetPosition);
            }
        };
        linearSmoothScroller.setTargetPosition(position);
        this.startSmoothScroll(linearSmoothScroller);
    }

    public PointF computeScrollVectorForPosition(int targetPosition) {
        int direction;
        if (this.getChildCount() == 0) {
            return null;
        }
        int firstChildPos = this.getPosition(this.getChildAt(0));
        int n = direction = targetPosition < firstChildPos != this.mShouldReverseLayout ? -1 : 1;
        if (this.mOrientation == 0) {
            return new PointF((float)direction, 0.0f);
        }
        return new PointF(0.0f, (float)direction);
    }

    @Override
    public void onLayoutChildren(CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state) {
        int endOffset;
        int startOffset;
        View existing;
        int extraForStart;
        int extraForEnd;
        boolean before;
        if (this.mPendingSavedState != null && this.mPendingSavedState.hasValidAnchor()) {
            this.mPendingScrollPosition = this.mPendingSavedState.mAnchorPosition;
        }
        this.ensureLayoutState();
        this.mLayoutState.mRecycle = false;
        this.resolveShouldLayoutReverse();
        this.mAnchorInfo.reset();
        this.mAnchorInfo.mLayoutFromEnd = this.mShouldReverseLayout ^ this.mStackFromEnd;
        this.updateAnchorInfoForLayout(state, this.mAnchorInfo);
        int extra = this.getExtraLayoutSpace(state);
        boolean bl = before = state.hasTargetScrollPosition() && state.getTargetScrollPosition() < this.mAnchorInfo.mPosition;
        if (before == this.mAnchorInfo.mLayoutFromEnd) {
            extraForEnd = extra;
            extraForStart = 0;
        } else {
            extraForStart = extra;
            extraForEnd = 0;
        }
        extraForStart += this.mOrientationHelper.getStartAfterPadding();
        extraForEnd += this.mOrientationHelper.getEndPadding();
        if (state.isPreLayout() && this.mPendingScrollPosition != -1 && this.mPendingScrollPositionOffset != Integer.MIN_VALUE && (existing = this.findViewByPosition(this.mPendingScrollPosition)) != null) {
            int upcomingOffset;
            int current;
            if (this.mShouldReverseLayout) {
                current = this.mOrientationHelper.getEndAfterPadding() - this.mOrientationHelper.getDecoratedEnd(existing);
                upcomingOffset = current - this.mPendingScrollPositionOffset;
            } else {
                current = this.mOrientationHelper.getDecoratedStart(existing) - this.mOrientationHelper.getStartAfterPadding();
                upcomingOffset = this.mPendingScrollPositionOffset - current;
            }
            if (upcomingOffset > 0) {
                extraForStart += upcomingOffset;
            } else {
                extraForEnd -= upcomingOffset;
            }
        }
        this.onAnchorReady(state, this.mAnchorInfo);
        this.detachAndScrapAttachedViews(recycler);
        this.mLayoutState.mIsPreLayout = state.isPreLayout();
        if (this.mAnchorInfo.mLayoutFromEnd) {
            this.updateLayoutStateToFillStart(this.mAnchorInfo);
            this.mLayoutState.mExtra = extraForStart;
            this.fill(recycler, this.mLayoutState, state, false);
            startOffset = this.mLayoutState.mOffset;
            if (this.mLayoutState.mAvailable > 0) {
                extraForEnd += this.mLayoutState.mAvailable;
            }
            this.updateLayoutStateToFillEnd(this.mAnchorInfo);
            this.mLayoutState.mExtra = extraForEnd;
            this.mLayoutState.mCurrentPosition += this.mLayoutState.mItemDirection;
            this.fill(recycler, this.mLayoutState, state, false);
            endOffset = this.mLayoutState.mOffset;
        } else {
            this.updateLayoutStateToFillEnd(this.mAnchorInfo);
            this.mLayoutState.mExtra = extraForEnd;
            this.fill(recycler, this.mLayoutState, state, false);
            endOffset = this.mLayoutState.mOffset;
            if (this.mLayoutState.mAvailable > 0) {
                extraForStart += this.mLayoutState.mAvailable;
            }
            this.updateLayoutStateToFillStart(this.mAnchorInfo);
            this.mLayoutState.mExtra = extraForStart;
            this.mLayoutState.mCurrentPosition += this.mLayoutState.mItemDirection;
            this.fill(recycler, this.mLayoutState, state, false);
            startOffset = this.mLayoutState.mOffset;
        }
        if (this.getChildCount() > 0) {
            int fixOffset;
            if (this.mShouldReverseLayout ^ this.mStackFromEnd) {
                fixOffset = this.fixLayoutEndGap(endOffset, recycler, state, true);
                startOffset += fixOffset;
                endOffset += fixOffset;
                fixOffset = this.fixLayoutStartGap(startOffset, recycler, state, false);
                startOffset += fixOffset;
                endOffset += fixOffset;
            } else {
                fixOffset = this.fixLayoutStartGap(startOffset, recycler, state, true);
                startOffset += fixOffset;
                endOffset += fixOffset;
                fixOffset = this.fixLayoutEndGap(endOffset, recycler, state, false);
                startOffset += fixOffset;
                endOffset += fixOffset;
            }
        }
        this.layoutForPredictiveAnimations(recycler, state, startOffset, endOffset);
        if (!state.isPreLayout()) {
            this.mPendingScrollPosition = -1;
            this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
            this.mOrientationHelper.onLayoutComplete();
        }
        this.mLastStackFromEnd = this.mStackFromEnd;
        this.mPendingSavedState = null;
    }

    void onAnchorReady(CustomRecyclerView.State state, AnchorInfo anchorInfo) {
    }

    private void layoutForPredictiveAnimations(CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state, int startOffset, int endOffset) {
        if (!state.willRunPredictiveAnimations() || this.getChildCount() == 0 || state.isPreLayout() || !this.supportsPredictiveItemAnimations()) {
            return;
        }
        int scrapExtraStart = 0;
        int scrapExtraEnd = 0;
        List<CustomRecyclerView.ViewHolder> scrapList = recycler.getScrapList();
        int scrapSize = scrapList.size();
        int firstChildPos = this.getPosition(this.getChildAt(0));
        for (int i = 0; i < scrapSize; ++i) {
            int direction;
            CustomRecyclerView.ViewHolder scrap = scrapList.get(i);
            int position = scrap.getLayoutPosition();
            int n = direction = position < firstChildPos != this.mShouldReverseLayout ? -1 : 1;
            if (direction == -1) {
                scrapExtraStart += this.mOrientationHelper.getDecoratedMeasurement(scrap.itemView);
                continue;
            }
            scrapExtraEnd += this.mOrientationHelper.getDecoratedMeasurement(scrap.itemView);
        }
        this.mLayoutState.mScrapList = scrapList;
        if (scrapExtraStart > 0) {
            View anchor = this.getChildClosestToStart();
            this.updateLayoutStateToFillStart(this.getPosition(anchor), startOffset);
            this.mLayoutState.mExtra = scrapExtraStart;
            this.mLayoutState.mAvailable = 0;
            this.mLayoutState.mCurrentPosition = this.mLayoutState.mCurrentPosition + (this.mShouldReverseLayout ? 1 : -1);
            this.fill(recycler, this.mLayoutState, state, false);
        }
        if (scrapExtraEnd > 0) {
            View anchor = this.getChildClosestToEnd();
            this.updateLayoutStateToFillEnd(this.getPosition(anchor), endOffset);
            this.mLayoutState.mExtra = scrapExtraEnd;
            this.mLayoutState.mAvailable = 0;
            this.mLayoutState.mCurrentPosition = this.mLayoutState.mCurrentPosition + (this.mShouldReverseLayout ? -1 : 1);
            this.fill(recycler, this.mLayoutState, state, false);
        }
        this.mLayoutState.mScrapList = null;
    }

    private void updateAnchorInfoForLayout(CustomRecyclerView.State state, AnchorInfo anchorInfo) {
        if (this.updateAnchorFromPendingData(state, anchorInfo)) {
            return;
        }
        if (this.updateAnchorFromChildren(state, anchorInfo)) {
            return;
        }
        anchorInfo.assignCoordinateFromPadding();
        anchorInfo.mPosition = this.mStackFromEnd ? state.getItemCount() - 1 : 0;
    }

    private boolean updateAnchorFromChildren(CustomRecyclerView.State state, AnchorInfo anchorInfo) {
        View referenceChild;
        if (this.getChildCount() == 0) {
            return false;
        }
        View focused = this.getFocusedChild();
        if (focused != null && anchorInfo.assignFromViewIfValid(focused, state)) {
            return true;
        }
        if (this.mLastStackFromEnd != this.mStackFromEnd) {
            return false;
        }
        View view = referenceChild = anchorInfo.mLayoutFromEnd ? this.findReferenceChildClosestToEnd(state) : this.findReferenceChildClosestToStart(state);
        if (referenceChild != null) {
            anchorInfo.assignFromView(referenceChild);
            if (!state.isPreLayout() && this.supportsPredictiveItemAnimations()) {
                boolean notVisible;
                boolean bl = notVisible = this.mOrientationHelper.getDecoratedStart(referenceChild) >= this.mOrientationHelper.getEndAfterPadding() || this.mOrientationHelper.getDecoratedEnd(referenceChild) < this.mOrientationHelper.getStartAfterPadding();
                if (notVisible) {
                    anchorInfo.mCoordinate = anchorInfo.mLayoutFromEnd ? this.mOrientationHelper.getEndAfterPadding() : this.mOrientationHelper.getStartAfterPadding();
                }
            }
            return true;
        }
        return false;
    }

    private boolean updateAnchorFromPendingData(CustomRecyclerView.State state, AnchorInfo anchorInfo) {
        if (state.isPreLayout() || this.mPendingScrollPosition == -1) {
            return false;
        }
        if (this.mPendingScrollPosition < 0 || this.mPendingScrollPosition >= state.getItemCount()) {
            this.mPendingScrollPosition = -1;
            this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
            return false;
        }
        anchorInfo.mPosition = this.mPendingScrollPosition;
        if (this.mPendingSavedState != null && this.mPendingSavedState.hasValidAnchor()) {
            anchorInfo.mLayoutFromEnd = this.mPendingSavedState.mAnchorLayoutFromEnd;
            anchorInfo.mCoordinate = anchorInfo.mLayoutFromEnd ? this.mOrientationHelper.getEndAfterPadding() - this.mPendingSavedState.mAnchorOffset : this.mOrientationHelper.getStartAfterPadding() + this.mPendingSavedState.mAnchorOffset;
            return true;
        }
        if (this.mPendingScrollPositionOffset == Integer.MIN_VALUE) {
            View child = this.findViewByPosition(this.mPendingScrollPosition);
            if (child != null) {
                int childSize = this.mOrientationHelper.getDecoratedMeasurement(child);
                if (childSize > this.mOrientationHelper.getTotalSpace()) {
                    anchorInfo.assignCoordinateFromPadding();
                    return true;
                }
                int startGap = this.mOrientationHelper.getDecoratedStart(child) - this.mOrientationHelper.getStartAfterPadding();
                if (startGap < 0) {
                    anchorInfo.mCoordinate = this.mOrientationHelper.getStartAfterPadding();
                    anchorInfo.mLayoutFromEnd = false;
                    return true;
                }
                int endGap = this.mOrientationHelper.getEndAfterPadding() - this.mOrientationHelper.getDecoratedEnd(child);
                if (endGap < 0) {
                    anchorInfo.mCoordinate = this.mOrientationHelper.getEndAfterPadding();
                    anchorInfo.mLayoutFromEnd = true;
                    return true;
                }
                anchorInfo.mCoordinate = anchorInfo.mLayoutFromEnd ? this.mOrientationHelper.getDecoratedEnd(child) + this.mOrientationHelper.getTotalSpaceChange() : this.mOrientationHelper.getDecoratedStart(child);
            } else {
                if (this.getChildCount() > 0) {
                    int pos = this.getPosition(this.getChildAt(0));
                    anchorInfo.mLayoutFromEnd = this.mPendingScrollPosition < pos == this.mShouldReverseLayout;
                }
                anchorInfo.assignCoordinateFromPadding();
            }
            return true;
        }
        anchorInfo.mLayoutFromEnd = this.mShouldReverseLayout;
        anchorInfo.mCoordinate = this.mShouldReverseLayout ? this.mOrientationHelper.getEndAfterPadding() - this.mPendingScrollPositionOffset : this.mOrientationHelper.getStartAfterPadding() + this.mPendingScrollPositionOffset;
        return true;
    }

    private int fixLayoutEndGap(int endOffset, CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state, boolean canOffsetChildren) {
        int gap = this.mOrientationHelper.getEndAfterPadding() - endOffset;
        int fixOffset = 0;
        if (gap <= 0) {
            return 0;
        }
        fixOffset = -this.scrollBy(-gap, recycler, state);
        if (canOffsetChildren && (gap = this.mOrientationHelper.getEndAfterPadding() - (endOffset += fixOffset)) > 0) {
            this.mOrientationHelper.offsetChildren(gap);
            return gap + fixOffset;
        }
        return fixOffset;
    }

    private int fixLayoutStartGap(int startOffset, CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state, boolean canOffsetChildren) {
        int gap = startOffset - this.mOrientationHelper.getStartAfterPadding();
        int fixOffset = 0;
        if (gap <= 0) {
            return 0;
        }
        fixOffset = -this.scrollBy(gap, recycler, state);
        if (canOffsetChildren && (gap = (startOffset += fixOffset) - this.mOrientationHelper.getStartAfterPadding()) > 0) {
            this.mOrientationHelper.offsetChildren(-gap);
            return fixOffset - gap;
        }
        return fixOffset;
    }

    private void updateLayoutStateToFillEnd(AnchorInfo anchorInfo) {
        this.updateLayoutStateToFillEnd(anchorInfo.mPosition, anchorInfo.mCoordinate);
    }

    private void updateLayoutStateToFillEnd(int itemPosition, int offset) {
        this.mLayoutState.mAvailable = this.mOrientationHelper.getEndAfterPadding() - offset;
        this.mLayoutState.mItemDirection = this.mShouldReverseLayout ? -1 : 1;
        this.mLayoutState.mCurrentPosition = itemPosition;
        this.mLayoutState.mLayoutDirection = 1;
        this.mLayoutState.mOffset = offset;
        this.mLayoutState.mScrollingOffset = Integer.MIN_VALUE;
    }

    private void updateLayoutStateToFillStart(AnchorInfo anchorInfo) {
        this.updateLayoutStateToFillStart(anchorInfo.mPosition, anchorInfo.mCoordinate);
    }

    private void updateLayoutStateToFillStart(int itemPosition, int offset) {
        this.mLayoutState.mAvailable = offset - this.mOrientationHelper.getStartAfterPadding();
        this.mLayoutState.mCurrentPosition = itemPosition;
        this.mLayoutState.mItemDirection = this.mShouldReverseLayout ? 1 : -1;
        this.mLayoutState.mLayoutDirection = -1;
        this.mLayoutState.mOffset = offset;
        this.mLayoutState.mScrollingOffset = Integer.MIN_VALUE;
    }

    protected boolean isLayoutRTL() {
        return this.getLayoutDirection() == 1;
    }

    void ensureLayoutState() {
        if (this.mLayoutState == null) {
            this.mLayoutState = new LayoutState();
        }
        if (this.mOrientationHelper == null) {
            this.mOrientationHelper = OrientationHelper.createOrientationHelper(this, this.mOrientation);
        }
    }

    @Override
    public void scrollToPosition(int position) {
        this.mPendingScrollPosition = position;
        this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        if (this.mPendingSavedState != null) {
            this.mPendingSavedState.invalidateAnchor();
        }
        this.requestLayout();
    }

    public void scrollToPositionWithOffset(int position, int offset) {
        this.mPendingScrollPosition = position;
        this.mPendingScrollPositionOffset = offset;
        if (this.mPendingSavedState != null) {
            this.mPendingSavedState.invalidateAnchor();
        }
        this.requestLayout();
    }

    @Override
    public int scrollHorizontallyBy(int dx, CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state) {
        if (this.mOrientation == 1) {
            return 0;
        }
        return this.scrollBy(dx, recycler, state);
    }

    @Override
    public int scrollVerticallyBy(int dy, CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state) {
        if (this.mOrientation == 0) {
            return 0;
        }
        return this.scrollBy(dy, recycler, state);
    }

    @Override
    public int computeHorizontalScrollOffset(CustomRecyclerView.State state) {
        return this.computeScrollOffset(state);
    }

    @Override
    public int computeVerticalScrollOffset(CustomRecyclerView.State state) {
        return this.computeScrollOffset(state);
    }

    @Override
    public int computeHorizontalScrollExtent(CustomRecyclerView.State state) {
        return this.computeScrollExtent(state);
    }

    @Override
    public int computeVerticalScrollExtent(CustomRecyclerView.State state) {
        return this.computeScrollExtent(state);
    }

    @Override
    public int computeHorizontalScrollRange(CustomRecyclerView.State state) {
        return this.computeScrollRange(state);
    }

    @Override
    public int computeVerticalScrollRange(CustomRecyclerView.State state) {
        return this.computeScrollRange(state);
    }

    private int computeScrollOffset(CustomRecyclerView.State state) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        this.ensureLayoutState();
        return ScrollbarHelper.computeScrollOffset(state, this.mOrientationHelper, this.findFirstVisibleChildClosestToStart(!this.mSmoothScrollbarEnabled, true), this.findFirstVisibleChildClosestToEnd(!this.mSmoothScrollbarEnabled, true), this, this.mSmoothScrollbarEnabled, this.mShouldReverseLayout);
    }

    private int computeScrollExtent(CustomRecyclerView.State state) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        this.ensureLayoutState();
        return ScrollbarHelper.computeScrollExtent(state, this.mOrientationHelper, this.findFirstVisibleChildClosestToStart(!this.mSmoothScrollbarEnabled, true), this.findFirstVisibleChildClosestToEnd(!this.mSmoothScrollbarEnabled, true), this, this.mSmoothScrollbarEnabled);
    }

    private int computeScrollRange(CustomRecyclerView.State state) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        this.ensureLayoutState();
        return ScrollbarHelper.computeScrollRange(state, this.mOrientationHelper, this.findFirstVisibleChildClosestToStart(!this.mSmoothScrollbarEnabled, true), this.findFirstVisibleChildClosestToEnd(!this.mSmoothScrollbarEnabled, true), this, this.mSmoothScrollbarEnabled);
    }

    public void setSmoothScrollbarEnabled(boolean enabled) {
        this.mSmoothScrollbarEnabled = enabled;
    }

    public boolean isSmoothScrollbarEnabled() {
        return this.mSmoothScrollbarEnabled;
    }

    private void updateLayoutState(int layoutDirection, int requiredSpace, boolean canUseExistingSpace, CustomRecyclerView.State state) {
        int fastScrollSpace;
        this.mLayoutState.mExtra = this.getExtraLayoutSpace(state);
        this.mLayoutState.mLayoutDirection = layoutDirection;
        if (layoutDirection == 1) {
            this.mLayoutState.mExtra += this.mOrientationHelper.getEndPadding();
            View child = this.getChildClosestToEnd();
            this.mLayoutState.mItemDirection = this.mShouldReverseLayout ? -1 : 1;
            this.mLayoutState.mCurrentPosition = this.getPosition(child) + this.mLayoutState.mItemDirection;
            this.mLayoutState.mOffset = this.mOrientationHelper.getDecoratedEnd(child);
            fastScrollSpace = this.mOrientationHelper.getDecoratedEnd(child) - this.mOrientationHelper.getEndAfterPadding();
        } else {
            View child = this.getChildClosestToStart();
            this.mLayoutState.mExtra += this.mOrientationHelper.getStartAfterPadding();
            this.mLayoutState.mItemDirection = this.mShouldReverseLayout ? 1 : -1;
            this.mLayoutState.mCurrentPosition = this.getPosition(child) + this.mLayoutState.mItemDirection;
            this.mLayoutState.mOffset = this.mOrientationHelper.getDecoratedStart(child);
            fastScrollSpace = -this.mOrientationHelper.getDecoratedStart(child) + this.mOrientationHelper.getStartAfterPadding();
        }
        this.mLayoutState.mAvailable = requiredSpace;
        if (canUseExistingSpace) {
            this.mLayoutState.mAvailable -= fastScrollSpace;
        }
        this.mLayoutState.mScrollingOffset = fastScrollSpace;
    }

    int scrollBy(int dy, CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state) {
        if (this.getChildCount() == 0 || dy == 0) {
            return 0;
        }
        this.mLayoutState.mRecycle = true;
        this.ensureLayoutState();
        int layoutDirection = dy > 0 ? 1 : -1;
        int absDy = Math.abs(dy);
        this.updateLayoutState(layoutDirection, absDy, true, state);
        int freeScroll = this.mLayoutState.mScrollingOffset;
        int consumed = freeScroll + this.fill(recycler, this.mLayoutState, state, false);
        if (consumed < 0) {
            return 0;
        }
        int scrolled = absDy > consumed ? layoutDirection * consumed : dy;
        this.mOrientationHelper.offsetChildren(-scrolled);
        return scrolled;
    }

    @Override
    public void assertNotInLayoutOrScroll(String message) {
        if (this.mPendingSavedState == null) {
            super.assertNotInLayoutOrScroll(message);
        }
    }

    private void recycleChildren(CustomRecyclerView.Recycler recycler, int startIndex, int endIndex) {
        if (startIndex == endIndex) {
            return;
        }
        if (endIndex > startIndex) {
            for (int i = endIndex - 1; i >= startIndex; --i) {
                this.removeAndRecycleViewAt(i, recycler);
            }
        } else {
            for (int i = startIndex; i > endIndex; --i) {
                this.removeAndRecycleViewAt(i, recycler);
            }
        }
    }

    private void recycleViewsFromStart(CustomRecyclerView.Recycler recycler, int dt) {
        if (dt < 0) {
            return;
        }
        int limit = dt;
        int childCount = this.getChildCount();
        if (this.mShouldReverseLayout) {
            for (int i = childCount - 1; i >= 0; --i) {
                View child = this.getChildAt(i);
                if (this.mOrientationHelper.getDecoratedEnd(child) <= limit) continue;
                this.recycleChildren(recycler, childCount - 1, i);
                return;
            }
        } else {
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                if (this.mOrientationHelper.getDecoratedEnd(child) <= limit) continue;
                this.recycleChildren(recycler, 0, i);
                return;
            }
        }
    }

    private void recycleViewsFromEnd(CustomRecyclerView.Recycler recycler, int dt) {
        int childCount = this.getChildCount();
        if (dt < 0) {
            return;
        }
        int limit = this.mOrientationHelper.getEnd() - dt;
        if (this.mShouldReverseLayout) {
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                if (this.mOrientationHelper.getDecoratedStart(child) >= limit) continue;
                this.recycleChildren(recycler, 0, i);
                return;
            }
        } else {
            for (int i = childCount - 1; i >= 0; --i) {
                View child = this.getChildAt(i);
                if (this.mOrientationHelper.getDecoratedStart(child) >= limit) continue;
                this.recycleChildren(recycler, childCount - 1, i);
                return;
            }
        }
    }

    private void recycleByLayoutState(CustomRecyclerView.Recycler recycler, LayoutState layoutState) {
        if (!layoutState.mRecycle) {
            return;
        }
        if (layoutState.mLayoutDirection == -1) {
            this.recycleViewsFromEnd(recycler, layoutState.mScrollingOffset);
        } else {
            this.recycleViewsFromStart(recycler, layoutState.mScrollingOffset);
        }
    }

    int fill(CustomRecyclerView.Recycler recycler, LayoutState layoutState, CustomRecyclerView.State state, boolean stopOnFocusable) {
        int start = layoutState.mAvailable;
        if (layoutState.mScrollingOffset != Integer.MIN_VALUE) {
            if (layoutState.mAvailable < 0) {
                layoutState.mScrollingOffset += layoutState.mAvailable;
            }
            this.recycleByLayoutState(recycler, layoutState);
        }
        int remainingSpace = layoutState.mAvailable + layoutState.mExtra;
        LayoutChunkResult layoutChunkResult = new LayoutChunkResult();
        while (remainingSpace > 0 && layoutState.hasMore(state)) {
            layoutChunkResult.resetInternal();
            this.layoutChunk(recycler, state, layoutState, layoutChunkResult);
            if (layoutChunkResult.mFinished) break;
            layoutState.mOffset += layoutChunkResult.mConsumed * layoutState.mLayoutDirection;
            if (!layoutChunkResult.mIgnoreConsumed || this.mLayoutState.mScrapList != null || !state.isPreLayout()) {
                layoutState.mAvailable -= layoutChunkResult.mConsumed;
                remainingSpace -= layoutChunkResult.mConsumed;
            }
            if (layoutState.mScrollingOffset != Integer.MIN_VALUE) {
                layoutState.mScrollingOffset += layoutChunkResult.mConsumed;
                if (layoutState.mAvailable < 0) {
                    layoutState.mScrollingOffset += layoutState.mAvailable;
                }
                this.recycleByLayoutState(recycler, layoutState);
            }
            if (!stopOnFocusable || !layoutChunkResult.mFocusable) continue;
            break;
        }
        return start - layoutState.mAvailable;
    }

    void layoutChunk(CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state, LayoutState layoutState, LayoutChunkResult result) {
        int top;
        int bottom;
        int left;
        int right;
        View view = layoutState.next(recycler);
        if (view == null) {
            result.mFinished = true;
            return;
        }
        CustomRecyclerView.LayoutParams params = (CustomRecyclerView.LayoutParams)view.getLayoutParams();
        if (layoutState.mScrapList == null) {
            if (this.mShouldReverseLayout == (layoutState.mLayoutDirection == -1)) {
                this.addView(view);
            } else {
                this.addView(view, 0);
            }
        } else if (this.mShouldReverseLayout == (layoutState.mLayoutDirection == -1)) {
            this.addDisappearingView(view);
        } else {
            this.addDisappearingView(view, 0);
        }
        this.measureChildWithMargins(view, 0, 0);
        result.mConsumed = this.mOrientationHelper.getDecoratedMeasurement(view);
        if (this.mOrientation == 1) {
            if (this.isLayoutRTL()) {
                right = this.getWidth() - this.getPaddingRight();
                left = right - this.mOrientationHelper.getDecoratedMeasurementInOther(view);
            } else {
                left = this.getPaddingLeft();
                right = left + this.mOrientationHelper.getDecoratedMeasurementInOther(view);
            }
            if (layoutState.mLayoutDirection == -1) {
                bottom = layoutState.mOffset;
                top = layoutState.mOffset - result.mConsumed;
            } else {
                top = layoutState.mOffset;
                bottom = layoutState.mOffset + result.mConsumed;
            }
        } else {
            top = this.getPaddingTop();
            bottom = top + this.mOrientationHelper.getDecoratedMeasurementInOther(view);
            if (layoutState.mLayoutDirection == -1) {
                right = layoutState.mOffset;
                left = layoutState.mOffset - result.mConsumed;
            } else {
                left = layoutState.mOffset;
                right = layoutState.mOffset + result.mConsumed;
            }
        }
        this.layoutDecorated(view, left + params.leftMargin, top + params.topMargin, right - params.rightMargin, bottom - params.bottomMargin);
        if (params.isItemRemoved() || params.isItemChanged()) {
            result.mIgnoreConsumed = true;
        }
        result.mFocusable = view.isFocusable();
    }

    private int convertFocusDirectionToLayoutDirection(int focusDirection) {
        switch (focusDirection) {
            case 1: {
                return -1;
            }
            case 2: {
                return 1;
            }
            case 33: {
                return this.mOrientation == 1 ? -1 : Integer.MIN_VALUE;
            }
            case 130: {
                return this.mOrientation == 1 ? 1 : Integer.MIN_VALUE;
            }
            case 17: {
                return this.mOrientation == 0 ? -1 : Integer.MIN_VALUE;
            }
            case 66: {
                return this.mOrientation == 0 ? 1 : Integer.MIN_VALUE;
            }
        }
        return Integer.MIN_VALUE;
    }

    private View getChildClosestToStart() {
        return this.getChildAt(this.mShouldReverseLayout ? this.getChildCount() - 1 : 0);
    }

    private View getChildClosestToEnd() {
        return this.getChildAt(this.mShouldReverseLayout ? 0 : this.getChildCount() - 1);
    }

    private View findFirstVisibleChildClosestToStart(boolean completelyVisible, boolean acceptPartiallyVisible) {
        if (this.mShouldReverseLayout) {
            return this.findOneVisibleChild(this.getChildCount() - 1, -1, completelyVisible, acceptPartiallyVisible);
        }
        return this.findOneVisibleChild(0, this.getChildCount(), completelyVisible, acceptPartiallyVisible);
    }

    private View findFirstVisibleChildClosestToEnd(boolean completelyVisible, boolean acceptPartiallyVisible) {
        if (this.mShouldReverseLayout) {
            return this.findOneVisibleChild(0, this.getChildCount(), completelyVisible, acceptPartiallyVisible);
        }
        return this.findOneVisibleChild(this.getChildCount() - 1, -1, completelyVisible, acceptPartiallyVisible);
    }

    private View findReferenceChildClosestToEnd(CustomRecyclerView.State state) {
        return this.mShouldReverseLayout ? this.findFirstReferenceChild(state.getItemCount()) : this.findLastReferenceChild(state.getItemCount());
    }

    private View findReferenceChildClosestToStart(CustomRecyclerView.State state) {
        return this.mShouldReverseLayout ? this.findLastReferenceChild(state.getItemCount()) : this.findFirstReferenceChild(state.getItemCount());
    }

    private View findFirstReferenceChild(int itemCount) {
        return this.findReferenceChild(0, this.getChildCount(), itemCount);
    }

    private View findLastReferenceChild(int itemCount) {
        return this.findReferenceChild(this.getChildCount() - 1, -1, itemCount);
    }

    private View findReferenceChild(int start, int end, int itemCount) {
        this.ensureLayoutState();
        View invalidMatch = null;
        View outOfBoundsMatch = null;
        int boundsStart = this.mOrientationHelper.getStartAfterPadding();
        int boundsEnd = this.mOrientationHelper.getEndAfterPadding();
        int diff = end > start ? 1 : -1;
        for (int i = start; i != end; i += diff) {
            View view = this.getChildAt(i);
            int position = this.getPosition(view);
            if (position < 0 || position >= itemCount) continue;
            if (((CustomRecyclerView.LayoutParams)view.getLayoutParams()).isItemRemoved()) {
                if (invalidMatch != null) continue;
                invalidMatch = view;
                continue;
            }
            if (this.mOrientationHelper.getDecoratedStart(view) >= boundsEnd || this.mOrientationHelper.getDecoratedEnd(view) < boundsStart) {
                if (outOfBoundsMatch != null) continue;
                outOfBoundsMatch = view;
                continue;
            }
            return view;
        }
        return outOfBoundsMatch != null ? outOfBoundsMatch : invalidMatch;
    }

    public int findFirstVisibleItemPosition() {
        View child = this.findOneVisibleChild(0, this.getChildCount(), false, true);
        return child == null ? -1 : this.getPosition(child);
    }

    public int findFirstCompletelyVisibleItemPosition() {
        View child = this.findOneVisibleChild(0, this.getChildCount(), true, false);
        return child == null ? -1 : this.getPosition(child);
    }

    public int findLastVisibleItemPosition() {
        View child = this.findOneVisibleChild(this.getChildCount() - 1, -1, false, true);
        return child == null ? -1 : this.getPosition(child);
    }

    public int findLastCompletelyVisibleItemPosition() {
        View child = this.findOneVisibleChild(this.getChildCount() - 1, -1, true, false);
        return child == null ? -1 : this.getPosition(child);
    }

    View findOneVisibleChild(int fromIndex, int toIndex, boolean completelyVisible, boolean acceptPartiallyVisible) {
        this.ensureLayoutState();
        int start = this.mOrientationHelper.getStartAfterPadding();
        int end = this.mOrientationHelper.getEndAfterPadding();
        int next = toIndex > fromIndex ? 1 : -1;
        View partiallyVisible = null;
        for (int i = fromIndex; i != toIndex; i += next) {
            View child = this.getChildAt(i);
            int childStart = this.mOrientationHelper.getDecoratedStart(child);
            int childEnd = this.mOrientationHelper.getDecoratedEnd(child);
            if (childStart >= end || childEnd <= start) continue;
            if (completelyVisible) {
                if (childStart >= start && childEnd <= end) {
                    return child;
                }
                if (!acceptPartiallyVisible || partiallyVisible != null) continue;
                partiallyVisible = child;
                continue;
            }
            return child;
        }
        return partiallyVisible;
    }

    @Override
    public View onFocusSearchFailed(View focused, int focusDirection, CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state) {
        this.resolveShouldLayoutReverse();
        if (this.getChildCount() == 0) {
            return null;
        }
        int layoutDir = this.convertFocusDirectionToLayoutDirection(focusDirection);
        if (layoutDir == Integer.MIN_VALUE) {
            return null;
        }
        this.ensureLayoutState();
        View referenceChild = layoutDir == -1 ? this.findReferenceChildClosestToStart(state) : this.findReferenceChildClosestToEnd(state);
        if (referenceChild == null) {
            return null;
        }
        this.ensureLayoutState();
        int maxScroll = (int)(0.33f * (float)this.mOrientationHelper.getTotalSpace());
        this.updateLayoutState(layoutDir, maxScroll, false, state);
        this.mLayoutState.mScrollingOffset = Integer.MIN_VALUE;
        this.mLayoutState.mRecycle = false;
        this.fill(recycler, this.mLayoutState, state, true);
        View nextFocus = layoutDir == -1 ? this.getChildClosestToStart() : this.getChildClosestToEnd();
        if (nextFocus == referenceChild || !nextFocus.isFocusable()) {
            return null;
        }
        return nextFocus;
    }

    private void logChildren() {
        Log.d((String)TAG, (String)"internal representation of views on the screen");
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            Log.d((String)TAG, (String)("item " + this.getPosition(child) + ", coord:" + this.mOrientationHelper.getDecoratedStart(child)));
        }
        Log.d((String)TAG, (String)"==============");
    }

    void validateChildOrder() {
        Log.d((String)TAG, (String)("validating child count " + this.getChildCount()));
        if (this.getChildCount() < 1) {
            return;
        }
        int lastPos = this.getPosition(this.getChildAt(0));
        int lastScreenLoc = this.mOrientationHelper.getDecoratedStart(this.getChildAt(0));
        if (this.mShouldReverseLayout) {
            for (int i = 1; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                int pos = this.getPosition(child);
                int screenLoc = this.mOrientationHelper.getDecoratedStart(child);
                if (pos < lastPos) {
                    this.logChildren();
                    throw new RuntimeException("detected invalid position. loc invalid? " + (screenLoc < lastScreenLoc));
                }
                if (screenLoc <= lastScreenLoc) continue;
                this.logChildren();
                throw new RuntimeException("detected invalid location");
            }
        } else {
            for (int i = 1; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                int pos = this.getPosition(child);
                int screenLoc = this.mOrientationHelper.getDecoratedStart(child);
                if (pos < lastPos) {
                    this.logChildren();
                    throw new RuntimeException("detected invalid position. loc invalid? " + (screenLoc < lastScreenLoc));
                }
                if (screenLoc >= lastScreenLoc) continue;
                this.logChildren();
                throw new RuntimeException("detected invalid location");
            }
        }
    }

    @Override
    public boolean supportsPredictiveItemAnimations() {
        return this.mPendingSavedState == null && this.mLastStackFromEnd == this.mStackFromEnd;
    }

    protected static class LayoutChunkResult {
        public int mConsumed;
        public boolean mFinished;
        public boolean mIgnoreConsumed;
        public boolean mFocusable;

        protected LayoutChunkResult() {
        }

        void resetInternal() {
            this.mConsumed = 0;
            this.mFinished = false;
            this.mIgnoreConsumed = false;
            this.mFocusable = false;
        }
    }

    class AnchorInfo {
        int mPosition;
        int mCoordinate;
        boolean mLayoutFromEnd;

        AnchorInfo() {
        }

        void reset() {
            this.mPosition = -1;
            this.mCoordinate = Integer.MIN_VALUE;
            this.mLayoutFromEnd = false;
        }

        void assignCoordinateFromPadding() {
            this.mCoordinate = this.mLayoutFromEnd ? CustomLinearLayoutManager.this.mOrientationHelper.getEndAfterPadding() : CustomLinearLayoutManager.this.mOrientationHelper.getStartAfterPadding();
        }

        public String toString() {
            return "AnchorInfo{mPosition=" + this.mPosition + ", mCoordinate=" + this.mCoordinate + ", mLayoutFromEnd=" + this.mLayoutFromEnd + '}';
        }

        public boolean assignFromViewIfValid(View child, CustomRecyclerView.State state) {
            CustomRecyclerView.LayoutParams lp = (CustomRecyclerView.LayoutParams)child.getLayoutParams();
            if (!lp.isItemRemoved() && lp.getViewLayoutPosition() >= 0 && lp.getViewLayoutPosition() < state.getItemCount()) {
                this.assignFromView(child);
                return true;
            }
            return false;
        }

        public void assignFromView(View child) {
            this.mCoordinate = this.mLayoutFromEnd ? CustomLinearLayoutManager.this.mOrientationHelper.getDecoratedEnd(child) + CustomLinearLayoutManager.this.mOrientationHelper.getTotalSpaceChange() : CustomLinearLayoutManager.this.mOrientationHelper.getDecoratedStart(child);
            this.mPosition = CustomLinearLayoutManager.this.getPosition(child);
        }
    }

    static class SavedState
    implements Parcelable {
        int mAnchorPosition;
        int mAnchorOffset;
        boolean mAnchorLayoutFromEnd;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState() {
        }

        SavedState(Parcel in) {
            this.mAnchorPosition = in.readInt();
            this.mAnchorOffset = in.readInt();
            this.mAnchorLayoutFromEnd = in.readInt() == 1;
        }

        public SavedState(SavedState other) {
            this.mAnchorPosition = other.mAnchorPosition;
            this.mAnchorOffset = other.mAnchorOffset;
            this.mAnchorLayoutFromEnd = other.mAnchorLayoutFromEnd;
        }

        boolean hasValidAnchor() {
            return this.mAnchorPosition >= 0;
        }

        void invalidateAnchor() {
            this.mAnchorPosition = -1;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mAnchorPosition);
            dest.writeInt(this.mAnchorOffset);
            dest.writeInt(this.mAnchorLayoutFromEnd ? 1 : 0);
        }
    }

    static class LayoutState {
        static final String TAG = "CustomLinearLayoutManager#LayoutState";
        static final int LAYOUT_START = -1;
        static final int LAYOUT_END = 1;
        static final int INVALID_LAYOUT = Integer.MIN_VALUE;
        static final int ITEM_DIRECTION_HEAD = -1;
        static final int ITEM_DIRECTION_TAIL = 1;
        static final int SCOLLING_OFFSET_NaN = Integer.MIN_VALUE;
        boolean mRecycle = true;
        int mOffset;
        int mAvailable;
        int mCurrentPosition;
        int mItemDirection;
        int mLayoutDirection;
        int mScrollingOffset;
        int mExtra = 0;
        boolean mIsPreLayout = false;
        List<CustomRecyclerView.ViewHolder> mScrapList = null;

        LayoutState() {
        }

        boolean hasMore(CustomRecyclerView.State state) {
            return this.mCurrentPosition >= 0 && this.mCurrentPosition < state.getItemCount();
        }

        View next(CustomRecyclerView.Recycler recycler) {
            if (this.mScrapList != null) {
                return this.nextFromLimitedList();
            }
            View view = recycler.getViewForPosition(this.mCurrentPosition);
            this.mCurrentPosition += this.mItemDirection;
            return view;
        }

        private View nextFromLimitedList() {
            int size = this.mScrapList.size();
            CustomRecyclerView.ViewHolder closest = null;
            int closestDistance = Integer.MAX_VALUE;
            for (int i = 0; i < size; ++i) {
                int distance;
                CustomRecyclerView.ViewHolder viewHolder = this.mScrapList.get(i);
                if (!this.mIsPreLayout && viewHolder.isRemoved() || (distance = (viewHolder.getLayoutPosition() - this.mCurrentPosition) * this.mItemDirection) < 0 || distance >= closestDistance) continue;
                closest = viewHolder;
                closestDistance = distance;
                if (distance == 0) break;
            }
            if (closest != null) {
                this.mCurrentPosition = closest.getLayoutPosition() + this.mItemDirection;
                return closest.itemView;
            }
            return null;
        }

        void log() {
            Log.d((String)TAG, (String)("avail:" + this.mAvailable + ", ind:" + this.mCurrentPosition + ", dir:" + this.mItemDirection + ", offset:" + this.mOffset + ", layoutDir:" + this.mLayoutDirection));
        }
    }
}

