/*
 * Decompiled with CFR 0.152.
 */
package com.custom_recycler_view;

import android.content.Context;
import android.graphics.Rect;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import com.custom_recycler_view.CustomLinearLayoutManager;
import com.custom_recycler_view.CustomRecyclerView;
import java.util.Arrays;

public class CustomGridLayoutManager
extends CustomLinearLayoutManager {
    private static final boolean DEBUG = false;
    private static final String TAG = "CustomGridLayoutManager";
    public static final int DEFAULT_SPAN_COUNT = -1;
    static final int MAIN_DIR_SPEC = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
    int mSpanCount = -1;
    int mSizePerSpan;
    View[] mSet;
    final SparseIntArray mPreLayoutSpanSizeCache = new SparseIntArray();
    final SparseIntArray mPreLayoutSpanIndexCache = new SparseIntArray();
    SpanSizeLookup mSpanSizeLookup = new DefaultSpanSizeLookup();
    final Rect mDecorInsets = new Rect();

    public CustomGridLayoutManager(Context context, int spanCount) {
        super(context);
        this.setSpanCount(spanCount);
    }

    public CustomGridLayoutManager(Context context, int spanCount, int orientation, boolean reverseLayout) {
        super(context, orientation, reverseLayout);
        this.setSpanCount(spanCount);
    }

    @Override
    public void setStackFromEnd(boolean stackFromEnd) {
        if (stackFromEnd) {
            throw new UnsupportedOperationException("CustomGridLayoutManager does not support stack from end. Consider using reverse layout");
        }
        super.setStackFromEnd(false);
    }

    @Override
    public int getRowCountForAccessibility(CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state) {
        if (this.mOrientation == 0) {
            return this.mSpanCount;
        }
        if (state.getItemCount() < 1) {
            return 0;
        }
        return this.getSpanGroupIndex(recycler, state, state.getItemCount() - 1);
    }

    @Override
    public int getColumnCountForAccessibility(CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state) {
        if (this.mOrientation == 1) {
            return this.mSpanCount;
        }
        if (state.getItemCount() < 1) {
            return 0;
        }
        return this.getSpanGroupIndex(recycler, state, state.getItemCount() - 1);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoForItem(CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state, View host, AccessibilityNodeInfoCompat info) {
        ViewGroup.LayoutParams lp = host.getLayoutParams();
        if (!(lp instanceof LayoutParams)) {
            super.onInitializeAccessibilityNodeInfoForItem(host, info);
            return;
        }
        LayoutParams glp = (LayoutParams)lp;
        int spanGroupIndex = this.getSpanGroupIndex(recycler, state, glp.getViewLayoutPosition());
        if (this.mOrientation == 0) {
            info.setCollectionItemInfo((Object)AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)glp.getSpanIndex(), (int)glp.getSpanSize(), (int)spanGroupIndex, (int)1, (this.mSpanCount > 1 && glp.getSpanSize() == this.mSpanCount ? 1 : 0) != 0, (boolean)false));
        } else {
            info.setCollectionItemInfo((Object)AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)spanGroupIndex, (int)1, (int)glp.getSpanIndex(), (int)glp.getSpanSize(), (this.mSpanCount > 1 && glp.getSpanSize() == this.mSpanCount ? 1 : 0) != 0, (boolean)false));
        }
    }

    @Override
    public void onLayoutChildren(CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state) {
        if (state.isPreLayout()) {
            this.cachePreLayoutSpanMapping();
        }
        super.onLayoutChildren(recycler, state);
        this.clearPreLayoutSpanMappingCache();
    }

    private void clearPreLayoutSpanMappingCache() {
        this.mPreLayoutSpanSizeCache.clear();
        this.mPreLayoutSpanIndexCache.clear();
    }

    private void cachePreLayoutSpanMapping() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            LayoutParams lp = (LayoutParams)this.getChildAt(i).getLayoutParams();
            int viewPosition = lp.getViewLayoutPosition();
            this.mPreLayoutSpanSizeCache.put(viewPosition, lp.getSpanSize());
            this.mPreLayoutSpanIndexCache.put(viewPosition, lp.getSpanIndex());
        }
    }

    @Override
    public void onItemsAdded(CustomRecyclerView customRecyclerView, int positionStart, int itemCount) {
        this.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    @Override
    public void onItemsChanged(CustomRecyclerView customRecyclerView) {
        this.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    @Override
    public void onItemsRemoved(CustomRecyclerView customRecyclerView, int positionStart, int itemCount) {
        this.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    @Override
    public void onItemsUpdated(CustomRecyclerView customRecyclerView, int positionStart, int itemCount) {
        this.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    @Override
    public void onItemsMoved(CustomRecyclerView customRecyclerView, int from, int to, int itemCount) {
        this.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    @Override
    public CustomRecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    @Override
    public CustomRecyclerView.LayoutParams generateLayoutParams(Context c, AttributeSet attrs) {
        return new LayoutParams(c, attrs);
    }

    @Override
    public CustomRecyclerView.LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)lp);
        }
        return new LayoutParams(lp);
    }

    @Override
    public boolean checkLayoutParams(CustomRecyclerView.LayoutParams lp) {
        return lp instanceof LayoutParams;
    }

    public void setSpanSizeLookup(SpanSizeLookup spanSizeLookup) {
        this.mSpanSizeLookup = spanSizeLookup;
    }

    public SpanSizeLookup getSpanSizeLookup() {
        return this.mSpanSizeLookup;
    }

    private void updateMeasurements() {
        int totalSpace = this.getOrientation() == 1 ? this.getWidth() - this.getPaddingRight() - this.getPaddingLeft() : this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        this.mSizePerSpan = totalSpace / this.mSpanCount;
    }

    @Override
    void onAnchorReady(CustomRecyclerView.State state, CustomLinearLayoutManager.AnchorInfo anchorInfo) {
        super.onAnchorReady(state, anchorInfo);
        this.updateMeasurements();
        if (state.getItemCount() > 0 && !state.isPreLayout()) {
            this.ensureAnchorIsInFirstSpan(anchorInfo);
        }
        if (this.mSet == null || this.mSet.length != this.mSpanCount) {
            this.mSet = new View[this.mSpanCount];
        }
    }

    private void ensureAnchorIsInFirstSpan(CustomLinearLayoutManager.AnchorInfo anchorInfo) {
        int span = this.mSpanSizeLookup.getCachedSpanIndex(anchorInfo.mPosition, this.mSpanCount);
        while (span > 0 && anchorInfo.mPosition > 0) {
            --anchorInfo.mPosition;
            span = this.mSpanSizeLookup.getCachedSpanIndex(anchorInfo.mPosition, this.mSpanCount);
        }
    }

    private int getSpanGroupIndex(CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state, int viewPosition) {
        if (!state.isPreLayout()) {
            return this.mSpanSizeLookup.getSpanGroupIndex(viewPosition, this.mSpanCount);
        }
        int adapterPosition = recycler.convertPreLayoutPositionToPostLayout(viewPosition);
        if (adapterPosition == -1) {
            Log.w((String)TAG, (String)("Cannot find span size for pre layout position. " + viewPosition));
            return 0;
        }
        return this.mSpanSizeLookup.getSpanGroupIndex(adapterPosition, this.mSpanCount);
    }

    private int getSpanIndex(CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state, int pos) {
        if (!state.isPreLayout()) {
            return this.mSpanSizeLookup.getCachedSpanIndex(pos, this.mSpanCount);
        }
        int cached = this.mPreLayoutSpanIndexCache.get(pos, -1);
        if (cached != -1) {
            return cached;
        }
        int adapterPosition = recycler.convertPreLayoutPositionToPostLayout(pos);
        if (adapterPosition == -1) {
            Log.w((String)TAG, (String)("Cannot find span size for pre layout position. It is not cached, not in the adapter. Pos:" + pos));
            return 0;
        }
        return this.mSpanSizeLookup.getCachedSpanIndex(adapterPosition, this.mSpanCount);
    }

    private int getSpanSize(CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state, int pos) {
        if (!state.isPreLayout()) {
            return this.mSpanSizeLookup.getSpanSize(pos);
        }
        int cached = this.mPreLayoutSpanSizeCache.get(pos, -1);
        if (cached != -1) {
            return cached;
        }
        int adapterPosition = recycler.convertPreLayoutPositionToPostLayout(pos);
        if (adapterPosition == -1) {
            Log.w((String)TAG, (String)("Cannot find span size for pre layout position. It is not cached, not in the adapter. Pos:" + pos));
            return 1;
        }
        return this.mSpanSizeLookup.getSpanSize(adapterPosition);
    }

    @Override
    void layoutChunk(CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state, CustomLinearLayoutManager.LayoutState layoutState, CustomLinearLayoutManager.LayoutChunkResult result) {
        View view;
        boolean layingOutInPrimaryDirection = layoutState.mItemDirection == 1;
        int count = 0;
        int consumedSpanCount = 0;
        int remainingSpan = this.mSpanCount;
        if (!layingOutInPrimaryDirection) {
            int itemSpanIndex = this.getSpanIndex(recycler, state, layoutState.mCurrentPosition);
            int itemSpanSize = this.getSpanSize(recycler, state, layoutState.mCurrentPosition);
            remainingSpan = itemSpanIndex + itemSpanSize;
        }
        while (count < this.mSpanCount && layoutState.hasMore(state) && remainingSpan > 0) {
            int pos = layoutState.mCurrentPosition;
            int spanSize = this.getSpanSize(recycler, state, pos);
            if (spanSize > this.mSpanCount) {
                throw new IllegalArgumentException("Item at position " + pos + " requires " + spanSize + " spans but CustomGridLayoutManager has only " + this.mSpanCount + " spans.");
            }
            if ((remainingSpan -= spanSize) < 0 || (view = layoutState.next(recycler)) == null) break;
            consumedSpanCount += spanSize;
            this.mSet[count] = view;
            ++count;
        }
        if (count == 0) {
            result.mFinished = true;
            return;
        }
        int maxSize = 0;
        this.assignSpans(recycler, state, count, consumedSpanCount, layingOutInPrimaryDirection);
        for (int i = 0; i < count; ++i) {
            view = this.mSet[i];
            if (layoutState.mScrapList == null) {
                if (layingOutInPrimaryDirection) {
                    this.addView(view);
                } else {
                    this.addView(view, 0);
                }
            } else if (layingOutInPrimaryDirection) {
                this.addDisappearingView(view);
            } else {
                this.addDisappearingView(view, 0);
            }
            int spanSize = this.getSpanSize(recycler, state, this.getPosition(view));
            int spec = View.MeasureSpec.makeMeasureSpec((int)(this.mSizePerSpan * spanSize), (int)0x40000000);
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            if (this.mOrientation == 1) {
                this.measureChildWithDecorationsAndMargin(view, spec, this.getMainDirSpec(lp.height));
            } else {
                this.measureChildWithDecorationsAndMargin(view, this.getMainDirSpec(lp.width), spec);
            }
            int size = this.mOrientationHelper.getDecoratedMeasurement(view);
            if (size <= maxSize) continue;
            maxSize = size;
        }
        int maxMeasureSpec = this.getMainDirSpec(maxSize);
        for (int i = 0; i < count; ++i) {
            View view2 = this.mSet[i];
            if (this.mOrientationHelper.getDecoratedMeasurement(view2) == maxSize) continue;
            int spanSize = this.getSpanSize(recycler, state, this.getPosition(view2));
            int spec = View.MeasureSpec.makeMeasureSpec((int)(this.mSizePerSpan * spanSize), (int)0x40000000);
            if (this.mOrientation == 1) {
                this.measureChildWithDecorationsAndMargin(view2, spec, maxMeasureSpec);
                continue;
            }
            this.measureChildWithDecorationsAndMargin(view2, maxMeasureSpec, spec);
        }
        result.mConsumed = maxSize;
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        if (this.mOrientation == 1) {
            if (layoutState.mLayoutDirection == -1) {
                bottom = layoutState.mOffset;
                top = bottom - maxSize;
            } else {
                top = layoutState.mOffset;
                bottom = top + maxSize;
            }
        } else if (layoutState.mLayoutDirection == -1) {
            right = layoutState.mOffset;
            left = right - maxSize;
        } else {
            left = layoutState.mOffset;
            right = left + maxSize;
        }
        for (int i = 0; i < count; ++i) {
            View view3 = this.mSet[i];
            LayoutParams params = (LayoutParams)view3.getLayoutParams();
            if (this.mOrientation == 1) {
                left = this.getPaddingLeft() + this.mSizePerSpan * params.mSpanIndex;
                right = left + this.mOrientationHelper.getDecoratedMeasurementInOther(view3);
            } else {
                top = this.getPaddingTop() + this.mSizePerSpan * params.mSpanIndex;
                bottom = top + this.mOrientationHelper.getDecoratedMeasurementInOther(view3);
            }
            this.layoutDecorated(view3, left + params.leftMargin, top + params.topMargin, right - params.rightMargin, bottom - params.bottomMargin);
            if (params.isItemRemoved() || params.isItemChanged()) {
                result.mIgnoreConsumed = true;
            }
            result.mFocusable |= view3.isFocusable();
        }
        Arrays.fill(this.mSet, null);
    }

    private int getMainDirSpec(int dim) {
        if (dim < 0) {
            return MAIN_DIR_SPEC;
        }
        return View.MeasureSpec.makeMeasureSpec((int)dim, (int)0x40000000);
    }

    private void measureChildWithDecorationsAndMargin(View child, int widthSpec, int heightSpec) {
        this.calculateItemDecorationsForChild(child, this.mDecorInsets);
        CustomRecyclerView.LayoutParams lp = (CustomRecyclerView.LayoutParams)child.getLayoutParams();
        widthSpec = this.updateSpecWithExtra(widthSpec, lp.leftMargin + this.mDecorInsets.left, lp.rightMargin + this.mDecorInsets.right);
        heightSpec = this.updateSpecWithExtra(heightSpec, lp.topMargin + this.mDecorInsets.top, lp.bottomMargin + this.mDecorInsets.bottom);
        child.measure(widthSpec, heightSpec);
    }

    private int updateSpecWithExtra(int spec, int startInset, int endInset) {
        if (startInset == 0 && endInset == 0) {
            return spec;
        }
        int mode = View.MeasureSpec.getMode((int)spec);
        if (mode == Integer.MIN_VALUE || mode == 0x40000000) {
            return View.MeasureSpec.makeMeasureSpec((int)(View.MeasureSpec.getSize((int)spec) - startInset - endInset), (int)mode);
        }
        return spec;
    }

    private void assignSpans(CustomRecyclerView.Recycler recycler, CustomRecyclerView.State state, int count, int consumedSpanCount, boolean layingOutInPrimaryDirection) {
        int spanDiff;
        int span;
        int diff;
        int end;
        int start;
        if (layingOutInPrimaryDirection) {
            start = 0;
            end = count;
            diff = 1;
        } else {
            start = count - 1;
            end = -1;
            diff = -1;
        }
        if (this.mOrientation == 1 && this.isLayoutRTL()) {
            span = consumedSpanCount - 1;
            spanDiff = -1;
        } else {
            span = 0;
            spanDiff = 1;
        }
        for (int i = start; i != end; i += diff) {
            View view = this.mSet[i];
            LayoutParams params = (LayoutParams)view.getLayoutParams();
            params.mSpanSize = this.getSpanSize(recycler, state, this.getPosition(view));
            if (spanDiff == -1 && params.mSpanSize > 1) {
                params.mSpanIndex = span - (params.mSpanSize - 1);
            } else {
                params.mSpanIndex = span;
            }
            span += spanDiff * params.mSpanSize;
        }
    }

    public int getSpanCount() {
        return this.mSpanCount;
    }

    public void setSpanCount(int spanCount) {
        if (spanCount == this.mSpanCount) {
            return;
        }
        if (spanCount < 1) {
            throw new IllegalArgumentException("Span count should be at least 1. Provided " + spanCount);
        }
        this.mSpanCount = spanCount;
        this.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    @Override
    public boolean supportsPredictiveItemAnimations() {
        return this.mPendingSavedState == null;
    }

    public static class LayoutParams
    extends CustomRecyclerView.LayoutParams {
        public static final int INVALID_SPAN_ID = -1;
        private int mSpanIndex = -1;
        private int mSpanSize = 0;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(CustomRecyclerView.LayoutParams source) {
            super(source);
        }

        public int getSpanIndex() {
            return this.mSpanIndex;
        }

        public int getSpanSize() {
            return this.mSpanSize;
        }
    }

    public static final class DefaultSpanSizeLookup
    extends SpanSizeLookup {
        @Override
        public int getSpanSize(int position) {
            return 1;
        }

        @Override
        public int getSpanIndex(int position, int spanCount) {
            return position % spanCount;
        }
    }

    public static abstract class SpanSizeLookup {
        final SparseIntArray mSpanIndexCache = new SparseIntArray();
        private boolean mCacheSpanIndices = false;

        public abstract int getSpanSize(int var1);

        public void setSpanIndexCacheEnabled(boolean cacheSpanIndices) {
            this.mCacheSpanIndices = cacheSpanIndices;
        }

        public void invalidateSpanIndexCache() {
            this.mSpanIndexCache.clear();
        }

        public boolean isSpanIndexCacheEnabled() {
            return this.mCacheSpanIndices;
        }

        int getCachedSpanIndex(int position, int spanCount) {
            if (!this.mCacheSpanIndices) {
                return this.getSpanIndex(position, spanCount);
            }
            int existing = this.mSpanIndexCache.get(position, -1);
            if (existing != -1) {
                return existing;
            }
            int value = this.getSpanIndex(position, spanCount);
            this.mSpanIndexCache.put(position, value);
            return value;
        }

        public int getSpanIndex(int position, int spanCount) {
            int prevKey;
            int positionSpanSize = this.getSpanSize(position);
            if (positionSpanSize == spanCount) {
                return 0;
            }
            int span = 0;
            int startPos = 0;
            if (this.mCacheSpanIndices && this.mSpanIndexCache.size() > 0 && (prevKey = this.findReferenceIndexFromCache(position)) >= 0) {
                span = this.mSpanIndexCache.get(prevKey) + this.getSpanSize(prevKey);
                startPos = prevKey + 1;
            }
            for (int i = startPos; i < position; ++i) {
                int size = this.getSpanSize(i);
                if ((span += size) == spanCount) {
                    span = 0;
                    continue;
                }
                if (span <= spanCount) continue;
                span = size;
            }
            if (span + positionSpanSize <= spanCount) {
                return span;
            }
            return 0;
        }

        int findReferenceIndexFromCache(int position) {
            int lo = 0;
            int hi = this.mSpanIndexCache.size() - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                int midVal = this.mSpanIndexCache.keyAt(mid);
                if (midVal < position) {
                    lo = mid + 1;
                    continue;
                }
                hi = mid - 1;
            }
            int index = lo - 1;
            if (index >= 0 && index < this.mSpanIndexCache.size()) {
                return this.mSpanIndexCache.keyAt(index);
            }
            return -1;
        }

        public int getSpanGroupIndex(int adapterPosition, int spanCount) {
            int span = 0;
            int group = 0;
            int positionSpanSize = this.getSpanSize(adapterPosition);
            for (int i = 0; i < adapterPosition; ++i) {
                int size = this.getSpanSize(i);
                if ((span += size) == spanCount) {
                    span = 0;
                    ++group;
                    continue;
                }
                if (span <= spanCount) continue;
                span = size;
                ++group;
            }
            if (span + positionSpanSize > spanCount) {
                ++group;
            }
            return group;
        }
    }
}

