package com.kidoz.sdk.api.ui_views.panel_view;

import android.content.Context;
import android.widget.RelativeLayout;

import com.custom_recycler_view.CustomLinearLayoutManager;
import com.custom_recycler_view.CustomRecyclerView;
import com.custom_recycler_view.DefaultItemAnimator;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.structure.ContentItem;

import java.util.ArrayList;

/**
 * Created by roni on 10/7/2015.
 */
public class PanelSliderView extends RelativeLayout
{
    private PANEL_TYPE mPanelType;
    private CustomRecyclerView mCustomRecyclerView;
    private PanelAdapter mPanelAdapter;

    public PanelSliderView(Context context)
    {
        super(context);
        initView();
    }

    private void initView()
    {
        initRecyclerView();
    }

    public void initRecyclerView()
    {
        // Create an instance of the recycler view
        mCustomRecyclerView = new CustomRecyclerView(getContext());
        mCustomRecyclerView.setHasFixedSize(true);
        mCustomRecyclerView.setItemAnimator(new DefaultItemAnimator());
        mCustomRecyclerView.setClipToPadding(false);

        CustomLinearLayoutManager customLinearLayoutManager = new CustomLinearLayoutManager(getContext(), CustomLinearLayoutManager.HORIZONTAL, false);
        mCustomRecyclerView.setLayoutManager(customLinearLayoutManager);

        // Init the adapter
        mPanelAdapter = new PanelAdapter();
        mCustomRecyclerView.setAdapter(mPanelAdapter);

        // Add the recycler view to the root layout
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        addView(mCustomRecyclerView, params);
    }

    private void preparePanelSlider()
    {
        // Set the width and height and layout manager orientation
        float SCALE_FACTOR = ScreenUtils.getScaleFactor(getContext());
        int itemWidth = (int) (517f * SCALE_FACTOR);
        int itemHeight = (int) (402f * SCALE_FACTOR);
        int padding = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(getContext(), 3);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        CustomLinearLayoutManager customLinearLayoutManager = new CustomLinearLayoutManager(getContext(), CustomLinearLayoutManager.HORIZONTAL, false);
        switch (mPanelType)
        {
            case LEFT:
            {
                params.width = itemWidth + (padding * 4);
                params.height = LayoutParams.MATCH_PARENT;
                mCustomRecyclerView.setPadding(padding, padding, 0, padding);
                customLinearLayoutManager.setOrientation(CustomLinearLayoutManager.VERTICAL);
                break;
            }
            case TOP:
            {
                params.width = LayoutParams.MATCH_PARENT;
                params.height = itemHeight + (padding * 3);
                mCustomRecyclerView.setPadding(padding, padding, padding, 0);
                customLinearLayoutManager.setOrientation(CustomLinearLayoutManager.HORIZONTAL);
                break;
            }
            case RIGHT:
            {
                params.width = itemWidth + (padding * 4);
                params.height = LayoutParams.MATCH_PARENT;
                mCustomRecyclerView.setPadding(0, padding, padding, padding);
                customLinearLayoutManager.setOrientation(CustomLinearLayoutManager.VERTICAL);
                break;
            }
            case BOTTOM:
            {
                params.width = LayoutParams.MATCH_PARENT;
                params.height = itemHeight + (padding * 3);
                mCustomRecyclerView.setPadding(0, padding, padding, padding);
                customLinearLayoutManager.setOrientation(CustomLinearLayoutManager.HORIZONTAL);
                break;
            }
        }
        mCustomRecyclerView.setLayoutParams(params);
        mCustomRecyclerView.setLayoutManager(customLinearLayoutManager);
    }

    public void setPanelType(PANEL_TYPE panelType)
    {
        mPanelType = panelType;
        preparePanelSlider();
    }

    public void setContent(ArrayList<ContentItem> content)
    {
        mPanelAdapter.setContent(content);
    }

    public void clearContent()
    {
        mPanelAdapter.clearContent();
    }

    public void setPanelViewListener(PanelViewListener panelViewListener)
    {
        mPanelAdapter.setPanelViewListener(panelViewListener);
    }
}
