package com.kidoz.sdk.api.ui_views.panel_view;

import android.animation.Animator;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;

import com.custom_recycler_view.CustomRecyclerView;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.AnimationsUtils;
import com.kidoz.sdk.api.structure.ContentItem;

import java.util.ArrayList;

/**
 * Created by roni on 10/7/2015.
 */
public class PanelAdapter extends CustomRecyclerView.Adapter<PanelAdapter.ViewHolder> implements View.OnClickListener
{
    private PanelViewListener mPanelViewListener;
    private ArrayList<ContentItem> mContent;
    private Handler mHandler;
    private boolean mIsCanClick;
    private int mLastPosition;

    public PanelAdapter()
    {
        mLastPosition = -1;
        mContent = new ArrayList<>();
        mHandler = new Handler();
        mIsCanClick = true;
    }

    public void setContent(ArrayList<ContentItem> content)
    {
        synchronized (this)
        {
            if (content != null)
            {
                if (mContent.isEmpty() == true)
                {
                    mContent.clear();
                    mContent.addAll(content);
                    notifyItemRangeInserted(0, getItemCount());
                    notifyItemRangeChanged(0, getItemCount());
                }
                else
                {
                    mContent.clear();
                    mContent.addAll(content);
                    notifyDataSetChanged();
                }
            }
        }
    }

    public void clearContent()
    {
        synchronized (this)
        {
            if (mContent != null)
            {
                mLastPosition = -1;
                if (mContent.isEmpty() == true)
                {
                    notifyItemRangeRemoved(0, getItemCount());
                    notifyItemRangeChanged(0, getItemCount());
                    mContent.clear();
                }
                else
                {
                    mContent.clear();
                    notifyDataSetChanged();
                }
            }
        }
    }

    public class ViewHolder extends CustomRecyclerView.ViewHolder
    {
        private PanelContentItem mPanelContentItem;

        public ViewHolder(PanelContentItem view)
        {
            super(view);
            mPanelContentItem = view;
        }

        public void setData(ContentItem contentItem)
        {
            mPanelContentItem.setData(contentItem);
        }
    }

    @Override public int getItemCount()
    {
        int result = 0;
        if (mContent != null)
        {
            result = mContent.size();
        }
        return result;
    }

    @Override public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType)
    {
        PanelContentItem panelContentItem = new PanelContentItem(parent.getContext());
        ViewHolder viewHolder = new ViewHolder(panelContentItem);
        viewHolder.mPanelContentItem.setOnClickListener(this);
        viewHolder.mPanelContentItem.setTag(viewHolder);

        return viewHolder;
    }

    @Override public void onBindViewHolder(final ViewHolder holder, int position)
    {
        ContentItem contentItem = mContent.get(position);
        holder.setData(contentItem);

        if (position > mLastPosition)
        {
            holder.mPanelContentItem.setVisibility(View.INVISIBLE);
            mHandler.postDelayed(new Runnable()
            {
                @Override public void run()
                {
                    GenAnimator.recycleItemAnimation(holder.mPanelContentItem, new GenAnimator.ViewAnimationListener()
                    {
                        @Override public void onAnimationEnd()
                        {
                        }

                        @Override public void onAnimationStart()
                        {
                            holder.mPanelContentItem.setVisibility(View.VISIBLE);
                        }
                    });
                }
            }, 0);
            mLastPosition = position;
        }
        else
        {
            holder.mPanelContentItem.clearAnimation();
            holder.mPanelContentItem.setVisibility(View.VISIBLE);
        }
    }

    @Override public void onClick(final View view)
    {
        if (mIsCanClick == true)
        {
            mIsCanClick = false;

            AnimationsUtils.animateClick(view, new Animator.AnimatorListener()
            {
                @Override public void onAnimationStart(Animator animation)
                {
                }

                @Override public void onAnimationEnd(Animator animation)
                {
                    final ViewHolder viewHolder = (ViewHolder) view.getTag();
                    int position = viewHolder.getAdapterPosition();
                    ContentItem contentItem = mContent.get(position);
                    if (position == CustomRecyclerView.NO_POSITION)
                    {
                        position = viewHolder.getPosition();
                    }
                    if (position != CustomRecyclerView.NO_POSITION)
                    {
                        if (mPanelViewListener != null)
                        {
                            mPanelViewListener.onItemClick(contentItem, position);
                        }
                    }
                    mIsCanClick = true;
                }

                @Override public void onAnimationCancel(Animator animation)
                {

                }

                @Override public void onAnimationRepeat(Animator animation)
                {

                }
            }, 50, 100);
        }
    }

    public void setPanelViewListener(PanelViewListener panelViewListener)
    {
        mPanelViewListener = panelViewListener;
    }
}
