package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.Gravity;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kidoz.sdk.api.general.utils.AppAssetsUtils;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;

import java.io.File;

/**
 * Created by roni on 9/29/2015.
 */
public class TitleView extends RelativeLayout
{
    private final String TAG = TitleView.class.getSimpleName();

    private ImageView mImageView;
    private TextView mTitle;
    private Paint mWhitePaint;
    private File mImageFile;
    private float mScaleFactor;
    private int mWidth;
    private int mHeight;

    public TitleView(Context context)
    {
        super(context);
        initView();
    }

    private void initView()
    {
        setWillNotDraw(false);
        initImageFile();
        initImageParameters();
        initPaints();
        initImageView();
        initTitle();
    }


    private void initTitle()
    {
        float TEXT_SIZE = 50f / 140f;
        mTitle = new TextView(getContext());
        mTitle.setSingleLine(true);
        mTitle.setTextColor(Color.parseColor("#04a0e1"));
        mTitle.setTextSize(TypedValue.COMPLEX_UNIT_PX, (int) (TEXT_SIZE * mHeight));
        mTitle.setGravity(Gravity.CENTER_VERTICAL | Gravity.LEFT);
        mTitle.setEllipsize(TextUtils.TruncateAt.END);
        mTitle.setShadowLayer(2.0f, 1, 1, Color.parseColor("#666666"));
        mTitle.setTypeface(null, Typeface.BOLD);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        addView(mTitle, params);
    }

    private void initImageView()
    {
        mImageView = new ImageView(getContext());
        mImageView.setScaleType(ImageView.ScaleType.FIT_XY);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(mWidth, mHeight);
        addView(mImageView, params);
    }

    private void initImageFile()
    {
        mImageFile = AppAssetsUtils.getAssetFile(getContext(), AppAssetsUtils.APP_ASSET_TYPE.TOP_BAR_TITLE);
    }

    private void initImageParameters()
    {
        mScaleFactor = ScreenUtils.getScaleFactor(getContext());
        mWidth = 710;
        mHeight = 140;
        if (mImageFile.exists() == true)
        {
            String width = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), AppAssetsUtils.TOP_BAR_TITLE_WIDTH, "710", Context.MODE_PRIVATE);
            String height = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), AppAssetsUtils.TOP_BAR_TITLE_HEIGHT, "140", Context.MODE_PRIVATE);

            try
            {
                mWidth = Integer.parseInt(width);
                mHeight = Integer.parseInt(height);
            }
            catch (Exception ex)
            {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to init image parameters: " + ex.getMessage());
            }
        }
        mWidth *= mScaleFactor;
        mHeight *= mScaleFactor;
    }

    private void initPaints()
    {
        mWhitePaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        mWhitePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        mWhitePaint.setColor(Color.parseColor("#ffffff"));

        setLayerType(LAYER_TYPE_SOFTWARE, mWhitePaint);
    }

    private void loadImage()
    {
        if (mImageFile.exists() == true)
        {
            if (mImageView.getDrawable() == null)
            {
                PicassoOk.getPicasso(getContext()).load(mImageFile).into(mImageView);
            }
        }
    }

    @Override protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec)
    {
        setMeasuredDimension(mWidth, mHeight);
    }

    @Override protected void onLayout(boolean changed, int l, int t, int r, int b)
    {
        getChildAt(0).layout(0, 0, getMeasuredWidth(), getMeasuredHeight());

        float TEXT_WIDTH = 524f / 710f;
        float MARGIN_LEFT = 109f / 710f;
        float MARGIN_TOP = 20f / 140f;
        getChildAt(1).layout((int) (MARGIN_LEFT * mWidth), (int) (MARGIN_TOP * mHeight), (int) (TEXT_WIDTH * mWidth), getMeasuredHeight());
    }

    @Override protected void onDraw(Canvas canvas)
    {
        super.onDraw(canvas);
        if (mImageFile.exists() == false)
        {
            // Draw first circle
            float radius = (110f / 710f) * mWidth;
            float centerX = (85f / 710f) * mWidth;
            float centerY = (15f / 140f) * mHeight;
            canvas.drawCircle(centerX, centerY, radius, mWhitePaint);

            // Draw second circle
            radius = (167.04f / 710f) * mWidth;
            centerX = (241.61f / 710f) * mWidth;
            centerY = (-27.4f / 140f) * mHeight;
            canvas.drawCircle(centerX, centerY, radius, mWhitePaint);

            // Draw third circle
            radius = (167.05f / 710f) * mWidth;
            centerX = (420.61f / 710f) * mWidth;
            centerY = (-27.05f / 140f) * mHeight;
            canvas.drawCircle(centerX, centerY, radius, mWhitePaint);

            // Draw third circle
            radius = (93f / 710f) * mWidth;
            centerX = (617f / 710f) * mWidth;
            centerY = (-23f / 140f) * mHeight;
            canvas.drawCircle(centerX, centerY, radius, mWhitePaint);
        }
        else
        {
            loadImage();
        }
    }

    public void setTitle(String title)
    {
        mTitle.setText(title);
    }
}
