package com.kidoz.sdk.api.ui_views;


import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.general.custom_views.KidozBottomBar;
import com.kidoz.sdk.api.general.custom_views.KidozTopBar;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.structure.ContentData;

/**
 * Created by User on 16/07/2015.
 */
public class FeedFullVeiw extends FrameLayout
{

    private ContentPanelView mContentPanelView;
    private ContentData mContentData;

    private KidozTopBar mKidozTopBar;
    private KidozBottomBar mKidozBottomBar;
    private com.kidoz.sdk.api.general.utils.Utils.StaticHandler mStaticHandler = new com.kidoz.sdk.api.general.utils.Utils.StaticHandler();

    // Close button click listener
    private OnClickListener mCloseBtnClickListener = null;

    public FeedFullVeiw(Context context)
    {
        super(context);
        initView();
    }

    @Override protected void onConfigurationChanged(Configuration newConfig)
    {
        super.onConfigurationChanged(newConfig);
        com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog("HERE", ">>>>FeedFullVeiw: onConfigurationChanged");
    }

    private void initView()
    {
        //Create container view.
        RelativeLayout containerLayout = new RelativeLayout(getContext());
        containerLayout.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));

        GradientDrawable gradientDrawable = new GradientDrawable(
                GradientDrawable.Orientation.TOP_BOTTOM,
                new int[]{Color.parseColor("#98e0ff"),Color.parseColor("#e0e4ed"),Color.parseColor("#98e0ff")}
        );
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            containerLayout.setBackground(gradientDrawable);
        }else {
            containerLayout.setBackgroundDrawable(gradientDrawable);
        }

        // Create header to container.
        mKidozTopBar = new KidozTopBar(getContext(), false);
        mKidozTopBar.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        mKidozTopBar.setTitle("More Cool Stuff");
        mKidozTopBar.setKidozTopBarListener(new KidozTopBar.KidozTopBarListener()
        {
            @Override public void onExitClicked(View view)
            {
                if (mCloseBtnClickListener != null)
                {
                    mCloseBtnClickListener.onClick(null);
                }
            }

        });
        mKidozTopBar.showParentalLockIcon(true);

        // Create footer to container.
        mKidozBottomBar = new KidozBottomBar(getContext());
        mKidozBottomBar.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());

        //Create main feed view.
        mContentPanelView = new ContentPanelView(getContext(), ContentPanelView.LayoutViewType.STAGGERED);
        mContentPanelView.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());

        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        // Add main view.
        containerLayout.addView(mContentPanelView, params);

        // Add top bar.
        params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        containerLayout.addView(mKidozTopBar, params);

        // Add botom bar.
        params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        containerLayout.addView(mKidozBottomBar, params);

        addView(containerLayout, new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT));
        initOnBoardingCloud();
    }

    public void setContentDataAndRefresh(ContentData contentData)
    {
        mContentData = contentData;
        // set biew styling
        applyViewStyling();
        if (mContentData != null)
        {
            String alreadyBoardedKey = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), OnBoardingView.ON_BOARDING_SHARED_PREFERENCES_KEY);
            if (alreadyBoardedKey == null)
            {
                SharedPreferencesUtils.saveSharedPreferencesData(getContext(), OnBoardingView.ON_BOARDING_SHARED_PREFERENCES_KEY, OnBoardingView.ON_BOARDING_SHARED_PREFERENCES_KEY);
                postDelayed(new Runnable()
                {
                    @Override public void run()
                    {
                        mContentPanelView.addDatandRefreshView(mContentData.getContentDataItems());
                    }
                }, 3200);
            }
            else
            {
                mContentPanelView.addDatandRefreshView(mContentData.getContentDataItems());
            }
        }
    }

    /**
     * Apply view customization settings recieved from the server
     */
    private void applyViewStyling()
    {
        /*
        mContentPanelView.setBackgroundColor(mContentData.getContainerViewBgColor());
        mKidozTopBar.setTopBarBackgroundColor(mContentData.getHeaderViewBgColor());
        mKidozTopBar.setTitle(mContentData.getHeaderTextStr());
        mKidozBottomBar.setBottomBarBackgroundColor(mContentData.getFooterViewBgColor());
        mKidozBottomBar.setImageUri(com.kidoz.sdk.api.general.utils.Utils.prepareCorrectUri(mContentData.getPowerByUrl()));*/

        if (mContentData != null)
        {

            mKidozBottomBar.setBackgroundURI();
            mContentPanelView.setRoundingCorenrsValue(mContentData.getViewItemCorenrRadiusPx());
        }
    }

    /**
     * Set on close button click listener
     *
     * @param clickListenr click listener
     */
    public void setOnCloseButtonClickListenr(OnClickListener clickListenr)
    {
        mCloseBtnClickListener = clickListenr;
        if (mKidozBottomBar != null)
        {
            mKidozTopBar.setKidozTopBarListener(new KidozTopBar.KidozTopBarListener()
            {
                @Override public void onExitClicked(View view)
                {
                    if (mCloseBtnClickListener != null)
                    {
                        mCloseBtnClickListener.onClick(null);
                    }
                }
            });
        }
    }

    /**
     * Set on content item click listener
     *
     * @param listener click listener
     */
    public void setOnContentItemClickListener(ContentPanelView.IOnContentItemClickListener listener)
    {
        if (mContentPanelView != null)
        {
            mContentPanelView.setOnContentItemClickListener(listener);
        }
    }

    public void screenStatusChanged(boolean screenOn)
    {
        mContentPanelView.screenStatusChanged(screenOn);
    }

    private void initOnBoardingCloud()
    {
        String alreadyBoardedKey = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), OnBoardingView.ON_BOARDING_SHARED_PREFERENCES_KEY + "2");
        if (alreadyBoardedKey == null)
        {
            SharedPreferencesUtils.saveSharedPreferencesData(getContext(), OnBoardingView.ON_BOARDING_SHARED_PREFERENCES_KEY + "2", OnBoardingView.ON_BOARDING_SHARED_PREFERENCES_KEY);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
            final OnBoardingView onBoardingView = new OnBoardingView(getContext());
            addView(onBoardingView, params);
            getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener()
            {
                @Override public void onGlobalLayout()
                {
                    if (Build.VERSION.SDK_INT < 16)
                    {
                        getViewTreeObserver().removeGlobalOnLayoutListener(this);
                    }
                    else
                    {
                        getViewTreeObserver().removeOnGlobalLayoutListener(this);
                    }
                    onBoardingView.animateView(new OnBoardingView.OnBoardingCloudInterface()
                    {
                        @Override public void onFinished()
                        {
                            removeView(onBoardingView);
                        }
                    });
                }
            });
        }
    }


    public KidozBottomBar getViewBottomBar()
    {
        return mKidozBottomBar;
    }
}


