package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.util.AttributeSet;

import com.custom_recycler_view.CustomGridLayoutManager;
import com.custom_recycler_view.CustomLinearLayoutManager;
import com.custom_recycler_view.CustomRecyclerView;
import com.custom_recycler_view.CustomStaggeredGridLayoutManager;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.custom_views.KidozBottomBar;
import com.kidoz.sdk.api.general.custom_views.KidozTopBar;
import com.kidoz.sdk.api.structure.ContentItem;

import java.util.ArrayList;


/**
 * Created by Eugine on 15/07/2015.
 * A Feed panel implementation view
 */

public class ContentPanelView extends AbstractContentPanel {
    /**
     * Feed panel layout view types
     */
    public enum LayoutViewType {
        STAGGERED, GRID, LINEAR_VERTICAL, LINEAR_HORIZONTAL
    }

    private CustomRecyclerView mCustomRecyclerView;
    private RecycleEndlessScrollListener endlesScollPaginghandler;
    private ItemVerticalRecycleViewAdapter mAdapter;

    private CustomStaggeredGridLayoutManager mStaggaredLayoutManager;
    private CustomGridLayoutManager mCustomGridLayoutManager;
    private CustomLinearLayoutManager mLinearLayoutManager;

    //private SwipeRefreshLayout swipeRefreshLayout;
    private LayoutViewType mLayoutViewType = LayoutViewType.STAGGERED;
    private ArrayList<ContentItem> mItemsList = new ArrayList<ContentItem>();

    private int[] fPos = new int[3];
    private int[] lPos = new int[3];
    private int mCurrentVisiblePosition = 0;

    public ContentPanelView(Context context, LayoutViewType layoutViewType) {
        super(context);
        mLayoutViewType = layoutViewType;
        initPanelView(context);
    }

    public ContentPanelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initPanelView(context);
    }

    public ContentPanelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initPanelView(context);
    }

    @Override
    public void initPanelView(Context context) {
        // initSwipeRefreshLayout(context);
        initRecyclerView(context);
        initAdaper();
        initLaoutManager();

        LayoutParams relParams = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
        addView(mCustomRecyclerView, relParams);
    }

   /* private void initSwipeRefreshLayout(Context context)
    {
        swipeRefreshLayout = new SwipeRefreshLayout(context);
        swipeRefreshLayout.setOnRefreshListener(null);
        swipeRefreshLayout.setEnabled(false);
        swipeRefreshLayout.setColorSchemeColors(Color.RED, Color.GRAY, Color.CYAN);
    }*/

    private void initRecyclerView(Context context) {
        mCustomRecyclerView = new CustomRecyclerView(context);
        mCustomRecyclerView.setClipToPadding(false);
        Point point = com.kidoz.sdk.api.general.utils.Utils.getScreenSize(getContext());
        int paddingBottom = (int) (Math.max(point.x, point.y) * KidozBottomBar.BACKGROUND_RATIO);
        int paddingTop = (int) (Math.max(point.x, point.y) * KidozTopBar.BACKGROUND_RATIO);
        mCustomRecyclerView.setPadding(0, paddingTop, 0, paddingBottom);
    }

    private void initLaoutManager() {
        setLayoutManagerView(mLayoutViewType);
    }

    private void initAdaper() {
        mAdapter = new ItemVerticalRecycleViewAdapter(getContext(), mItemsList, getCurrentSpanCount());

        endlesScollPaginghandler = new RecycleEndlessScrollListener(4) {
            @Override
            public void onLoadMore(int page, int totalItemsCount) {
                if (totalItemsCount > 0) {
                   /* FeedItem feedItem = mAdapter.getLastItemInList();
                    if (feedItem != null)
                    {
                        if (mFeedWallFragmentHelper != null)
                        {
                            mFeedWallFragmentHelper.loadSomeMoreKidFeedsFromServer(feedItem.getFeedItemCreateDateTimeStamp());
                        }
                    }*/
                }
            }
        };

        mCustomRecyclerView.setOnScrollListener(new CustomRecyclerView.OnScrollListener() {

            @Override
            public void onScrolled(CustomRecyclerView customRecyclerView, int dx, int dy) {
                super.onScrolled(customRecyclerView, dx, dy);
                mAdapter.setIsRegularAnimation(true);
                try {
                    if (mLayoutViewType == LayoutViewType.GRID || mLayoutViewType == LayoutViewType.LINEAR_HORIZONTAL || mLayoutViewType == LayoutViewType.LINEAR_VERTICAL) {
                        fPos[0] = mCustomGridLayoutManager.findFirstVisibleItemPosition();
                        lPos[0] = mCustomGridLayoutManager.findLastVisibleItemPosition();

                        endlesScollPaginghandler.onScroll(fPos[0], lPos[0] - fPos[0], mItemsList.size());

                    } else if (mLayoutViewType == LayoutViewType.STAGGERED) {
                        mStaggaredLayoutManager.findFirstVisibleItemPositions(fPos);
                        mStaggaredLayoutManager.findLastVisibleItemPositions(lPos);

                        endlesScollPaginghandler.onScroll(fPos[0], lPos[0] - fPos[0], mItemsList.size());
                    }
                } catch (Exception e) {
                }

                mCurrentVisiblePosition = fPos[0];


            }

            @Override
            public void onScrollStateChanged(CustomRecyclerView customRecyclerView, int newState) {
                try {


                    super.onScrollStateChanged(customRecyclerView, newState);
//
//                    //to save time make sure we stoped scroll
//                    if (newState == RecyclerView.SCROLL_STATE_IDLE)
//                    {
//                        int lastPos = lPos[0];
//                        if (lastPos < lPos[1])
//                        {
//                            lastPos = lPos[1];
//                            if (lastPos < lPos[2])
//                            {
//                                lastPos = lPos[2];
//                            }
//                        }
//                        for (int i = fPos[0]; i < lastPos; i++)
//                        {
//                            ContentItem item = mItemsList.get(i);
//                            if (item.isPromoted())
//                            {
//                                if (mSponsoredContentDisplayed.containsKey(item.getId()) == false)
//                                {
//                                    mSponsoredContentDisplayed.put(item.getId(), new Integer(i));
//                                    EventManager.getInstance().logSponsoredContentImpressionEvent(
//                                            getContext(),
//                                            EventParameters.ACTION_IMPRESSION_VIEWED, item.getName(),
//                                            item.getAdvertiserID(), item.getId(), i);
//                                }
//                            }
//                        }
//                    }
                } catch (Exception e) {

                }
            }
        });

        mCustomRecyclerView.setAdapter(mAdapter);
        if (mCurrentVisiblePosition != 0) {
            mCustomRecyclerView.scrollToPosition(mCurrentVisiblePosition);
        }
    }

    /**
     * Get current spann account calculated by the device type and orientation
     */
    private int getCurrentSpanCount() {
        return KidozSDK.getCreativeToolsData().getNumberOfColumns(getContext());
    }

    /**
     * Set choosen layout view type
     *
     * @param viewType layout view type
     */
    public void setLayoutManagerView(LayoutViewType viewType) {
        mLayoutViewType = viewType;
        switch (viewType) {
            case STAGGERED: {
                mStaggaredLayoutManager = new CustomStaggeredGridLayoutManager(getCurrentSpanCount(), CustomStaggeredGridLayoutManager.VERTICAL);
                mCustomRecyclerView.setLayoutManager(mStaggaredLayoutManager);
                break;
            }

            case GRID: {
                mCustomGridLayoutManager = new CustomGridLayoutManager(getContext(), getCurrentSpanCount());
                mCustomRecyclerView.setLayoutManager(mCustomGridLayoutManager);
                break;
            }

            case LINEAR_HORIZONTAL: {
                mLinearLayoutManager = new CustomLinearLayoutManager(getContext(), CustomLinearLayoutManager.HORIZONTAL, false);
                mCustomRecyclerView.setLayoutManager(mLinearLayoutManager);
                break;
            }

            case LINEAR_VERTICAL: {
                mLinearLayoutManager = new CustomLinearLayoutManager(getContext(), CustomLinearLayoutManager.VERTICAL, false);
                mCustomRecyclerView.setLayoutManager(mLinearLayoutManager);
                break;
            }
        }
    }

    /**
     * Set rounding corners size in pixels
     *
     * @param rounding rounding in pixels
     */
    public void setRoundingCorenrsValue(int rounding) {

    }

    /**
     * Set on content item click listener
     *
     * @param listener listener
     */
    public void setOnContentItemClickListener(IOnContentItemClickListener listener) {
        if (mAdapter != null) {
            mAdapter.setOnItemClickListener(listener);
        }
    }


    /**
     * Clear content data from view
     */
    public void clearDataFromView() {
        mItemsList.clear();
//      mSponsoredContentDisplayed.clear();
        mAdapter.clearContentDataWithNotify();
    }

    /**
     * Add content data to view
     */
    public void addDatandRefreshView(ArrayList<ContentItem> list) {
        if (list != null) {
            mItemsList.clear();
            mItemsList.addAll(list);
            //add position of promoted items
            mAdapter.notifyDataSetChanged();
        }
    }


    /**
     * notify about the screen status changed
     */
    public void screenStatusChanged(boolean screenOn) {
//        //clear visibility flag
//        for (ImpressionVisibility vc :mSponsoredContentPositionList)
//        {
//            vc.mVisible = false;
//        }
//
//        int lastPos = lPos[0];
//        if (lastPos<lPos[1])
//        {
//            lastPos = lPos[1];
//            if (lastPos<lPos[2])
//            {
//                lastPos = lPos[2];
//            }
//        }
//
//        for (ImpressionVisibility vc :mSponsoredContentPositionList)
//        {
//            if (vc.visibilityChanged(fPos[0],lastPos)==true)
//            {
//                ContentItem contentItem =  mItemsList.get(vc.mIndex);
//                EventManager.getInstance().logSponsoredContentImpressionEvent(
//                        getContext(),
//                        EventParameters.ACTION_IMPRESSION_VIEWED,contentItem.getName(),
//                        contentItem.getAdvertiserID(), contentItem.getId(), vc.mIndex);
//            }
//        }
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);

        int spanCount = getCurrentSpanCount();
        mAdapter.setSpanCount(spanCount, newConfig.orientation);
        setLayoutManagerView(mLayoutViewType);
        mCustomRecyclerView.scrollToPosition(mCurrentVisiblePosition);
    }

}
