package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.Gravity;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardView;


/**
 * Created by User on 13/07/2015.
 * A content view item implementation
 */
class ContentItemView extends KidozCardView {

    public static final int DEFAULT_CORNER_RADIUS_PIXELS = 6;
    public static final int DEFAULT_SHADOW_ELEVATION_RADIUS_DP = 4;
    public static final int MAIN_THUMB_FADE_DURATION = 120;

    public static final int CARD_OUTER_MARGIN = 4;
    public static final int VIEW_CONTENT_PADDING = 2;

    // Item card background view properties


    private RelativeLayout mInnerContainer;
    private ImageView mMainIconThumb;
    private ImageView mSecondaryThumb;
    private TextView mNameView;
    private int mOuterMargin;


    public ContentItemView(Context context) {
        super(context);

        initCardViewGeneral(context);
        initView(context);
    }

    /**
     * Main constructor
     *
     * @param roundingCorenrs item defined rounding corners
     */
    public ContentItemView(Context context, int roundingCorenrs) {
        super(context);

        initCardViewGeneral(context);
        initView(context);
    }

    // Initiate card and its properties
    private void initCardViewGeneral(Context context) {
        KidozCardView.LayoutParams params = new KidozCardView.LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
        mOuterMargin = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(context, CARD_OUTER_MARGIN);
        params.setMargins(mOuterMargin, mOuterMargin, mOuterMargin, mOuterMargin);
        setLayoutParams(params);
        int pad = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(context, VIEW_CONTENT_PADDING);
        setContentPadding(pad, pad, pad, pad);
        mInnerContainer = new RelativeLayout(context);
        setRadius(com.kidoz.sdk.api.general.utils.Utils.dpTOpx(context, DEFAULT_CORNER_RADIUS_PIXELS));
        setCardElevation(com.kidoz.sdk.api.general.utils.Utils.dpTOpx(context, DEFAULT_SHADOW_ELEVATION_RADIUS_DP));
    }


    private void initView(Context context) {

        //Crete inner layout that will have a bg color
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
        addView(mInnerContainer, layoutParams);

        // Crete main thumb view
        mMainIconThumb = new ImageView(context);
        mMainIconThumb.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        mMainIconThumb.setScaleType(ImageView.ScaleType.FIT_XY);

        //Add main thumb to inner container
        mInnerContainer.addView(mMainIconThumb, layoutParams);

        //Create secondary thumb icon
        mSecondaryThumb = new ImageView(context);
        mSecondaryThumb.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        mSecondaryThumb.setScaleType(ImageView.ScaleType.FIT_CENTER);
        //MAIN_THUMB_FADE_DURATION

        layoutParams = new RelativeLayout.LayoutParams(com.kidoz.sdk.api.general.utils.Utils.dpTOpx(context, 30), com.kidoz.sdk.api.general.utils.Utils.dpTOpx(context, 30));
        layoutParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        layoutParams.addRule(RelativeLayout.ALIGN_BOTTOM, mMainIconThumb.getId());
        layoutParams.setMargins(0, 0, com.kidoz.sdk.api.general.utils.Utils.dpTOpx(context, 10), com.kidoz.sdk.api.general.utils.Utils.dpTOpx(context, -25));
        mInnerContainer.addView(mSecondaryThumb, layoutParams);

        // Create view name/title/description
        mNameView = new TextView(context);
        mNameView.setId(com.kidoz.sdk.api.general.utils.Utils.generateViewId());
        mNameView.setTextColor(Color.parseColor("#484848"));
        mNameView.setTextSize(TypedValue.COMPLEX_UNIT_SP, getNameTextSizeByScreenLayout(getContext()));
        mNameView.setLines(2);
        mNameView.setEllipsize(TextUtils.TruncateAt.END);
        mNameView.setGravity(Gravity.CENTER_VERTICAL);
        mNameView.setPadding(0, com.kidoz.sdk.api.general.utils.Utils.dpTOpx(context, 4), 0, com.kidoz.sdk.api.general.utils.Utils.dpTOpx(context, 4));

        layoutParams = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
        layoutParams.addRule(RelativeLayout.BELOW, mMainIconThumb.getId());
        layoutParams.addRule(RelativeLayout.LEFT_OF, mSecondaryThumb.getId());
        layoutParams.setMargins(com.kidoz.sdk.api.general.utils.Utils.dpTOpx(context, 6), com.kidoz.sdk.api.general.utils.Utils.dpTOpx(context, 0), com.kidoz.sdk.api.general.utils.Utils.dpTOpx(context, 6), 0);
        mInnerContainer.addView(mNameView, layoutParams);
    }

    public ImageView getMainThumbView() {
        return mMainIconThumb;
    }


    public ImageView getSecondaryThumbView() {
        return mSecondaryThumb;
    }

    public TextView getNameTextView() {
        return mNameView;
    }

    public void setItemBgColor(int color) {
        setCardBackgroundColor(color);
    }


    private static int getNameTextSizeByScreenLayout(Context context) {

        int size = 16;
        int screenLayout = context.getResources().getConfiguration().screenLayout;
        screenLayout &= Configuration.SCREENLAYOUT_SIZE_MASK;

        switch (screenLayout) {
            case Configuration.SCREENLAYOUT_SIZE_SMALL: {
                size = 13;
                break;
            }

            case Configuration.SCREENLAYOUT_SIZE_NORMAL: {
                size = 15;
                break;
            }

            case Configuration.SCREENLAYOUT_SIZE_LARGE: {
                size = 17;
                break;
            }

            case Configuration.SCREENLAYOUT_SIZE_XLARGE: {
                size = 21;
                break;
            }
        }
        return size;
    }

    public static int getViewMargin(Context context) {
        return com.kidoz.sdk.api.general.utils.Utils.dpTOpx(context, CARD_OUTER_MARGIN);
    }
}

