package com.kidoz.sdk.api.structure;

import android.content.Context;
import android.content.res.Configuration;

/**
 * Created by roni on 7/27/2015.
 */
public class CreativeToolsData
{
    private int mNumberOfColumnsInPortraitPhone;
    private int mNumberOfColumnsInLandscapePhone;
    private int mNumberOfColumnsInPortraitTablet;
    private int mNumberOfColumnsInLandscapeTablet;

    public CreativeToolsData()
    {
        mNumberOfColumnsInPortraitPhone = Integer.MIN_VALUE;
        mNumberOfColumnsInLandscapePhone = Integer.MIN_VALUE;
        mNumberOfColumnsInPortraitTablet = Integer.MIN_VALUE;
        mNumberOfColumnsInLandscapeTablet = Integer.MIN_VALUE;
    }

    public int getNumberOfColumns(Context context)
    {
        int result = 2;
        if (context.getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE)
        {
            if (com.kidoz.sdk.api.general.utils.Utils.getIsDeviceTablet(context) == true)
            {
                // Landscape and Tablet
                result = 3;
                if (mNumberOfColumnsInLandscapeTablet != Integer.MIN_VALUE)
                {
                    result = mNumberOfColumnsInLandscapeTablet;
                }
            }
            else
            {
                // Landscape and Phone
                result = 2;
                if (mNumberOfColumnsInLandscapePhone != Integer.MIN_VALUE)
                {
                    result = mNumberOfColumnsInLandscapePhone;
                }
            }
        }
        else
        {
            if (com.kidoz.sdk.api.general.utils.Utils.getIsDeviceTablet(context) == true)
            {
                // Portrait and Tablet
                result = 2;
                if (mNumberOfColumnsInPortraitTablet != Integer.MIN_VALUE)
                {
                    result = mNumberOfColumnsInPortraitTablet;
                }
            }
            else
            {
                // Portrait and Phone
                result = 2;
                if (mNumberOfColumnsInPortraitPhone != Integer.MIN_VALUE)
                {
                    result = mNumberOfColumnsInPortraitPhone;
                }
            }
        }

        return result;
    }

    public void setNumberOfColumns(NUMBER_OF_COLUMNS_CONFIGURATION numberOfColumnsConfiguration, int numberOfColumns)
    {
        if (numberOfColumnsConfiguration != null)
        {
            switch (numberOfColumnsConfiguration)
            {
                case PHONE_LANDSCAPE:
                {
                    mNumberOfColumnsInLandscapePhone = numberOfColumns;
                    break;
                }
                case PHONE_PORTRAIT:
                {
                    mNumberOfColumnsInPortraitPhone = numberOfColumns;
                    break;
                }
                case TABLET_LANDSCAPE:
                {
                    mNumberOfColumnsInLandscapeTablet = numberOfColumns;
                    break;
                }
                case TABLET_PORTRAIT:
                {
                    mNumberOfColumnsInPortraitTablet = numberOfColumns;
                    break;
                }
            }
        }
    }

    public enum NUMBER_OF_COLUMNS_CONFIGURATION
    {
        TABLET_LANDSCAPE, TABLET_PORTRAIT, PHONE_LANDSCAPE, PHONE_PORTRAIT
    }
}
