package com.kidoz.sdk.api.receivers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

/**
 * Created by roni on 8/9/2015.
 */
public class SdkReceiver extends BroadcastReceiver
{
    private final String TAG = SdkReceiver.class.getSimpleName();

    @Override public void onReceive(Context context, Intent intent)
    {
        if (intent != null)
        {
            String action = intent.getAction();
            if (action != null)
            {
                if (action.equalsIgnoreCase(Intent.ACTION_PACKAGE_ADDED))
                {
                    if (intent.getData() != null)
                    {
                        String packageName = intent.getData().getSchemeSpecificPart();
                        if (packageName != null)
                        {
                            com.kidoz.sdk.api.general.utils.SDKLogger.printWarningLog("--------------------+++++++  INSTALL RECEIVER LAUNCHED ++++++ ------------------");

                            Intent serviceIntent = new Intent(context, com.kidoz.events.SyncEventService.class);
                            serviceIntent.putExtra(com.kidoz.events.SyncEventService.SYNC_TYPE_KEY, com.kidoz.events.SyncEventService.UPDATE_INSTALL_EVENT);
                            serviceIntent.putExtra(com.kidoz.events.SyncEventService.PACKAGE_NAME_KEY, packageName);
                            context.startService(serviceIntent);
                        }
                    }
                }
            }
        }
       // SharedPreferencesUtils.removeSharedPreferencesData(context, SharedPreferencesUtils.PROMOTED_APP_PACKAGE_NAME);
    }
}
