package com.kidoz.sdk.api.players.web_player;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Point;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.general.custom_views.KidozTopBar;
import com.kidoz.sdk.api.general.utils.Utils;

/**
 * Created by Eugine on 7/22/2015.
 */
public class WebPlayerView extends FrameLayout
{

    private static final int DEFAULT_TOP_BAR_COLOR = Color.parseColor("#36a7ec");

    private RelativeLayout mInnerContainer;
    private KidozTopBar mKidozTopBar;
    private KidozWebView mKidozWebView;
    private WebPlayerType mWebPlayerType;

    private OnClickListener mCloseBtnClickListener = null;
    private IOnRemoveViewRequestListener mRemoveViewRequestListener;

    public WebPlayerView(Context context, WebPlayerType webPlayerType)
    {
        super(context);
        if (webPlayerType != null && webPlayerType == WebPlayerType.EXTERNAL_LINK)
        {
            setAlpha(0);
        }
        else
        {
            setAlpha(1);
        }
        mWebPlayerType = webPlayerType;

        initiateView();
    }

    private void initiateView()
    {
        mInnerContainer = new RelativeLayout(getContext());
        mInnerContainer.setBackgroundColor(Color.WHITE);
        addView(mInnerContainer, new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT));


        initWebView();
        initTopBar();
    }

    /**
     * Initiate Top header bar
     */
    private void initTopBar()
    {
        Point point = Utils.getScreenSize(getContext());

        //Create top header view
        mKidozTopBar = new KidozTopBar(getContext(), true);
        mKidozTopBar.setId(Utils.generateViewId());
        mKidozTopBar.setTopBarBackgroundColor(DEFAULT_TOP_BAR_COLOR);
        mKidozTopBar.setKidozTopBarListener(new KidozTopBar.KidozTopBarListener()
        {
            @Override public void onExitClicked(View view)
            {
                if (mCloseBtnClickListener != null)
                {
                    mCloseBtnClickListener.onClick(view);
                }
            }
        });
        mKidozTopBar.showParentalLockIcon(false);

        // Add header lay mo view
        mInnerContainer.addView(mKidozTopBar, new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT));
    }


    private void initWebView()
    {
        mKidozWebView = new KidozWebView(getContext(), mWebPlayerType);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        Point point = com.kidoz.sdk.api.general.utils.Utils.getScreenSize(getContext());
        int paddingTop = (int) (Math.max(point.x, point.y) * KidozTopBar.BACKGROUND_RATIO);
        params.topMargin = paddingTop;
        mInnerContainer.addView(mKidozWebView, params);

        mKidozWebView.setOnLounchExternalAppFromRedirect(new KidozWebView.IOnLounchExternalAppFromRedirectListener()
        {
            @Override public void onLounch()
            {
                if (mRemoveViewRequestListener != null)
                {
                    mRemoveViewRequestListener.onRemoveView();
                }
            }
        });
    }

    @Override protected void onConfigurationChanged(Configuration newConfig)
    {
        super.onConfigurationChanged(newConfig);
    }

    public void loadWebUrl(String url, String googlePlayAppId, String title)
    {
        mKidozWebView.loadWebUrl(url, googlePlayAppId);
        if (title != null)
        {
            mKidozTopBar.setTitle(title);
        }
        else
        {
            mKidozTopBar.setTitle("");
        }
    }

    @Override protected void onDetachedFromWindow()
    {
        super.onDetachedFromWindow();

        if (mKidozWebView != null)
        {
            mKidozWebView.stopLoading();
        }
    }

    /**
     * Set on close button click listener
     *
     * @param clickListener click listener
     */
    public void setOnCloseButtonClickListenr(OnClickListener clickListener)
    {
        mCloseBtnClickListener = clickListener;
    }

    /**
     * Set on remove view request listener
     *
     * @param listener click listener
     */
    public void setOnRemoveViewRequestListener(IOnRemoveViewRequestListener listener)
    {
        mRemoveViewRequestListener = listener;
    }

    /**
     * Close the view and release innenr resources
     */
    public void releseAndcloseView()
    {
        if (mKidozWebView != null)
        {
            mKidozWebView.stopAndReleaseWebView();
        }
    }

    /**
     * Request remove view listener
     */
    public interface IOnRemoveViewRequestListener
    {
        public void onRemoveView();
    }
}
