package com.kidoz.sdk.api.players.web_player;

import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.view.View;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.structure.ContentItem;

/**
 * Created by Eugine on 8/2/2015.
 */
public class WebPlayerActivity extends FragmentActivity {

    private static final String TAG = WebPlayerActivity.class.getSimpleName();

    public static final String EXTRA_CONTENT_ITEM_KEY = "EXTRA_CONTENT_ITEM_KEY";
    public static final String EXTRA_WEB_PLAYER_TYPE_KEY = "EXTRA_WEB_PLAYER_TYPE_KEY";

    private ContentItem mContentItem;
    private WebPlayerType mWebPlayerType;
    private WebPlayerView mWebPlayerView;

    private int mCurrentOrientationState;

    private long mEventID;

    private static final int mWebPlayerResourceID = 1;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        ScreenUtils.hideNavigationAndStatusBar(getWindow());

        mCurrentOrientationState = getResources().getConfiguration().orientation;
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR);

        Intent intent = getIntent();
        if (intent != null) {
            mContentItem = (ContentItem) intent.getSerializableExtra(EXTRA_CONTENT_ITEM_KEY);
            mWebPlayerType = (WebPlayerType) intent.getSerializableExtra(EXTRA_WEB_PLAYER_TYPE_KEY);
            if (mContentItem != null && mWebPlayerType != null) {
                initActivityView();
                setContentView(mWebPlayerView);
            } else {
                finish();
            }
        } else {
            finish();
        }
    }


    @Override
    protected void onDestroy() {
        super.onDestroy();

        setRequestedOrientation(mCurrentOrientationState);

        if (mWebPlayerView != null)
        {
            try
            {
                mWebPlayerView.releseAndcloseView();
            }
            catch (Exception ex)
            {
                com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, "Error when trying to onDetach: " + ex.getMessage());
            }
        }
    }

    private void initActivityView() {
        mWebPlayerView = new WebPlayerView(this, mWebPlayerType);
        mWebPlayerView.loadWebUrl(mContentItem.getData(), mContentItem.getId(), mContentItem.getName());

        mWebPlayerView.setOnCloseButtonClickListenr(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });

        mWebPlayerView.setOnRemoveViewRequestListener(new WebPlayerView.IOnRemoveViewRequestListener()
        {
            @Override
            public void onRemoveView()
            {
                finish();
            }
        });
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        ScreenUtils.hideNavigationAndStatusBar(getWindow());
    }

    @Override public void onResume()
    {
        super.onResume();

        String activityName="";
        String action = "";
        switch (mWebPlayerType)
        {
            case EXTERNAL_LINK:
                activityName = "Web Player External Link";
                action = EventParameters.ACTION_EXTERNAL_LINK_VIEW;
                break;
            case ONLINE_GAME:
                activityName = "Web Player Online Game";
                action = EventParameters.ACTION_GAME_VIEW;
                break;
            case WEB_BROWSER:
                activityName = "Web Player Web Browser";
                action = EventParameters.ACTION_WEBSITE_VIEW;
                break;
        }
        mEventID = EventManager.getInstance().activityStart(this,EventManager.LOG_CRITICAL_LEVEL,activityName);
        EventManager.getInstance().logEventWithDuration(this, EventManager.LOG_NORMAL_LEVEL, mWebPlayerResourceID,
                EventManager.LOG_CLOSE_RESOURCE_LEVEL, EventParameters.CATEGORY_WEB_PLAYER,
                action, mContentItem.getName(), mContentItem.getId());
    }

    @Override public void onPause()
    {
        EventManager.getInstance().activityEnd(this, EventManager.LOG_CRITICAL_LEVEL, mEventID);
        EventManager.getInstance().logEventWithDurationEnd(this, mWebPlayerResourceID);
        super.onPause();
    }

}
