package com.kidoz.sdk.api.players.video_player;

import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentTransaction;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;

import com.google.android.youtube.player.YouTubeInitializationResult;
import com.google.android.youtube.player.YouTubePlayer;
import com.google.android.youtube.player.YouTubePlayerSupportFragment;
import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.general.custom_views.KidozTopBar;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.Utils;

/**
 * Created by roni on 7/28/2015.
 */
public class YouTubePlayerActivity extends FragmentActivity implements YouTubePlayer.OnInitializedListener
{
    private static final String TAG = YouTubePlayerActivity.class.getSimpleName();
    public static final String INTENT_EXTRA_VIDEO_ID = "INTENT_EXTRA_VIDEO_ID";
    public static final String INTENT_EXTRA_VIDEO_NAME = "INTENT_EXTRA_VIDEO_NAME";
    public static final String INTENT_EXTRA_CONTENT_ITEM_ID = "INTENT_EXTRA_CONTENT_ITEM_ID";
    public static final String INTENT_EXTRA_TOP_BAR_COLOR = "INTENT_EXTRA_TOP_BAR_COLOR";

    private static int VIDEO_FRAME_CONTAINER_LAYOUT_ID;

    private YouTubePlayerSupportFragment mYouTubePlayerSupportFragment;
    private YouTubePlayer mYouTubePlayer;
    private KidozTopBar mKidozTopBar;
    private String mVideoID;
    private String mVideoName;
    private long mEventID;

    private static final int mVideoPlayerResourceID = 1;
    @Override public void onConfigurationChanged(Configuration newConfig)
    {
        super.onConfigurationChanged(newConfig);
        ScreenUtils.hideNavigationAndStatusBar(getWindow());
    }

    @Override protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);

        setContentView(generateViewLayout());

        initActivity();
    }

    private void initActivity()
    {
        getVideoIDFromIntent();
        initVideoFragment();
        initTopBar();
    }

    private View generateViewLayout() {
        // Init view layout
        LinearLayout mRootView = new LinearLayout(this);
        mRootView.setOrientation(LinearLayout.VERTICAL);
        mRootView.setBackgroundColor(Color.BLACK);
        mKidozTopBar = new KidozTopBar(this,true);
        mRootView.addView(mKidozTopBar, new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT));

        FrameLayout container = new FrameLayout(this);
        VIDEO_FRAME_CONTAINER_LAYOUT_ID =  Utils.generateViewId();
        container.setId(VIDEO_FRAME_CONTAINER_LAYOUT_ID);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.MATCH_PARENT);
        params.weight = 1;
        mRootView.addView(container, params);

        return  mRootView;
    }

    private void initTopBar()
    {
       // mKidozTopBar = (KidozTopBar) findViewById(R.id.YoutubePlayerKidozTopBar);
        mVideoName = null;

        if (mKidozTopBar != null)
        {
            Intent intent = getIntent();
            if (intent != null && intent.hasExtra(INTENT_EXTRA_VIDEO_NAME) == true)
            {
                mVideoName = intent.getStringExtra(INTENT_EXTRA_VIDEO_NAME);
            }
            else if (intent != null && intent.hasExtra(INTENT_EXTRA_TOP_BAR_COLOR) == true)
            {
                //                mKidozTopBar.setTopBarBackgroundColor(intent.getIntExtra(INTENT_EXTRA_TOP_BAR_COLOR, KidozTopBar.DEFAULT_TOP_BAR_COLOR));
            }
            mKidozTopBar.setTitle(mVideoName);
            mKidozTopBar.showParentalLockIcon(false);
            mKidozTopBar.setKidozTopBarListener(new KidozTopBar.KidozTopBarListener()
            {
                @Override public void onExitClicked(View view)
                {
                    finish();
                }
            });
        }
    }

    private void getVideoIDFromIntent()
    {
        Intent intent = getIntent();
        if (intent != null && intent.hasExtra(INTENT_EXTRA_VIDEO_ID) == true)
        {
            mVideoID = intent.getStringExtra(INTENT_EXTRA_VIDEO_ID);
        }
    }

    private void initVideoFragment()
    {
        mYouTubePlayerSupportFragment = YouTubePlayerSupportFragment.newInstance();
        mYouTubePlayerSupportFragment.initialize("AIzaSyCO0ANo6o7l286UdA4LHBvzTZ6Aza79lTc", this);

        FragmentTransaction fragmentTransaction = getSupportFragmentManager().beginTransaction();
        fragmentTransaction.replace(VIDEO_FRAME_CONTAINER_LAYOUT_ID, mYouTubePlayerSupportFragment,"YoutubeVideoPlayer");
        fragmentTransaction.commit();
    }

    @Override public void onInitializationSuccess(YouTubePlayer.Provider provider, YouTubePlayer youTubePlayer, boolean restored)
    {
        mYouTubePlayer = youTubePlayer;
        mYouTubePlayer.setPlayerStyle(YouTubePlayer.PlayerStyle.DEFAULT);
        mYouTubePlayer.addFullscreenControlFlag(YouTubePlayer.FULLSCREEN_FLAG_CUSTOM_LAYOUT);
        mYouTubePlayer.setOnFullscreenListener(new YouTubePlayer.OnFullscreenListener()
        {
            @Override public void onFullscreen(boolean isFullScreen)
            {
                if (isFullScreen == true)
                {
                    setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
                }
                else
                {
                    setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
                }
            }
        });
        if (restored == false && mVideoID != null)
        {
            mYouTubePlayer.loadVideo(mVideoID);
        }
    }

    @Override public void onInitializationFailure(YouTubePlayer.Provider provider, YouTubeInitializationResult result)
    {

    }

    @Override public void onResume()
    {
        super.onResume();
        ScreenUtils.hideNavigationAndStatusBar(getWindow());
        if (mYouTubePlayer != null)
        {
            mYouTubePlayer.play();
        }
        mEventID = EventManager.getInstance().activityStart(this,EventManager.LOG_CRITICAL_LEVEL,"YouTube Player");
        EventManager.getInstance().logEventWithDuration(this,EventManager.LOG_NORMAL_LEVEL,mVideoPlayerResourceID,
                EventManager.LOG_CLOSE_RESOURCE_LEVEL, EventParameters.CATEGORY_VIDEO_PLAYER,
                EventParameters.ACTION_VIDEO_VIEW,mVideoName,mVideoID);
    }

    @Override public void onPause()
    {
        EventManager.getInstance().activityEnd(this,EventManager.LOG_CRITICAL_LEVEL,mEventID);
        if (mYouTubePlayer != null)
        {
            mYouTubePlayer.pause();
            EventManager.getInstance().logEventWithDurationEnd(this,mVideoPlayerResourceID);
        }
        super.onPause();
    }

    @Override public void onDestroy()
    {
        if (mYouTubePlayer != null)
        {
            try
            {
                mYouTubePlayer.pause();
                mYouTubePlayer.release();
                mYouTubePlayer = null;
            }
            catch (Exception ex)
            {
                com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to release youtube player: " + ex.getMessage());
            }

        }
        super.onDestroy();
    }
}
