package com.kidoz.sdk.api.general.database;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

public class BaseTable {
    private final String TAG = BaseTable.class.getSimpleName();
    protected DatabaseManager mDBmanager;

    public static final int TRUE = 1;
    public static final int FALSE = 0;

    protected Object mSyncObject;

    public enum DBactionType {
        INSERT, UPDATE, DELETE, LOAD
    }

    public BaseTable(DatabaseManager databaseManager, Object syncObj) {
        this.mDBmanager = databaseManager;
        this.mSyncObject = syncObj;
    }

    /**
     * Print database debug log
     *
     * @param type      data base execution type
     * @param tableName table name
     * @param count     rows counted
     */
    protected static void printDBLog(DBactionType type, String fucntionName, String tableName, int count) {

        if (com.kidoz.sdk.api.general.utils.SDKLogger.IS_DEBBUG_MODE) {
            String print = "";
            switch (type) {

                case INSERT:
                    print = "KD (" + fucntionName + ")  : Inserted [" + count + "] items into " + tableName + "DB Table";
                    break;
                case UPDATE:
                    print = "KD (" + fucntionName + ") :  Updated [" + count + "] items at " + tableName + "DB Table";
                    break;
                case DELETE:
                    print = "KD (" + fucntionName + ") :  Deleted [" + count + "] items from " + tableName + "DB Table";
                    break;
                case LOAD:
                    print = "KD (" + fucntionName + ") :  Loaded [" + count + "] items from " + tableName + "DB Table";
                    break;
            }

            com.kidoz.sdk.api.general.utils.SDKLogger.printInfoLog("Kidoz DataBase Print Log", print);
        }

    }

    /**
     * Clear database table of all rows
     *
     * @param tableName table name
     */
    public void clearTable(String tableName) {
        if (mDBmanager != null) {
            synchronized (mSyncObject) {
                int rowsCount = 0;
                int rowID = -1;
                SQLiteDatabase database = mDBmanager.openDatabase();
                rowID = database.delete(tableName, null, null);
                if (rowID != -1) {
                    rowsCount = rowID;
                }
                printDBLog(DBactionType.DELETE, "clearTable", tableName, rowsCount);
                mDBmanager.closeDatabase();
            }
        }
    }

    /**
     * Debugging function
     */
    public void printTable(String tableName) {
        if (mDBmanager != null) {
            synchronized (mSyncObject) {
                SQLiteDatabase db = mDBmanager.openDatabase();
                try {
                    StringBuilder stringBuilder = new StringBuilder();
                    db.beginTransaction();
                    Cursor cursor = db.query(tableName, null, null, null, null, null, null);
                    if (cursor != null) {
                        String[] columnNames = cursor.getColumnNames();
                        for (String nextColumn : columnNames) {
                            stringBuilder.append(nextColumn + "\t");
                        }
                        stringBuilder.append("\n");
                        if (cursor.getCount() > 0) {
                            cursor.moveToFirst();
                            do {
                                for (String nextColumn : columnNames) {
                                    stringBuilder.append(cursor.getString(cursor.getColumnIndex(nextColumn)) + "\t");
                                }
                                stringBuilder.append("\n");
                            }
                            while (cursor.moveToNext());
                        }
                    }
                    com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, ">>>>Print Table = " + tableName + "\n" + stringBuilder.toString());
                    db.setTransactionSuccessful();
                } finally {
                    db.endTransaction();
                    mDBmanager.closeDatabase();
                }
            }
        }
    }
}
