package com.kidoz.sdk.api.general.animations;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;

import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;

/**
 * Created by User on 14/07/2015.
 * Class that hold specific animations used in the SDK
 */
public class GenAnimator
{

    /**
     * Content item click animation
     */
    public static AnimatorSet clickItemAnimation(View view, int duration, final ViewAnimationListener listener)
    {
        AnimatorSet cilAnim = new AnimatorSet();
        AnimatorSet clickSet = new AnimatorSet();
        clickSet.playTogether(ObjectAnimator.ofFloat(view, "scaleX", 1, 0.8f), ObjectAnimator.ofFloat(view, "scaleY", 1, 0.8f));

        AnimatorSet unClickSet = new AnimatorSet();
        unClickSet.playTogether(ObjectAnimator.ofFloat(view, "scaleX", 0.8f, 1), ObjectAnimator.ofFloat(view, "scaleY", 0.8f, 1));

        cilAnim.playSequentially(clickSet, unClickSet);
        cilAnim.setDuration(duration);
        cilAnim.setInterpolator(new AccelerateDecelerateInterpolator());

        cilAnim.addListener(new Animator.AnimatorListener()
        {
            @Override public void onAnimationStart(Animator animation)
            {
                if (listener != null)
                {
                    listener.onAnimationStart();
                }
            }

            @Override public void onAnimationEnd(Animator animation)
            {
                if (listener != null)
                {
                    listener.onAnimationEnd();
                }
            }

            @Override public void onAnimationCancel(Animator animation)
            {

            }

            @Override public void onAnimationRepeat(Animator animation)
            {

            }
        });

        cilAnim.start();
        return cilAnim;
    }


    public interface ViewAnimationListener
    {
        public void onAnimationEnd();

        public void onAnimationStart();
    }

    /**
     * Recycle item show animation
     */
    public static AnimatorSet recycleItemAnimation(View view, final ViewAnimationListener listener)
    {
        ObjectAnimator anim1 = ObjectAnimator.ofFloat(view, "scaleX", 0.52f, 1f);
        anim1.setDuration(250);

        ObjectAnimator anim2 = ObjectAnimator.ofFloat(view, "scaleY", 0.52f, 1f);
        anim2.setDuration(250);

        ObjectAnimator anim3 = ObjectAnimator.ofFloat(view, "alpha", 0.2f, 1f);
        anim3.setDuration(250);

        AnimatorSet set = new AnimatorSet();
        set.playTogether(anim1, anim2, anim3);
        set.setInterpolator(new AccelerateDecelerateInterpolator());

        set.addListener(new Animator.AnimatorListener()
        {
            @Override public void onAnimationStart(Animator animation)
            {
                if (listener != null)
                {
                    listener.onAnimationStart();
                }
            }

            @Override public void onAnimationEnd(Animator animation)
            {
                if (listener != null)
                {
                    listener.onAnimationEnd();
                }
            }

            @Override public void onAnimationCancel(Animator animation)
            {

            }

            @Override public void onAnimationRepeat(Animator animation)
            {

            }
        });

        set.start();
        return set;
    }

    /**
     * Slider panel slide up (Show animation)
     */
    public static AnimatorSet playSlideUpAnimation(View view, int slideOffset, int duration, TimeInterpolator timeInterpolator, Animator.AnimatorListener animatorListener)
    {
        AnimatorSet set = new AnimatorSet();
        set.play(ObjectAnimator.ofFloat(view, "translationY", slideOffset, 0));
        set.setDuration(duration);
        if (timeInterpolator != null)
        {
            set.setInterpolator(timeInterpolator);
        }

        if (animatorListener != null)
        {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    /**
     * Slider panel slide down (Hide animation)
     */
    public static AnimatorSet playSlideDownAnimation(View view, int slideOffset, int duration, TimeInterpolator timeInterpolator, Animator.AnimatorListener animatorListener)
    {
        AnimatorSet set = new AnimatorSet();
        set.play(ObjectAnimator.ofFloat(view, "translationY", 0, slideOffset));
        set.setDuration(duration);
        if (timeInterpolator != null)
        {
            set.setInterpolator(timeInterpolator);
        }
        if (animatorListener != null)
        {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    /**
     * Play slide In left animation
     */
    public static AnimatorSet playSlideInLeftAnimation(View view, Animator.AnimatorListener animatorListener, int duration)
    {
        AnimatorSet set = new AnimatorSet();
        int distance = view.getWidth() - view.getLeft();
        set.playTogether(ObjectAnimator.ofFloat(view, "alpha", 0, 1), ObjectAnimator.ofFloat(view, "translationX", -distance, 0));
        set.setDuration(duration);
        set.setInterpolator(new DecelerateInterpolator());
        if (animatorListener != null)
        {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    /**
     * Play slide In left animation
     */
    public static AnimatorSet playSlideInRightAnimation(View view, Animator.AnimatorListener animatorListener, int duration)
    {
        AnimatorSet set = new AnimatorSet();
        int distance = view.getWidth() - view.getLeft();
        set.playTogether(ObjectAnimator.ofFloat(view, "alpha", 0, 1), ObjectAnimator.ofFloat(view, "translationX", distance, 0));
        set.setDuration(duration);
        set.setInterpolator(new DecelerateInterpolator());
        if (animatorListener != null)
        {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }


    /**
     * Play slide Out left animation
     */
    public static AnimatorSet playSlideOutLeftAnimation(View view, Animator.AnimatorListener animatorListener, int duration)
    {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(ObjectAnimator.ofFloat(view, "alpha", 1, 0), ObjectAnimator.ofFloat(view, "translationX", 0, -view.getWidth()));
        set.setDuration(duration);
        set.setInterpolator(new DecelerateInterpolator());
        if (animatorListener != null)
        {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    /**
     * Play slide Out right animation
     */
    public static AnimatorSet playSlideOutRightAnimation(View view, Animator.AnimatorListener animatorListener, int duration)
    {
        AnimatorSet set = new AnimatorSet();
        int distance = view.getWidth() - view.getLeft();
        set.playTogether(ObjectAnimator.ofFloat(view, "alpha", 0, 1), ObjectAnimator.ofFloat(view, "translationX", 0, distance));
        set.setDuration(duration);
        set.setInterpolator(new DecelerateInterpolator());
        if (animatorListener != null)
        {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }


    /**
     * Play bounce in right animation
     */
    public static AnimatorSet playBounceInRightAnimation(View view, Animator.AnimatorListener animatorListener, int duration)
    {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(ObjectAnimator.ofFloat(view, "translationX", -view.getWidth(), 30, -10, 0), ObjectAnimator.ofFloat(view, "alpha", 0, 1, 1, 1));
        set.setDuration(duration);
        set.setInterpolator(new AccelerateInterpolator());
        if (animatorListener != null)
        {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    /**
     * Play bounce in left animation
     */
    public static AnimatorSet playBounceInLeftAnimation(View view, Animator.AnimatorListener animatorListener, int duration)
    {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(ObjectAnimator.ofFloat(view, "translationX", view.getWidth(), -30, 10, 0), ObjectAnimator.ofFloat(view, "alpha", 0, 1, 1, 1));
        set.setDuration(duration);
        if (animatorListener != null)
        {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    /**
     * Stand up animation
     */
    public static AnimatorSet playStandUpAnimation(View target, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        float x = (target.getWidth() - target.getPaddingLeft() - target.getPaddingRight()) / 2 + target.getPaddingLeft();
        float y = target.getPaddingBottom();
        result.setInterpolator(new LinearInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", x), ObjectAnimator.ofFloat(target, "pivotY", y, y), ObjectAnimator.ofFloat(target, "rotationX", -15, -30, -15, 0, 15, 0, -15, 0, 10, 0, -10, 0, 5, 0, -5, 0));
        result.setDuration(750);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }


    public static AnimatorSet playDropAnimation(View target, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new BounceInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "translationY", -target.getHeight(), 0));
        result.setDuration(800);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playOnBoardingCloudDropAnimation(View target, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new LinearInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "translationY", -target.getHeight(), 0));
        result.setDuration(800);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPopOutAnimation(View target, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new AccelerateInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "translationY", 0, -target.getHeight()));
        result.setDuration(450);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }


    public static AnimatorSet playPopInFromRightBottom(View target, int[] pivot, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        int pivotX = target.getWidth() - pivot[0];
        int pivotY = target.getHeight() - pivot[1];
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new DecelerateInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", pivotX, pivotX), ObjectAnimator.ofFloat(target, "pivotY", pivotY, pivotY), ObjectAnimator.ofFloat(target, "scaleX", 0f, 1f), ObjectAnimator.ofFloat(target, "scaleY", 0f, 1f));
        result.setDuration(300);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPopInFromRightTop(View target, int[] pivot, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        int pivotX = -target.getLeft() + pivot[0];
        int pivotY = -target.getTop() + pivot[1];
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new DecelerateInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", pivotX, pivotX), ObjectAnimator.ofFloat(target, "pivotY", pivotY, pivotY), ObjectAnimator.ofFloat(target, "scaleX", 0f, 1f), ObjectAnimator.ofFloat(target, "scaleY", 0f, 1f));
        result.setDuration(300);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPopOutToRightBottom(View target, int[] pivot, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        int pivotX = target.getWidth() - pivot[0];
        int pivotY = target.getHeight() - pivot[1];
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new AccelerateInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", pivotX, pivotX), ObjectAnimator.ofFloat(target, "pivotY", pivotY, pivotY), ObjectAnimator.ofFloat(target, "scaleX", 1f, 0f), ObjectAnimator.ofFloat(target, "scaleY", 1f, 0f));
        result.setDuration(400);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPopOutToRightTop(View target, int[] pivot, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        int pivotX = -target.getLeft() + pivot[0];
        int pivotY = -target.getTop() + pivot[1];
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new AccelerateInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", pivotX, pivotX), ObjectAnimator.ofFloat(target, "pivotY", pivotY, pivotY), ObjectAnimator.ofFloat(target, "scaleX", 1f, 0f), ObjectAnimator.ofFloat(target, "scaleY", 1f, 0f));
        result.setDuration(400);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static void closePanelView(View target,long duration, View anchorView, PANEL_TYPE panelType, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        switch (panelType)
        {
            case LEFT:
            {
                float distance = anchorView.getWidth();
                result.play(ObjectAnimator.ofFloat(target, "translationX", 0f, -distance));
                break;
            }
            case TOP:
            {
                float distance = anchorView.getHeight();
                result.play(ObjectAnimator.ofFloat(target, "translationY", 0f, -distance));
                break;
            }
            case RIGHT:
            {
                float distance = anchorView.getWidth();
                result.play(ObjectAnimator.ofFloat(target, "translationX", 0f, distance));
                break;
            }
            case BOTTOM:
            {
                float distance = anchorView.getHeight();
                result.play(ObjectAnimator.ofFloat(target, "translationY", 0f, distance));
                break;
            }
        }
        result.setInterpolator(new AccelerateInterpolator());
        result.setDuration(duration);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
    }

    public static void openPanelView(View target, View anchorView, PANEL_TYPE panelType, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        switch (panelType)
        {
            case LEFT:
            {
                float distance = -anchorView.getWidth();
                result.play(ObjectAnimator.ofFloat(target, "translationX", distance, 0f));
                break;
            }
            case TOP:
            {
                float distance = -anchorView.getHeight();
                result.play(ObjectAnimator.ofFloat(target, "translationY", distance, 0f));
                break;
            }
            case RIGHT:
            {
                float distance = anchorView.getWidth();
                result.play(ObjectAnimator.ofFloat(target, "translationX", distance, 0f));
                break;
            }
            case BOTTOM:
            {
                float distance = anchorView.getHeight();
                result.play(ObjectAnimator.ofFloat(target, "translationY", distance, 0f));
                break;
            }
        }
        result.setInterpolator(new DecelerateInterpolator());
        result.setDuration(200);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
    }

    public static AnimatorSet playClickAnimation(View target, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        AnimatorSet clickStart = new AnimatorSet();
        clickStart.setInterpolator(new DecelerateInterpolator());
        clickStart.playTogether(ObjectAnimator.ofFloat(target, "scaleX", 1f, 0.8f), ObjectAnimator.ofFloat(target, "scaleY", 1f, 0.8f));
        clickStart.setDuration(100);

        AnimatorSet clickEnd = new AnimatorSet();
        clickEnd.setInterpolator(new AccelerateInterpolator());
        clickEnd.playTogether(ObjectAnimator.ofFloat(target, "scaleX", 0.8f, 1f), ObjectAnimator.ofFloat(target, "scaleY", 0.8f, 1f));
        clickEnd.setDuration(100);

        result.playSequentially(clickStart, clickEnd);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playGrowAnimation(View target, long duration, long startDelay, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new AccelerateInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "scaleX", 0f, 1f), ObjectAnimator.ofFloat(target, "scaleY", 0f, 1f));
        result.setDuration(duration);
        result.setStartDelay(startDelay);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playShrinkAnimation(View target, long duration, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new DecelerateInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "scaleX", 1f, 0f), ObjectAnimator.ofFloat(target, "scaleY", 1f, 0f));
        result.setDuration(duration);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet animateHandleClose(View target, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        float pivotX = target.getWidth() / 2;
        float pivotY = target.getHeight() / 2;

        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new DecelerateInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", pivotX), ObjectAnimator.ofFloat(target, "pivotY", pivotY), ObjectAnimator.ofFloat(target, "rotation", 45, 0));
        result.setDuration(300);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet animateHandleOpen(View target, Animator.AnimatorListener animatorListener)
    {
        target.clearAnimation();
        float pivotX = target.getWidth() / 2;
        float pivotY = target.getHeight() / 2;

        AnimatorSet result = new AnimatorSet();
        result.setInterpolator(new DecelerateInterpolator());
        result.playTogether(ObjectAnimator.ofFloat(target, "pivotX", pivotX), ObjectAnimator.ofFloat(target, "pivotY", pivotY), ObjectAnimator.ofFloat(target, "rotation", 0, 45));
        result.setDuration(300);
        if (animatorListener != null)
        {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }
}
