package com.kidoz.sdk.api.general;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.view.WindowManager;

/**
 * Created by Eugine on 7/15/15.
 */

public class BaseDialog extends Dialog
{
    private final String TAG = BaseDialog.class.getSimpleName();
    protected Activity mCallingActivity;
    private long mDisplayDuration;

    public BaseDialog(Context context)
    {
        super(context);
        if (context != null)
        {
            mCallingActivity = (Activity) context;
        }
    }

    public BaseDialog(Context context, int theme)
    {
        super(context, theme);
        if (context != null)
        {
            mCallingActivity = (Activity) context;
        }
    }

    protected void openDialog()
    {
        if (mCallingActivity != null && mCallingActivity.isFinishing() == false)
        {
            getWindow().setFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE, WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE);
            getWindow().getDecorView().setSystemUiVisibility(mCallingActivity.getWindow().getDecorView().getSystemUiVisibility());

            mDisplayDuration = System.currentTimeMillis();

            super.show();

            getWindow().clearFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE);
            WindowManager wm = (WindowManager) mCallingActivity.getSystemService(Context.WINDOW_SERVICE);
            wm.updateViewLayout(getWindow().getDecorView(), getWindow().getAttributes());
        }
    }

    protected void closeDialog()
    {
        if (mCallingActivity != null && mCallingActivity.isFinishing() == false)
        {
            dismiss();
        }
    }

    @Override public void show()
    {
        try
        {
            throw new DialogException();
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to open dialog: " + ex.getMessage());
        }
    }

    private class DialogException extends Exception
    {
        private static final long serialVersionUID = 1L;

        @Override public String getMessage()
        {
            return "Don't use the show() method\nUse openDialog() instead!";
        }
    }

    /**
     * Return the time the dialog was visible in seconds
     *
     * @return
     */
    public int getTotalDisplayDuration()
    {
        int totalTimeInSeconds = (int) ((System.currentTimeMillis() - mDisplayDuration) / 1000);
        return totalTimeInSeconds;
    }
}
