package com.kidoz.sdk.api.dialogs;

import android.animation.Animator;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.TextView;
import android.widget.ViewAnimator;

import com.custom_recycler_view.CustomGridLayoutManager;
import com.custom_recycler_view.CustomRecyclerView;
import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.general.animations.AnimationFactory;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardView;
import com.kidoz.sdk.api.general.utils.AnimationsUtils;
import com.kidoz.sdk.api.general.utils.AppAssetsUtils;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.LockIconData;
import com.kidoz.sdk.api.ui_views.parental_lock.LockIconsAdapter;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;

/**
 * Created by roni on 8/24/2015.
 */
public class ParentalLockDialog extends Dialog
{

    private static final int DIALOG_BACKGROUND = Color.parseColor("#0fcaf7");
    private static final int DIALOG_BACKGROUND_CORRNER_RADIUS = 4; //DP


    private final String TAG = ParentalLockDialog.class.getSimpleName();
    public static final String PARENTAL_LOCK_ACTIVE_KEY = "PARENTAL_LOCK_ACTIVE_KEY";
    public static final float PIVOT_X_FACTOR = 0.722f;
    public static final float PIVOT_Y_FACTOR = 0.04f;

    private final int NUMBER_OF_COLUMNS = 4;
    private final int NUMBER_OF_LOCK_ICONS = 8;
    private final int FLIP_ANIMATION_DURATION = 200;

    private int[] mPopLocation;

    private View mRootView;
    private CustomRecyclerView mCustomRecyclerView;
    private LockIconsAdapter mAdapter;
    private TextView mDialogMessage;
    private TextView mDialogTitleTextView;
    private ArrayList<LockIconData> mContent;
    private int[] mLockCombination;
    private boolean mIsFirstLockIconCorrect;
    private boolean mIsLockActive;
    private ParentLockDialogListener mParentLockDialogListener;
    private boolean mIsGateToGooglePlay;
    private boolean mIsLockChangeSuccessfully;

    // Feedback message related.
    private ViewAnimator mViewAnimator;
    private TextView mFeedbackMessage;
    private TextView mFeedbackMessageAction;
    private View mAnimatableView;
    private KidozCardView kidozCardView;

    private int mCounter;

    private Handler mHandler;

    public ParentalLockDialog(Context context, boolean isGateToGooglePlay, int[] popLocation)
    {
        super(context, android.R.style.Theme_Translucent_NoTitleBar_Fullscreen);
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
        this.requestWindowFeature(Window.FEATURE_NO_TITLE);
        mPopLocation = popLocation;
        mRootView = ParentalLockLayoutGenerator.generateParentalLockView(context);
        mIsGateToGooglePlay = isGateToGooglePlay;
        setContentView(mRootView);
    }

    @Override protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        initDialog();
    }

    private void initDialog()
    {
        mHandler = new Handler();
        initDialogBackgroundView();

        initParameters();
        initTitle();
        initDialogWidth();
        initExitButton();
        initRecyclerView();
        initMessageTextView();
        initFeedbackMessageView();
        prepareDialog();
        mCounter = 0;
    }

    private void initDialogBackgroundView()
    {
        //KidozCardView kidozCardView = (KidozCardView) mRootView.findViewById(R.id.ParentalCardView);
        kidozCardView = (KidozCardView) mRootView.findViewById(ParentalLockLayoutGenerator.PARENTAL_CARDVIEW_ID);
        kidozCardView.setRadius(Utils.dpTOpx(getContext(), DIALOG_BACKGROUND_CORRNER_RADIUS));
        kidozCardView.setCardBackgroundColor(DIALOG_BACKGROUND);
    }

    private void initFeedbackMessageView()
    {
        // Init relevant text views and container.
        // View feedbackMessageContainer = mRootView.findViewById(R.id.FeedbackMessageContainer);
        View feedbackMessageContainer = mRootView.findViewById(ParentalLockLayoutGenerator.FEEDBACK_MESSAGE_CONTAINER_ID);

        feedbackMessageContainer.setSoundEffectsEnabled(false);
        feedbackMessageContainer.setOnClickListener(new View.OnClickListener()
        {
            @Override public void onClick(View v)
            {
                prepareDialog();
                if (mIsLockChangeSuccessfully == true)
                {
                    mIsLockChangeSuccessfully = false;
                }
                animateFeedBackMessageBack();
            }
        });

        //mFeedbackMessage = (TextView) mRootView.findViewById(R.id.FeedbackMessageTextView);
        //mFeedbackMessageAction = (TextView) mRootView.findViewById(R.id.FeedbackActionTextView);

        mFeedbackMessage = (TextView) mRootView.findViewById(ParentalLockLayoutGenerator.FEEDBACK_MESSAGE_TEXT_VIEW_ID);
        mFeedbackMessageAction = (TextView) mRootView.findViewById(ParentalLockLayoutGenerator.FEEDBACK_ACTION_TEXT_VIEW_ID);

        // Init view animator.
        int availableSpace = Math.min(ScreenUtils.getScreenSize(getContext(), true), ScreenUtils.getScreenSize(getContext(), false));
        if (ScreenUtils.getIsTablet(getContext()) == true)
        {
            availableSpace = (int) (0.8f * availableSpace);
        }
        int itemSize = availableSpace / NUMBER_OF_COLUMNS;

        //mViewAnimator = (ViewAnimator) mRootView.findViewById(R.id.ViewFlipper);
        mViewAnimator = (ViewAnimator) mRootView.findViewById(ParentalLockLayoutGenerator.VIEW_FLIPPER_ID);
        mViewAnimator.getLayoutParams().width = availableSpace;
        mViewAnimator.getLayoutParams().height = (itemSize * 2);
    }

    private void initTitle()
    {
        //mDialogTitleTextView = (TextView) mRootView.findViewById(R.id.ParentalLockDialogTitle);
        mDialogTitleTextView = (TextView) mRootView.findViewById(ParentalLockLayoutGenerator.PARENTAL_DIALOG_TITLE_ID);
    }

    private void initDialogWidth()
    {
        mAnimatableView = mRootView.findViewById(ParentalLockLayoutGenerator.ANIMATABLE_VIEW);
        if (ScreenUtils.getIsTablet(getContext()) == false)
        {
            mAnimatableView.getLayoutParams().width = Math.min(ScreenUtils.getScreenSize(getContext(), true), ScreenUtils.getScreenSize(getContext(), false));
        }
        else
        {
            mAnimatableView.getLayoutParams().width = (int) (0.8f * Math.min(ScreenUtils.getScreenSize(getContext(), true), ScreenUtils.getScreenSize(getContext(), false)));
        }
    }

    private void initParameters()
    {
        mContent = new ArrayList<LockIconData>();
        JSONArray jSONArray = AppAssetsUtils.loadParentalLockConfigurationFile(getContext());
        if (jSONArray != null && jSONArray.length() > 0)
        {
            for (int lockIconIndex = 0; lockIconIndex < jSONArray.length(); lockIconIndex++)
            {
                try
                {
                    JSONObject nextJSONObject = jSONArray.getJSONObject(lockIconIndex);
                    LockIconData nextLockIconData = new LockIconData(getContext(), nextJSONObject);
                    mContent.add(nextLockIconData);
                }
                catch (Exception ex)
                {
                    com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to parse configuration JSON:" + ex.getMessage());
                }
            }
        }
    }

    private void prepareDialog()
    {
        // Init lock status.
        mIsLockActive = SharedPreferencesUtils.loadSharedPreferencesData(getContext(), PARENTAL_LOCK_ACTIVE_KEY) == null ? false : true;

        // Generate random lock key.
        mIsFirstLockIconCorrect = false;
        mLockCombination = new int[2];
        Random random = new Random();
        while (mLockCombination[0] == mLockCombination[1])
        {
            mLockCombination[0] = random.nextInt(NUMBER_OF_LOCK_ICONS);
            mLockCombination[1] = random.nextInt(NUMBER_OF_LOCK_ICONS);
        }

        // Init Dialog title.
        if (mIsGateToGooglePlay == true)
        {
            mDialogTitleTextView.setText(getContext().getString(R.string.ParentalLockDialogTitleForGooglePlay));
        }
        else
        {
            if (mIsLockActive == true)
            {
                mDialogTitleTextView.setText(getContext().getString(R.string.ParentalLockDialogTitleDeActivate));
            }
            else
            {
                mDialogTitleTextView.setText(getContext().getString(R.string.ParentalLockDialogTitleActivate));
            }
        }

        // Init Dialog message.
        String name_1 = mContent.get(mLockCombination[0]).getName().toUpperCase();
        String name_2 = mContent.get(mLockCombination[1]).getName().toUpperCase();
        if (mIsGateToGooglePlay == true)
        {
            mDialogMessage.setText(String.format(Locale.getDefault(), getContext().getString(R.string.ParentalLockDialogMessageGooglePlayGate), name_1, name_2));
        }
        else
        {
            if (mIsLockActive == true)
            {
                mDialogMessage.setText(String.format(Locale.getDefault(), getContext().getString(R.string.ParentalLockDialogMessageParentalLockDeactivation), name_1, name_2));
            }
            else
            {
                mDialogMessage.setText(String.format(Locale.getDefault(), getContext().getString(R.string.ParentalLockDialogMessageParentalLockActivation), name_1, name_2));
            }
        }
    }

    private void initMessageTextView()
    {
        //mDialogMessage = (TextView) mRootView.findViewById(R.id.ParentalLockDialogMessageTextView);
        mDialogMessage = (TextView) mRootView.findViewById(ParentalLockLayoutGenerator.PARENTAL_LOCK_DIALOG_MESSAGE_TEXTVIEW_ID);
    }

    private void initExitButton()
    {
        mRootView.findViewById(ParentalLockLayoutGenerator.EXIT_BUTTON_ID).setOnClickListener(new View.OnClickListener()
        {
            @Override public void onClick(View view)
            {
                AnimationsUtils.animateClick(view, new Animator.AnimatorListener()
                {
                    @Override public void onAnimationStart(Animator animation)
                    {

                    }

                    @Override public void onAnimationEnd(Animator animation)
                    {
                        dismiss();
                    }

                    @Override public void onAnimationCancel(Animator animation)
                    {

                    }

                    @Override public void onAnimationRepeat(Animator animation)
                    {

                    }
                });
            }
        });
    }

    private void initRecyclerView()
    {
        int availableSpace = Math.min(ScreenUtils.getScreenSize(getContext(), true), ScreenUtils.getScreenSize(getContext(), false));
        if (ScreenUtils.getIsTablet(getContext()) == true)
        {
            availableSpace = (int) (0.8f * availableSpace);
        }
        int itemSize = availableSpace / NUMBER_OF_COLUMNS;

        int padding = Utils.dpTOpx(getContext(), 30);
        ArrayList<LockIconData> content = new ArrayList<LockIconData>();
        for (int i = 0; i < NUMBER_OF_LOCK_ICONS; i++)
        {
            LockIconData nextLockIconData = new LockIconData();
            content.add(nextLockIconData);
        }
        mAdapter = new LockIconsAdapter();
        mAdapter.setLockIconAdapterListener(new LockIconsAdapter.LockIconAdapterListener()
        {
            @Override public void onLockIconClick(int index)
            {
                if (mIsFirstLockIconCorrect == false)
                {
                    // This is the first click.
                    if (index == mLockCombination[0])
                    {
                        mIsFirstLockIconCorrect = true;
                    }
                    else
                    {
                        animateFeedBackMessageError();
                    }
                }
                else
                {
                    // This is the second click.
                    if (index == mLockCombination[1])
                    {
                        mIsLockChangeSuccessfully = true;
                        if (mIsGateToGooglePlay == true)
                        {
                            dismiss();
                        }
                        else
                        {
                            if (mIsLockActive == true)
                            {
                                SharedPreferencesUtils.removeSharedPreferencesData(getContext(), PARENTAL_LOCK_ACTIVE_KEY);
                            }
                            else
                            {
                                SharedPreferencesUtils.saveSharedPreferencesData(getContext(), PARENTAL_LOCK_ACTIVE_KEY, PARENTAL_LOCK_ACTIVE_KEY);
                            }
                            animateFeedBackMessageSuccess(mIsLockActive);
                            if (mParentLockDialogListener != null)
                            {
                                mParentLockDialogListener.onPasswordEntered(true);
                                EventManager.getInstance().LogEventWithIntField(getContext(), EventManager.LOG_NORMAL_LEVEL, EventParameters.CATEGORY_PARENTAL_LOCK, EventParameters.ACTION_PARENTAL_CORRECT_PASSWORD, null, mCounter);
                            }
                        }
                        if (mParentLockDialogListener != null)
                        {
                            mParentLockDialogListener.onPasswordEntered(true);
                            mCounter += 1;
                            EventManager.getInstance().LogEventWithIntField(getContext(), EventManager.LOG_NORMAL_LEVEL, EventParameters.CATEGORY_PARENTAL_LOCK, EventParameters.ACTION_PARENTAL_CORRECT_PASSWORD, null, mCounter);
                        }
                    }
                    else
                    {
                        animateFeedBackMessageError();
                    }
                }
            }
        });

        // mRecyclerView = (RecyclerView) mRootView.findViewById(R.id.ParentalLockRecyclerView);
        mCustomRecyclerView = (CustomRecyclerView) mRootView.findViewById(ParentalLockLayoutGenerator.RECYCLER_VIEW_ID);
        CustomGridLayoutManager layoutManager = new CustomGridLayoutManager(getContext(), NUMBER_OF_COLUMNS);
        mCustomRecyclerView.setLayoutManager(layoutManager);
        mCustomRecyclerView.setPadding(padding, 0, padding, 0);
        mCustomRecyclerView.setHasFixedSize(true);
        mCustomRecyclerView.getLayoutParams().width = availableSpace;
        mCustomRecyclerView.getLayoutParams().height = (itemSize * 2);
        mCustomRecyclerView.setAdapter(mAdapter);
    }

    @Override protected void onStart()
    {
        super.onStart();
        mHandler.postDelayed(new Runnable()
        {
            @Override public void run()
            {
                mAdapter.setContent(mContent);
            }
        }, 300);
    }

    @Override public void show()
    {
        super.show();
        EventManager.getInstance().LogEventWithIntField(getContext(), EventManager.LOG_NORMAL_LEVEL, EventParameters.CATEGORY_PARENTAL_LOCK, EventParameters.ACTION_PARENTAL_DIALOG_SHOW, null, mCounter);
        mAnimatableView.setVisibility(View.INVISIBLE);
        mAnimatableView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener()
        {
            @Override public void onGlobalLayout()
            {
                if (Build.VERSION.SDK_INT < 16)
                {
                    mAnimatableView.getViewTreeObserver().removeGlobalOnLayoutListener(this);
                }
                else
                {
                    mAnimatableView.getViewTreeObserver().removeOnGlobalLayoutListener(this);
                }
                if (mPopLocation != null)
                {
                    GenAnimator.playPopInFromRightTop(mAnimatableView, mPopLocation, new Animator.AnimatorListener()
                    {
                        @Override public void onAnimationStart(Animator animation)
                        {
                            mAnimatableView.setVisibility(View.VISIBLE);
                        }

                        @Override public void onAnimationEnd(Animator animation)
                        {
                        }

                        @Override public void onAnimationCancel(Animator animation)
                        {

                        }

                        @Override public void onAnimationRepeat(Animator animation)
                        {

                        }
                    });
                }
                else
                {
                    mAnimatableView.setVisibility(View.VISIBLE);
                }
            }
        });
    }

    @Override public void dismiss()
    {
        if (mPopLocation != null)
        {
            GenAnimator.playPopOutToRightTop(mAnimatableView, mPopLocation, new Animator.AnimatorListener()
            {
                @Override public void onAnimationStart(Animator animation)
                {

                }

                @Override public void onAnimationEnd(Animator animation)
                {
                    if (mParentLockDialogListener != null)
                    {
                        mParentLockDialogListener.onPasswordEntered(false);
                    }
                    EventManager.getInstance().LogEventWithIntField(getContext(), EventManager.LOG_NORMAL_LEVEL, EventParameters.CATEGORY_PARENTAL_LOCK, EventParameters.ACTION_PARENTAL_DIALOG_DISMISS, null, mCounter);
                    ParentalLockDialog.super.dismiss();
                }

                @Override public void onAnimationCancel(Animator animation)
                {

                }

                @Override public void onAnimationRepeat(Animator animation)
                {

                }
            });
        }
        else
        {
            if (mParentLockDialogListener != null)
            {
                mParentLockDialogListener.onPasswordEntered(false);
            }
            EventManager.getInstance().LogEventWithIntField(getContext(), EventManager.LOG_NORMAL_LEVEL, EventParameters.CATEGORY_PARENTAL_LOCK, EventParameters.ACTION_PARENTAL_DIALOG_DISMISS, null, mCounter);
            ParentalLockDialog.super.dismiss();
        }
    }

    public interface ParentLockDialogListener
    {
        public void onPasswordEntered(boolean isPasswordCorrect);
    }

    public void setParentLockDialogListener(ParentLockDialogListener parentLockDialogListener)
    {
        mParentLockDialogListener = parentLockDialogListener;
    }

    private void animateFeedBackMessageError()
    {
        mCounter += 1;
        EventManager.getInstance().LogEventWithIntField(getContext(), EventManager.LOG_NORMAL_LEVEL, EventParameters.CATEGORY_PARENTAL_LOCK, EventParameters.ACTION_PARENTAL_INCORRECT_PASSWORD, null, mCounter);
        String tryAgain = getContext().getString(R.string.ParentalLockDialogWrongSelectionTryAgain);
        String wrongSelection = getContext().getString(R.string.ParentalLockDialogWrongSelection);
        SpannableString messageTextError = new SpannableString(wrongSelection);
        SpannableString messageActionTryAgain = new SpannableString(tryAgain);
        messageActionTryAgain.setSpan(new StyleSpan(Typeface.BOLD), 0, messageActionTryAgain.length(), 0);

        mFeedbackMessage.setText(messageTextError);
        mFeedbackMessageAction.setText(messageActionTryAgain);

        AnimationFactory.flipTransition(mViewAnimator, AnimationFactory.FlipDirection.BOTTOM_TOP, FLIP_ANIMATION_DURATION);
    }

    private void animateFeedBackMessageSuccess(boolean mIsLockActive)
    {
        if (mIsLockActive == true)
        {
            String lockStatus = getContext().getString(R.string.ParentalLockDialogLockStatus);
            String off = getContext().getString(R.string.ParentalLockDialogLockStatusOff);
            String activate = getContext().getString(R.string.ParentalLockDialogLockActivate);

            SpannableString message = new SpannableString(lockStatus + off);
            message.setSpan(new StyleSpan(Typeface.BOLD), lockStatus.length(), message.length(), 0);

            SpannableString messageAction = new SpannableString(activate);
            messageAction.setSpan(new StyleSpan(Typeface.BOLD), 0, messageAction.length(), 0);

            mFeedbackMessage.setText(message);
            mFeedbackMessageAction.setText(messageAction);
        }
        else
        {
            String lockStatus = getContext().getString(R.string.ParentalLockDialogLockStatus);
            String on = getContext().getString(R.string.ParentalLockDialogLockStatusOn);
            String deactivate = getContext().getString(R.string.ParentalLockDialogLockDeactivate);

            SpannableString message = new SpannableString(lockStatus + on);
            message.setSpan(new StyleSpan(Typeface.BOLD), lockStatus.length(), message.length(), 0);

            SpannableString messageAction = new SpannableString(deactivate);
            messageAction.setSpan(new StyleSpan(Typeface.BOLD), 0, messageAction.length(), 0);

            mFeedbackMessage.setText(message);
            mFeedbackMessageAction.setText(messageAction);
        }
        AnimationFactory.flipTransition(mViewAnimator, AnimationFactory.FlipDirection.BOTTOM_TOP, FLIP_ANIMATION_DURATION);
    }

    private void animateFeedBackMessageBack()
    {
        AnimationFactory.flipTransition(mViewAnimator, AnimationFactory.FlipDirection.BOTTOM_TOP, FLIP_ANIMATION_DURATION);
    }


    public static boolean getIsCanShowDialog(Context context)
    {
        boolean result = false;
        JSONArray jSONArray = AppAssetsUtils.loadParentalLockConfigurationFile(context);
        if (jSONArray != null && jSONArray.length() > 0)
        {
            result = true;
        }
        return result;
    }
}
