package com.kidoz.sdk.api.dialogs;

import android.animation.Animator;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.custom_views.CloseButtonImageView;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardView;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.web_player.KidozWebView;

/**
 * Created by roni on 10/11/2015.
 */
public class AboutKidozDialog extends Dialog
{
    private final String TAG = AboutKidozDialog.class.getSimpleName();

    private RelativeLayout mRootView;
    private RelativeLayout mContainer;
    private KidozCardView mKidozCardView;
    private KidozWebView mKidozWebView;
    private Utils.StaticHandler mStaticHandler;
    private int[] mPopLocation;

    public AboutKidozDialog(Context context, int[] popLocation)
    {
        super(context, android.R.style.Theme_Translucent_NoTitleBar_Fullscreen);
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
        this.requestWindowFeature(Window.FEATURE_NO_TITLE);

        mPopLocation = popLocation;
        initDialog();
        setContentView(mRootView);
    }

    private void initDialog()
    {
        mStaticHandler = new Utils.StaticHandler();
        initRootView();
        initBackgroundkidozCardView();
        initWebView();
    }

    private void initRootView()
    {
        mRootView = new RelativeLayout(getContext());
    }

    private void initBackgroundkidozCardView()
    {
        mKidozCardView = new KidozCardView(getContext());
        mKidozCardView.setCardBackgroundColor(Color.parseColor("#ffffff"));
        mKidozCardView.setRadius(Utils.dpTOpx(getContext(), 4));
        int padding = Utils.dpTOpx(getContext(), 10);
        mKidozCardView.setPadding(padding, padding, padding, padding);

        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        if (ScreenUtils.getIsTablet(getContext()) == false)
        {
            params.width = Math.min(ScreenUtils.getScreenSize(getContext(), true), ScreenUtils.getScreenSize(getContext(), false));
            params.height = (int) (0.5f * Math.max(ScreenUtils.getScreenSize(getContext(), true), ScreenUtils.getScreenSize(getContext(), false)));
        }
        else
        {
            params.width = (int) (0.8f * Math.min(ScreenUtils.getScreenSize(getContext(), true), ScreenUtils.getScreenSize(getContext(), false)));
            params.height = (int) (0.5f * Math.max(ScreenUtils.getScreenSize(getContext(), true), ScreenUtils.getScreenSize(getContext(), false)));
        }
        params.setMargins(padding, padding, padding, padding);
        params.addRule(RelativeLayout.CENTER_IN_PARENT);
        mRootView.addView(mKidozCardView, params);

        mContainer = new RelativeLayout(getContext());
        mKidozCardView.addView(mContainer, new KidozCardView.LayoutParams(KidozCardView.LayoutParams.MATCH_PARENT, KidozCardView.LayoutParams.MATCH_PARENT));
    }

    private void initWebView()
    {
        mKidozWebView = new KidozWebView(getContext());
        mKidozWebView.getSettings().setUseWideViewPort(true);
        mKidozWebView.getSettings().setLoadWithOverviewMode(true);
        mKidozWebView.getSettings().setSupportZoom(false);
        mKidozWebView.setWebViewClient(new WebViewClient()
        {
            @Override public boolean shouldOverrideUrlLoading(WebView view, String url)
            {
                if (url.startsWith("mailto:"))
                {
                    Intent mailIntent = new Intent(Intent.ACTION_SENDTO, Uri.parse(url));
                    getContext().startActivity(mailIntent);
                }
                else
                {
                    view.loadUrl(url);
                }
                return true;
            }
        });
        mKidozWebView.setOnTouchListener(new View.OnTouchListener()
        {
            @Override public boolean onTouch(View v, MotionEvent event)
            {
                return true;
            }
        });
        mKidozWebView.setLongClickable(true);
        mKidozWebView.setOnLongClickListener(new View.OnLongClickListener()
        {
            @Override public boolean onLongClick(View v)
            {
                return true;
            }
        });
        mKidozWebView.setVerticalScrollBarEnabled(false);
        mKidozWebView.setHorizontalScrollBarEnabled(false);
        mKidozWebView.loadUrl("http://kidoz.net/v3policy/");

        mContainer.addView(mKidozWebView, new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT));

        CloseButtonImageView closeButtonImageView = new CloseButtonImageView(getContext(), Color.parseColor("#04a0e1"));
        closeButtonImageView.setOnClickListener(new View.OnClickListener()
        {
            @Override public void onClick(View v)
            {
                GenAnimator.clickItemAnimation(v, 100, new GenAnimator.ViewAnimationListener()
                {
                    @Override public void onAnimationEnd()
                    {
                        dismiss();
                    }

                    @Override public void onAnimationStart()
                    {

                    }
                });
            }
        });
        int padding = Utils.dpTOpx(getContext(), 10);
        closeButtonImageView.setPadding(padding, padding, padding, padding);
        RelativeLayout.LayoutParams xButtonParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        xButtonParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        xButtonParams.setMargins(0, Utils.dpTOpx(getContext(), 5), Utils.dpTOpx(getContext(), 5), 0);

        mContainer.addView(closeButtonImageView, xButtonParams);
    }


    @Override public void show()
    {
        super.show();
        mKidozCardView.setVisibility(View.INVISIBLE);
        mKidozCardView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener()
        {
            @Override public void onGlobalLayout()
            {
                if (Build.VERSION.SDK_INT < 16)
                {
                    mKidozCardView.getViewTreeObserver().removeGlobalOnLayoutListener(this);
                }
                else
                {
                    mKidozCardView.getViewTreeObserver().removeOnGlobalLayoutListener(this);
                }
                if (mPopLocation != null)
                {
                    GenAnimator.playPopInFromRightTop(mKidozCardView, mPopLocation, new Animator.AnimatorListener()
                    {
                        @Override public void onAnimationStart(Animator animation)
                        {
                            mKidozCardView.setVisibility(View.VISIBLE);
                        }

                        @Override public void onAnimationEnd(Animator animation)
                        {
                        }

                        @Override public void onAnimationCancel(Animator animation)
                        {

                        }

                        @Override public void onAnimationRepeat(Animator animation)
                        {

                        }
                    });
                }
                else
                {
                    mKidozCardView.setVisibility(View.VISIBLE);
                }
            }
        });
    }

    @Override public void dismiss()
    {
        if (mPopLocation != null)
        {
            GenAnimator.playPopOutToRightTop(mKidozCardView, mPopLocation, new Animator.AnimatorListener()
            {
                @Override public void onAnimationStart(Animator animation)
                {

                }

                @Override public void onAnimationEnd(Animator animation)
                {
                    AboutKidozDialog.super.dismiss();
                }

                @Override public void onAnimationCancel(Animator animation)
                {

                }

                @Override public void onAnimationRepeat(Animator animation)
                {

                }
            });
        }
        else
        {
            AboutKidozDialog.super.dismiss();
        }
    }
}
