package com.kidoz.sdk.api;


import android.app.Activity;
import android.content.Context;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.View;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.general.enums.UiStyleType;
import com.kidoz.sdk.api.interfaces.IOnFeedViewEventListener;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;

import java.util.ArrayList;

/**
 * Created by Evgeny on 16/07/2015.
 */
public class FeedView {
    private static final String TAG = FeedView.class.getSimpleName();

    private Builder mBuilder;
    private FeedVeiwFragmentDialog mFeedVeiwFragmentDialog;
    private FeedViewDialog mFeedViewDialog;
    protected ContentLogicLoader mContentLogicLoader;

    private IOnFeedViewEventListener mOnInterstitialViewEventListener;
    /**
     * Flag used to check ,is Pre load or Post load the content data
     */
    private boolean mIsPostLoadData = false;

    private FeedView(Builder builder) {
        mBuilder = builder;

        if (mBuilder.mFragmentManager != null) {
            Fragment existingDialog = mBuilder.mFragmentManager.findFragmentByTag(FeedVeiwFragmentDialog.TAG);
            if (existingDialog != null && existingDialog instanceof FeedVeiwFragmentDialog) {
                mFeedVeiwFragmentDialog = (FeedVeiwFragmentDialog) existingDialog;
            } else {
                mFeedVeiwFragmentDialog = FeedVeiwFragmentDialog.newInstance();
            }

            mFeedVeiwFragmentDialog.setOnCloseButtonClickListenr(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    dismissView();
                }
            });
        }

        initContentLogicLoader();
    }

    /**
     * Initiate  content loader logic ,that handles all the logic for loading content
     **/
    private void initContentLogicLoader() {
        mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback() {
            @Override
            public void onDataReady(ContentData contentData) {
                int servedCounter = 0;
                if (contentData != null) {
                    ArrayList<ContentItem> contentItems = contentData.getContentDataItems();
                    if (contentItems != null && contentItems.isEmpty() == false) {
                        for (ContentItem nextContentItem : contentItems) {
                            if (nextContentItem.isPromoted() == true) {
                                servedCounter++;
                            }
                        }
                    }
                    EventManager.getInstance().LogEventWithIntField(mBuilder.mContext, EventManager.LOG_CRITICAL_LEVEL, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_IMPRESSION_SERVED, null, servedCounter);
                }

                if (mBuilder.mFragmentManager != null && mFeedVeiwFragmentDialog != null) {
                    mFeedVeiwFragmentDialog.setContentData(contentData);
                } else if (mFeedViewDialog != null) {
                    mFeedViewDialog.setContentData(contentData);
                }


                if (mIsPostLoadData == false) {
                    if (mOnInterstitialViewEventListener != null) {
                        mOnInterstitialViewEventListener.onReadyToShow();
                    }

                    if (mBuilder.mFragmentManager != null && mFeedVeiwFragmentDialog != null) {
                        mFeedVeiwFragmentDialog.openDialog(mBuilder.mFragmentManager);
                    } else {
                        openSimpleDialog();
                    }
                }
            }
        });
    }

    /**
     * Show feed interstitial view (Will be shown <b>After</b> content data is ready)
     **/
   /* public void showView() {
        mIsPostLoadData = false;
        mContentLogicLoader.loadContent(mBuilder.mContext, UiStyleType.FEED_VIEW_STYLE);
    }*/

    /**
     * Show feed interstitial view (Will be shown <b>Before</b> content data is ready)
     **/
    public void showView() {
        mIsPostLoadData = true;

        if (mOnInterstitialViewEventListener != null) {
            mOnInterstitialViewEventListener.onReadyToShow();
        }

        if (mBuilder.mFragmentManager != null && mFeedVeiwFragmentDialog != null) {
            mFeedVeiwFragmentDialog.openDialog(mBuilder.mFragmentManager);
        } else {
            openSimpleDialog();
        }

        mContentLogicLoader.loadContent(mBuilder.mContext, UiStyleType.FEED_VIEW_STYLE);
    }

    /**
     * Create and open simple (Not fragment based) Dialog view
     */
    private void openSimpleDialog() {
        if (mBuilder.mContext != null && mBuilder.mContext instanceof Activity) {
            mFeedViewDialog = new FeedViewDialog(mBuilder.mContext);
            mFeedViewDialog.setOnCloseButtonClickListenr(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    dismissView();
                }
            });
        }

        mFeedViewDialog.openDialog();
    }

    /**
     * Dismiss view
     **/
    public void dismissView() {
        if (mBuilder.mFragmentManager != null && mFeedVeiwFragmentDialog != null) {
            mFeedVeiwFragmentDialog.closeDialog(mBuilder.mFragmentManager);
            if (mOnInterstitialViewEventListener != null) {
                mOnInterstitialViewEventListener.onDismissView();
            }
        } else {
            if (mFeedViewDialog != null) {
                mFeedViewDialog.closeDialog();
            }

            if (mOnInterstitialViewEventListener != null) {
                mOnInterstitialViewEventListener.onDismissView();
            }
        }
    }

    /**
     * Set on view event listener
     *
     * @param listener
     **/
    public void setOnFeedViewEventListener(IOnFeedViewEventListener listener) {
        mOnInterstitialViewEventListener = listener;
        if (mBuilder.mFragmentManager != null && mFeedVeiwFragmentDialog != null) {
            mFeedVeiwFragmentDialog.setOnInterstitialViewEventListener(mOnInterstitialViewEventListener);
        } else if (mFeedViewDialog != null) {
            mFeedViewDialog.setOnInterstitialViewEventListener(mOnInterstitialViewEventListener);
        }
    }

    /**
     * Builder class that handles view initiation
     **/
    public static class Builder {
        private FragmentManager mFragmentManager = null;
        private Context mContext;

        public Builder(Context context) {
            mContext = context;
            if (context instanceof FragmentActivity) {
                mFragmentManager = ((FragmentActivity) mContext).getSupportFragmentManager();
            }
        }

        public FeedView build() {
            return new FeedView(this);
        }
    }

    /**
     * On configuration change for correct flow of orientation change on open view
     **/
    public void onConfigurationChange() {
        if (mFeedViewDialog != null) {
            mFeedViewDialog.setOnCloseButtonClickListenr(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    dismissView();
                }
            });
        }
    }
}
