package com.kidoz.sdk.api;


import android.app.Dialog;
import android.content.DialogInterface;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.kidoz.events.EventManager;
import com.kidoz.events.EventParameters;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.interfaces.IOnFeedViewEventListener;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.ContentPanelView;
import com.kidoz.sdk.api.ui_views.FeedFullVeiw;


/**
 * Created by Eugine on 16/07/2015.
 */
public class FeedVeiwFragmentDialog extends DialogFragment
{

    public static final String TAG = FeedVeiwFragmentDialog.class.getSimpleName();

    private static final String SAVE_DATA_INSTANCE_KEY = "SAVE_DATA_INSTANCE_KEY";
    private static final String SAVE_ORIGINAL_ORIENTATION_KEY = "SAVE_ORIGINAL_ORIENTATION_KEY";

    private FeedFullVeiw mFeedFullVeiw;
    private ContentData mContentData = null;
    // Close button click listener
    private View.OnClickListener mCloseBtnClickListener = null;

    private int mCurrentOrientationState;

    private long mEventID;
    private boolean mImpressionServed;
    private IOnFeedViewEventListener mOnInterstitialViewEventListener;


    /**
     * Create a new instance of MyDialogFragment
     */
    protected static FeedVeiwFragmentDialog newInstance()
    {
        FeedVeiwFragmentDialog f = new FeedVeiwFragmentDialog();
        return f;
    }

    @Override public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);

        int style = DialogFragment.STYLE_NO_FRAME, theme = android.R.style.Theme_Black_NoTitleBar_Fullscreen;
        setStyle(style, theme);

        setCancelable(false);

        if (savedInstanceState != null && savedInstanceState.containsKey(SAVE_ORIGINAL_ORIENTATION_KEY))
        {
            mCurrentOrientationState = savedInstanceState.getInt(SAVE_ORIGINAL_ORIENTATION_KEY);
        }
        else
        {
            mCurrentOrientationState = getResources().getConfiguration().orientation;
            getActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR);
        }

        mImpressionServed = false;
    }

    @Override public Dialog onCreateDialog(Bundle savedInstanceState)
    {

        Dialog dialog = super.onCreateDialog(savedInstanceState);
       // dialog.getWindow().getAttributes().windowAnimations = R.style.FullViewInOutAnimation;
        dialog.setOnKeyListener(new DialogInterface.OnKeyListener()
        {
            @Override public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event)
            {
                boolean result = true;
                if (event.getAction() == KeyEvent.ACTION_DOWN)
                {
                    if (keyCode == KeyEvent.KEYCODE_BACK)
                    {
                        if (mFeedFullVeiw != null && mFeedFullVeiw.getViewBottomBar().isAboutViewVisible())
                        {
                            mFeedFullVeiw.getViewBottomBar().hideAboutView();
                        }
                        else
                        {
                            if (mOnInterstitialViewEventListener != null)
                            {
                                mOnInterstitialViewEventListener.onDismissView();
                            }
                            closeDialog(getFragmentManager());
                        }
                    }
                }
                return result;
            }
        });
        return dialog;
    }

    @Override public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState)
    {
        // Restore current view state data in case the fragment was destroyed due to going offscreen
        if (mContentData == null && savedInstanceState != null && savedInstanceState.containsKey(SAVE_DATA_INSTANCE_KEY))
        {
            mContentData = (ContentData) savedInstanceState.get(SAVE_DATA_INSTANCE_KEY);
        }

        //Create main feed view
        mFeedFullVeiw = new FeedFullVeiw(getActivity());
        mFeedFullVeiw.setOnContentItemClickListener(new ContentPanelView.IOnContentItemClickListener()
        {
            @Override public void onItemClick(ContentItem contentItem, int postion)
            {
                if (contentItem != null && contentItem.getContentType() != null && contentItem.getContentType() != ContentType.NONE)
                {
                    // Handle content item click
                    ContentExecutionHandler.handleContentItemClick(getActivity(), contentItem, postion);
                }
            }
        });

        mFeedFullVeiw.setOnCloseButtonClickListenr(mCloseBtnClickListener);
        mFeedFullVeiw.setContentDataAndRefresh(mContentData);

        return mFeedFullVeiw;
    }

    protected void setContentData(ContentData contentData)
    {
        mContentData = contentData;
        if (mFeedFullVeiw != null)
        {
            mFeedFullVeiw.setContentDataAndRefresh(mContentData);
        }
    }

    /**
     * Set on close button click listener
     *
     * @param clickListenr click listener
     */
    protected void setOnCloseButtonClickListenr(View.OnClickListener clickListenr)
    {
        mCloseBtnClickListener = clickListenr;
        if (mFeedFullVeiw != null)
        {
            mFeedFullVeiw.setOnCloseButtonClickListenr(mCloseBtnClickListener);
        }
    }


    /**
     * Show dialog view Set
     *
     * @param fragmentManager support fragment manager
     */
    protected void openDialog(FragmentManager fragmentManager)
    {
        if (KidozSDK.isInitialised())
        {
            FragmentTransaction ft = fragmentManager.beginTransaction();
            ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
            Fragment prev = fragmentManager.findFragmentByTag(TAG);
            if (prev != null)
            {
                ft.remove(prev);
            }
            else
            {
                if (isAdded() == false)
                {
                    ft.addToBackStack(null);
                    show(fragmentManager, TAG);
                }
            }
            EventManager.getInstance().logEvent(getActivity(), EventManager.LOG_CRITICAL_LEVEL, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_WIDGET_VIEW, null);
        }

    }

    /**
     * Dismiss dialog view
     *
     * @param fragmentManager support fragment manager
     */
    protected void closeDialog(FragmentManager fragmentManager)
    {
        mContentData = null;

        FragmentTransaction ft = fragmentManager.beginTransaction();
        ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_CLOSE);
        Fragment prev = fragmentManager.findFragmentByTag(TAG);
        if (prev != null)
        {
            ft.remove(prev);
        }

        // Restore previous orientation
        restoreUserOriginalOrientation();

        if (this != null)
        {
            this.dismissAllowingStateLoss();
        }
    }


    @Override public void onSaveInstanceState(Bundle outState)
    {
        super.onSaveInstanceState(outState);
        if (mContentData != null)
        {
            outState.putSerializable(SAVE_DATA_INSTANCE_KEY, mContentData);
            outState.putInt(SAVE_ORIGINAL_ORIENTATION_KEY, mCurrentOrientationState);
        }
    }

    @Override public void onPause()
    {
        EventManager.getInstance().activityEnd(getActivity(), EventManager.LOG_CRITICAL_LEVEL, mEventID);
        super.onPause();
    }

    @Override public void onResume()
    {
        super.onResume();
        mEventID = EventManager.getInstance().activityStart(getActivity(), EventManager.LOG_CRITICAL_LEVEL, "FeedViewDialog");
    }

    /**
     * Restore user original orientation
     */
    private void restoreUserOriginalOrientation()
    {
        if (getActivity() != null && getActivity().isFinishing() == false)
        {
            switch (mCurrentOrientationState)
            {
                case Configuration.ORIENTATION_LANDSCAPE:
                {
                    getActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_LANDSCAPE);
                    break;
                }

                case Configuration.ORIENTATION_PORTRAIT:
                {
                    getActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_PORTRAIT);
                    break;
                }
                case Configuration.ORIENTATION_UNDEFINED:
                {
                    getActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR);
                    break;
                }
            }
        }
    }

    public void setOnInterstitialViewEventListener(IOnFeedViewEventListener onInterstitialViewEventListener)
    {
        mOnInterstitialViewEventListener = onInterstitialViewEventListener;
    }
}


