package com.kidoz.sdk.api;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.custom_views.AnimatableGifImageView;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.KidozLogoDrawable;

/**
 * Created by Eugine on 8/26/2015.
 */
public class FeedButton extends RelativeLayout {

    private static final String TAG = FeedButton.class.getSimpleName();

    private static final float BUTTON_SIZE_AS_SCREEN_PORTION = 0.27f;
    private AnimatableGifImageView mAnimatableGifImageView;
    private FeedView mFeedView;

    private View mRootView;

    public FeedButton(Context context) {
        super(context);
        intiView(-1);
    }

    /**
     * Initiate button view
     *
     * @param size button size
     */
    public FeedButton(Context context,int size) {
        super(context);
        intiView(size);
    }

    /**
     * Initiate button view
     */
    public FeedButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        intiView(-1);
    }

    public FeedButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        intiView(-1);
    }

    /**
     * Initiate view
     */
    private void intiView(int initSize) {

        mRootView = this;

        int size = getDefaultButtonSize(getContext());

        if(initSize != -1) {
            size = initSize;
        }

        mAnimatableGifImageView = new AnimatableGifImageView(getContext());

        RelativeLayout.LayoutParams animatableImageParams = new RelativeLayout.LayoutParams(size, size);
        addView(mAnimatableGifImageView, animatableImageParams);

        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(size,size);
        setLayoutParams(params);

        KidozLogoDrawable kidozLogoDrawable = new KidozLogoDrawable();
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            mAnimatableGifImageView.setBackground(kidozLogoDrawable);
        } else {
            mAnimatableGifImageView.setBackgroundDrawable(kidozLogoDrawable);
        }

        if (isInEditMode() == false) {
            mAnimatableGifImageView.setAnimatedGif(Utils.prepareCorrectUri("https://kidoz-cdn.s3.amazonaws.com/sdk/btn_animation.gif"), new AnimatableGifImageView.IOnAnimatedGifReadyListener() {
                @Override
                public void onGifReady() {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                        mAnimatableGifImageView.setBackground(null);
                    } else {
                        mAnimatableGifImageView.setBackgroundDrawable(null);
                    }
                }
            });

            initFeedView();
        }
    }


    /**
     * Initiate button click listener
     */
    private void initClickListener() {
        setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mFeedView != null) {
                    GenAnimator.clickItemAnimation(mRootView, 100, new GenAnimator.ViewAnimationListener() {
                        @Override
                        public void onAnimationEnd() {
                            mFeedView.showView();
                        }

                        @Override
                        public void onAnimationStart() {

                        }
                    });
                }
            }
        });
    }

    /**
     * Initiate interstitial view
     */
    private void initFeedView() {
        mFeedView = new FeedView.Builder(getContext()).build();
        initClickListener();
    }

    /**
     * Get the inner interstitial view object
     *
     * @return interstitial view object
     */
    public FeedView getFeedView() {
        if(mFeedView == null) {
            initFeedView();
        }
        return mFeedView;
    }

    /**
     * Set button size
     *
     * @param size size in pixels
     */
    public void setFeedButtonSize(int size) {
        mAnimatableGifImageView.getLayoutParams().height = size;
        mAnimatableGifImageView.getLayoutParams().width = size;

        getLayoutParams().height = size;
        getLayoutParams().width = size;
    }

    /** Get default button size
     *
     * @return button size in pixels
     */
    public static int getDefaultButtonSize(Context context) {
        Point point = Utils.getScreenSize(context);
        return (int) (Math.min(point.x, point.y) * BUTTON_SIZE_AS_SCREEN_PORTION);
    }
}
