package com.kidoz.sdk.api;

import android.content.Context;
import android.widget.Toast;

import com.kidoz.sdk.api.general.enums.UiStyleType;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.structure.ContentData;

/**
 * Created by Eugine on 8/9/2015.
 */
public class ContentLogicLoader
{
    IOnContentDataReadyCallback mDataReadyCallback;
    private boolean mIsLoadContentIsInProgress;

    public ContentLogicLoader(IOnContentDataReadyCallback dataReadyCallback)
    {
        mDataReadyCallback = dataReadyCallback;
    }

    public void loadContent(final Context context, UiStyleType view_style)
    {
        if (mIsLoadContentIsInProgress == false)
        {
            mIsLoadContentIsInProgress = true;
            com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(">>>>loadContent");
            KidozSDK.getApiManager(context).loadContent(context, view_style, new ApiResultCallback<ContentData>()
            {
                @Override public void onServerResult(ResultData<?> result)
                {
                    if (result != null && result.getData() != null)
                    {
                        ContentData contentData = (ContentData) result.getData();
                        if (contentData.isHasContentToShow())
                        {
                            if (mDataReadyCallback != null)
                            {
                                mDataReadyCallback.onDataReady(contentData);
                            }
                        }
                    }
                    mIsLoadContentIsInProgress = false;
                }

                @Override public void onFailed()
                {
                    mIsLoadContentIsInProgress = false;
                    Toast.makeText(context, "No internet connection", Toast.LENGTH_LONG).show();
                }
            });
        }
    }


    protected void loadRefreshebleContent(UiStyleType view_style)
    {
        // TODO to add futere support for refreshable content
    }


    public interface IOnContentDataReadyCallback
    {
        public void onDataReady(ContentData contentData);
    }
}

