package com.kidoz.events;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.res.Configuration;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.view.WindowManager;

import com.kidoz.sdk.api.general.utils.ScreenUtils;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.zip.CRC32;

/**
 * Created by orikam on 8/20/15.
 */
public class EventManager
{
//    private class OpenedEventsInfo
//    {
//        public Date mStartTime;
//        public long mSessionID;
//        public long mActivityID;
//        public long mEventID;
//        public String mCategory;
//        public String mLabel;
//        public String mAction;
//        public int mLogLevel;
//
//    }//end class OpenedEventsInfo


    public static int LOG_CRITICAL_LEVEL = 0;
    public static int LOG_NORMAL_LEVEL = 1;

    public static int LOG_CLOSE_ANY_EVENT_LEVEL = 0;
    public static int LOG_CLOSE_RESOURCE_LEVEL = 1;
    public static int LOG_CLOSE_ACTIVITY_LEVEL = 2;
    public static int LOG_CLOSE_SESSION_LEVEL = 3;

    private static final String TAG = EventManager.class.getSimpleName();
    public static final String SYNC_ALARM_INTENT = "kidoz.sync.alarm.event.action";
    public static final String STOP_SERVICE_EXTRA = "STOP_SERVICE_EXTRA";
    public static final int SYNC_ALARM_INTENT_REQUEST_CODE = 1982;

    private static final int SYNC_ALARM_INTERVAL_IN_MILLISECONDS = 1 * 5 * 60 * 1000; ///oooOri should be 5 minutes
    private static final int NIGHT_TIME_HOUR_VALUE_START = 21;
    private static final int NIGHT_TIME_HOUR_VALUE_END = 8;
    private static final int DAY_TIME_AMOUNT = 10;
    private static final int NIGHT_TIME_AMOUNT_EXTRA = 50;
    private static final int THREE_G_CONNECTON_TYPE_AMOUNT = 10;
    private static final int WIFI_CONNECTON_TYPE_AMOUNT_EXTRA = 20;
    private static final int SCREEN_STATE_ON_AMOUNT = 10;
    private static final int SCREEN_STATE_OFF_AMOUNT_EXTRA = 20;
    private static final String OS_TYPE = "Android";
    private static final long DEFAULT_DELTA_TIME_BETWEEN_ACTIVITES_FOR_NEW_SESSION = 30*1000;//time in msec
    public static final String EVENTS_SHARED_PREFERENCES_KEY ="events_shared_preferences";
    public static final String EVENTS_LAST_SESSION_ID_KEY = "last_session_id";
    private static final String EVENTS_LAST_ACTIVITY_ID_KEY ="last_activity_id";
    private static final String EVENT_SERVER_ADDRESS_KEY = "event_server_address";
    private static final String DELTA_FOR_NEW_SESSION_KEY = "delta_for_new_session_key";
    public static final String LOG_LEVEL_KEY = "log_level";

    private static EventManager mEventManager;
    private int mLogLevel;
    private String mServerAdress;
    private long mSessionID;
    private long mActivityID;
    private String mActivityName;
    private Date mLastEventTimeStamp;
    private Date mLastActivityEndTime;
//    private long mDeltaForNewSession;
    private String mDeveloperID;
    private ArrayList<Event> mOpenedEventsList;

    private  EventLogDatabaseManager mDatabaseManager;
    private  EventManager()
    {
        mOpenedEventsList = new ArrayList<Event>();
    }

    private boolean initialized = false;
    public static EventManager getInstance()
    {
        if (mEventManager == null)
        {
            mEventManager = new EventManager();

        }
        return  mEventManager;
    }//end getInstance


    private EventLogDatabaseManager getEventDB(Context context) {
        if(mDatabaseManager == null) {
            mDatabaseManager = new EventLogDatabaseManager(context);
        }
        return mDatabaseManager;
    }

    /**
     *
     * this function init the event manager.
     * @param params
     *
     */
    public void init(Context context, JSONObject params)
    {

        SharedPreferences eventsPref = context.getSharedPreferences(EVENTS_SHARED_PREFERENCES_KEY, 0);
        try
        {
            if (params!=null)
            {
                mLogLevel = params.optInt(LOG_LEVEL_KEY, EventManager.LOG_CRITICAL_LEVEL);
                mServerAdress = params.optString("serveraddress", EVENT_SERVER_ADDRESS_KEY);
                mDeveloperID = params.optString(EventParameters.DEVELOPER_ID, "");
                mSessionID = params.optInt(EventParameters.SESSION_ID,0);
                //todo: save new values to preference and reload them
                SharedPreferences.Editor editor = eventsPref.edit();
                editor.putInt(LOG_LEVEL_KEY,mLogLevel);
                editor.putString(EventParameters.DEVELOPER_ID, mDeveloperID);
                editor.commit();
            }
            else
            {
                mLogLevel = eventsPref.getInt(LOG_LEVEL_KEY, EventManager.LOG_CRITICAL_LEVEL);
                mServerAdress = eventsPref.getString("serveraddress", EVENT_SERVER_ADDRESS_KEY);
                mDeveloperID = eventsPref.getString(EventParameters.DEVELOPER_ID, "");
                mSessionID = -1;
            }



//            mSessionID = eventsPref.getLong(EVENTS_LAST_SESSION_ID_KEY, 0);
            mActivityID = 0;//eventsPref.getLong(EVENTS_LAST_ACTIVITY_ID_KEY, 0);
//            mDeltaForNewSession = eventsPref.getLong(DELTA_FOR_NEW_SESSION_KEY, DEFAULT_DELTA_TIME_BETWEEN_ACTIVITES_FOR_NEW_SESSION);

            if (mDatabaseManager == null)
            {
                mDatabaseManager = new EventLogDatabaseManager(context);
            }
            com.kidoz.sdk.api.general.utils.SDKLogger.printInfoLog("init Event manager");


            //new session
//            mSessionID += 1;
//            SharedPreferences eventsPref = context.getSharedPreferences(EVENTS_SHARED_PREFERENCES_KEY, 0);
//            SharedPreferences.Editor editor = eventsPref.edit();
//            editor.putLong(EVENTS_LAST_SESSION_ID_KEY, mSessionID);
//            editor.commit();

//            internalLogEvent(context, LOG_CRITICAL_LEVEL, null, EventParameters.CATEGORY_SESSION, EventParameters.ACTION_SESSION_START, null);
//            SDKLogger.printInfoLog("Session start event generated");
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog("Error on EventManager init " + ex.getMessage());
        }
        initialized = true;
    }//end init function

    /**
     * This method randomly set the next sync alarm fire time.
     *
     * @param context
     */
    public void setSyncAlarm(Context context)
    {
        if (initialized == false)
        {
            init(context,null);
        }
        AlarmManager alarmManager = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
        Intent intent = new Intent(context, SyncReciever.class);
        intent.setAction(SYNC_ALARM_INTENT);
        PendingIntent pendingIntent = PendingIntent.getBroadcast(context, SYNC_ALARM_INTENT_REQUEST_CODE, intent, PendingIntent.FLAG_UPDATE_CURRENT);

        // Randomly trigger the next alarm. the minimum trigger time can be 3
        // hours from now, the maximum can be 6.
        Random random = new Random();
        long currentTimeInMilliseconds = Calendar.getInstance().getTimeInMillis();
        long triggerAtMillis = currentTimeInMilliseconds + random.nextInt(SYNC_ALARM_INTERVAL_IN_MILLISECONDS) + SYNC_ALARM_INTERVAL_IN_MILLISECONDS;
        alarmManager.set(AlarmManager.RTC_WAKEUP, triggerAtMillis, pendingIntent);
    }

    /**
     * This method cancel an active alarm if exist.
     *
     * @param context
     */
    public void cancelSyncAlarm(Context context)
    {
        if (initialized == false)
        {
            init(context,null);
        }
        Intent intent = new Intent(context, SyncReciever.class);
        PendingIntent pendingIntent = PendingIntent.getBroadcast(context, SYNC_ALARM_INTENT_REQUEST_CODE, intent, PendingIntent.FLAG_NO_CREATE);
        AlarmManager alarmManager = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
        if (intent != null)
        {
            alarmManager.cancel(pendingIntent);
        }
    }

    /**
     * This method simply start the SyncEventService.
     *
     * @param context
     */
    public void startSync(Context context)
    {
        Intent intent = getSyncServiceIntent(context);
        context.startService(intent);
    }

    /**
     * This method create a sync service intent and return it. * IMPORTANTE-
     * This method should only be called from SyncReciever onReceive because
     * this intent will hold a wake lock.
     *
     * @param context
     * @return
     */
    public  Intent getSyncServiceIntent(Context context)
    {
        if (initialized == false)
        {
            init(context,null);
        }

        Intent intent = new Intent(context, SyncEventService.class);
        intent.putExtra(SyncEventService.SYNC_TYPE_KEY,SyncEventService.SYNC_EVENTS);
        return intent;
    }

    /**
     * This method return wherever a log can be sent. A log can be sent if the
     * following rules are valid: 1. Is connected to the internet? 2. If Kidoz
     * is not running or if it does the screen is off. 3. If there is still
     * events waiting in DB.
     *
     * @return is can send log.
     */
    public  boolean getIsCanSendLog(Context context)
    {
//        initKidozEventManager(context);
        boolean result = false;
        if (initialized == false)
        {
            init(context,null);
        }
        // 1. Check if network connection available?
        //if (BaseConnectionClient.isNetworkAvailable(context) == true)
        //{
            // 2. Check if there is still events waiting in DB?
            if (getEventDB(context).getEventsTable().isDBempty() == false)
            {
                result = true;
            }
        //}
        return result;
    }

    public EventBulk getNextBulk(Context context)
    {
        if (initialized == false)
        {
            init(context,null);
        }
        EventBulk result = new EventBulk();
        result.setDeviceParamsJSONObject(getBulkDeviceParamsJsonObject(context));
        result.setEventArrayList(getEventDB(context).getEventsTable().getEvents(calculateBulkSize(context)));
        return result;
    }

    public  void removeBulkFromDB(Context context, EventBulk eventBulk)
    {
        if (initialized == false)
        {
            init(context,null);
        }
        getEventDB(context).getEventsTable().removeLogEventsFromDB(eventBulk.getEventArrayList());
    }

    private  int calculateBulkSize(Context context)
    {
        if (initialized == false)
        {
            init(context,null);
        }
        // The minimum bulk is 30, the maximum is 120.
        int result = DAY_TIME_AMOUNT + THREE_G_CONNECTON_TYPE_AMOUNT + SCREEN_STATE_ON_AMOUNT;
        Calendar calendar = Calendar.getInstance();
        int currentHour = calendar.get(Calendar.HOUR_OF_DAY);
        if (currentHour >= NIGHT_TIME_HOUR_VALUE_START || currentHour <= NIGHT_TIME_HOUR_VALUE_END)
        {
            result += NIGHT_TIME_AMOUNT_EXTRA;
        }

        /*if (BaseConnectionClient.getConnectionType(context) == ConnectivityManager.TYPE_WIFI)
        {
            result += WIFI_CONNECTON_TYPE_AMOUNT_EXTRA;
        }*/

        if (ScreenUtils.getIsScreenOff(context) == true)
        {
            result += SCREEN_STATE_OFF_AMOUNT_EXTRA;
        }

        return result;
    }

    /**
     *  This method create the session start event.
     *  the returned value is the id for the new activity. res lower than 0 means there was some error
     */
    public long activityStart(Context context, int logLevel, String activityName)
    {

        try
        {
            if (initialized == false)
            {
                init(context,null);
            }

            mLastEventTimeStamp = new Date();

            if (mLastActivityEndTime==null)
            {
                mLastActivityEndTime = new Date(0);
            }
            Date lastEventTime = mLastEventTimeStamp;
            mLastEventTimeStamp = new Date();
            Long timeDelta = mLastEventTimeStamp.getTime() - mLastActivityEndTime.getTime();
            //new session
//            if (timeDelta > mDeltaForNewSession)
//            {
//                mSessionID += 1;
//                SharedPreferences eventsPref = context.getSharedPreferences(EVENTS_SHARED_PREFERENCES_KEY, 0);
//                SharedPreferences.Editor editor = eventsPref.edit();
//                editor.putLong(EVENTS_LAST_SESSION_ID_KEY, mSessionID);
//                editor.commit();
//
//                internalLogEvent(context, LOG_CRITICAL_LEVEL,null, EventParameters.CATEGORY_SESSION, EventParameters.ACTION_SESSION_START, null);
//                SDKLogger.printInfoLog("Session start event generated");
//            }
            mActivityID += 1;
            // SharedPreferences eventsPref = context.getSharedPreferences(EVENTS_SHARED_PREFERENCES_KEY, 0);
            // SharedPreferences.Editor editor = eventsPref.edit();
            // editor.putLong(EVENTS_LAST_ACTIVITY_ID_KEY, mSessionID);
            // editor.commit();

            Event openedEvent = new Event();
            fillBaseEventParameters(openedEvent, EventParameters.CATEGORY_ACTIVITY, EventParameters.ACTION_ACTIVITY_END, activityName);
            openedEvent.setLogLevel(EventManager.LOG_CRITICAL_LEVEL);
            openedEvent.setCloseLevel(EventManager.LOG_CLOSE_ACTIVITY_LEVEL);
            mOpenedEventsList.add(openedEvent);

            mActivityName = activityName;

            //send event to server
            internalLogEvent(context, logLevel, null, EventParameters.CATEGORY_ACTIVITY, EventParameters.ACTION_ACTIVITY_START, activityName);
            com.kidoz.sdk.api.general.utils.SDKLogger.printInfoLog("activity start event generated");
            return mActivityID;
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog("Error on EventManager activityStart " + ex.getMessage());
        }
        return -1;

    }

    /**
     *  This method create the session end event. if the returned value lower than 0 then some error accourd
     */
    public int activityEnd(Context context, int logLevel, long activityID)
    {

        try
        {
            Date currentDate = new Date();
            //close all open events
            for (Iterator<Event> iterator = mOpenedEventsList.iterator(); iterator.hasNext(); )
            {
                Event opendEvent = iterator.next();
                if (opendEvent.getCloseLevel() <= LOG_CLOSE_ACTIVITY_LEVEL)
                {
                    long duration = currentDate.getTime() - opendEvent.getEventCreationTime();
                    opendEvent.addParameterToJsonObject(EventParameters.DURATION,String.valueOf(duration));
                    internalLogEvent(context, opendEvent.getLogLevel(), opendEvent, null, null, null);
                    iterator.remove();
                }
            }//end iterator
            com.kidoz.sdk.api.general.utils.SDKLogger.printInfoLog("activity end event called");
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog("Error on EventManager activity end " + ex.getMessage());
        }
        mLastActivityEndTime = new Date();
        return 0;
    }//end activityEnd function


    /**
     *  This method create basic event
     */
    public int logClickEvent(Context context, String action, String label, String itemID, int position)
    {

        Event event = new Event();
        event.addParameterToJsonObject(EventParameters.ITEM_ID, itemID);
        event.addParameterToJsonObject(EventParameters.ITEM_INDEX, position);
        internalLogEvent(context, EventManager.LOG_NORMAL_LEVEL, event, EventParameters.CATEGORY_CONTENT_CLICK, action, label);

        return 0;
    }//end logEvent function

    /**
     *  This method create basic event
     */
    public int logEvent(Context context,int logLevel, String category, String action, String label)
    {

        internalLogEvent(context, logLevel, null, category, action, label);

        return 0;
    }//end logEvent function

    /**
     *  This method create event with duration. if a log entry with the same resource key ends
     *  the previous event and start a new one. the return value is the resource id.
     */
    public int logEventWithDuration(Context context,int logLevel, int resourceID, int closeLevel, String category, String action, String label, String itemID)
    {
        try
        {
            Date currentDate = new Date();
            for (Iterator<Event> iterator = mOpenedEventsList.iterator(); iterator.hasNext(); )
            {
                Event opendEvent = iterator.next();
                if (opendEvent.getResourceID() == resourceID)
                {
                    long duration = currentDate.getTime() - opendEvent.getEventCreationTime();
                    opendEvent.addParameterToJsonObject(EventParameters.DURATION,duration);
                    opendEvent.addParameterToJsonObject(EventParameters.ITEM_ID,itemID);
                    internalLogEvent(context, opendEvent.getLogLevel(), opendEvent, null, null, null);
                    iterator.remove();
                }
            }//end iterator
            com.kidoz.sdk.api.general.utils.SDKLogger.printInfoLog("activity end event called");
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog("Error on EventManager logEventWithDuration " + ex.getMessage());
        }
        Event openedEvent = new Event();
        fillBaseEventParameters(openedEvent, category, action, label);
        openedEvent.setLogLevel(logLevel);
        openedEvent.setCloseLevel(closeLevel);
        openedEvent.setResourceID(resourceID);
        mOpenedEventsList.add(openedEvent);

        return 0;
    }//end logEvent function

    /**
     *  This method ends the event with duration based on the resource ID
     */
    public int logEventWithDurationEnd(Context context,int resourceID)
    {
        try
        {
            Date currentDate = new Date();
            for (Iterator<Event> iterator = mOpenedEventsList.iterator(); iterator.hasNext(); )
            {
                Event opendEvent = iterator.next();
                if (opendEvent.getResourceID() == resourceID)
                {
                    long duration = currentDate.getTime() - opendEvent.getEventCreationTime();
                    opendEvent.addParameterToJsonObject(EventParameters.DURATION,String.valueOf(duration));
                    internalLogEvent(context, opendEvent.getLogLevel(), opendEvent, null, null, null);
                    iterator.remove();
                }
            }//end iterator
            com.kidoz.sdk.api.general.utils.SDKLogger.printInfoLog("activity end event called");
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog("Error on EventManager logEventWithDuration " + ex.getMessage());
        }
        return 0;
    }//end logEvent function

    public int logSponsoredContentImpressionEvent(Context context, String action, String label,
                                 String advertiserID, String itemID, int positionIndex )
    {
        try
        {
            Event event = new Event();
            event.addParameterToJsonObject(EventParameters.ITEM_ID, itemID);
            event.addParameterToJsonObject(EventParameters.ADVERTISER_ID, advertiserID);
            event.addParameterToJsonObject(EventParameters.ITEM_INDEX, positionIndex);
            internalLogEvent(context, EventManager.LOG_CRITICAL_LEVEL, event, EventParameters.CATEGORY_SPONSORED_CONTENT, action, label);
            return 0;
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog("Error on EventManager logImpressionEvent " + ex.getMessage());
        }
        return -1;
    }

    public int logSponsoredContentClickEvent(Context context, String label,
                                  String advertiserID, String itemID, int positionIndex )
    {
        try
        {
            Event event = new Event();
            event.addParameterToJsonObject(EventParameters.ITEM_ID, itemID);
            event.addParameterToJsonObject(EventParameters.ADVERTISER_ID, advertiserID);
            event.addParameterToJsonObject(EventParameters.ITEM_INDEX, positionIndex);
            internalLogEvent(context, EventManager.LOG_CRITICAL_LEVEL, event, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_CLICK, label);
            return 0;
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog("Error on EventManager logImpressionEvent " + ex.getMessage());
        }
        return -1;
    }

    public int logSponsoredContentInstallEvent(Context context, String label,
                                             String advertiserID, String itemID, int positionIndex )
    {
        try
        {
            Event event = new Event();
            event.addParameterToJsonObject(EventParameters.ITEM_ID, itemID);
            event.addParameterToJsonObject(EventParameters.ADVERTISER_ID, advertiserID);
            event.addParameterToJsonObject(EventParameters.ITEM_INDEX, positionIndex);
            internalLogEvent(context, EventManager.LOG_CRITICAL_LEVEL, event, EventParameters.CATEGORY_SPONSORED_CONTENT, EventParameters.ACTION_PROMOTED_APP_INSTALL_COMPLETE, label);
            return 0;
        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog("Error on EventManager logImpressionEvent " + ex.getMessage());
        }
        return -1;
    }

    /**
     *  This method is used to log basic event
     */
    public int LogEventWithIntField(Context context, int logLevel, String category, String action, String label,int intField)
    {

        Event event = new Event();
//        fillBaseEventParameters(event, category, action, label);
        event.addParameterToJsonObject(EventParameters.INT_FIELD, intField);
        return (internalLogEvent(context,logLevel,event,category,action,label));

    }//end internalLogEvent function


    /**
     *  This method is used to log basic event
     */
    public int LogEvent(Context context, int logLevel, Event event,String category, String action, String label)
    {

        return (internalLogEvent(context,logLevel,event,category,action,label));

    }//end internalLogEvent function

    /**
     *  This method create create the events and add it to que
     */
    private int internalLogEvent(Context context, int logLevel, Event event,String category, String action, String label)
    {
        Event tempEvent;

        if (logLevel<=mLogLevel)
        {
            if (event == null)
            {
                tempEvent = new Event();
            } else
            {
                tempEvent = event;
            }
            fillBaseEventParameters(tempEvent, category, action, label);

            com.kidoz.sdk.api.general.utils.SDKLogger.printInfoLog("Event sent to DB: " + tempEvent.getJSONObject().toString());
            getEventDB(context).getEventsTable().inserLogEventToDB(tempEvent);
        }

        return 0;
    }//end internalLogEvent function


    private int fillBaseEventParameters(Event event,String category, String action, String label)
    {
        if (category != null)
        {
            event.addParameterToJsonObject(EventParameters.CATEGORY, category);
        }
        if (action != null)
        {
            event.addParameterToJsonObject(EventParameters.ACTION, action);
        }
        if (label != null)
        {
            event.addParameterToJsonObject(EventParameters.LABEL, label);
        }
        event.addParameterToJsonObject(EventParameters.ACTIVITY_NAME, mActivityName);
        event.addParameterToJsonObject(EventParameters.ACTIVITY_ID, mActivityID);
        event.addParameterToJsonObject(EventParameters.SESSION_ID,mSessionID);
//        SDKLogger.printInfoLog("Event basic parameters added: " + event.getJSONObject().toString());

        return 0;
    }


    private  JSONObject getStaticDeviceParamsJsonObject(Context context)
    {
        JSONObject result = new JSONObject();
        try
        {
            String deviceID = Settings.Secure.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
            CRC32 crc = new CRC32();
            crc.update(deviceID.getBytes());
            result.put(EventParameters.DEVICE_HASH, String.valueOf(crc.getValue()));
            result.put(EventParameters.DEVICE_TYPE, String.valueOf(Build.DEVICE));
            result.put(EventParameters.DEVICE_BRAND, String.valueOf(Build.MANUFACTURER));
            result.put(EventParameters.DEVICE_MODEL, String.valueOf(Build.MODEL));
            result.put(EventParameters.SCREEN_TYPE, String.valueOf((context.getResources().getConfiguration().screenLayout & Configuration.SCREENLAYOUT_SIZE_MASK)));
            result.put(EventParameters.SCREEN_SIZE, String.valueOf(ScreenUtils.getDeviceScreenSizeInInches(context)));
            WindowManager windowManager = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
            DisplayMetrics metrics = new DisplayMetrics();
            windowManager.getDefaultDisplay().getMetrics(metrics);
            result.put(EventParameters.DPI_FACTOR, String.valueOf(metrics.densityDpi));
            result.put(EventParameters.SCREEN_WIDTH, String.valueOf(DeviceUtils.getScreenSize(context, true)));
            result.put(EventParameters.SCREEN_HEIGHT, String.valueOf(DeviceUtils.getScreenSize(context, false)));
            result.put(EventParameters.OS_TYPE, String.valueOf(OS_TYPE));
            result.put(EventParameters.OS_VERSION, String.valueOf(Build.VERSION.SDK_INT));
            //result.put(EventParameters.CONNECTION_TYPE, EventParameters.convertConnectionTypeToString(BaseConnectionClient.getConnectionType(context)));
            result.put(EventParameters.DEVICE_LANGUAGE, String.valueOf(Locale.getDefault().getLanguage()));
            result.put(EventParameters.TIME_ZONE, EventParameters.getCurrentTimezoneOffset());
            result.put(EventParameters.COUNTRY, String.valueOf(Locale.getDefault().getCountry()));
            result.put(EventParameters.EVENT_TYPE, EventParameters.EVENT_TYPE_DEVICE_INFO);

        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to create device params: " + ex.getMessage());
        }
        return result;
    }

    private  JSONObject getBulkDeviceParamsJsonObject(Context context)
    {
        JSONObject result = new JSONObject();
        try
        {
            String deviceID = Settings.Secure.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
            CRC32 crc = new CRC32();
            crc.update(deviceID.getBytes());
            result.put(EventParameters.DEVICE_HASH, String.valueOf(crc.getValue()));
            result.put(EventParameters.USER_REFFERAL, DeviceUtils.getDeviceReferral(context));
            result.put(EventParameters.KIDOZ_APP_PACKAGE_NAME, context.getPackageName());
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            result.put(EventParameters.APP_VERSION, String.valueOf(pInfo.versionName));
            result.put(EventParameters.APP_ID, String.valueOf(pInfo.packageName));
            if (mDeveloperID == null)
            {
                SharedPreferences eventsPref = context.getSharedPreferences(EVENTS_SHARED_PREFERENCES_KEY, 0);
                mDeveloperID = eventsPref.getString(EventParameters.DEVELOPER_ID, "");
            }
            result.put(EventParameters.DEVELOPER_ID, mDeveloperID);
            result.put(EventParameters.EVENT_TYPE, EventParameters.EVENT_TYPE_NORMAL);
            result.put("EventVersion", 0);
//            result.put("debugid", "oooOri");

            //todo: this data should be sent only once
            result.put(EventParameters.DEVICE_TYPE, String.valueOf(Build.DEVICE));
            result.put(EventParameters.DEVICE_BRAND, String.valueOf(Build.MANUFACTURER));
            result.put(EventParameters.DEVICE_MODEL, String.valueOf(Build.MODEL));
            result.put(EventParameters.SCREEN_TYPE, String.valueOf((context.getResources().getConfiguration().screenLayout & Configuration.SCREENLAYOUT_SIZE_MASK)));
            result.put(EventParameters.SCREEN_SIZE, String.valueOf(ScreenUtils.getDeviceScreenSizeInInches(context)));
            WindowManager windowManager = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
            DisplayMetrics metrics = new DisplayMetrics();
            windowManager.getDefaultDisplay().getMetrics(metrics);
            result.put(EventParameters.DPI_FACTOR, String.valueOf(metrics.densityDpi));
            result.put(EventParameters.SCREEN_WIDTH, String.valueOf(DeviceUtils.getScreenSize(context, true)));
            result.put(EventParameters.SCREEN_HEIGHT, String.valueOf(DeviceUtils.getScreenSize(context, false)));
            result.put(EventParameters.OS_TYPE, String.valueOf(OS_TYPE));
            result.put(EventParameters.OS_VERSION, String.valueOf(Build.VERSION.SDK_INT));
            //result.put(EventParameters.CONNECTION_TYPE, EventParameters.convertConnectionTypeToString(BaseConnectionClient.getConnectionType(context)));
            result.put(EventParameters.DEVICE_LANGUAGE, String.valueOf(Locale.getDefault().getLanguage()));
            result.put(EventParameters.TIME_ZONE, EventParameters.getCurrentTimezoneOffset());
            result.put(EventParameters.COUNTRY, String.valueOf(Locale.getDefault().getCountry()));
            result.put(EventParameters.EVENT_TYPE, EventParameters.EVENT_TYPE_DEVICE_INFO);

        }
        catch (Exception ex)
        {
            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog( "Error when trying to create device params: " + ex.getMessage());
        }
        return result;
    }
}// end class EventManager
