/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.general.custom_views.KidozBottomBar;
import com.kidoz.sdk.api.general.custom_views.KidozTopBar;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.ui_views.AbstractContentPanel;
import com.kidoz.sdk.api.ui_views.ContentPanelView;
import com.kidoz.sdk.api.ui_views.OnBoardingCloud;

public class FeedFullVeiw
extends FrameLayout {
    private ContentPanelView mContentPanelView;
    private ContentData mContentData;
    private KidozTopBar mKidozTopBar;
    private KidozBottomBar mKidozBottomBar;
    private Utils.StaticHandler mStaticHandler = new Utils.StaticHandler();
    private View.OnClickListener mCloseBtnClickListener = null;

    public FeedFullVeiw(Context context) {
        super(context);
        this.initView();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        SDKLogger.printDebbugLog("HERE", ">>>>FeedFullVeiw: onConfigurationChanged");
    }

    private void initView() {
        RelativeLayout containerLayout = new RelativeLayout(this.getContext());
        containerLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        containerLayout.setBackgroundResource(R.drawable.feed_background_gradient);
        this.mKidozTopBar = new KidozTopBar(this.getContext(), KidozTopBar.TopBarCloseMode.CLOSE_BUTTON);
        this.mKidozTopBar.setId(Utils.generateViewId());
        this.mKidozTopBar.setTitle("More Cool Stuff");
        this.mKidozTopBar.setKidozTopBarListener(new KidozTopBar.KidozTopBarListener(){

            @Override
            public void onExitClicked(View view) {
                if (FeedFullVeiw.this.mCloseBtnClickListener != null) {
                    FeedFullVeiw.this.mCloseBtnClickListener.onClick(null);
                }
            }
        });
        this.mKidozTopBar.showParentalLockIcon(true);
        this.mKidozBottomBar = new KidozBottomBar(this.getContext());
        this.mKidozBottomBar.setId(Utils.generateViewId());
        this.mContentPanelView = new ContentPanelView(this.getContext(), ContentPanelView.LayoutViewType.STAGGERED);
        this.mContentPanelView.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        containerLayout.addView((View)this.mContentPanelView, (ViewGroup.LayoutParams)params);
        params = new RelativeLayout.LayoutParams(-1, -1);
        containerLayout.addView((View)this.mKidozTopBar, (ViewGroup.LayoutParams)params);
        params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(12);
        containerLayout.addView((View)this.mKidozBottomBar, (ViewGroup.LayoutParams)params);
        this.addView((View)containerLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.initOnBoardingCloud();
    }

    public void setContentDataAndRefresh(ContentData contentData) {
        this.mContentData = contentData;
        this.applyViewStyling();
        if (this.mContentData != null) {
            String alreadyBoardedKey = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "ON_BOARDING_SHARED_PREFERENCES_KEY");
            if (alreadyBoardedKey == null) {
                SharedPreferencesUtils.saveSharedPreferencesData(this.getContext(), "ON_BOARDING_SHARED_PREFERENCES_KEY", "ON_BOARDING_SHARED_PREFERENCES_KEY");
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        FeedFullVeiw.this.mContentPanelView.addDatandRefreshView(FeedFullVeiw.this.mContentData.getContentDataItems());
                    }
                }, 3200L);
            } else {
                this.mContentPanelView.addDatandRefreshView(this.mContentData.getContentDataItems());
            }
        }
    }

    private void applyViewStyling() {
        if (this.mContentData != null) {
            this.mKidozBottomBar.setBackgroundURI();
            this.mContentPanelView.setRoundingCorenrsValue(this.mContentData.getViewItemCorenrRadiusPx());
        }
    }

    public void setOnCloseButtonClickListenr(View.OnClickListener clickListenr) {
        this.mCloseBtnClickListener = clickListenr;
        if (this.mKidozBottomBar != null) {
            this.mKidozTopBar.setKidozTopBarListener(new KidozTopBar.KidozTopBarListener(){

                @Override
                public void onExitClicked(View view) {
                    if (FeedFullVeiw.this.mCloseBtnClickListener != null) {
                        FeedFullVeiw.this.mCloseBtnClickListener.onClick(null);
                    }
                }
            });
        }
    }

    public void setOnContentItemClickListener(AbstractContentPanel.IOnContentItemClickListener listener) {
        if (this.mContentPanelView != null) {
            this.mContentPanelView.setOnContentItemClickListener(listener);
        }
    }

    public void screenStatusChanged(boolean screenOn) {
        this.mContentPanelView.screenStatusChanged(screenOn);
    }

    private void initOnBoardingCloud() {
        String alreadyBoardedKey = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "ON_BOARDING_SHARED_PREFERENCES_KEY2");
        if (alreadyBoardedKey == null) {
            SharedPreferencesUtils.saveSharedPreferencesData(this.getContext(), "ON_BOARDING_SHARED_PREFERENCES_KEY2", "ON_BOARDING_SHARED_PREFERENCES_KEY");
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
            final OnBoardingCloud onBoardingCloud = new OnBoardingCloud(this.getContext());
            this.addView((View)onBoardingCloud, (ViewGroup.LayoutParams)params);
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (Build.VERSION.SDK_INT < 16) {
                        FeedFullVeiw.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        FeedFullVeiw.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                    onBoardingCloud.animateView(new OnBoardingCloud.OnBoardingCloudInterface(){

                        @Override
                        public void onFinished() {
                            FeedFullVeiw.this.removeView((View)onBoardingCloud);
                        }
                    });
                }
            });
        }
    }

    public KidozBottomBar getViewBottomBar() {
        return this.mKidozBottomBar;
    }
}

