/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.structure;

import android.content.Context;
import android.graphics.Bitmap;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.kidoz.sdk.api.structure.LockIconData;
import com.kidoz.sdk.api.structure.ParentalLockData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class SDKConfigurationData {
    private static final String TAG = SDKConfigurationData.class.getSimpleName();
    private final String SDK_CONFIGURATION_VERSION = "SDK_CONFIGURATION_VERSION";
    private String mConfigurationVersion;
    private ParentalLockData mParentalLockData;

    public SDKConfigurationData(String data) {
        if (data != null) {
            try {
                JSONObject jSONObject;
                JSONObject resultJSONObject = new JSONObject(data);
                if (resultJSONObject.has("data") && !resultJSONObject.isNull("data") && (jSONObject = resultJSONObject.getJSONObject("data")) != null) {
                    if (jSONObject.has("configuration_version") && !jSONObject.isNull("configuration_version")) {
                        this.mConfigurationVersion = jSONObject.getString("configuration_version");
                    }
                    if (jSONObject.has("parental_lock_data") && !jSONObject.isNull("parental_lock_data")) {
                        this.mParentalLockData = new ParentalLockData(jSONObject.getJSONObject("parental_lock_data"));
                    }
                }
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error creating sdk configuration data: " + ex.getMessage());
            }
        }
    }

    public String getConfigurationVersion() {
        return this.mConfigurationVersion;
    }

    public void setConfigurationVersion(String configurationVersion) {
        this.mConfigurationVersion = configurationVersion;
    }

    public ParentalLockData getParentalLockData() {
        return this.mParentalLockData;
    }

    public static void saveConfigurationFile(Context context, JSONArray jSONArray) {
        String configurationFileName = "ConfigurationFile";
        try {
            File dir = context.getFilesDir();
            File file = new File(dir, configurationFileName);
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream fileOutputStream = context.openFileOutput(configurationFileName, 0);
            fileOutputStream.write(jSONArray.toString().getBytes());
            fileOutputStream.close();
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to create configuration file: " + ex.getMessage());
        }
    }

    public static void saveLockIconToFS(Context context, Bitmap bitmap, String lockIconName) {
        try {
            FileOutputStream fileOutputStream = context.openFileOutput(lockIconName, 0);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to create configuration file: " + ex.getMessage());
        }
    }

    public static JSONArray loadConfigurationFile(Context context) {
        JSONArray result = null;
        String configurationFileName = "ConfigurationFile";
        StringBuffer stringBuffer = new StringBuffer();
        try {
            FileInputStream fileInputStream = context.openFileInput(configurationFileName);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String nextLine = bufferedReader.readLine();
            while (nextLine != null) {
                stringBuffer.append(nextLine);
                nextLine = bufferedReader.readLine();
            }
            inputStreamReader.close();
            result = new JSONArray(stringBuffer.toString());
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to load configuration file: " + ex.getMessage());
        }
        return result;
    }

    public void updateConfigurationIfNeeded(Context context) {
        try {
            String savedConfigurationVersionAsString = SharedPreferencesUtils.loadSharedPreferencesData(context, "SDK_CONFIGURATION_VERSION");
            int savedConfigurationVersion = -1;
            int newConfigurationVersion = 0;
            if (savedConfigurationVersionAsString != null) {
                savedConfigurationVersion = Integer.parseInt(savedConfigurationVersionAsString);
            }
            if (this.mConfigurationVersion != null) {
                newConfigurationVersion = Integer.parseInt(this.mConfigurationVersion);
            }
            if (newConfigurationVersion > savedConfigurationVersion) {
                SharedPreferencesUtils.saveSharedPreferencesData(context, "SDK_CONFIGURATION_VERSION", this.mConfigurationVersion);
                if (this.mParentalLockData.getIsActivated()) {
                    SharedPreferencesUtils.saveSharedPreferencesData(context, "PARENTAL_LOCK_ACTIVE_KEY", "PARENTAL_LOCK_ACTIVE_KEY");
                } else {
                    SharedPreferencesUtils.removeSharedPreferencesData(context, "PARENTAL_LOCK_ACTIVE_KEY");
                }
                ArrayList<LockIconData> lockIconArrayList = this.mParentalLockData.getLockIconArrayList();
                if (lockIconArrayList != null && !lockIconArrayList.isEmpty()) {
                    JSONArray jSONArray = new JSONArray();
                    for (LockIconData nextLockIconData : lockIconArrayList) {
                        JSONObject nextJSONObject = new JSONObject();
                        nextJSONObject.put("LockIconURL", (Object)nextLockIconData.getIconURL());
                        nextJSONObject.put("LockIconName", (Object)nextLockIconData.getName());
                        nextJSONObject.put("LockIconOnFS", (Object)("Lock_Icon_" + nextLockIconData.getName() + ".jpg"));
                        jSONArray.put((Object)nextJSONObject);
                        Bitmap nextBitmap = PicassoOk.getPicasso(context).load(nextLockIconData.getIconURL()).get();
                        SDKConfigurationData.saveLockIconToFS(context, nextBitmap, "Lock_Icon_" + nextLockIconData.getName() + ".jpg");
                    }
                    SDKConfigurationData.saveConfigurationFile(context, jSONArray);
                }
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to updateConfigurationIfNeeded: " + ex.getMessage());
        }
    }

    public static void prepareLockIcons(Context context) {
        JSONArray jSONArray = SDKConfigurationData.loadConfigurationFile(context);
        if (jSONArray != null && jSONArray.length() > 0) {
            for (int lockIconIndex = 0; lockIconIndex < jSONArray.length(); ++lockIconIndex) {
                try {
                    JSONObject nextJSONObject = jSONArray.getJSONObject(lockIconIndex);
                    LockIconData nextLockIconData = new LockIconData(context, nextJSONObject);
                    File dir = context.getFilesDir();
                    File imageFile = new File(dir, nextLockIconData.getIconURL());
                    PicassoOk.getPicasso(context).load(imageFile).fetch();
                    continue;
                }
                catch (Exception ex) {
                    SDKLogger.printErrorLog(TAG, "Error when trying to prepareLockIcons:" + ex.getMessage());
                }
            }
        }
    }
}

