/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.structure;

import android.content.Context;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class LockIconData {
    private final String TAG = LockIconData.class.getSimpleName();
    private String mName;
    private String mIconURL;

    public LockIconData() {
    }

    public LockIconData(JSONArray jSONArray, HashMap<String, Integer> keys) {
        if (jSONArray != null && keys != null) {
            try {
                this.mName = jSONArray.getString(keys.get("name").intValue());
                this.mIconURL = jSONArray.getString(keys.get("icon").intValue());
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(this.TAG, "Error creating lock icon data: " + ex.getMessage());
            }
        }
    }

    public LockIconData(Context context, JSONObject jSONObject) {
        if (jSONObject != null) {
            try {
                if (jSONObject.has("LockIconOnFS") && !jSONObject.isNull("LockIconOnFS")) {
                    this.mIconURL = jSONObject.getString("LockIconOnFS");
                }
                if (jSONObject.has("LockIconName") && !jSONObject.isNull("LockIconName")) {
                    this.mName = jSONObject.getString("LockIconName");
                }
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(this.TAG, "Error creating lock icon data: " + ex.getMessage());
            }
        }
    }

    public void setIconURL(String iconURL) {
        this.mIconURL = iconURL;
    }

    public String getIconURL() {
        return this.mIconURL;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }
}

