/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.structure;

import android.graphics.Color;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;
import java.io.Serializable;
import java.util.HashMap;
import org.json.JSONArray;

public class ContentItem
implements Serializable {
    private final String ID_KEY = "id";
    private final String THUMB_KEY = "thumb";
    private final String SEC_THUMB_KEY = "sec_thumb";
    private final String CONTENT_TYPE_KEY = "type";
    private final String DATA_KEY = "data";
    private final String TITLE_KEY = "title";
    private final String LANG_KEY = "lang";
    private final String PROMOTED_KEY = "promoted";
    private final String ADVERTISER_KEY = "advertiser_id";
    private String mId;
    private String mThumb;
    private String mSecThumb;
    private ContentType mContentType;
    private String mData;
    private String mTiltle;
    private String mLang;
    private boolean mPromoted;
    private String mAdvertiserID;
    private int[] mMainThumbSize;
    private float mMainThumbImageRation;
    private int mPaliteBgColor = -1;
    private int mPaliteTextColor = Color.parseColor((String)"#484848");

    public ContentItem(JSONArray jsonArray, HashMap<String, Integer> keysMap) {
        if (jsonArray != null) {
            int val;
            if (keysMap.containsKey("id")) {
                this.mId = jsonArray.optString(keysMap.get("id").intValue(), "");
            }
            if (keysMap.containsKey("thumb")) {
                this.mThumb = jsonArray.optString(keysMap.get("thumb").intValue(), "");
                this.mThumb = Utils.fixUrlLink(this.mThumb);
                this.getThumbSize();
            }
            if (keysMap.containsKey("sec_thumb")) {
                this.mSecThumb = jsonArray.optString(keysMap.get("sec_thumb").intValue(), "");
                this.mSecThumb = Utils.fixUrlLink(this.mSecThumb);
            }
            if (keysMap.containsKey("type")) {
                try {
                    val = jsonArray.optInt(keysMap.get("type").intValue(), -1);
                    this.mContentType = ContentType.getTypeByValue(val);
                    if (this.mContentType != null) {
                        switch (this.mContentType) {
                            case PROMOTED_PLAY_APPLICATION: 
                            case GOOGLE_PLAY_APPLICATION: {
                                this.mPaliteBgColor = Color.parseColor((String)"#4aaed3");
                                break;
                            }
                            case WEB_GAME_URL: {
                                this.mPaliteBgColor = Color.parseColor((String)"#b0d63a");
                                break;
                            }
                            case STREAMING_VIDEO: 
                            case YOTUBE_VIDEO: {
                                this.mPaliteBgColor = Color.parseColor((String)"#f8de46");
                                break;
                            }
                            case WEBSITE_URL: {
                                this.mPaliteBgColor = Color.parseColor((String)"#f8a850");
                            }
                        }
                    }
                }
                catch (Exception e) {
                    SDKLogger.printErrorLog("Error parsing single content item Action : \n" + e.getMessage());
                    this.mContentType = ContentType.NONE;
                }
            }
            if (keysMap.containsKey("data")) {
                this.mData = jsonArray.optString(keysMap.get("data").intValue(), "");
            }
            if (keysMap.containsKey("title")) {
                this.mTiltle = jsonArray.optString(keysMap.get("title").intValue(), "");
            }
            if (keysMap.containsKey("lang")) {
                this.mLang = jsonArray.optString(keysMap.get("lang").intValue(), "");
            }
            if (keysMap.containsKey("advertiser_id")) {
                this.mAdvertiserID = jsonArray.optString(keysMap.get("advertiser_id").intValue(), "0");
            }
            if (keysMap.containsKey("promoted")) {
                val = jsonArray.optInt(keysMap.get("promoted").intValue(), 0);
                this.mPromoted = val == 1;
            }
        }
    }

    private void getThumbSize() {
        String sizePrefix = "ImageSize_";
        if (this.mThumb.contains(sizePrefix)) {
            try {
                String[] dotSplitArray = this.mThumb.split("\\.");
                String stripedExtensionString = dotSplitArray[dotSplitArray.length - 2];
                int start = stripedExtensionString.indexOf(sizePrefix);
                if (start != -1) {
                    String sizeString = stripedExtensionString.substring(start + sizePrefix.length(), stripedExtensionString.length());
                    String[] values = sizeString.split("_");
                    this.mMainThumbSize = new int[2];
                    this.mMainThumbSize[0] = Integer.parseInt(values[0]);
                    this.mMainThumbSize[1] = Integer.parseInt(values[1]);
                    this.mMainThumbImageRation = (float)this.mMainThumbSize[1] / (float)this.mMainThumbSize[0];
                }
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog("Error trying to extract image size from WEBSITE_URL: \n" + this.mThumb + "\n " + ex.getMessage());
            }
        }
    }

    public int getPaliteBgColor() {
        return this.mPaliteBgColor;
    }

    public void setPaliteBgColor(int paliteBgColor) {
    }

    public int getPaliteTextColor() {
        return this.mPaliteTextColor;
    }

    public void setPaliteTextColor(int paliteTextColor) {
        this.mPaliteTextColor = paliteTextColor;
    }

    public float getMainThumbImageRatio() {
        return this.mMainThumbImageRation;
    }

    public int[] getMainThumbSize() {
        return this.mMainThumbSize;
    }

    public String getId() {
        return this.mId;
    }

    public String getThumb() {
        return this.mThumb;
    }

    public void setThumb(String thumb) {
        this.mThumb = thumb;
    }

    public ContentType getContentType() {
        return this.mContentType;
    }

    public String getSecThumb() {
        return this.mSecThumb;
    }

    public String getData() {
        return this.mData;
    }

    public void setData(String data) {
        this.mData = data;
    }

    public String getName() {
        return this.mTiltle;
    }

    public void setName(String name) {
        this.mTiltle = name;
    }

    public String getLang() {
        return this.mLang;
    }

    public boolean isPromoted() {
        return this.mPromoted;
    }

    public String getAdvertiserID() {
        return this.mAdvertiserID;
    }

    public void setContentType(ContentType contentType) {
        this.mContentType = contentType;
    }
}

