/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.server_connect;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.squareup.okhttp.Cache;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@SuppressLint(value={"NewApi"})
public class BaseConnectionClient {
    protected static String MAIN_SERVER_URL = "";
    protected static String KIDOZ_ANALITYCS_SERVER_URL = "";
    protected static final String TAG = BaseConnectionClient.class.getSimpleName();
    private static final OkHttpClient client = new OkHttpClient();
    private static final MediaType JSON = MediaType.parse((String)"application/x-www-form-urlencoded; charset=utf-8");

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    public static int getConnectionType(Context context) {
        ConnectivityManager connManager;
        NetworkInfo nInfo;
        int reuslt = 1;
        if (context != null && (nInfo = (connManager = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null && nInfo.isAvailable()) {
            reuslt = nInfo.getType();
        }
        return reuslt;
    }

    protected static void initConnectionClient(boolean enableCache) {
        File file;
        client.setConnectTimeout(10L, TimeUnit.SECONDS);
        client.setWriteTimeout(10L, TimeUnit.SECONDS);
        client.setReadTimeout(20L, TimeUnit.SECONDS);
        if (enableCache && (file = Environment.getDownloadCacheDirectory()) != null && (file = new File(file.getAbsolutePath() + File.separator + "SDKhttpCacheDir")) != null) {
            if (!file.exists()) {
                file.mkdirs();
            }
            int cacheSize = 0xA00000;
            Cache cache = new Cache(file, (long)cacheSize);
            client.setCache(cache);
        }
        BaseConnectionClient.initCookieManager();
    }

    private static void initCookieManager() {
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(cookieManager);
    }

    public static Call makePostConnection(String url, ContentValues contentValues, String requestTag) throws IOException {
        Call result = null;
        if (contentValues != null && contentValues.size() > 0) {
            String val;
            StringBuilder stringBuilder = new StringBuilder();
            Set set = contentValues.keySet();
            Iterator iter = set.iterator();
            if (iter.hasNext()) {
                val = (String)iter.next();
                stringBuilder.append(val + "=" + contentValues.getAsString(val));
            }
            while (iter.hasNext()) {
                val = (String)iter.next();
                stringBuilder.append("&");
                stringBuilder.append(val + "=" + contentValues.getAsString(val));
            }
            if (url != null && !url.equals("") && stringBuilder != null) {
                SDKLogger.printDebbugLog(TAG, ">>>>stringBuilder = " + stringBuilder.toString());
                RequestBody body = RequestBody.create((MediaType)JSON, (String)stringBuilder.toString());
                Request request = new Request.Builder().url(url).post(body).tag((Object)requestTag).build();
                result = client.newCall(request);
            } else {
                SDKLogger.printErrorLog(" \n Invalid Server Url or Request parameters JSON !");
            }
        }
        return result;
    }

    public static Call makeGetConnection(String url, ContentValues contentValues, String requestTag) throws IOException {
        Call call = null;
        StringBuilder sb = new StringBuilder(url);
        if (contentValues != null && contentValues.size() > 0) {
            String val;
            sb.append("?");
            Set set = contentValues.keySet();
            Iterator iter = set.iterator();
            if (iter.hasNext()) {
                val = (String)iter.next();
                sb.append(val + "=" + contentValues.getAsString(val));
            }
            while (iter.hasNext()) {
                val = (String)iter.next();
                sb.append("&");
                sb.append(val + "=" + contentValues.getAsString(val));
            }
        }
        Request request = new Request.Builder().url(sb.toString()).tag((Object)requestTag).build();
        call = client.newCall(request);
        return call;
    }

    private static void cancelRequest(String tag) {
        client.cancel((Object)tag);
    }

    public static OkHttpClient getConnectionClient() {
        return client;
    }

    public static void getImageStreamAsync(String url, String requestTag, final IOnImageRequestCallback requestCallback) {
        Request request = new Request.Builder().url(url).tag((Object)requestTag).build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
            }

            public void onResponse(Response response) throws IOException {
                requestCallback.onImageRecieved(response.body().byteStream());
            }
        });
    }

    public static Call getImageStream(String url, String requestTag) throws IOException {
        Request request = new Request.Builder().url(url).tag((Object)requestTag).build();
        return client.newCall(request);
    }

    public static interface IOnImageRequestCallback {
        public void onImageRecieved(InputStream var1) throws IOException;
    }

    protected static enum CONNECTION_TYPE {
        POST,
        GET;

    }
}

