/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.video_player.util;

import com.kidoz.sdk.api.general.utils.SDKLogger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YouTubeUtils {
    private static final String TAG = YouTubeUtils.class.getSimpleName();
    private static final String YOUTUBE_INDICATOR = "youtube.com";
    private static final String YOUTUBE_URL_VIDEOID_REGULAR_EXPRESSIONS = "^.*((youtu.be\\/)|(v\\/)|(\\/u\\/w\\/)|(embed\\/)|(watch\\?))\\??v?=?([^#\\&\\?]*).*";
    private static final String YOUTUBE_VIDEOID_REGULAR_EXPRESSIONS = "^[a-zA-Z0-9]*$";

    public static String extractYouTubeVideoIDString(String videoURL) {
        String videoId = null;
        if (videoURL.contains(YOUTUBE_INDICATOR)) {
            String groupIndex1;
            Pattern pattern = Pattern.compile(YOUTUBE_URL_VIDEOID_REGULAR_EXPRESSIONS);
            Matcher matcher = pattern.matcher(videoURL);
            if (matcher.matches() && (groupIndex1 = matcher.group(7)) != null && groupIndex1.length() == 11) {
                videoId = groupIndex1;
            }
        } else if (videoURL.matches(YOUTUBE_VIDEOID_REGULAR_EXPRESSIONS)) {
            videoId = videoURL;
        }
        SDKLogger.printDebbugLog(TAG, ">>>> Next Video WEBSITE_URL = " + videoURL);
        SDKLogger.printDebbugLog(TAG, ">>>> Next Video ID = " + videoId);
        return videoId;
    }
}

