/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.video_player.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.media.ThumbnailUtils;
import android.net.Uri;
import java.io.File;

public class ImageUtil {
    public static Uri prepareCorrectUri(Object res) {
        if (res != null) {
            if (res instanceof Uri) {
                return (Uri)res;
            }
            if (res instanceof Integer) {
                return Uri.parse((String)("res:///" + (Integer)res));
            }
            if (res instanceof File) {
                return Uri.fromFile((File)((File)res));
            }
            int val = -1;
            try {
                val = Integer.parseInt((String)res);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (val != -1) {
                return Uri.parse((String)("res:///" + val));
            }
            if (((String)res).startsWith("http://") || ((String)res).startsWith("https://")) {
                return Uri.parse((String)((String)res));
            }
            if (((String)res).contains("mnt/") || ((String)res).contains("storage/")) {
                return Uri.fromFile((File)new File((String)res));
            }
            return Uri.parse((String)("asset:///" + (String)res));
        }
        return Uri.EMPTY;
    }

    public static Bitmap getMaskedBitmap(Context context, Bitmap originalBitmap, int maskImageID) {
        Bitmap result = null;
        if (originalBitmap != null) {
            Bitmap maskBitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)maskImageID);
            result = Bitmap.createBitmap((int)maskBitmap.getWidth(), (int)maskBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            originalBitmap = ThumbnailUtils.extractThumbnail((Bitmap)originalBitmap, (int)maskBitmap.getWidth(), (int)maskBitmap.getHeight());
            if (maskBitmap != null) {
                Canvas canvas = new Canvas(result);
                Paint paint = new Paint();
                paint.setFilterBitmap(true);
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
                paint.setDither(true);
                canvas.drawBitmap(maskBitmap, 0.0f, 0.0f, null);
                canvas.drawBitmap(originalBitmap, 0.0f, 0.0f, paint);
            }
        }
        return result;
    }
}

