/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.video_player.ui.fragments;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.players.video_player.logics.VIDEO_PLAYER_TYPE;
import com.kidoz.sdk.api.players.video_player.logics.VideoPlayerListener;
import com.kidoz.sdk.api.players.video_player.ui.custom_views.VideoPlayerController;
import com.kidoz.sdk.api.players.video_player.ui.fragments.VideoFragment;
import com.kidoz.sdk.api.players.video_player.util.ScreenUtils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.AbstractContentPanel;
import java.util.ArrayList;

public class VideoPlayerFragment
extends Fragment {
    public static final String TAG = VideoPlayerFragment.class.getSimpleName();
    private VIDEO_PLAYER_TYPE mVideoPlayerType = VIDEO_PLAYER_TYPE.YOUTUBE;
    private View mRootView;
    protected VideoPlayerController mVideoPlayerController;
    private VideoFragment mVideoFragment;
    private FrameLayout mVideoPlayerContainerFrameLayout;
    private VideoPlayerListener mVideoPlayerListener;
    private String mCurrentVideoID;
    private String mKidAvatarURL;
    private String mVideoName;
    private String mNumberOfLikes;
    private boolean mIsLiked;
    private AbstractContentPanel.IOnContentItemClickListener mRelatedContentListener;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(R.layout.video_player_fragment, container, false);
        this.initFragment();
        return this.mRootView;
    }

    private void initFragment() {
        this.initAnchor();
        this.initVideoPlayerController();
        this.initVideoPlayerContainerFrameLayout();
        this.initVideoFragment();
    }

    private void initAnchor() {
        int screenMaxSize = Math.max(ScreenUtils.getScreenSize((Context)this.getActivity(), true), ScreenUtils.getScreenSize((Context)this.getActivity(), false));
        int height = (int)((float)screenMaxSize * 0.061458334f);
        View anchorView = this.mRootView.findViewById(R.id.AnchorView);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, height);
        anchorView.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void initVideoPlayerController() {
        this.mVideoPlayerController = new VideoPlayerController((Context)this.getActivity());
    }

    private void initVideoPlayerContainerFrameLayout() {
        this.mVideoPlayerContainerFrameLayout = (FrameLayout)this.mRootView.findViewById(R.id.VideoContainerFrameLayout);
    }

    private void initVideoFragment() {
        if (this.mVideoPlayerType != null) {
            switch (this.mVideoPlayerType) {
                case YOUTUBE: {
                    this.initYoutubeVideoPlayer();
                }
            }
        }
    }

    private void initYoutubeVideoPlayer() {
        this.mVideoFragment = VideoFragment.newInstance();
        FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
        fragmentTransaction.replace(R.id.VideoContainerFrameLayout, (Fragment)this.mVideoFragment, VideoFragment.TAG);
        fragmentTransaction.commit();
        this.mVideoPlayerController.setVideoFragment(this.mVideoFragment, this.mVideoPlayerContainerFrameLayout);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        ScreenUtils.hideNavigationAndStatusBar(this.getActivity().getWindow());
        this.mVideoPlayerController.fixVideoLayout();
        if (this.getResources().getConfiguration().orientation == 1) {
            if (this.mVideoFragment != null) {
                this.mVideoFragment.toggleFullScreen(false);
            }
        } else if (this.mVideoFragment != null) {
            this.mVideoFragment.toggleFullScreen(true);
        }
    }

    public void onResume() {
        super.onResume();
        this.mVideoPlayerController.initWindowParameters();
        ScreenUtils.hideNavigationAndStatusBar(this.getActivity().getWindow());
        this.playVideo(this.mCurrentVideoID);
        this.mVideoPlayerController.setKidAvatar(this.mKidAvatarURL);
        this.mVideoPlayerController.setVideoName(this.mVideoName);
        this.mVideoPlayerController.setRelatedContentItemListener(this.mRelatedContentListener);
        this.mVideoPlayerController.setVideoPlayerListener(this.mVideoPlayerListener);
        this.mVideoPlayerController.setNumberOfLikes(this.mNumberOfLikes);
        this.mVideoPlayerController.setLikeIndication(this.mIsLiked);
    }

    public void onPause() {
        super.onPause();
        this.mVideoPlayerContainerFrameLayout.setVisibility(4);
        this.mVideoPlayerController.closeView();
    }

    public void onDestroy() {
        super.onDestroy();
        this.mVideoFragment.onDestroy();
    }

    public void setVideoPlayerListener(VideoPlayerListener videoPlayerListener) {
        this.mVideoPlayerListener = videoPlayerListener;
    }

    public void setVideoID(String videoID) {
        this.mCurrentVideoID = videoID;
        if (this.mVideoFragment != null) {
            this.mVideoFragment.setVideoId(this.mCurrentVideoID);
        }
    }

    public void playVideo(String videoID) {
        this.mCurrentVideoID = videoID;
        if (this.mVideoFragment != null) {
            this.mVideoFragment.setVideoId(this.mCurrentVideoID);
            this.mVideoFragment.playVideo();
        }
    }

    public void resumeVideoIfUserDidNotPauseIt() {
        if (this.mVideoFragment != null && !this.mVideoPlayerController.getIsUserPausedVideo()) {
            this.mVideoFragment.setVideoId(this.mCurrentVideoID);
            this.mVideoFragment.playVideo();
        }
    }

    public void stopVideo() {
        if (this.mVideoFragment != null) {
            this.mVideoFragment.pauseVideo();
        }
    }

    public void setTopBarTitle(String topBarTitle) {
    }

    public void setNumberOfLikes(String numberOfLikes) {
        this.mNumberOfLikes = numberOfLikes;
        if (this.mVideoPlayerController != null) {
            this.mVideoPlayerController.setNumberOfLikes(this.mNumberOfLikes);
        }
    }

    public void setLikeIndication(boolean isLiked) {
        this.mIsLiked = isLiked;
        if (this.mVideoPlayerController != null) {
            this.mVideoPlayerController.setLikeIndication(this.mIsLiked);
        }
    }

    public void setKidAvatarImage(String avatarURL) {
        this.mKidAvatarURL = avatarURL;
    }

    public void setVideoName(String videoName) {
        this.mVideoName = videoName;
        if (this.mVideoPlayerController != null) {
            this.mVideoPlayerController.setVideoName(this.mVideoName);
        }
    }

    public void setRelatedContentItemListener(AbstractContentPanel.IOnContentItemClickListener itemListener) {
        this.mRelatedContentListener = itemListener;
    }

    public void setRelatedContent(ArrayList<ContentItem> content) {
        this.mVideoPlayerController.setRelatedContent(content);
    }
}

