/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.video_player.ui.dialogs;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.youtube.player.YouTubeInitializationResult;
import com.google.android.youtube.player.YouTubePlayer;
import com.google.android.youtube.player.YouTubePlayerSupportFragment;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.players.video_player.ui.custom_views.InterceptableTouchEventRelativeLayout;

public class VideoPlayerDialogFragment
extends DialogFragment
implements YouTubePlayer.OnInitializedListener {
    public static final String TAG = VideoPlayerDialogFragment.class.getSimpleName();
    private InterceptableTouchEventRelativeLayout mRootView;
    private FrameLayout mFragmentContainer;
    private YouTubePlayerSupportFragment mYouTubePlayerSupportFragment;
    private YouTubePlayer mYouTubePlayer;
    private String mVideoID;

    public void setVideoID(String videoID) {
        this.mVideoID = videoID;
    }

    public static VideoPlayerDialogFragment newInstance() {
        return new VideoPlayerDialogFragment();
    }

    private void initFragmentDialog() {
        this.setStyle(2, 0x1030011);
        this.setCancelable(false);
        this.mRootView = new InterceptableTouchEventRelativeLayout((Context)this.getActivity());
        this.mRootView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mRootView.setIsInterceptTouchEvent(true);
        this.mFragmentContainer = new FrameLayout((Context)this.getActivity());
        this.mFragmentContainer.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.mRootView.addView((View)this.mFragmentContainer);
        this.mYouTubePlayerSupportFragment = YouTubePlayerSupportFragment.newInstance();
        this.mYouTubePlayerSupportFragment.initialize("AIzaSyCO0ANo6o7l286UdA4LHBvzTZ6Aza79lTc", (YouTubePlayer.OnInitializedListener)this);
    }

    public void onInitializationSuccess(YouTubePlayer.Provider provider, YouTubePlayer youTubePlayer, boolean restored) {
        this.mYouTubePlayer = youTubePlayer;
        this.mYouTubePlayer.setPlayerStyle(YouTubePlayer.PlayerStyle.MINIMAL);
        if (!restored && this.mVideoID != null) {
            this.mYouTubePlayer.loadVideo(this.mVideoID);
        }
    }

    public void onInitializationFailure(YouTubePlayer.Provider provider, YouTubeInitializationResult result) {
        this.mYouTubePlayer = null;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.youtube_player_activity, container, false);
        this.mYouTubePlayerSupportFragment.initialize("AIzaSyCO0ANo6o7l286UdA4LHBvzTZ6Aza79lTc", (YouTubePlayer.OnInitializedListener)this);
        return rootView;
    }

    public void onResume() {
        super.onResume();
        if (this.mYouTubePlayer != null) {
            this.mYouTubePlayer.play();
        }
    }

    public void onPause() {
        super.onPause();
        if (this.mYouTubePlayer != null) {
            this.mYouTubePlayer.pause();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mYouTubePlayer != null) {
            this.mYouTubePlayer.pause();
            this.mYouTubePlayer.release();
            this.mYouTubePlayer = null;
        }
    }
}

